/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.TransferListener;

public class ExTransferable
implements Transferable {
    public static final Transferable EMPTY = new Empty();
    public static final DataFlavor multiFlavor;
    private LinkedHashMap<DataFlavor, Single> map = new LinkedHashMap();
    private EventListenerList listeners;

    private ExTransferable(final Transferable transferable) {
        final DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray != null) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                try {
                    final int n = i;
                    this.map.put(dataFlavorArray[i], new Single(dataFlavorArray[i]){

                        @Override
                        public Object getData() throws IOException, UnsupportedFlavorException {
                            return transferable.getTransferData(dataFlavorArray[n]);
                        }
                    });
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void put(Single single) {
        this.map.put(single.flavor, single);
    }

    public void remove(DataFlavor dataFlavor) {
        this.map.remove(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.map.keySet().toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.map.containsKey(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Single single = this.map.get(dataFlavor);
        if (single == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return single.getTransferData(dataFlavor);
    }

    public static ExTransferable create(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            return (ExTransferable)transferable;
        }
        return new ExTransferable(transferable);
    }

    public final synchronized void addTransferListener(TransferListener transferListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(TransferListener.class, transferListener);
    }

    public final synchronized void removeTransferListener(TransferListener transferListener) {
        if (this.listeners != null) {
            this.listeners.remove(TransferListener.class, transferListener);
        }
    }

    final void fireAccepted(int n) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((TransferListener)objectArray[i]).accepted(n);
        }
    }

    final void fireRejected() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((TransferListener)objectArray[i]).rejected();
        }
    }

    final void fireOwnershipLost() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ((TransferListener)objectArray[i]).ownershipLost();
        }
    }

    static {
        try {
            multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle(ExTransferable.class).getString("transferFlavorsMultiFlavorName"), MultiTransferObject.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    private static class Empty
    implements Transferable {
        Empty() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    public static class Multi
    implements Transferable {
        private static final DataFlavor[] flavorList = new DataFlavor[]{multiFlavor};
        private MultiTransferObject transferObject;

        public Multi(Transferable[] transferableArray) {
            this.transferObject = new TransferObjectImpl(transferableArray);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavorList;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(multiFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.transferObject;
        }

        static class TransferObjectImpl
        implements MultiTransferObject {
            private Transferable[] trans;

            public TransferObjectImpl(Transferable[] transferableArray) {
                this.trans = transferableArray;
            }

            @Override
            public int getCount() {
                return this.trans.length;
            }

            @Override
            public Transferable getTransferableAt(int n) {
                return this.trans[n];
            }

            @Override
            public boolean isDataFlavorSupported(int n, DataFlavor dataFlavor) {
                try {
                    return this.trans[n].isDataFlavorSupported(dataFlavor);
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public boolean areDataFlavorsSupported(DataFlavor[] dataFlavorArray) {
                int n;
                HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>();
                for (n = 0; n < dataFlavorArray.length; ++n) {
                    hashSet.add(dataFlavorArray[n]);
                }
                block1: for (n = 0; n < this.trans.length; ++n) {
                    DataFlavor[] dataFlavorArray2 = this.trans[n].getTransferDataFlavors();
                    if (dataFlavorArray2 == null) {
                        return false;
                    }
                    for (int i = 0; i < dataFlavorArray2.length; ++i) {
                        if (hashSet.contains(dataFlavorArray2[i])) continue block1;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors(int n) {
                return this.trans[n].getTransferDataFlavors();
            }

            @Override
            public Object getTransferData(int n, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return this.trans[n].getTransferData(dataFlavor);
            }
        }
    }

    public static abstract class Single
    implements Transferable {
        private DataFlavor flavor;

        public Single(DataFlavor dataFlavor) {
            this.flavor = dataFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.flavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.flavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.getData();
        }

        protected abstract Object getData() throws IOException, UnsupportedFlavorException;
    }
}

