/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchHostsSniffer;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.http.ClusterAlertHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpHostBuilder;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.NodeFailureListener;
import org.elasticsearch.xpack.monitoring.exporter.http.PipelineHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.SecurityHttpClientConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.TemplateHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.TimeoutRequestConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.VersionHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.WatcherExistsHttpResource;
import org.joda.time.format.DateTimeFormatter;

public class HttpExporter
extends Exporter {
    private static final Logger logger = Loggers.getLogger(HttpExporter.class);
    public static final String TYPE = "http";
    public static final Setting.AffixSetting<List<String>> HOST_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"host", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> BULK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"bulk.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> CONNECTION_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)6L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> CONNECTION_READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> AUTH_USERNAME_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.username", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> AUTH_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.password", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Settings> SSL_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"ssl", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> PROXY_BASE_PATH_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"proxy.base_path", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Boolean> SNIFF_ENABLED_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"sniff.enabled", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Settings> HEADERS_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"headers", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Set<String> BLACKLISTED_HEADERS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"Content-Length", "Content-Type"}));
    public static final Setting.AffixSetting<TimeValue> TEMPLATE_CHECK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Boolean> TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.create_legacy_templates", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> PIPELINE_CHECK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.pipeline.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Version MIN_SUPPORTED_CLUSTER_VERSION = Version.V_6_0_0_alpha1;
    private final RestClient client;
    @Nullable
    private final Sniffer sniffer;
    private final Map<String, String> defaultParams;
    private final HttpResource resource;
    private final AtomicBoolean clusterAlertsAllowed = new AtomicBoolean(false);
    private final ThreadContext threadContext;
    private final DateTimeFormatter dateTimeFormatter;

    public HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext) {
        this(config, sslService, threadContext, new NodeFailureListener(), (HttpResource)HttpExporter.createResources(config));
    }

    HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, NodeFailureListener listener, HttpResource resource) {
        this(config, HttpExporter.createRestClient(config, sslService, listener), threadContext, listener, resource);
    }

    HttpExporter(Exporter.Config config, RestClient client, ThreadContext threadContext, NodeFailureListener listener, HttpResource resource) {
        this(config, client, HttpExporter.createSniffer(config, client, listener), threadContext, listener, resource);
    }

    HttpExporter(Exporter.Config config, RestClient client, @Nullable Sniffer sniffer, ThreadContext threadContext, NodeFailureListener listener, HttpResource resource) {
        super(config);
        this.client = Objects.requireNonNull(client);
        this.sniffer = sniffer;
        this.resource = resource;
        this.defaultParams = HttpExporter.createDefaultParams(config);
        this.threadContext = threadContext;
        this.dateTimeFormatter = HttpExporter.dateTimeFormatter(config);
        listener.setResource(resource);
    }

    static RestClient createRestClient(Exporter.Config config, SSLService sslService, NodeFailureListener listener) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])HttpExporter.createHosts(config)).setFailureListener((RestClient.FailureListener)listener);
        Setting concreteSetting = PROXY_BASE_PATH_SETTING.getConcreteSettingForNamespace(config.name());
        String proxyBasePath = (String)concreteSetting.get(config.settings());
        if (!Strings.isNullOrEmpty((String)proxyBasePath)) {
            try {
                builder.setPathPrefix(proxyBasePath);
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + concreteSetting.getKey() + "] is malformed [" + proxyBasePath + "]", (Throwable)e);
            }
        }
        HttpExporter.configureHeaders(builder, config);
        HttpExporter.configureSecurity(builder, config, sslService);
        HttpExporter.configureTimeouts(builder, config);
        return builder.build();
    }

    static Sniffer createSniffer(Exporter.Config config, RestClient client, NodeFailureListener listener) {
        Sniffer sniffer = null;
        boolean sniffingEnabled = (Boolean)SNIFF_ENABLED_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (sniffingEnabled) {
            List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
            ElasticsearchHostsSniffer.Scheme scheme = ((String)hosts.get(0)).startsWith("https") ? ElasticsearchHostsSniffer.Scheme.HTTPS : ElasticsearchHostsSniffer.Scheme.HTTP;
            ElasticsearchHostsSniffer hostsSniffer = new ElasticsearchHostsSniffer(client, ElasticsearchHostsSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
            sniffer = Sniffer.builder((RestClient)client).setHostsSniffer((HostsSniffer)hostsSniffer).build();
            listener.setSniffer(sniffer);
            logger.debug("exporter [{}] using host sniffing", (Object)config.name());
        }
        return sniffer;
    }

    static MultiHttpResource createResources(Exporter.Config config) {
        String resourceOwnerName = "xpack.monitoring.exporters." + config.name();
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        resources.add(new VersionHttpResource(resourceOwnerName, MIN_SUPPORTED_CLUSTER_VERSION));
        HttpExporter.configureTemplateResources(config, resourceOwnerName, resources);
        HttpExporter.configurePipelineResources(config, resourceOwnerName, resources);
        HttpExporter.configureClusterAlertsResources(config, resourceOwnerName, resources);
        return new MultiHttpResource(resourceOwnerName, resources);
    }

    private static HttpHost[] createHosts(Exporter.Config config) {
        List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        String configKey = HOST_SETTING.getConcreteSettingForNamespace(config.name()).getKey();
        if (hosts.isEmpty()) {
            throw new SettingsException("missing required setting [" + configKey + "]");
        }
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(hosts.size());
        boolean httpHostFound = false;
        boolean httpsHostFound = false;
        for (String host : hosts) {
            HttpHost httpHost;
            try {
                httpHost = HttpHostBuilder.builder(host).build();
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + configKey + "] invalid host: [" + host + "]", (Throwable)e);
            }
            if (TYPE.equals(httpHost.getSchemeName())) {
                httpHostFound = true;
            } else {
                httpsHostFound = true;
            }
            if (httpHostFound && httpsHostFound) {
                throw new SettingsException("[" + configKey + "] must use a consistent scheme: http or https");
            }
            httpHosts.add(httpHost);
        }
        logger.debug("exporter [{}] using hosts {}", (Object)config.name(), (Object)hosts);
        return httpHosts.toArray(new HttpHost[httpHosts.size()]);
    }

    private static void configureHeaders(RestClientBuilder builder, Exporter.Config config) {
        Setting concreteSetting = HEADERS_SETTING.getConcreteSettingForNamespace(config.name());
        Settings headerSettings = (Settings)concreteSetting.get(config.settings());
        Set names = headerSettings.names();
        if (names.isEmpty()) {
            return;
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (String name : names) {
            if (BLACKLISTED_HEADERS.contains(name)) {
                throw new SettingsException("header cannot be overwritten via [" + concreteSetting.getKey() + name + "]");
            }
            List values = headerSettings.getAsList(name);
            if (values.isEmpty()) {
                throw new SettingsException("headers must have values, missing for setting [" + concreteSetting.getKey() + name + "]");
            }
            for (String value : values) {
                headers.add(new BasicHeader(name, value));
            }
        }
        builder.setDefaultHeaders(headers.toArray(new Header[headers.size()]));
    }

    private static void configureSecurity(RestClientBuilder builder, Exporter.Config config, SSLService sslService) {
        Settings sslSettings = (Settings)SSL_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        SSLIOSessionStrategy sslStrategy = sslService.sslIOSessionStrategy(sslSettings);
        CredentialsProvider credentialsProvider = HttpExporter.createCredentialsProvider(config);
        List hostList = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (credentialsProvider != null && !hostList.stream().findFirst().orElse("").startsWith("https")) {
            logger.warn("exporter [{}] is not using https, but using user authentication with plaintext username/password!", (Object)config.name());
        }
        if (sslStrategy != null) {
            builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new SecurityHttpClientConfigCallback(sslStrategy, credentialsProvider));
        }
    }

    private static void configureTimeouts(RestClientBuilder builder, Exporter.Config config) {
        TimeValue connectTimeout = (TimeValue)CONNECTION_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        TimeValue socketTimeout = (TimeValue)CONNECTION_READ_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        builder.setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)new TimeoutRequestConfigCallback(connectTimeout, socketTimeout));
    }

    @Nullable
    private static CredentialsProvider createCredentialsProvider(Exporter.Config config) {
        String username = (String)AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        String password = (String)AUTH_PASSWORD_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (Strings.isNullOrEmpty((String)username)) {
            if (!Strings.isNullOrEmpty((String)password)) {
                throw new SettingsException("[" + AUTH_PASSWORD_SETTING.getConcreteSettingForNamespace(config.name()).getKey() + "] without [" + AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(config.name()).getKey() + "]");
            }
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    static Map<String, String> createDefaultParams(Exporter.Config config) {
        TimeValue bulkTimeout = (TimeValue)BULK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        MapBuilder params = new MapBuilder();
        if (!TimeValue.MINUS_ONE.equals((Object)bulkTimeout)) {
            params.put((Object)"timeout", (Object)bulkTimeout.toString());
        }
        if (((Boolean)USE_INGEST_PIPELINE_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            params.put((Object)"pipeline", (Object)MonitoringTemplateUtils.pipelineName((String)"6"));
        }
        params.put((Object)"filter_path", (Object)"errors,items.*.error");
        return params.immutableMap();
    }

    private static void configureTemplateResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        TimeValue templateTimeout = (TimeValue)TEMPLATE_CHECK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        for (String templateId : MonitoringTemplateUtils.TEMPLATE_IDS) {
            String templateName = MonitoringTemplateUtils.templateName((String)templateId);
            Supplier<String> templateLoader = () -> MonitoringTemplateUtils.loadTemplate((String)templateId);
            resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName, templateLoader));
        }
        boolean createLegacyTemplates = (Boolean)TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (createLegacyTemplates) {
            for (String templateId : MonitoringTemplateUtils.OLD_TEMPLATE_IDS) {
                String templateName = MonitoringTemplateUtils.oldTemplateName((String)templateId);
                Supplier<String> templateLoader = () -> MonitoringTemplateUtils.createEmptyTemplate((String)templateId);
                resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName, templateLoader));
            }
        }
    }

    private static void configurePipelineResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        if (((Boolean)USE_INGEST_PIPELINE_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            TimeValue pipelineTimeout = (TimeValue)PIPELINE_CHECK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
            for (String pipelineId : MonitoringTemplateUtils.PIPELINE_IDS) {
                String pipelineName = MonitoringTemplateUtils.pipelineName((String)pipelineId);
                Supplier<byte[]> pipeline = () -> BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)MonitoringTemplateUtils.loadPipeline((String)pipelineId, (XContentType)XContentType.JSON)));
                resources.add(new PipelineHttpResource(resourceOwnerName, pipelineTimeout, pipelineName, pipeline));
            }
        }
    }

    private static void configureClusterAlertsResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        if (((Boolean)CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            ClusterService clusterService = config.clusterService();
            ArrayList<ClusterAlertHttpResource> watchResources = new ArrayList<ClusterAlertHttpResource>();
            List<String> blacklist = ClusterAlertsUtil.getClusterAlertsBlacklist(config);
            for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
                boolean blacklisted = blacklist.contains(watchId);
                Supplier<String> uniqueWatchId = () -> ClusterAlertsUtil.createUniqueWatchId(clusterService, watchId);
                Supplier<String> watch = blacklisted ? null : () -> ClusterAlertsUtil.loadWatch(clusterService, watchId);
                watchResources.add(new ClusterAlertHttpResource(resourceOwnerName, config.licenseState(), uniqueWatchId, watch));
            }
            resources.add(new WatcherExistsHttpResource(resourceOwnerName, clusterService, new MultiHttpResource(resourceOwnerName, watchResources)));
        }
    }

    boolean isExporterReady() {
        boolean canUseClusterAlerts = this.config.licenseState().isMonitoringClusterAlertsAllowed();
        if (this.clusterAlertsAllowed.compareAndSet(!canUseClusterAlerts, canUseClusterAlerts)) {
            this.resource.markDirty();
        }
        return this.resource.checkAndPublishIfDirty(this.client);
    }

    @Override
    public HttpExportBulk openBulk() {
        if (this.isExporterReady()) {
            String name = "xpack.monitoring.exporters." + this.config.name();
            return new HttpExportBulk(name, this.client, this.defaultParams, this.dateTimeFormatter, this.threadContext);
        }
        return null;
    }

    @Override
    public void doClose() {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (IOException | RuntimeException e) {
            logger.error("an error occurred while closing the internal client sniffer", (Throwable)e);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException | RuntimeException e) {
                logger.error("an error occurred while closing the internal client", (Throwable)e);
            }
        }
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        return Arrays.asList(HOST_SETTING, TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING, AUTH_PASSWORD_SETTING, AUTH_USERNAME_SETTING, BULK_TIMEOUT_SETTING, CONNECTION_READ_TIMEOUT_SETTING, CONNECTION_TIMEOUT_SETTING, PIPELINE_CHECK_TIMEOUT_SETTING, PROXY_BASE_PATH_SETTING, SNIFF_ENABLED_SETTING, TEMPLATE_CHECK_TIMEOUT_SETTING, SSL_SETTING, HEADERS_SETTING);
    }
}

