/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.snapshots.Snapshot;

public class SnapshotStatus
implements ToXContentObject,
Streamable {
    private Snapshot snapshot;
    private SnapshotsInProgress.State state;
    private List<SnapshotIndexShardStatus> shards;
    private Map<String, SnapshotIndexStatus> indicesStatus;
    private SnapshotShardsStats shardsStats;
    private SnapshotStats stats;
    @Nullable
    private Boolean includeGlobalState;
    private static final String SNAPSHOT = "snapshot";
    private static final String REPOSITORY = "repository";
    private static final String UUID = "uuid";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";

    SnapshotStatus(Snapshot snapshot, SnapshotsInProgress.State state, List<SnapshotIndexShardStatus> shards, Boolean includeGlobalState) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.state = Objects.requireNonNull(state);
        this.shards = Objects.requireNonNull(shards);
        this.includeGlobalState = includeGlobalState;
        this.shardsStats = new SnapshotShardsStats(shards);
        this.updateShardStats();
    }

    SnapshotStatus() {
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public SnapshotsInProgress.State getState() {
        return this.state;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotIndexShardStatus> getShards() {
        return this.shards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public Map<String, SnapshotIndexStatus> getIndices() {
        if (this.indicesStatus != null) {
            return this.indicesStatus;
        }
        HashMap<String, SnapshotIndexStatus> indicesStatus = new HashMap<String, SnapshotIndexStatus>();
        HashSet<String> indices = new HashSet<String>();
        for (SnapshotIndexShardStatus shard : this.shards) {
            indices.add(shard.getIndex());
        }
        for (String index : indices) {
            ArrayList<SnapshotIndexShardStatus> shards = new ArrayList<SnapshotIndexShardStatus>();
            for (SnapshotIndexShardStatus shard : this.shards) {
                if (!shard.getIndex().equals(index)) continue;
                shards.add(shard);
            }
            indicesStatus.put(index, new SnapshotIndexStatus(index, shards));
        }
        this.indicesStatus = Collections.unmodifiableMap(indicesStatus);
        return this.indicesStatus;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.snapshot = new Snapshot(in);
        this.state = SnapshotsInProgress.State.fromValue(in.readByte());
        int size = in.readVInt();
        ArrayList<SnapshotIndexShardStatus> builder = new ArrayList<SnapshotIndexShardStatus>();
        for (int i = 0; i < size; ++i) {
            builder.add(SnapshotIndexShardStatus.readShardSnapshotStatus(in));
        }
        this.shards = Collections.unmodifiableList(builder);
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.includeGlobalState = in.readOptionalBoolean();
        }
        this.updateShardStats();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshot.writeTo(out);
        out.writeByte(this.state.value());
        out.writeVInt(this.shards.size());
        for (SnapshotIndexShardStatus shard : this.shards) {
            shard.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeOptionalBoolean(this.includeGlobalState);
        }
    }

    public static SnapshotStatus readSnapshotStatus(StreamInput in) throws IOException {
        SnapshotStatus snapshotInfo = new SnapshotStatus();
        snapshotInfo.readFrom(in);
        return snapshotInfo;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, false);
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT, this.snapshot.getSnapshotId().getName());
        builder.field(REPOSITORY, this.snapshot.getRepository());
        builder.field(UUID, this.snapshot.getSnapshotId().getUUID());
        builder.field(STATE, this.state.name());
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        this.shardsStats.toXContent(builder, params);
        this.stats.toXContent(builder, params);
        builder.startObject(INDICES);
        for (SnapshotIndexStatus indexStatus : this.getIndices().values()) {
            indexStatus.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private void updateShardStats() {
        this.stats = new SnapshotStats();
        this.shardsStats = new SnapshotShardsStats(this.shards);
        for (SnapshotIndexShardStatus shard : this.shards) {
            this.stats.add(shard.getStats());
        }
    }
}

