/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.BinaryLogic;
import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.And;
import org.elasticsearch.xpack.sql.expression.predicate.Not;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class Or
extends BinaryLogic
implements BinaryOperator.Negateable {
    public Or(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<Or> info() {
        return NodeInfo.create(this, Or::new, this.left(), this.right());
    }

    @Override
    protected BinaryOperator replaceChildren(Expression newLeft, Expression newRight) {
        return new Or(this.location(), newLeft, newRight);
    }

    @Override
    public Object fold() {
        return Objects.equals(this.left().fold(), Boolean.TRUE) || Objects.equals(this.right().fold(), Boolean.TRUE);
    }

    @Override
    public Or swapLeftAndRight() {
        return new Or(this.location(), this.right(), this.left());
    }

    @Override
    public And negate() {
        return new And(this.location(), new Not(this.location(), this.left()), new Not(this.location(), this.right()));
    }

    @Override
    public String symbol() {
        return "||";
    }
}

