/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Collections;
import java.util.TimeZone;
import java.util.function.Function;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.sql.client.shared.CheckedFunction;
import org.elasticsearch.xpack.sql.client.shared.ClientException;
import org.elasticsearch.xpack.sql.client.shared.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.shared.JreHttpUrlConnection;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.SqlClearCursorRequest;
import org.elasticsearch.xpack.sql.plugin.SqlClearCursorResponse;
import org.elasticsearch.xpack.sql.plugin.SqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.SqlQueryResponse;

public class HttpClient {
    private static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;
    private final ConnectionConfiguration cfg;
    private NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;

    public HttpClient(ConnectionConfiguration cfg) throws SQLException {
        this.cfg = cfg;
    }

    public boolean ping(long timeoutInMs) throws SQLException {
        return this.head("/", timeoutInMs);
    }

    public MainResponse serverInfo() throws SQLException {
        return this.get("/", MainResponse::fromXContent);
    }

    public SqlQueryResponse queryInit(String query, int fetchSize) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(AbstractSqlRequest.Mode.PLAIN, query, Collections.emptyList(), null, TimeZone.getTimeZone("UTC"), fetchSize, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), "");
        return this.query(sqlRequest);
    }

    public SqlQueryResponse query(SqlQueryRequest sqlRequest) throws SQLException {
        return this.post("/_xpack/sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public SqlQueryResponse nextPage(String cursor) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest();
        sqlRequest.cursor(cursor);
        return this.post("/_xpack/sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public boolean queryClose(String cursor) throws SQLException {
        SqlClearCursorResponse response = this.post("/_xpack/sql/close", new SqlClearCursorRequest(AbstractSqlRequest.Mode.PLAIN, cursor), SqlClearCursorResponse::fromXContent);
        return response.isSucceeded();
    }

    private <Request extends AbstractSqlRequest, Response> Response post(String path, Request request, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        BytesReference requestBytes = HttpClient.toXContent(request);
        String query = "error_trace&mode=" + (Object)((Object)request.mode());
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, query, this.cfg, con -> con.request(requestBytes::writeTo, this::readFrom, "POST"))).getResponseOrThrowException();
        return this.fromXContent((XContentType)((Object)response.v1()), (BytesReference)response.v2(), responseParser);
    }

    private boolean head(String path, long timeoutInMs) throws SQLException {
        ConnectionConfiguration pingCfg = new ConnectionConfiguration(this.cfg.baseUri(), this.cfg.connectionString(), this.cfg.connectTimeout(), timeoutInMs, this.cfg.queryTimeout(), this.cfg.pageTimeout(), this.cfg.pageSize(), this.cfg.authUser(), this.cfg.authPass(), this.cfg.sslConfig(), this.cfg.proxyConfig());
        try {
            return AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", pingCfg, JreHttpUrlConnection::head));
        }
        catch (ClientException ex) {
            throw new SQLException("Cannot ping server", ex);
        }
    }

    private <Response> Response get(String path, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", this.cfg, con -> con.request(null, this::readFrom, "GET"))).getResponseOrThrowException();
        return this.fromXContent((XContentType)((Object)response.v1()), (BytesReference)response.v2(), responseParser);
    }

    private static <Request extends ToXContent> BytesReference toXContent(Request xContent) {
        try {
            return XContentHelper.toXContent(xContent, REQUEST_BODY_CONTENT_TYPE, false);
        }
        catch (IOException ex) {
            throw new ClientException("Cannot serialize request", ex);
        }
    }

    private Tuple<XContentType, BytesReference> readFrom(InputStream inputStream, Function<String, String> headers) {
        String contentType = headers.apply("Content-Type");
        XContentType xContentType = XContentType.fromMediaTypeOrFormat(contentType);
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + contentType);
        }
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            Streams.copy(inputStream, out);
        }
        catch (IOException ex) {
            throw new ClientException("Cannot deserialize response", ex);
        }
        return new Tuple<XContentType, BytesReference>(xContentType, out.bytes());
    }

    /*
     * Exception decompiling
     */
    private <Response> Response fromXContent(XContentType xContentType, BytesReference bytesReference, CheckedFunction<XContentParser, Response, IOException> responseParser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

