/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.CachingUsernamePasswordRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordRealm;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    private final Cache<String, UserWithHash> cache;
    final Hasher hasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config) {
        super(type, config);
        this.hasher = Hasher.resolve((String)((String)CachingUsernamePasswordRealmSettings.CACHE_HASH_ALGO_SETTING.get(config.settings())), (Hasher)Hasher.SSHA256);
        TimeValue ttl = (TimeValue)CachingUsernamePasswordRealmSettings.CACHE_TTL_SETTING.get(config.settings());
        this.cache = ttl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterWrite(ttl).setMaximumWeight((long)((Integer)CachingUsernamePasswordRealmSettings.CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build() : null;
    }

    public final void expire(String username) {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cache.invalidate((Object)username);
        }
    }

    public final void expireAll() {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cache.invalidateAll();
        }
    }

    public final void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult> listener) {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        try {
            if (this.cache == null) {
                this.doAuthenticate(token, listener);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void authenticateWithCache(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        UserWithHash userWithHash = (UserWithHash)this.cache.get((Object)token.principal());
        if (userWithHash == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("user [{}] not found in cache for realm [{}], proceeding with normal authentication", (Object)token.principal(), (Object)this.name());
            }
            this.doAuthenticateAndCache(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(result -> {
                if (result.isAuthenticated()) {
                    User user = result.getUser();
                    this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                }
                listener.onResponse(result);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else if (userWithHash.hasHash()) {
            if (userWithHash.verify(token.credentials())) {
                if (userWithHash.user.enabled()) {
                    User user = userWithHash.user;
                    this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                    listener.onResponse((Object)AuthenticationResult.success((User)user));
                } else {
                    this.cache.invalidate((Object)token.principal());
                    this.doAuthenticateAndCache(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(result -> {
                        if (result.isAuthenticated()) {
                            User user = result.getUser();
                            this.logger.debug("realm [{}] authenticated user [{}] (enabled:{}), with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.enabled(), (Object)user.roles());
                        }
                        listener.onResponse(result);
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
            } else {
                this.cache.invalidate((Object)token.principal());
                this.doAuthenticateAndCache(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(result -> {
                    if (result.isAuthenticated()) {
                        User user = result.getUser();
                        this.logger.debug("cached user's password changed. realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                    }
                    listener.onResponse(result);
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        } else {
            this.cache.invalidate((Object)token.principal());
            this.doAuthenticateAndCache(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(result -> {
                if (result.isAuthenticated()) {
                    User user = result.getUser();
                    this.logger.debug("cached user came from a lookup and could not be used for authentication. realm [{}] authenticated user [{}] with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                }
                listener.onResponse(result);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void doAuthenticateAndCache(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        ActionListener wrapped = ActionListener.wrap(result -> {
            Objects.requireNonNull(result, "AuthenticationResult cannot be null");
            if (result.getStatus() == AuthenticationResult.Status.SUCCESS) {
                UserWithHash userWithHash = new UserWithHash(result.getUser(), token.credentials(), this.hasher);
                this.cache.put((Object)token.principal(), (Object)userWithHash);
            }
            listener.onResponse(result);
        }, arg_0 -> listener.onFailure(arg_0));
        this.doAuthenticate(token, (ActionListener<AuthenticationResult>)wrapped);
    }

    public Map<String, Object> usageStats() {
        Map stats = super.usageStats();
        stats.put("size", this.cache.count());
        return stats;
    }

    protected abstract void doAuthenticate(UsernamePasswordToken var1, ActionListener<AuthenticationResult> var2);

    public final void lookupUser(String username, ActionListener<User> listener) {
        if (this.cache != null) {
            UserWithHash withHash = (UserWithHash)this.cache.get((Object)username);
            if (withHash == null) {
                try {
                    this.doLookupUser(username, (ActionListener<User>)ActionListener.wrap(user -> {
                        Runnable action = () -> listener.onResponse(null);
                        if (user != null) {
                            UserWithHash userWithHash = new UserWithHash((User)user, null, null);
                            try {
                                this.cache.computeIfAbsent((Object)username, n -> userWithHash);
                                action = () -> listener.onResponse((Object)userWithHash.user);
                            }
                            catch (ExecutionException e) {
                                action = () -> listener.onFailure((Exception)e);
                            }
                        }
                        action.run();
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            } else {
                listener.onResponse((Object)withHash.user);
            }
        } else {
            this.doLookupUser(username, listener);
        }
    }

    protected abstract void doLookupUser(String var1, ActionListener<User> var2);

    private static class UserWithHash {
        User user;
        char[] hash;
        Hasher hasher;

        UserWithHash(User user, SecureString password, Hasher hasher) {
            this.user = user;
            this.hash = password == null ? null : hasher.hash(password);
            this.hasher = hasher;
        }

        boolean verify(SecureString password) {
            return this.hash != null && this.hasher.verify(password, this.hash);
        }

        boolean hasHash() {
            return this.hash != null;
        }
    }
}

