/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PresentationDirection;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.Margins;
import org.gjt.sp.jedit.print.PrintPreview;
import org.gjt.sp.jedit.print.PrintRangeType;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.print.Reverse;
import org.gjt.sp.util.GenericGUIUtilities;

public class PrinterDialog
extends JDialog
implements ListSelectionListener {
    private View view;
    private String jobName = null;
    private PrintService selectedPrintService = null;
    private PrintRequestAttributeSet attributes;
    private JTabbedPane tabs;
    private JList<PrintService> printers;
    private JSpinner copies = null;
    private JComboBox<String> paperSize;
    private List<Media> paperSizes;
    private JComboBox<Priority> priority;
    private JComboBox<Finishings> finishing;
    private JComboBox<Sides> sides;
    private JComboBox<NumberUp> pagesPerSide;
    private JComboBox<PresentationDirection> pageOrdering;
    private JComboBox<MediaTray> paperSource;
    private JComboBox<OrientationRequested> orientation;
    private boolean pageSetupOnly;
    private boolean canceled = false;
    private Map<String, String> messageMap;
    private PageSetupPanel pageSetupPanel;
    public static int onlyPrintPages = PrintRangeType.ALL.getValue();
    private DocFlavor DOC_FLAVOR = DocFlavor.SERVICE_FORMATTED.PRINTABLE;

    public PrinterDialog(View view, PrintRequestAttributeSet printRequestAttributeSet, boolean bl) {
        super((Window)view, Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.view = view;
            this.pageSetupOnly = bl;
            this.setTitle(bl ? jEdit.getProperty("print.dialog.pageSetupTitle") : jEdit.getProperty("print.dialog.title"));
            this.attributes = printRequestAttributeSet != null ? new HashPrintRequestAttributeSet(printRequestAttributeSet) : new HashPrintRequestAttributeSet();
            Attribute attribute = this.attributes.get(JobName.class);
            if (attribute != null) {
                this.jobName = attribute.toString();
            }
            this.attributes.remove(Destination.class);
            this.initMessages();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
            this.tabs = new JTabbedPane();
            this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
            this.tabs.add(jEdit.getProperty("print.dialog.General", "General"), new GeneralPanel());
            this.pageSetupPanel = new PageSetupPanel();
            this.tabs.add(jEdit.getProperty("print.dialog.Page_Setup", "Page Setup"), this.pageSetupPanel);
            this.tabs.add(jEdit.getProperty("print.dialog.Job", "Job"), new JobPanel());
            this.tabs.add(jEdit.getProperty("print.dialog.Advanced", "Advanced"), new AdvancedPanel());
            this.tabs.add(jEdit.getProperty("print.dialog.jEdit", "jEdit"), new jEditPanel());
            if (bl) {
                this.tabs.setSelectedIndex(1);
                this.tabs.setEnabledAt(0, false);
                this.tabs.setEnabledAt(1, true);
                this.tabs.setEnabledAt(2, false);
                this.tabs.setEnabledAt(3, false);
                this.tabs.setEnabledAt(4, false);
            }
            jPanel.add((Component)this.tabs, "Center");
            JButton jButton = new JButton(jEdit.getProperty("print.dialog.preview", "Preview"));
            jButton.addActionListener(this.getPreviewButtonListener());
            JButton jButton2 = new JButton(jEdit.getProperty("common.ok"));
            jButton2.addActionListener(this.getOkButtonListener());
            JButton jButton3 = new JButton(jEdit.getProperty("common.cancel"));
            jButton3.addActionListener(this.getCancelButtonListener());
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 6, 6));
            GenericGUIUtilities.makeSameSize(jButton, jButton2, jButton3);
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            jPanel2.add(jButton3);
            jPanel.add((Component)jPanel2, "South");
            this.setContentPane(jPanel);
            this.valueChanged(null);
            this.pageSetupPanel.setDefaultMargins();
            this.pack();
            this.getRootPane().registerKeyboardAction(actionEvent -> {
                this.setVisible(false);
                this.dispose();
                this.canceled = true;
            }, KeyStroke.getKeyStroke(27, 0), 2);
            this.setLocationRelativeTo(jEdit.getActiveView().getTextArea());
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ActionListener getPreviewButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                String string = PrinterDialog.this.pageSetupPanel.recalculate();
                if (string != null) {
                    JOptionPane.showMessageDialog(PrinterDialog.this, string, jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                for (int i = 0; i < PrinterDialog.this.tabs.getTabCount(); ++i) {
                    serializable = (PrinterPanel)PrinterDialog.this.tabs.getComponentAt(i);
                    AttributeSet attributeSet = serializable.getAttributes();
                    if (attributeSet == null) continue;
                    PrinterDialog.this.attributes.addAll(attributeSet);
                }
                PageRanges pageRanges = (PageRanges)PrinterDialog.this.attributes.get(PageRanges.class);
                try {
                    serializable = PrinterDialog.this.mergeRanges(pageRanges);
                    if (serializable != null) {
                        PrinterDialog.this.attributes.add((Attribute)serializable);
                    }
                }
                catch (PrintException printException) {
                    printException.printStackTrace();
                    JOptionPane.showMessageDialog(PrinterDialog.this, jEdit.getProperty("print-error.message", new String[]{printException.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                new PrintPreview(PrinterDialog.this.view, PrinterDialog.this.view.getBuffer(), PrinterDialog.this.getPrintService(), PrinterDialog.this.attributes);
            }
        };
    }

    private ActionListener getOkButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                String string = PrinterDialog.this.pageSetupPanel.recalculate();
                if (string != null) {
                    JOptionPane.showMessageDialog(PrinterDialog.this, string, jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                for (int i = 0; i < PrinterDialog.this.tabs.getTabCount(); ++i) {
                    object2 = (PrinterPanel)PrinterDialog.this.tabs.getComponentAt(i);
                    object = ((PrinterPanel)object2).getAttributes();
                    if (object == null) continue;
                    PrinterDialog.this.attributes.addAll((AttributeSet)object);
                }
                PageRanges pageRanges = (PageRanges)PrinterDialog.this.attributes.get(PageRanges.class);
                try {
                    object2 = PrinterDialog.this.mergeRanges(pageRanges);
                    if (object2 != null) {
                        PrinterDialog.this.attributes.add((Attribute)object2);
                    }
                }
                catch (PrintException printException) {
                    printException.printStackTrace();
                    JOptionPane.showMessageDialog(PrinterDialog.this, jEdit.getProperty("print-error.message", new String[]{printException.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                if (!PrinterDialog.this.pageSetupOnly && PrinterDialog.this.getPrintService() instanceof StreamPrintService) {
                    object2 = "out";
                    if (PrinterDialog.this.jobName != null) {
                        object = new File(PrinterDialog.this.jobName);
                        object2 = ((File)object).getName();
                    }
                    object2 = (String)object2 + ".ps";
                    object = new File(System.getProperty("user.home"), (String)object2);
                    String[] stringArray = GUIUtilities.showVFSFileDialog(PrinterDialog.this, PrinterDialog.this.view, ((File)object).getAbsolutePath(), 1, false);
                    if (stringArray != null && stringArray.length > 0) {
                        File file = new File(stringArray[0]);
                        PrinterDialog.this.selectedPrintService = PrinterDialog.this.getPostscriptPrintService(file);
                    } else {
                        return;
                    }
                }
                PrinterDialog.this.setVisible(false);
                PrinterDialog.this.dispose();
            }
        };
    }

    private ActionListener getCancelButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterDialog.this.setVisible(false);
                PrinterDialog.this.dispose();
                PrinterDialog.this.canceled = true;
            }
        };
    }

    public PrintService getPrintService() {
        return this.selectedPrintService;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private PrintService[] getPrintServices() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(this.DOC_FLAVOR, null);
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>(Arrays.asList(printServiceArray));
        StreamPrintService streamPrintService = this.getPostscriptPrintService(null);
        if (streamPrintService != null) {
            arrayList.add(streamPrintService);
        }
        printServiceArray = arrayList.toArray(new PrintService[0]);
        return printServiceArray;
    }

    private StreamPrintService getPostscriptPrintService(File file) {
        if (file == null) {
            file = new File(System.getProperty("user.home"), "out.ps");
        }
        String string = "application/postscript";
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(this.DOC_FLAVOR, string);
        StreamPrintService streamPrintService = null;
        if (streamPrintServiceFactoryArray.length > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(fileOutputStream);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return streamPrintService;
    }

    private PageRanges mergeRanges(PageRanges pageRanges) throws PrintException {
        Object object;
        if (pageRanges == null || onlyPrintPages == PrintRangeType.ALL.getValue()) {
            return pageRanges;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[][] nArray = pageRanges.getMembers();
        for (int i = 0; i < nArray.length; ++i) {
            object = nArray[i];
            int n = object[0];
            Object object2 = ((int[])object).length == 1 ? object[0] : (Object)Math.min((int)(object[0] + 500), (int)object[1]);
            for (int j = n; j <= object2; ++j) {
                if (j % 2 == 0 && onlyPrintPages == PrintRangeType.EVEN.getValue()) {
                    arrayList.add(j);
                    continue;
                }
                if (j % 2 != 1 || onlyPrintPages != PrintRangeType.ODD.getValue()) continue;
                arrayList.add(j);
            }
        }
        if (arrayList.isEmpty()) {
            throw new PrintException("No pages are selected to print.\nPlease check the 'Range' setting on the General tab and\nthe 'Only print' setting on the Page Setup tab.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = arrayList.iterator();
        while (object.hasNext()) {
            Integer n = (Integer)object.next();
            stringBuilder.append(n).append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return new PageRanges(stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        void var4_7;
        Class<?>[] classArray;
        this.selectedPrintService = this.printers.getSelectedValue();
        HashMap hashMap = new HashMap();
        for (Class<?> clazz : classArray = this.selectedPrintService.getSupportedAttributeCategories()) {
            Object object = this.selectedPrintService.getSupportedAttributeValues(clazz, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            hashMap.put(clazz, object);
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 999, 1);
        Object v = hashMap.get(Copies.class);
        if (v != null) {
            String string = v.toString();
            if (string.indexOf(45) > 0) {
                string = string.substring(string.indexOf(45) + 1);
            }
            SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(1, 1, Integer.valueOf(string), 1);
        }
        this.copies.setModel((SpinnerModel)var4_7);
        v = hashMap.get(Media.class);
        HashSet<MediaSizeName> hashSet = new HashSet<MediaSizeName>();
        for (Media media : (Media[])v) {
            if (!(media instanceof MediaSizeName)) continue;
            hashSet.add((MediaSizeName)media);
        }
        MediaSizeName[] mediaSizeNameArray = hashSet.toArray(new MediaSizeName[hashSet.size()]);
        Arrays.sort(mediaSizeNameArray, new Comparator<MediaSizeName>(){

            @Override
            public int compare(MediaSizeName mediaSizeName, MediaSizeName mediaSizeName2) {
                return mediaSizeName.toString().compareTo(mediaSizeName2.toString());
            }
        });
        Media media = (Media)this.attributes.get(Media.class);
        MediaSizeName mediaSizeName = null;
        if (media instanceof MediaSizeName) {
            mediaSizeName = (MediaSizeName)media;
        }
        if (this.paperSize != null) {
            String[] stringArray = new String[mediaSizeNameArray.length];
            this.paperSizes = new ArrayList<Media>();
            int n = -1;
            int n2 = 0;
            for (int i = 0; i < mediaSizeNameArray.length; ++i) {
                Media media2 = mediaSizeNameArray[i];
                if (MediaSizeName.NA_LETTER.equals(media2)) {
                    n2 = i;
                } else if (media2.equals(mediaSizeName)) {
                    n = i;
                }
                this.paperSizes.add(media2);
                stringArray[i] = this.getMessage(media2.toString());
            }
            n = n == -1 ? n2 : n;
            this.paperSize.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.paperSize.setEnabled(true);
            this.paperSize.setSelectedIndex(n);
        }
        if (this.finishing != null) {
            v = hashMap.get(Finishings.class);
            if (v == null) {
                this.finishing.setModel(new DefaultComboBoxModel());
                this.finishing.setEnabled(false);
            } else {
                Finishings[] finishingsArray = (Finishings[])v;
                if (finishingsArray.length == 0 || finishingsArray.length == 1 && Finishings.NONE.equals(finishingsArray[0])) {
                    this.finishing.setModel(new DefaultComboBoxModel());
                    this.finishing.setEnabled(false);
                } else {
                    this.finishing.setModel(new DefaultComboBoxModel<Finishings>(finishingsArray));
                    this.finishing.setEnabled(true);
                }
            }
        }
        if (this.sides != null) {
            v = hashMap.get(Sides.class);
            if (v == null) {
                this.sides.setEnabled(false);
            } else {
                this.sides.setModel(new DefaultComboBoxModel<Sides>((Sides[])v));
                Sides sides = (Sides)this.attributes.get(Sides.class);
                this.sides.setSelectedItem(sides == null ? Sides.ONE_SIDED : sides);
                this.sides.setEnabled(true);
            }
        }
        if (this.pagesPerSide != null) {
            v = hashMap.get(NumberUp.class);
            if (v == null) {
                this.pagesPerSide.setEnabled(false);
            } else {
                NumberUp[] numberUpArray = (NumberUp[])v;
                Arrays.sort(numberUpArray, new Comparator<NumberUp>(){

                    @Override
                    public int compare(NumberUp numberUp, NumberUp numberUp2) {
                        int n;
                        int n2 = numberUp.getValue();
                        if (n2 < (n = numberUp2.getValue())) {
                            return -1;
                        }
                        if (n2 == n) {
                            return 0;
                        }
                        return 1;
                    }
                });
                this.pagesPerSide.setModel(new DefaultComboBoxModel<NumberUp>(numberUpArray));
                this.pagesPerSide.setEnabled(true);
            }
        }
        if (this.pageOrdering != null) {
            v = hashMap.get(PresentationDirection.class);
            if (v == null) {
                this.pageOrdering.setEnabled(false);
            } else {
                PresentationDirection[] presentationDirectionArray = (PresentationDirection[])v;
                this.pageOrdering.setModel(new DefaultComboBoxModel<PresentationDirection>(presentationDirectionArray));
                this.pageOrdering.setEnabled(true);
            }
        }
        if (this.paperSource != null) {
            v = hashMap.get(Media.class);
            if (v == null) {
                this.paperSource.setEnabled(false);
            } else {
                HashSet<MediaTray> hashSet2 = new HashSet<MediaTray>();
                for (Media media2 : (Media[])v) {
                    if (!(media2 instanceof MediaTray)) continue;
                    hashSet2.add((MediaTray)media2);
                }
                if (hashSet2.size() > 0) {
                    Media[] mediaArray = hashSet2.toArray(new MediaTray[hashSet2.size()]);
                    this.paperSource.setModel(new DefaultComboBoxModel<Media>(mediaArray));
                    this.paperSource.setEnabled(true);
                    MediaTray mediaTray = (MediaTray)this.attributes.get(MediaTray.class);
                    this.paperSource.setSelectedItem(mediaTray == null ? mediaArray[0] : mediaTray);
                } else {
                    this.paperSource.setEnabled(false);
                }
            }
        }
        if (this.orientation != null) {
            v = hashMap.get(OrientationRequested.class);
            if (v == null) {
                this.orientation.setEnabled(false);
            } else {
                OrientationRequested[] orientationRequestedArray = (OrientationRequested[])v;
                this.orientation.setModel(new DefaultComboBoxModel<OrientationRequested>(orientationRequestedArray));
                this.orientation.setEnabled(true);
                OrientationRequested orientationRequested = (OrientationRequested)this.attributes.get(OrientationRequested.class);
                this.orientation.setSelectedItem(orientationRequested == null ? OrientationRequested.PORTRAIT : orientationRequested);
            }
        }
    }

    public void initMessages() {
        this.messageMap = new HashMap<String, String>();
        this.messageMap.put("Automatic-Feeder", jEdit.getProperty("print.dialog.Automatic-Feeder", "Automatic Feeder"));
        this.messageMap.put("Cassette", jEdit.getProperty("print.dialog.Cassette", "Cassette"));
        this.messageMap.put("Form-Source", jEdit.getProperty("print.dialog.Form-Source", "Form Source"));
        this.messageMap.put("Large-Format", jEdit.getProperty("print.dialog.Large-Format", "Large Format"));
        this.messageMap.put("Manual-Envelope", jEdit.getProperty("print.dialog.Manual-Envelope", "Manual Envelope"));
        this.messageMap.put("Small-Format", jEdit.getProperty("print.dialog.Small-Format", "Small Format"));
        this.messageMap.put("Tractor-Feeder", jEdit.getProperty("print.dialog.Tractor-Feeder", "Tractor Feeder"));
        this.messageMap.put("a", jEdit.getProperty("print.dialog.a", "Engineering A"));
        this.messageMap.put("accepting-jobs", jEdit.getProperty("print.dialog.accepting-jobs", "Accepting jobs"));
        this.messageMap.put("auto-select", jEdit.getProperty("print.dialog.auto-select", "Automatically Select"));
        this.messageMap.put("b", jEdit.getProperty("print.dialog.b", "Engineering B"));
        this.messageMap.put("c", jEdit.getProperty("print.dialog.c", "Engineering C"));
        this.messageMap.put("color", jEdit.getProperty("print.dialog.Color", "Color"));
        this.messageMap.put("d", jEdit.getProperty("print.dialog.d", "Engineering D"));
        this.messageMap.put("draft", jEdit.getProperty("print.dialog.Draft", "Draft"));
        this.messageMap.put("e", jEdit.getProperty("print.dialog.e", "Engineering E"));
        this.messageMap.put("envelope", jEdit.getProperty("print.dialog.envelope", "Envelope"));
        this.messageMap.put("executive", jEdit.getProperty("print.dialog.executive", "Executive"));
        this.messageMap.put("folio", jEdit.getProperty("print.dialog.folio", "Folio"));
        this.messageMap.put("high", jEdit.getProperty("print.dialog.High", "High"));
        this.messageMap.put("invite-envelope", jEdit.getProperty("print.dialog.invite-envelope", "Invitation Envelope"));
        this.messageMap.put("invoice", jEdit.getProperty("print.dialog.invoice", "Invoice"));
        this.messageMap.put("iso-2a0", jEdit.getProperty("print.dialog.iso-2a0", "2A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-4a0", jEdit.getProperty("print.dialog.iso-4a0", "4A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a0", jEdit.getProperty("print.dialog.iso-a0", "A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a1", jEdit.getProperty("print.dialog.iso-a1", "A1 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a2", jEdit.getProperty("print.dialog.iso-a2", "A2 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a3", jEdit.getProperty("print.dialog.iso-a3", "A3 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a4", jEdit.getProperty("print.dialog.iso-a4", "A4 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a5", jEdit.getProperty("print.dialog.iso-a5", "A5 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a6", jEdit.getProperty("print.dialog.iso-a6", "A6 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a7", jEdit.getProperty("print.dialog.iso-a7", "A7 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a8", jEdit.getProperty("print.dialog.iso-a8", "A8 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a9", jEdit.getProperty("print.dialog.iso-a9", "A9 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a10", jEdit.getProperty("print.dialog.iso-a10", "A10 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-b0", jEdit.getProperty("print.dialog.iso-b0", "B0 (ISO/DIN)"));
        this.messageMap.put("iso-b1", jEdit.getProperty("print.dialog.iso-b1", "B1 (ISO/DIN)"));
        this.messageMap.put("iso-b2", jEdit.getProperty("print.dialog.iso-b2", "B2 (ISO/DIN)"));
        this.messageMap.put("iso-b3", jEdit.getProperty("print.dialog.iso-b3", "B3 (ISO/DIN)"));
        this.messageMap.put("iso-b4", jEdit.getProperty("print.dialog.iso-b4", "B4 (ISO/DIN)"));
        this.messageMap.put("iso-b5", jEdit.getProperty("print.dialog.iso-b5", "B5 (ISO/DIN)"));
        this.messageMap.put("iso-b6", jEdit.getProperty("print.dialog.iso-b6", "B6 (ISO/DIN)"));
        this.messageMap.put("iso-b7", jEdit.getProperty("print.dialog.iso-b7", "B7 (ISO/DIN)"));
        this.messageMap.put("iso-b8", jEdit.getProperty("print.dialog.iso-b8", "B8 (ISO/DIN)"));
        this.messageMap.put("iso-b9", jEdit.getProperty("print.dialog.iso-b9", "B9 (ISO/DIN)"));
        this.messageMap.put("iso-b10", jEdit.getProperty("print.dialog.iso-b10", "B10 (ISO/DIN)"));
        this.messageMap.put("iso-c0", jEdit.getProperty("print.dialog.iso-c0", "C0 (ISO/DIN)"));
        this.messageMap.put("iso-c1", jEdit.getProperty("print.dialog.iso-c1", "C1 (ISO/DIN)"));
        this.messageMap.put("iso-c2", jEdit.getProperty("print.dialog.iso-c2", "C2 (ISO/DIN)"));
        this.messageMap.put("iso-c3", jEdit.getProperty("print.dialog.iso-c3", "C3 (ISO/DIN)"));
        this.messageMap.put("iso-c4", jEdit.getProperty("print.dialog.iso-c4", "C4 (ISO/DIN)"));
        this.messageMap.put("iso-c5", jEdit.getProperty("print.dialog.iso-c5", "C5 (ISO/DIN)"));
        this.messageMap.put("iso-c6", jEdit.getProperty("print.dialog.iso-c6", "C6 (ISO/DIN)"));
        this.messageMap.put("iso-c7", jEdit.getProperty("print.dialog.iso-c7", "C7 (ISO/DIN)"));
        this.messageMap.put("iso-c8", jEdit.getProperty("print.dialog.iso-c8", "C8 (ISO/DIN)"));
        this.messageMap.put("iso-c9", jEdit.getProperty("print.dialog.iso-c9", "C9 (ISO/DIN)"));
        this.messageMap.put("iso-c10", jEdit.getProperty("print.dialog.iso-c10", "C10 (ISO/DIN)"));
        this.messageMap.put("iso-designated-long", jEdit.getProperty("print.dialog.iso-designated-long", "ISO Designated Long"));
        this.messageMap.put("italian-envelope", jEdit.getProperty("print.dialog.italian-envelope", "Italy Envelope"));
        this.messageMap.put("italy-envelope", jEdit.getProperty("print.dialog.italy-envelope", "Italy Envelope"));
        this.messageMap.put("japanese-postcard", jEdit.getProperty("print.dialog.japanese-postcard", "Postcard (JIS)"));
        this.messageMap.put("jis-b0", jEdit.getProperty("print.dialog.jis-b0", "B0 (JIS)"));
        this.messageMap.put("jis-b1", jEdit.getProperty("print.dialog.jis-b1", "B1 (JIS)"));
        this.messageMap.put("jis-b2", jEdit.getProperty("print.dialog.jis-b2", "B2 (JIS)"));
        this.messageMap.put("jis-b3", jEdit.getProperty("print.dialog.jis-b3", "B3 (JIS)"));
        this.messageMap.put("jis-b4", jEdit.getProperty("print.dialog.jis-b4", "B4 (JIS)"));
        this.messageMap.put("jis-b5", jEdit.getProperty("print.dialog.jis-b5", "B5 (JIS)"));
        this.messageMap.put("jis-b6", jEdit.getProperty("print.dialog.jis-b6", "B6 (JIS)"));
        this.messageMap.put("jis-b7", jEdit.getProperty("print.dialog.jis-b7", "B7 (JIS)"));
        this.messageMap.put("jis-b8", jEdit.getProperty("print.dialog.jis-b8", "B8 (JIS)"));
        this.messageMap.put("jis-b9", jEdit.getProperty("print.dialog.jis-b9", "B9 (JIS)"));
        this.messageMap.put("jis-b10", jEdit.getProperty("print.dialog.jis-b10", "B10 (JIS)"));
        this.messageMap.put("landscape", jEdit.getProperty("print.dialog.landscape", "Landscape"));
        this.messageMap.put("main", jEdit.getProperty("print.dialog.main", "Main"));
        this.messageMap.put("manual", jEdit.getProperty("print.dialog.manual", "Manual"));
        this.messageMap.put("middle", jEdit.getProperty("print.dialog.middle", "Middle"));
        this.messageMap.put("monarch-envelope", jEdit.getProperty("print.dialog.monarch-envelope", "Monarch Envelope"));
        this.messageMap.put("monochrome", jEdit.getProperty("print.dialog.Monochrome", "Monochrome"));
        this.messageMap.put("na-5x7", jEdit.getProperty("print.dialog.na-5x7", "5\") x 7\" Paper"));
        this.messageMap.put("na-6x9-envelope", jEdit.getProperty("print.dialog.na-6x9-envelope", "6x9 Envelope"));
        this.messageMap.put("na-7x9-envelope", jEdit.getProperty("print.dialog.na-7x9-envelope", "6x7 Envelope"));
        this.messageMap.put("na-8x10", jEdit.getProperty("print.dialog.na-8x10", "8\") x 10\" Paper"));
        this.messageMap.put("na-9x11-envelope", jEdit.getProperty("print.dialog.na-9x11-envelope", "9x11 Envelope"));
        this.messageMap.put("na-9x12-envelope", jEdit.getProperty("print.dialog.na-9x12-envelope", "9x12 Envelope"));
        this.messageMap.put("na-10x13-envelope", jEdit.getProperty("print.dialog.na-10x13-envelope", "10x15 Envelope"));
        this.messageMap.put("na-10x14-envelope", jEdit.getProperty("print.dialog.na-10x14-envelope", "10x15 Envelope"));
        this.messageMap.put("na-10x15-envelope", jEdit.getProperty("print.dialog.na-10x15-envelope", "10x15 Envelope"));
        this.messageMap.put("na-legal", jEdit.getProperty("print.dialog.na-legal", "Legal"));
        this.messageMap.put("na-letter", jEdit.getProperty("print.dialog.na-letter", "Letter"));
        this.messageMap.put("na-number-9-envelope", jEdit.getProperty("print.dialog.na-number-9-envelope", "No. 9 Envelope"));
        this.messageMap.put("na-number-10-envelope", jEdit.getProperty("print.dialog.na-number-10-envelope", "No. 10 Envelope"));
        this.messageMap.put("na-number-11-envelope", jEdit.getProperty("print.dialog.na-number-11-envelope", "No. 11 Envelope"));
        this.messageMap.put("na-number-12-envelope", jEdit.getProperty("print.dialog.na-number-12-envelope", "No. 12 Envelope"));
        this.messageMap.put("na-number-14-envelope", jEdit.getProperty("print.dialog.na-number-14-envelope", "No. 14 Envelope"));
        this.messageMap.put("normal", jEdit.getProperty("print.dialog.Normal", "Normal"));
        this.messageMap.put("not-accepting-jobs", jEdit.getProperty("print.dialog.not-accepting-jobs", "Not accepting jobs"));
        this.messageMap.put("one-sided", jEdit.getProperty("print.dialog.one-sided", "One sided"));
        this.messageMap.put("oufuko-postcard", jEdit.getProperty("print.dialog.oufuko-postcard", "Double Postcard (JIS)"));
        this.messageMap.put("personal-envelope", jEdit.getProperty("print.dialog.personal-envelope", "Personal Envelope"));
        this.messageMap.put("portrait", jEdit.getProperty("print.dialog.portrait", "Portrait"));
        this.messageMap.put("quarto", jEdit.getProperty("print.dialog.quarto", "Quarto"));
        this.messageMap.put("reverse-landscape", jEdit.getProperty("print.dialog.reverse-landscape", "Reverse Landscape"));
        this.messageMap.put("reverse-portrait", jEdit.getProperty("print.dialog.reverse-portrait", "Reverse Portrait"));
        this.messageMap.put("side", jEdit.getProperty("print.dialog.side", "Side"));
        this.messageMap.put("tabloid", jEdit.getProperty("print.dialog.tabloid", "Tabloid"));
        this.messageMap.put("top", jEdit.getProperty("print.dialog.top", "Top"));
        this.messageMap.put("two-sided-long-edge", jEdit.getProperty("print.dialog.two-sided-long-edge", "Two Sided, Long Edge"));
        this.messageMap.put("two-sided-short-edge", jEdit.getProperty("print.dialog.two-sided-short-edge", "Two Sided, Short Edge"));
    }

    private String getMessage(String string) {
        String string2 = this.messageMap.get(string);
        return string2 == null ? string : string2;
    }

    class MyButtonGroup
    extends ButtonGroup {
        public MyButtonGroup(AbstractButton ... abstractButtonArray) {
            for (AbstractButton abstractButton : abstractButtonArray) {
                super.add(abstractButton);
            }
        }
    }

    private class jEditPanel
    extends PrinterPanel {
        private FontSelector font;
        private JCheckBox printHeader;
        private JCheckBox printFooter;
        private JCheckBox printLineNumbers;
        private JCheckBox printFolds;
        private JComboBox<String> tabSize;

        public jEditPanel() {
            this.font = new FontSelector(jEdit.getFontProperty("print.font"));
            this.printHeader = new JCheckBox(jEdit.getProperty("options.print.header"));
            this.printHeader.setSelected(jEdit.getBooleanProperty("print.header"));
            this.printFooter = new JCheckBox(jEdit.getProperty("options.print.footer"));
            this.printFooter.setSelected(jEdit.getBooleanProperty("print.footer"));
            this.printLineNumbers = new JCheckBox(jEdit.getProperty("options.print.lineNumbers"));
            this.printLineNumbers.setSelected(jEdit.getBooleanProperty("print.lineNumbers"));
            String[] stringArray = new String[]{"2", "4", "8"};
            this.tabSize = new JComboBox<String>(stringArray);
            this.tabSize.setEditor(new NumericTextField("", true, true));
            this.tabSize.setEditable(true);
            this.tabSize.setSelectedItem(jEdit.getProperty("print.tabSize"));
            this.printFolds = new JCheckBox(jEdit.getProperty("options.print.folds"));
            this.printFolds.setSelected(jEdit.getBooleanProperty("print.folds", true));
            JPanel jPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel.add(new JLabel(jEdit.getProperty("options.print.font")));
            jPanel.add(this.font);
            jPanel.add(new JLabel(jEdit.getProperty("options.print.tabSize")));
            jPanel.add(this.tabSize);
            jPanel.add(this.printHeader);
            jPanel.add(Box.createGlue());
            jPanel.add(this.printFooter);
            jPanel.add(Box.createGlue());
            jPanel.add(this.printLineNumbers);
            jPanel.add(Box.createGlue());
            jPanel.add(this.printFolds);
            jPanel.add(Box.createGlue());
            this.add((Component)jPanel, "North");
        }

        @Override
        public AttributeSet getAttributes() {
            jEdit.setFontProperty("print.font", this.font.getFont());
            jEdit.setBooleanProperty("print.header", this.printHeader.isSelected());
            jEdit.setBooleanProperty("print.footer", this.printFooter.isSelected());
            jEdit.setBooleanProperty("print.lineNumbers", this.printLineNumbers.isSelected());
            jEdit.setProperty("print.tabSize", (String)this.tabSize.getSelectedItem());
            jEdit.setBooleanProperty("print.folds", this.printFolds.isSelected());
            return null;
        }
    }

    private class AdvancedPanel
    extends PrinterPanel {
        private JComboBox<PrintQuality> quality;
        private JComboBox<Chromaticity> chromaticity;

        public AdvancedPanel() {
            this.quality = new JComboBox();
            this.quality.addItem(PrintQuality.DRAFT);
            this.quality.addItem(PrintQuality.NORMAL);
            this.quality.addItem(PrintQuality.HIGH);
            PrintQuality printQuality = (PrintQuality)PrinterDialog.this.attributes.get(PrintQuality.class);
            this.quality.setSelectedItem(printQuality == null ? PrintQuality.NORMAL : printQuality);
            this.quality.setRenderer(new QualityCellRenderer());
            this.chromaticity = new JComboBox();
            this.chromaticity.addItem(Chromaticity.MONOCHROME);
            this.chromaticity.addItem(Chromaticity.COLOR);
            Chromaticity chromaticity = (Chromaticity)PrinterDialog.this.attributes.get(Chromaticity.class);
            this.chromaticity.setSelectedItem(chromaticity == null ? Chromaticity.MONOCHROME : chromaticity);
            this.chromaticity.setRenderer(new ChromaticityCellRenderer());
            JPanel jPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Quality", "Quality")));
            jPanel.add(this.quality);
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Ink", "Ink")));
            jPanel.add(this.chromaticity);
            this.add((Component)jPanel, "North");
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            hashAttributeSet.add((Chromaticity)this.chromaticity.getSelectedItem());
            hashAttributeSet.add((PrintQuality)this.quality.getSelectedItem());
            return hashAttributeSet;
        }

        class ChromaticityCellRenderer
        extends JLabel
        implements ListCellRenderer<Chromaticity> {
            public ChromaticityCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Chromaticity> jList, Chromaticity chromaticity, int n, boolean bl, boolean bl2) {
                this.setText(chromaticity == null ? "" : PrinterDialog.this.getMessage(chromaticity.toString()));
                return this;
            }
        }

        class QualityCellRenderer
        extends JLabel
        implements ListCellRenderer<PrintQuality> {
            public QualityCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends PrintQuality> jList, PrintQuality printQuality, int n, boolean bl, boolean bl2) {
                this.setText(printQuality == null ? "" : PrinterDialog.this.getMessage(printQuality.toString()));
                return this;
            }
        }
    }

    private static class Priority {
        public static final Priority LOW = new Priority(1, jEdit.getProperty("print.dialog.Low", "Low"));
        public static final Priority MEDIUM = new Priority(50, jEdit.getProperty("print.dialog.Medium", "Medium"));
        public static final Priority HIGH = new Priority(80, jEdit.getProperty("print.dialog.High", "High"));
        public static final Priority URGENT = new Priority(100, jEdit.getProperty("print.dialog.Urgent", "Urgent"));
        private int value;
        private String name;

        private Priority(int n, String string) {
            this.value = n;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class JobPanel
    extends PrinterPanel {
        private JRadioButton nowButton;
        private JRadioButton atButton;
        private JRadioButton holdButton;
        private JSpinner when;

        public JobPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Job_Details", "Job Details")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.priority = new JComboBox();
            PrinterDialog.this.priority.addItem(Priority.LOW);
            PrinterDialog.this.priority.addItem(Priority.MEDIUM);
            PrinterDialog.this.priority.addItem(Priority.HIGH);
            PrinterDialog.this.priority.addItem(Priority.URGENT);
            PrinterDialog.this.priority.setSelectedItem(Priority.MEDIUM);
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(jEdit.getProperty("print.dialog.Priority", "Priority") + ':'));
            box.add(Box.createHorizontalStrut(6));
            box.add(PrinterDialog.this.priority);
            jPanel.add(box);
            JPanel jPanel2 = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Print_Document", "Print Document")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            this.nowButton = new JRadioButton(jEdit.getProperty("print.dialog.Now", "Now"));
            this.nowButton.setSelected(true);
            this.atButton = new JRadioButton(jEdit.getProperty("print.dialog.At", "At"));
            this.atButton.setEnabled(true);
            Calendar calendar = Calendar.getInstance(Locale.getDefault());
            Date date = calendar.getTime();
            calendar.add(1, 1);
            Date date2 = calendar.getTime();
            SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date, date2, 1);
            this.when = new JSpinner(spinnerDateModel);
            this.when.setEnabled(true);
            this.holdButton = new JRadioButton(jEdit.getProperty("print.dialog.On_Hold", "On Hold"));
            this.holdButton.setEnabled(true);
            new MyButtonGroup(this.nowButton, this.atButton, this.holdButton);
            jPanel2.add(this.nowButton);
            jPanel2.add(Box.createGlue());
            jPanel2.add(this.atButton);
            jPanel2.add(this.when);
            jPanel2.add(this.holdButton);
            jPanel2.add(Box.createGlue());
            JPanel jPanel3 = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            this.add((Component)jPanel3, "North");
            this.atButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JobPanel.this.when.setEnabled(JobPanel.this.atButton.isSelected());
                }
            });
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            hashAttributeSet.add(new JobPriority(((Priority)PrinterDialog.this.priority.getSelectedItem()).getValue()));
            if (PrinterDialog.this.finishing.isEnabled()) {
                hashAttributeSet.add((Finishings)PrinterDialog.this.finishing.getSelectedItem());
            }
            Date date = new Date(0L);
            if (this.atButton.isSelected()) {
                date = ((SpinnerDateModel)this.when.getModel()).getDate();
            } else if (this.holdButton.isSelected()) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(1, 1);
                date = calendar.getTime();
            }
            hashAttributeSet.add(new JobHoldUntil(date));
            return hashAttributeSet;
        }
    }

    private class PageSetupPanel
    extends PrinterPanel {
        private JComboBox<String> onlyPrint;
        private JComboBox<String> outputTray;
        NumericTextField topMarginField;
        NumericTextField leftMarginField;
        NumericTextField rightMarginField;
        NumericTextField bottomMarginField;

        public PageSetupPanel() {
            JPanel jPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Layout", "Layout")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.sides = new JComboBox();
            PrinterDialog.this.sides.setEnabled(false);
            PrinterDialog.this.sides.setRenderer(new SidesCellRenderer());
            PrinterDialog.this.pagesPerSide = new JComboBox();
            PrinterDialog.this.pagesPerSide.setEnabled(false);
            PrinterDialog.this.pageOrdering = new JComboBox();
            PrinterDialog.this.pageOrdering.setEnabled(false);
            this.onlyPrint = new JComboBox();
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.All_sheets", "All sheets"));
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.Odd_sheets", "Odd sheets"));
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.Even_sheets", "Even sheets"));
            this.onlyPrint.setSelectedIndex(0);
            this.onlyPrint.setEnabled(true);
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Two-sided", "Two-sided") + ':'));
            jPanel.add(PrinterDialog.this.sides);
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Pages_per_side", "Pages per side") + ':'));
            jPanel.add(PrinterDialog.this.pagesPerSide);
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Page_ordering", "Page ordering") + ':'));
            jPanel.add(PrinterDialog.this.pageOrdering);
            jPanel.add(new JLabel(jEdit.getProperty("print.dialog.Only_print", "Only print") + ':'));
            jPanel.add(this.onlyPrint);
            JPanel jPanel2 = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Paper", "Paper")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.paperSource = new JComboBox();
            PrinterDialog.this.paperSource.setEnabled(false);
            this.outputTray = new JComboBox();
            this.outputTray.setEnabled(false);
            PrinterDialog.this.paperSize = new JComboBox();
            PrinterDialog.this.paperSize.setEnabled(false);
            PrinterDialog.this.orientation = new JComboBox();
            PrinterDialog.this.orientation.setEnabled(false);
            PrinterDialog.this.orientation.setRenderer(new OrientationCellRenderer());
            jPanel2.add(new JLabel(jEdit.getProperty("print.dialog.Paper_source", "Paper source") + ':'));
            jPanel2.add(PrinterDialog.this.paperSource);
            jPanel2.add(new JLabel(jEdit.getProperty("print.dialog.Output_tray", "Output tray") + ':'));
            jPanel2.add(this.outputTray);
            jPanel2.add(new JLabel(jEdit.getProperty("print.dialog.Paper_size", "Paper size") + ':'));
            jPanel2.add(PrinterDialog.this.paperSize);
            jPanel2.add(new JLabel(jEdit.getProperty("print.dialog.Orientation", "Orientation") + ':'));
            jPanel2.add(PrinterDialog.this.orientation);
            JPanel jPanel3 = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Margins", "Margins")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            boolean bl = this.getUnits() == 1000;
            String string = jEdit.getProperty("print.topMargin", bl ? "25" : "1.0");
            String string2 = jEdit.getProperty("print.leftMargin", bl ? "25" : "1.0");
            String string3 = jEdit.getProperty("print.rightMargin", bl ? "25" : "1.0");
            String string4 = jEdit.getProperty("print.bottomMargin", bl ? "25" : "1.0");
            this.topMarginField = new NumericTextField(string, true, bl);
            this.leftMarginField = new NumericTextField(string2, true, bl);
            this.rightMarginField = new NumericTextField(string3, true, bl);
            this.bottomMarginField = new NumericTextField(string4, true, bl);
            String string5 = bl ? " (mm)" : " (in)";
            jPanel3.add(new JLabel(jEdit.getProperty("print.dialog.Top", "Top") + string5));
            jPanel3.add(this.topMarginField);
            jPanel3.add(new JLabel(jEdit.getProperty("print.dialog.Left", "Left") + string5));
            jPanel3.add(this.leftMarginField);
            jPanel3.add(new JLabel(jEdit.getProperty("print.dialog.Right", "Right") + string5));
            jPanel3.add(this.rightMarginField);
            jPanel3.add(new JLabel(jEdit.getProperty("print.dialog.Bottom", "Bottom") + string5));
            jPanel3.add(this.bottomMarginField);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Finishing", "Finishing")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.finishing = new JComboBox();
            PrinterDialog.this.finishing.setEnabled(false);
            PrinterDialog.this.finishing.setRenderer(new FinishingCellRenderer());
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(jEdit.getProperty("print.dialog.Finishing", "Finishing") + ':'));
            box.add(Box.createHorizontalStrut(6));
            box.add(PrinterDialog.this.finishing);
            jPanel4.add(box);
            JPanel jPanel5 = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            jPanel5.add(jPanel);
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            this.add(jPanel5);
            PrinterDialog.this.pagesPerSide.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NumberUp numberUp = (NumberUp)PrinterDialog.this.pagesPerSide.getSelectedItem();
                    if (numberUp != null && numberUp.getValue() == 1) {
                        PrinterDialog.this.pageOrdering.setEnabled(false);
                    }
                }
            });
            PrinterDialog.this.paperSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageSetupPanel.this.setDefaultMargins();
                }
            });
            PrinterDialog.this.orientation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageSetupPanel.this.setDefaultMargins();
                }
            });
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            if (PrinterDialog.this.sides.isEnabled()) {
                hashAttributeSet.add((Sides)PrinterDialog.this.sides.getSelectedItem());
            }
            if (PrinterDialog.this.pagesPerSide.isEnabled()) {
                hashAttributeSet.add((NumberUp)PrinterDialog.this.pagesPerSide.getSelectedItem());
            }
            if (PrinterDialog.this.pageOrdering.isEnabled()) {
                hashAttributeSet.add((PresentationDirection)PrinterDialog.this.pageOrdering.getSelectedItem());
            }
            onlyPrintPages = this.onlyPrint.getSelectedIndex();
            if (PrinterDialog.this.paperSource.isEnabled()) {
                hashAttributeSet.add((MediaTray)PrinterDialog.this.paperSource.getSelectedItem());
            }
            if (PrinterDialog.this.paperSize.isEnabled()) {
                hashAttributeSet.add((Attribute)PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex()));
            }
            if (PrinterDialog.this.orientation.isEnabled()) {
                hashAttributeSet.add((OrientationRequested)PrinterDialog.this.orientation.getSelectedItem());
            }
            Number number = this.topMarginField.getValue();
            Number number2 = this.leftMarginField.getValue();
            Number number3 = this.rightMarginField.getValue();
            Number number4 = this.bottomMarginField.getValue();
            Margins margins = new Margins(number.floatValue(), number2.floatValue(), number3.floatValue(), number4.floatValue());
            hashAttributeSet.add(margins);
            jEdit.setProperty("print.topMargin", number.toString());
            jEdit.setProperty("print.leftMargin", number2.toString());
            jEdit.setProperty("print.rightMargin", number3.toString());
            jEdit.setProperty("print.bottomMargin", number4.toString());
            return hashAttributeSet;
        }

        protected String recalculate() {
            if (!PrinterDialog.this.isShowing()) {
                return null;
            }
            int n = this.getUnits();
            MediaPrintableArea mediaPrintableArea = this.getSupportedPrintableArea();
            Media media = (Media)PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax size2DSyntax = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                size2DSyntax = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            float f = size2DSyntax.getX(n);
            float f2 = size2DSyntax.getY(n);
            float f3 = this.topMarginField.getValue().floatValue();
            float f4 = this.leftMarginField.getValue().floatValue();
            float f5 = this.rightMarginField.getValue().floatValue();
            float f6 = this.bottomMarginField.getValue().floatValue();
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(f3, f4, f5, f6, orientationRequested);
            float f7 = f4;
            float f8 = f3;
            float f9 = f - f4 - f5;
            float f10 = f2 - f3 - f6;
            if (f7 < mediaPrintableArea.getX(n)) {
                return jEdit.getProperty("print.dialog.error.Invalid_left_margin", "Invalid left margin.");
            }
            if (f8 < mediaPrintableArea.getY(n)) {
                return jEdit.getProperty("print.dialog.error.Invalid_top_margin", "Invalid top margin.");
            }
            if (f9 <= 0.0f || f7 + f9 > mediaPrintableArea.getX(n) + mediaPrintableArea.getWidth(n)) {
                return jEdit.getProperty("print.dialog.error.Invalid_left_andor_right_margin.", "Invalid left and/or right margin.");
            }
            if (f10 <= 0.0f || f8 + f10 > mediaPrintableArea.getY(n) + mediaPrintableArea.getHeight(n)) {
                return jEdit.getProperty("print.dialog.error.Invalid_top_andor_bottom_margin", "Invalid top and/or bottom margin.");
            }
            MediaPrintableArea mediaPrintableArea2 = new MediaPrintableArea(f7, f8, f9, f10, n);
            PrinterDialog.this.attributes.add(mediaPrintableArea2);
            return null;
        }

        private MediaPrintableArea getSupportedPrintableArea() {
            Object object;
            MediaPrintableArea mediaPrintableArea = null;
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (PrinterDialog.this.paperSizes != null) {
                hashPrintRequestAttributeSet.add((Attribute)PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex()));
            }
            if (PrinterDialog.this.orientation != null && PrinterDialog.this.orientation.getSelectedItem() != null) {
                hashPrintRequestAttributeSet.add((OrientationRequested)PrinterDialog.this.orientation.getSelectedItem());
            }
            if ((object = PrinterDialog.this.getPrintService().getSupportedAttributeValues(MediaPrintableArea.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, hashPrintRequestAttributeSet)) != null) {
                MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])object;
                mediaPrintableArea = mediaPrintableAreaArray[0];
            } else {
                mediaPrintableArea = (MediaPrintableArea)PrinterDialog.this.getPrintService().getDefaultAttributeValue(MediaPrintableArea.class);
            }
            return mediaPrintableArea;
        }

        private void rotateMargins(float f, float f2, float f3, float f4, OrientationRequested orientationRequested) {
            if (OrientationRequested.REVERSE_PORTRAIT.equals(orientationRequested)) {
                float f5 = f2;
                f2 = f3;
                f3 = f5;
                f5 = f;
                f = f4;
                f4 = f5;
            } else if (OrientationRequested.LANDSCAPE.equals(orientationRequested)) {
                float f6 = f2;
                f2 = f4;
                f4 = f3;
                f3 = f;
                f = f6;
            } else if (OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) {
                float f7 = f2;
                f2 = f;
                f = f3;
                f3 = f4;
                f4 = f7;
            }
        }

        void setDefaultMargins() {
            int n = this.getUnits();
            boolean bl = n == 1000;
            Margins margins = (Margins)PrinterDialog.this.attributes.get(Margins.class);
            float[] fArray = this.getMinimumMargins();
            float[] fArray2 = this.getMaximumMargins();
            float[] fArray3 = margins == null ? fArray : margins.getMargins(n);
            NumericTextField[] numericTextFieldArray = new NumericTextField[]{this.topMarginField, this.leftMarginField, this.rightMarginField, this.bottomMarginField};
            for (int i = 0; i < numericTextFieldArray.length; ++i) {
                NumericTextField numericTextField = numericTextFieldArray[i];
                Float f = null;
                String string = numericTextField.getText();
                if (string != null && !string.isEmpty()) {
                    f = new Float(string);
                }
                Float f2 = new Float(fArray3[i]);
                Float f3 = new Float(fArray[i]);
                Float f4 = new Float(fArray2[i]);
                if (f == null || f.floatValue() < f3.floatValue() || f.floatValue() > f4.floatValue()) {
                    numericTextField.setText(bl ? String.valueOf(f2.intValue()) : String.valueOf(f2));
                }
                numericTextField.setMinValue(Float.valueOf(bl ? (float)new Integer(f3.intValue()).intValue() : new Float(f3.floatValue()).floatValue()));
                numericTextField.setMaxValue(Float.valueOf(bl ? (float)new Integer(f4.intValue()).intValue() : new Float(f4.floatValue()).floatValue()));
                numericTextField.setToolTipText("Min: " + f3 + ", max: " + f4);
            }
        }

        private float[] getMinimumMargins() {
            int n = this.getUnits();
            boolean bl = n == 1000;
            MediaPrintableArea mediaPrintableArea = this.getSupportedPrintableArea();
            Media media = (Media)PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax size2DSyntax = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                size2DSyntax = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            float f = size2DSyntax.getX(n);
            float f2 = size2DSyntax.getY(n);
            float f3 = mediaPrintableArea.getY(n);
            f3 = bl ? new Double(Math.ceil(f3)).floatValue() : f3;
            float f4 = mediaPrintableArea.getX(n);
            f4 = bl ? new Double(Math.ceil(f4)).floatValue() : f4;
            float f5 = Math.max(0.0f, f - f4 - mediaPrintableArea.getWidth(n));
            f5 = bl ? new Double(Math.ceil(f5)).floatValue() : f5;
            float f6 = Math.max(0.0f, f2 - f3 - mediaPrintableArea.getHeight(n));
            f6 = bl ? new Double(Math.ceil(f6)).floatValue() : f6;
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(f3, f4, f5, f6, orientationRequested);
            return new float[]{f3, f4, f5, f6};
        }

        private float[] getMaximumMargins() {
            int n = this.getUnits();
            boolean bl = n == 1000;
            MediaPrintableArea mediaPrintableArea = this.getSupportedPrintableArea();
            Media media = (Media)PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax size2DSyntax = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                size2DSyntax = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            float f = size2DSyntax.getX(n);
            float f2 = size2DSyntax.getY(n);
            float f3 = mediaPrintableArea.getY(n) + mediaPrintableArea.getHeight(n);
            f3 = bl ? new Double(Math.ceil(f3)).floatValue() : f3;
            float f4 = mediaPrintableArea.getX(n) + mediaPrintableArea.getWidth(n);
            f4 = bl ? new Double(Math.ceil(f4)).floatValue() : f4;
            float f5 = f - mediaPrintableArea.getX(n);
            f5 = bl ? new Double(Math.ceil(f5)).floatValue() : f5;
            float f6 = f2 - mediaPrintableArea.getY(n);
            f6 = bl ? new Double(Math.ceil(f6)).floatValue() : f6;
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(f3, f4, f5, f6, orientationRequested);
            return new float[]{f3, f4, f5, f6};
        }

        private int getUnits() {
            String string = Locale.getDefault().getCountry();
            if ("".equals(string) || Locale.US.getCountry().equals(string) || Locale.CANADA.getCountry().equals(string)) {
                return 25400;
            }
            return 1000;
        }

        class FinishingCellRenderer
        extends JLabel
        implements ListCellRenderer<Finishings> {
            public FinishingCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Finishings> jList, Finishings finishings, int n, boolean bl, boolean bl2) {
                this.setText(finishings == null ? "" : PrinterDialog.this.getMessage(finishings.toString()));
                return this;
            }
        }

        class OrientationCellRenderer
        extends JLabel
        implements ListCellRenderer<OrientationRequested> {
            public OrientationCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends OrientationRequested> jList, OrientationRequested orientationRequested, int n, boolean bl, boolean bl2) {
                this.setText(orientationRequested == null ? "" : PrinterDialog.this.getMessage(orientationRequested.toString()));
                return this;
            }
        }

        class SidesCellRenderer
        extends JLabel
        implements ListCellRenderer<Sides> {
            public SidesCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Sides> jList, Sides sides, int n, boolean bl, boolean bl2) {
                this.setText(sides == null ? "" : PrinterDialog.this.getMessage(sides.toString()));
                return this;
            }
        }
    }

    private class GeneralPanel
    extends PrinterPanel {
        JRadioButton allPages;
        JRadioButton pages;
        JRadioButton currentPage;
        JRadioButton selection;
        JCheckBox collate;
        JCheckBox reverse;
        JTextField pagesField;

        public GeneralPanel() {
            PrinterDialog.this.printers = new JList<PrintService>(PrinterDialog.this.getPrintServices());
            PrinterDialog.this.printers.setCellRenderer(new PrintServiceCellRenderer());
            PrinterDialog.this.printers.setSelectionMode(0);
            JPanel jPanel = new JPanel(new GridLayout(4, 2, 6, 6));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Range", "Range")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            this.allPages = new JRadioButton(jEdit.getProperty("print.dialog.All_pages", "All pages"));
            this.allPages.setSelected(true);
            this.pages = new JRadioButton(jEdit.getProperty("print.dialog.Pages", "Pages") + ':');
            this.pagesField = new JTextField();
            this.pagesField.setEnabled(false);
            this.currentPage = new JRadioButton(jEdit.getProperty("print.dialog.Current_page", "Current page"));
            this.selection = new JRadioButton(jEdit.getProperty("print.dialog.Selection", "Selection"));
            new MyButtonGroup(this.allPages, this.pages, this.currentPage, this.selection);
            Box box = Box.createHorizontalBox();
            box.add(this.pages);
            box.add(Box.createHorizontalStrut(6));
            box.add(this.pagesField);
            jPanel.add(this.allPages);
            jPanel.add(Box.createGlue());
            jPanel.add(box);
            jPanel.add(Box.createGlue());
            jPanel.add(this.currentPage);
            jPanel.add(Box.createGlue());
            jPanel.add(this.selection);
            JPanel jPanel2 = new JPanel(new GridLayout(3, 2, 6, 6));
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Copies", "Copies")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            JLabel jLabel = new JLabel(jEdit.getProperty("print.dialog.Copies", "Copies:"));
            PrinterDialog.this.copies = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
            this.collate = new JCheckBox(jEdit.getProperty("print.dialog.Collate", "Collate"));
            this.collate.setSelected(false);
            this.collate.setEnabled(false);
            this.reverse = new JCheckBox(jEdit.getProperty("print.dialog.Reverse", "Reverse"));
            this.reverse.setSelected(false);
            this.reverse.setEnabled(true);
            jPanel2.add(jLabel);
            jPanel2.add(PrinterDialog.this.copies);
            jPanel2.add(this.collate);
            jPanel2.add(Box.createGlue());
            jPanel2.add(this.reverse);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 6, 6));
            jPanel4.add((Component)new JScrollPane(PrinterDialog.this.printers), "Center");
            jPanel5.add(jPanel);
            jPanel5.add(jPanel2);
            jPanel3.add((Component)jPanel4, "Center");
            jPanel3.add((Component)jPanel5, "South");
            this.add(jPanel3);
            PrinterDialog.this.printers.addListSelectionListener(PrinterDialog.this);
            this.allPages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralPanel.this.pagesField.setEnabled(GeneralPanel.this.pages.isSelected());
                }
            });
            this.pages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralPanel.this.pagesField.setEnabled(GeneralPanel.this.pages.isSelected());
                }
            });
            PrinterDialog.this.copies.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                    int n = (Integer)jSpinner.getValue();
                    GeneralPanel.this.collate.setEnabled(n > 1);
                    GeneralPanel.this.collate.setSelected(n > 1);
                }
            });
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            String string = jEdit.getProperty("print.lastUsedPrinter");
            if (string != null) {
                ListModel listModel = PrinterDialog.this.printers.getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    PrintService printService2 = (PrintService)listModel.getElementAt(i);
                    if (!string.equals(printService2.getName())) continue;
                    PrinterDialog.this.printers.setSelectedValue(printService2, true);
                    PrinterDialog.this.selectedPrintService = printService2;
                    break;
                }
            } else if (printService != null) {
                PrinterDialog.this.printers.setSelectedValue(printService, true);
                PrinterDialog.this.selectedPrintService = printService;
            } else {
                PrinterDialog.this.selectedPrintService = (PrintService)PrinterDialog.this.printers.getModel().getElementAt(0);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            jEdit.setProperty("print.lastUsedPrinter", ((PrintService)PrinterDialog.this.printers.getSelectedValue()).getName());
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            if (this.allPages.isSelected()) {
                hashAttributeSet.add(new PageRanges(1, 1000));
                hashAttributeSet.add(PrintRangeType.ALL);
            } else if (this.pages.isSelected()) {
                String string = this.pagesField.getText();
                if (string != null) {
                    try {
                        hashAttributeSet.add(new PageRanges(string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                hashAttributeSet.add(PrintRangeType.RANGE);
            } else if (this.currentPage.isSelected()) {
                PrinterDialog.this.attributes.add(new PageRanges(1, 1000));
                HashMap<Integer, Range> hashMap = BufferPrinter1_7.getCurrentPageRange(PrinterDialog.this.view, PrinterDialog.this.view.getBuffer(), PrinterDialog.this.attributes);
                int n = 1;
                if (hashMap != null && !hashMap.isEmpty()) {
                    n = hashMap.keySet().iterator().next();
                }
                hashAttributeSet.add(new PageRanges(n));
                hashAttributeSet.add(PrintRangeType.CURRENT_PAGE);
            } else if (this.selection.isSelected()) {
                PrinterDialog.this.attributes.add(new PageRanges(1, 1000));
                hashAttributeSet.add(PrintRangeType.SELECTION);
            }
            if (this.collate.isSelected()) {
                hashAttributeSet.add(SheetCollate.COLLATED);
            }
            hashAttributeSet.add(new Copies((Integer)PrinterDialog.this.copies.getValue()));
            if (this.reverse.isSelected()) {
                hashAttributeSet.add(new Reverse());
            } else {
                PrinterDialog.this.attributes.remove(Reverse.class);
            }
            return hashAttributeSet;
        }

        class PrintServiceCellRenderer
        extends JLabel
        implements ListCellRenderer<PrintService> {
            public PrintServiceCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends PrintService> jList, PrintService printService, int n, boolean bl, boolean bl2) {
                Color color;
                Color color2;
                this.setText(printService == null ? "" : printService.getName());
                if (bl) {
                    color2 = jEdit.getColorProperty("view.selectionColor");
                    color = jEdit.getColorProperty("view.fgColor");
                } else {
                    color2 = jEdit.getColorProperty("view.bgColor");
                    color = jEdit.getColorProperty("view.fgColor");
                }
                this.setBackground(color2);
                this.setForeground(color);
                Dimension dimension = new Dimension((int)this.getSize().getWidth(), (int)this.getSize().getHeight() + 5);
                this.setSize(dimension);
                return this;
            }
        }
    }

    private abstract class PrinterPanel
    extends JPanel {
        public PrinterPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        }

        abstract AttributeSet getAttributes();
    }
}

