/*
 * Decompiled with CFR 0.152.
 */
package org.joni.bench;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.Regex;
import org.joni.Syntax;

public abstract class AbstractBench {
    protected void bench(String _reg, String _str, int warmup, int times2) throws Exception {
        byte[] reg = _reg.getBytes();
        byte[] str = _str.getBytes();
        Regex p2 = new Regex(reg, 0, reg.length, 0, (Encoding)ASCIIEncoding.INSTANCE, Syntax.DEFAULT);
        System.err.println("::: /" + _reg + "/ =~ \"" + _str + "\", " + warmup + " * " + times2 + " times");
        for (int j = 0; j < warmup; ++j) {
            long before = System.currentTimeMillis();
            for (int i2 = 0; i2 < times2; ++i2) {
                p2.matcher(str, 0, str.length).search(0, str.length, 0);
            }
            long time = System.currentTimeMillis() - before;
            System.err.println(":  " + time + "ms");
        }
    }

    protected void benchBestOf(String _reg, String _str, int warmup, int times2) throws Exception {
        byte[] reg = _reg.getBytes();
        byte[] str = _str.getBytes();
        Regex p2 = new Regex(reg, 0, reg.length, 0, (Encoding)ASCIIEncoding.INSTANCE, Syntax.DEFAULT);
        System.err.println("::: /" + _reg + "/ =~ \"" + _str + "\", " + warmup + " * " + times2 + " times");
        long best = Long.MAX_VALUE;
        for (int j = 0; j < warmup; ++j) {
            long before = System.currentTimeMillis();
            for (int i2 = 0; i2 < times2; ++i2) {
                p2.matcher(str, 0, str.length).search(0, str.length, 0);
            }
            long time = System.currentTimeMillis() - before;
            if (time < best) {
                best = time;
            }
            System.err.print(".");
        }
        System.err.println(":  " + best + "ms");
    }
}

