// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A Freeze database environment descriptor.
 *
 **/
public class DbEnvDescriptor implements java.lang.Cloneable,
                                        java.io.Serializable
{
    /**
     * The name of the database environment.
     *
     **/
    public String name;

    /**
     * The description of this database environment.
     *
     **/
    public String description;

    /**
     * The home of the database environment (i.e., the directory where
     * the database files will be stored). If empty, the node will
     * provide a default database directory, otherwise the directory
     * must exist.
     *
     **/
    public String dbHome;

    /**
     * The configuration properties of the database environment.
     *
     **/
    public java.util.List<PropertyDescriptor> properties;

    public DbEnvDescriptor()
    {
        this.name = "";
        this.description = "";
        this.dbHome = "";
    }

    public DbEnvDescriptor(String name, String description, String dbHome, java.util.List<PropertyDescriptor> properties)
    {
        this.name = name;
        this.description = description;
        this.dbHome = dbHome;
        this.properties = properties;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        DbEnvDescriptor r = null;
        if(rhs instanceof DbEnvDescriptor)
        {
            r = (DbEnvDescriptor)rhs;
        }

        if(r != null)
        {
            if(this.name != r.name)
            {
                if(this.name == null || r.name == null || !this.name.equals(r.name))
                {
                    return false;
                }
            }
            if(this.description != r.description)
            {
                if(this.description == null || r.description == null || !this.description.equals(r.description))
                {
                    return false;
                }
            }
            if(this.dbHome != r.dbHome)
            {
                if(this.dbHome == null || r.dbHome == null || !this.dbHome.equals(r.dbHome))
                {
                    return false;
                }
            }
            if(this.properties != r.properties)
            {
                if(this.properties == null || r.properties == null || !this.properties.equals(r.properties))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int h_ = 5381;
        h_ = IceInternal.HashUtil.hashAdd(h_, "::IceGrid::DbEnvDescriptor");
        h_ = IceInternal.HashUtil.hashAdd(h_, name);
        h_ = IceInternal.HashUtil.hashAdd(h_, description);
        h_ = IceInternal.HashUtil.hashAdd(h_, dbHome);
        h_ = IceInternal.HashUtil.hashAdd(h_, properties);
        return h_;
    }

    public DbEnvDescriptor
    clone()
    {
        DbEnvDescriptor c = null;
        try
        {
            c = (DbEnvDescriptor)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    ice_writeMembers(Ice.OutputStream ostr)
    {
        ostr.writeString(this.name);
        ostr.writeString(this.description);
        ostr.writeString(this.dbHome);
        PropertyDescriptorSeqHelper.write(ostr, this.properties);
    }

    public void
    ice_readMembers(Ice.InputStream istr)
    {
        this.name = istr.readString();
        this.description = istr.readString();
        this.dbHome = istr.readString();
        this.properties = PropertyDescriptorSeqHelper.read(istr);
    }

    static public void
    ice_write(Ice.OutputStream ostr, DbEnvDescriptor v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public DbEnvDescriptor
    ice_read(Ice.InputStream istr)
    {
        DbEnvDescriptor v = new DbEnvDescriptor();
        v.ice_readMembers(istr);
        return v;
    }

    private static final DbEnvDescriptor _nullMarshalValue = new DbEnvDescriptor();

    public static final long serialVersionUID = -8665014517759078723L;
}
