#ifndef EFL_OBJECT_EO_HH
#define EFL_OBJECT_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_object.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { 
struct Object;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Object> : ::std::true_type {}; } }
namespace efl { 
struct Object;
} 

namespace eo_cxx {
namespace efl { 
struct Object {
   ::efl::eolian::return_traits< ::efl::Object>::type parent_get() const;
   ::efl::eolian::return_traits<void>::type parent_set( ::efl::eolian::in_traits< ::efl::Object>::type parent) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type name_get() const;
   ::efl::eolian::return_traits<void>::type name_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type name) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type comment_get() const;
   ::efl::eolian::return_traits<void>::type comment_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type comment) const;
   ::efl::eolian::return_traits<int>::type event_global_freeze_count_get() const;
   ::efl::eolian::return_traits<int>::type event_freeze_count_get() const;
   ::efl::eolian::return_traits<bool>::type finalized_get() const;
   ::efl::eolian::return_traits<void>::type del() const;
   ::efl::eolian::return_traits< ::efl::Object>::type provider_find( ::efl::eolian::in_traits< ::efl::Object>::type klass) const;
   ::efl::eolian::return_traits< ::efl::Object>::type constructor() const;
   ::efl::eolian::return_traits<void>::type destructor() const;
   ::efl::eolian::return_traits< ::efl::Object>::type finalize() const;
   ::efl::eolian::return_traits< ::efl::Object>::type name_find( ::efl::eolian::in_traits< ::efl::eina::string_view>::type search) const;
   ::efl::eolian::return_traits<void>::type event_thaw() const;
   ::efl::eolian::return_traits<void>::type event_freeze() const;
   ::efl::eolian::return_traits<void>::type event_global_thaw() const;
   ::efl::eolian::return_traits<void>::type event_global_freeze() const;
   ::efl::eolian::return_traits<void>::type event_callback_stop() const;
   ::efl::eolian::return_traits<void>::type event_callback_forwarder_add( ::efl::eolian::in_traits<Efl_Event_Description const&>::type desc,  ::efl::eolian::in_traits< ::efl::Object>::type new_obj) const;
   ::efl::eolian::return_traits<void>::type event_callback_forwarder_del( ::efl::eolian::in_traits<Efl_Event_Description const&>::type desc,  ::efl::eolian::in_traits< ::efl::Object>::type new_obj) const;
   ::efl::eolian::return_traits< ::efl::eina::iterator< ::efl::Object>>::type children_iterator_new() const;
   ::efl::eolian::return_traits<bool>::type composite_attach( ::efl::eolian::in_traits< ::efl::Object>::type comp_obj) const;
   ::efl::eolian::return_traits<bool>::type composite_detach( ::efl::eolian::in_traits< ::efl::Object>::type comp_obj) const;
   ::efl::eolian::return_traits<bool>::type composite_part_is() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_OBJECT_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Object() const;
   operator ::efl::Object&();
   operator ::efl::Object const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Object> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Object const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Object : ::efl::eo::concrete
{
   explicit Object( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Object(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Object(Object const& other) = default;
   Object(Object&& other) = default;
   Object& operator=(Object const& other) = default;
   Object& operator=(Object&& other) = default;
   Object()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Object( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Object(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits< ::efl::Object>::type parent_get() const;
   ::efl::eolian::return_traits<void>::type parent_set( ::efl::eolian::in_traits< ::efl::Object>::type parent) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type name_get() const;
   ::efl::eolian::return_traits<void>::type name_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type name) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type comment_get() const;
   ::efl::eolian::return_traits<void>::type comment_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type comment) const;
   ::efl::eolian::return_traits<int>::type event_global_freeze_count_get() const;
   ::efl::eolian::return_traits<int>::type event_freeze_count_get() const;
   ::efl::eolian::return_traits<bool>::type finalized_get() const;
   ::efl::eolian::return_traits<void>::type del() const;
   ::efl::eolian::return_traits< ::efl::Object>::type provider_find( ::efl::eolian::in_traits< ::efl::Object>::type klass) const;
   ::efl::eolian::return_traits< ::efl::Object>::type constructor() const;
   ::efl::eolian::return_traits<void>::type destructor() const;
   ::efl::eolian::return_traits< ::efl::Object>::type finalize() const;
   ::efl::eolian::return_traits< ::efl::Object>::type name_find( ::efl::eolian::in_traits< ::efl::eina::string_view>::type search) const;
   ::efl::eolian::return_traits<void>::type event_thaw() const;
   ::efl::eolian::return_traits<void>::type event_freeze() const;
   ::efl::eolian::return_traits<void>::type event_global_thaw() const;
   ::efl::eolian::return_traits<void>::type event_global_freeze() const;
   ::efl::eolian::return_traits<void>::type event_callback_stop() const;
   ::efl::eolian::return_traits<void>::type event_callback_forwarder_add( ::efl::eolian::in_traits<Efl_Event_Description const&>::type desc,  ::efl::eolian::in_traits< ::efl::Object>::type new_obj) const;
   ::efl::eolian::return_traits<void>::type event_callback_forwarder_del( ::efl::eolian::in_traits<Efl_Event_Description const&>::type desc,  ::efl::eolian::in_traits< ::efl::Object>::type new_obj) const;
   ::efl::eolian::return_traits< ::efl::eina::iterator< ::efl::Object>>::type children_iterator_new() const;
   ::efl::eolian::return_traits<bool>::type composite_attach( ::efl::eolian::in_traits< ::efl::Object>::type comp_obj) const;
   ::efl::eolian::return_traits<bool>::type composite_detach( ::efl::eolian::in_traits< ::efl::Object>::type comp_obj) const;
   ::efl::eolian::return_traits<bool>::type composite_part_is() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_OBJECT_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct callback_add_event
   {
      static Efl_Event_Description const* description()
      { return EFL_EVENT_CALLBACK_ADD; }
      typedef void parameter_type;
   } const callback_add_event;
   static struct callback_del_event
   {
      static Efl_Event_Description const* description()
      { return EFL_EVENT_CALLBACK_DEL; }
      typedef void parameter_type;
   } const callback_del_event;
   static struct del_event
   {
      static Efl_Event_Description const* description()
      { return EFL_EVENT_DEL; }
      typedef void parameter_type;
   } const del_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Object> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Object const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Object) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Object>::value, "");
} 
#endif
