/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/


#ifndef SBK_QTSCRIPTTOOLS_PYTHON_H
#define SBK_QTSCRIPTTOOLS_PYTHON_H

//workaround to access protected functions
#define protected public

#include <sbkpython.h>
#include <sbkconverter.h>
#include <sbkenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <pysidesignal.h>
// Module Includes
#include <pyside2_qtscript_python.h>
#include <pyside2_qtcore_python.h>
#include <pyside2_qtgui_python.h>
#include <pyside2_qtwidgets_python.h>

// Binded library includes
#include <qscriptenginedebugger.h>
// Conversion Includes - Primitive Types
#include <QStringList>
#include <qabstractitemmodel.h>
#include <signalmanager.h>
#include <QString>

// Conversion Includes - Container Types
#include <QSet>
#include <QPair>
#include <pysideqflags.h>
#include <QMap>
#include <QMultiMap>
#include <QVector>
#include <QList>
#include <QStack>
#include <QQueue>
#include <QLinkedList>

// Type indices
#define SBK_QSCRIPTENGINEDEBUGGER_IDX                                0
#define SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERWIDGET_IDX                 3
#define SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERACTION_IDX                 1
#define SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERSTATE_IDX                  2
#define SBK_QtScriptTools_IDX_COUNT                                  4

// This variable stores all Python types exported by this module.
extern PyTypeObject** SbkPySide2_QtScriptToolsTypes;

// This variable stores all type converters exported by this module.
extern SbkConverter** SbkPySide2_QtScriptToolsTypeConverters;

// Converter indices
#define SBK_QTSCRIPTTOOLS_QLIST_QOBJECTPTR_IDX                       0 // const QList<QObject* > &
#define SBK_QTSCRIPTTOOLS_QLIST_QBYTEARRAY_IDX                       1 // QList<QByteArray >
#define SBK_QTSCRIPTTOOLS_QLIST_QVARIANT_IDX                         2 // QList<QVariant >
#define SBK_QTSCRIPTTOOLS_QLIST_QSTRING_IDX                          3 // QList<QString >
#define SBK_QTSCRIPTTOOLS_QMAP_QSTRING_QVARIANT_IDX                  4 // QMap<QString,QVariant >
#define SBK_QtScriptTools_CONVERTERS_IDX_COUNT                       5

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType< ::QScriptEngineDebugger::DebuggerWidget >() { return SbkPySide2_QtScriptToolsTypes[SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERWIDGET_IDX]; }
template<> inline PyTypeObject* SbkType< ::QScriptEngineDebugger::DebuggerAction >() { return SbkPySide2_QtScriptToolsTypes[SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERACTION_IDX]; }
template<> inline PyTypeObject* SbkType< ::QScriptEngineDebugger::DebuggerState >() { return SbkPySide2_QtScriptToolsTypes[SBK_QSCRIPTENGINEDEBUGGER_DEBUGGERSTATE_IDX]; }
template<> inline PyTypeObject* SbkType< ::QScriptEngineDebugger >() { return reinterpret_cast<PyTypeObject*>(SbkPySide2_QtScriptToolsTypes[SBK_QSCRIPTENGINEDEBUGGER_IDX]); }

} // namespace Shiboken

#endif // SBK_QTSCRIPTTOOLS_PYTHON_H

