/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvmstat;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.model.AbstractModelProvider;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.jvmstat.JvmstatModelImpl;
import com.sun.tools.visualvm.jvmstat.application.JvmstatApplicationProvider;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModel;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmstatModelProvider
extends AbstractModelProvider<JvmstatModel, Application> {
    private static final Logger LOGGER = Logger.getLogger(JvmstatModelProvider.class.getName());

    static MonitoredVm getMonitoredVm(Application app) throws MonitorException {
        if (app.isRemoved() || app.getPid() == -1) {
            return null;
        }
        String vmId = "//" + app.getPid();
        try {
            MonitoredHost monitoredHost = JvmstatApplicationProvider.findMonitoredHost(app);
            if (monitoredHost != null) {
                int refreshInterval = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
                return monitoredHost.getMonitoredVm(new VmIdentifier(vmId), refreshInterval);
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "getMonitoredVm failed", ex);
        }
        return null;
    }

    public JvmstatModel createModelFor(Application app) {
        MonitoredVm vm = null;
        try {
            vm = JvmstatModelProvider.getMonitoredVm(app);
            if (vm != null) {
                if (vm.findByName("java.property.java.vm.version") != null) {
                    JvmstatModelImpl jvmstat = new JvmstatModelImpl(app, vm);
                    app.notifyWhenRemoved((DataRemovedListener)jvmstat);
                    return jvmstat;
                }
                LOGGER.log(Level.INFO, "java.property.java.vm.version is null");
            }
        }
        catch (MonitorException ex) {
            LOGGER.log(Level.INFO, "Could not get MonitoredVM", ex);
        }
        if (vm != null) {
            vm.detach();
        }
        return null;
    }
}

