/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ReorderImageryLayersAction
extends JosmAction {
    private static final int VK_SQUARE = 16777394;

    public ReorderImageryLayersAction() {
        super(I18n.tr("Reorder imagery layers", new Object[0]), "dialogs/layerlist", I18n.tr("Reorders non-overlay imagery layers.", new Object[0]), Shortcut.registerShortcut("imagery:reorder", I18n.tr("Reorder imagery layers", new Object[0]), 131, 5003), true);
        MainApplication.registerActionShortcut(this, Shortcut.registerShortcut("imagery:reorderbis", I18n.tr("Reorder imagery layers", new Object[0]), 16777394, 5003));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List layers = this.getNonOverlayImageryLayers().collect(Collectors.toList());
        int size = layers.size();
        if (size > 1) {
            this.getLayerManager().moveLayer((Layer)layers.get(0), this.getLayerManager().getLayers().indexOf(layers.get(size - 1)));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getNonOverlayImageryLayers().count() > 1L);
    }

    private Stream<ImageryLayer> getNonOverlayImageryLayers() {
        return this.getLayerManager().getLayersOfType(ImageryLayer.class).stream().filter(l -> !l.getInfo().isOverlay());
    }
}

