/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DrawSnapHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class DrawAction
extends MapMode
implements MapViewPaintable,
DataSelectionListener,
KeyPressReleaseListener,
ModifierExListener {
    public static final CachingProperty<Boolean> VIEWPORT_FOLLOWING = new BooleanProperty("draw.viewport.following", false).cached();
    private static final Color ORANGE_TRANSPARENT = new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue(), 128);
    private static final ArrowPaintHelper START_WAY_INDICATOR = new ArrowPaintHelper(Utils.toRadians(90.0), 8.0);
    static final CachingProperty<Boolean> USE_REPEATED_SHORTCUT = new BooleanProperty("draw.anglesnap.toggleOnRepeatedA", true).cached();
    static final CachingProperty<BasicStroke> RUBBER_LINE_STROKE = new StrokeProperty("draw.stroke.helper-line", "3").cached();
    static final CachingProperty<BasicStroke> HIGHLIGHT_STROKE = new StrokeProperty("draw.anglesnap.stroke.highlight", "10").cached();
    static final CachingProperty<BasicStroke> HELPER_STROKE = new StrokeProperty("draw.anglesnap.stroke.helper", "1 4").cached();
    static final CachingProperty<Double> SNAP_ANGLE_TOLERANCE = new DoubleProperty("draw.anglesnap.tolerance", 5.0).cached();
    static final CachingProperty<Boolean> DRAW_CONSTRUCTION_GEOMETRY = new BooleanProperty("draw.anglesnap.drawConstructionGeometry", true).cached();
    static final CachingProperty<Boolean> SHOW_PROJECTED_POINT = new BooleanProperty("draw.anglesnap.drawProjectedPoint", true).cached();
    static final CachingProperty<Boolean> SNAP_TO_PROJECTIONS = new BooleanProperty("draw.anglesnap.projectionsnap", true).cached();
    static final CachingProperty<Boolean> SHOW_ANGLE = new BooleanProperty("draw.anglesnap.showAngle", true).cached();
    static final CachingProperty<Color> SNAP_HELPER_COLOR = new NamedColorProperty(I18n.marktr("draw angle snap"), Color.ORANGE).cached();
    static final CachingProperty<Color> HIGHLIGHT_COLOR = new NamedColorProperty(I18n.marktr("draw angle snap highlight"), ORANGE_TRANSPARENT).cached();
    static final AbstractProperty<Color> RUBBER_LINE_COLOR = PaintColors.SELECTED.getProperty().getChildColor(I18n.marktr("helper line"));
    static final CachingProperty<Boolean> DRAW_HELPER_LINE = new BooleanProperty("draw.helper-line", true).cached();
    static final CachingProperty<Boolean> DRAW_TARGET_HIGHLIGHT = new BooleanProperty("draw.target-highlight", true).cached();
    static final CachingProperty<Double> SNAP_TO_INTERSECTION_THRESHOLD = new DoubleProperty("edit.snap-intersection-threshold", 10.0).cached();
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private transient Node lastUsedNode;
    private double toleranceMultiplier;
    private transient Node mouseOnExistingNode;
    private transient Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private transient Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private boolean wayIsFinished;
    private Point mousePos;
    private Point oldMousePos;
    private transient Node currentBaseNode;
    private transient Node previousNode;
    private EastNorth currentMouseEastNorth;
    private final transient DrawSnapHelper snapHelper = new DrawSnapHelper(this);
    private final transient Shortcut backspaceShortcut;
    private final BackSpaceAction backspaceAction;
    private final transient Shortcut snappingShortcut = Shortcut.registerShortcut("mapmode:drawanglesnapping", I18n.tr("Mode: Draw Angle snapping", new Object[0]), 65535, 5000);
    private boolean ignoreNextKeyRelease;
    private final SnapChangeAction snapChangeAction = new SnapChangeAction();
    private final JCheckBoxMenuItem snapCheckboxMenuItem = this.addMenuItem();
    private static final BasicStroke BASIC_STROKE = new BasicStroke(1.0f);
    private Point rightClickPressPos;

    public DrawAction() {
        super(I18n.tr("Draw", new Object[0]), "node/autonode", I18n.tr("Draw nodes", new Object[0]), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw", new Object[0])), 65, 5003), ImageProvider.getCursor("crosshair", null));
        this.snapHelper.setMenuCheckBox(this.snapCheckboxMenuItem);
        this.backspaceShortcut = Shortcut.registerShortcut("mapmode:backspace", I18n.tr("Backspace in Add mode", new Object[0]), 8, 5003);
        this.backspaceAction = new BackSpaceAction();
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
        this.snapHelper.init();
    }

    private JCheckBoxMenuItem addMenuItem() {
        int n = MainApplication.getMenu().editMenu.getItemCount();
        for (int i = n - 1; i > 0; --i) {
            JMenuItem item = MainApplication.getMenu().editMenu.getItem(i);
            if (item == null || item.getAction() == null || !(item.getAction() instanceof SnapChangeAction)) continue;
            MainApplication.getMenu().editMenu.remove(i);
        }
        return MainMenu.addWithCheckbox(MainApplication.getMenu().editMenu, this.snapChangeAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    private boolean redrawIfRequired(Object e) {
        boolean needsRepaint;
        this.updateStatusLine();
        boolean bl = needsRepaint = DRAW_HELPER_LINE.get() != false && !this.wayIsFinished;
        if (DRAW_TARGET_HIGHLIGHT.get().booleanValue()) {
            for (OsmPrimitive x : this.newHighlights) {
                if (this.oldHighlights.contains(x)) continue;
                x.setHighlighted(true);
                needsRepaint = true;
            }
            this.oldHighlights.removeAll(this.newHighlights);
            for (OsmPrimitive x : this.oldHighlights) {
                x.setHighlighted(false);
                needsRepaint = true;
            }
        }
        this.oldHighlights = this.newHighlights;
        if (!needsRepaint && !DRAW_TARGET_HIGHLIGHT.get().booleanValue()) {
            return false;
        }
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        Node baseNode = this.getCurrentBaseNode();
        if (editLayer != null && baseNode != null && !editLayer.data.selectionEmpty()) {
            DataSet currentDataSet = editLayer.getDataSet();
            Way continueFrom = DrawAction.getWayForNode(baseNode);
            if (this.alt && continueFrom != null && (!baseNode.isSelected() || continueFrom.isSelected())) {
                DrawAction.addRemoveSelection(currentDataSet, baseNode, continueFrom);
                needsRepaint = true;
            } else if (!this.alt && continueFrom != null && !continueFrom.isSelected()) {
                DrawAction.addSelection(currentDataSet, continueFrom);
                needsRepaint = true;
            }
        }
        if (!needsRepaint && e instanceof DataSelectionListener.SelectionChangeEvent) {
            DataSelectionListener.SelectionChangeEvent event = (DataSelectionListener.SelectionChangeEvent)e;
            boolean bl2 = needsRepaint = !event.getOldSelection().isEmpty() && event.getSelection().isEmpty();
        }
        if (needsRepaint && editLayer != null) {
            editLayer.invalidate();
        }
        return needsRepaint;
    }

    private static void addRemoveSelection(DataSet ds, OsmPrimitive toAdd, OsmPrimitive toRemove) {
        ds.beginUpdate();
        try {
            DrawAction.addSelection(ds, toAdd);
            DrawAction.clearSelection(ds, toRemove);
        }
        finally {
            ds.endUpdate();
        }
    }

    private static void updatePreservedFlag(OsmPrimitive osm, boolean state) {
        osm.setPreserved(state);
        if (osm instanceof Way) {
            for (Node n : ((Way)osm).getNodes()) {
                n.setPreserved(state);
            }
        }
    }

    private static void setSelection(DataSet ds, Collection<OsmPrimitive> toSet) {
        toSet.stream().forEach(x -> DrawAction.updatePreservedFlag(x, true));
        ds.setSelected(toSet);
    }

    private static void setSelection(DataSet ds, OsmPrimitive toSet) {
        DrawAction.updatePreservedFlag(toSet, true);
        ds.setSelected(toSet);
    }

    private static void addSelection(DataSet ds, OsmPrimitive toAdd) {
        DrawAction.updatePreservedFlag(toAdd, true);
        ds.addSelected(toAdd);
    }

    private static void clearSelection(DataSet ds, OsmPrimitive toRemove) {
        ds.clearSelection(toRemove);
        DrawAction.updatePreservedFlag(toRemove, false);
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        this.determineCurrentBaseNodeAndPreviousNode(this.getLayerManager().getEditDataSet().getSelected());
        this.wayIsFinished = this.getCurrentBaseNode() == null;
        this.toleranceMultiplier = 0.01 * (double)NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue();
        this.snapHelper.init();
        this.snapCheckboxMenuItem.getAction().setEnabled(true);
        MapFrame map = MainApplication.getMap();
        map.statusLine.getAnglePanel().addMouseListener(this.snapHelper.anglePopupListener);
        MainApplication.registerActionShortcut(this.backspaceAction, this.backspaceShortcut);
        map.mapView.addMouseListener(this);
        map.mapView.addMouseMotionListener(this);
        map.mapView.addTemporaryLayer(this);
        SelectionEventManager.getInstance().addSelectionListenerForEdt(this);
        map.keyDetector.addKeyListener(this);
        map.keyDetector.addModifierExListener(this);
        this.ignoreNextKeyRelease = true;
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.mapView.removeMouseMotionListener(this);
        map.mapView.removeTemporaryLayer(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MainApplication.unregisterActionShortcut(this.backspaceAction, this.backspaceShortcut);
        this.snapHelper.unsetFixedMode();
        this.snapCheckboxMenuItem.getAction().setEnabled(false);
        map.statusLine.getAnglePanel().removeMouseListener(this.snapHelper.anglePopupListener);
        map.statusLine.activateAnglePanel(false);
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.getSelected().stream().forEach(x -> DrawAction.updatePreservedFlag(x, false));
        }
        this.removeHighlighting(null);
        map.keyDetector.removeKeyListener(this);
        map.keyDetector.removeModifierExListener(this);
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(modifiers);
        this.computeHelperLine();
        this.addHighlighting(null);
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
        if (!(this.snappingShortcut.isEvent(e) || USE_REPEATED_SHORTCUT.get().booleanValue() && this.getShortcut().isEvent(e))) {
            return;
        }
        this.snapHelper.setFixedMode();
        this.computeHelperLine();
        this.redrawIfRequired(e);
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
        if (!(this.snappingShortcut.isEvent(e) || USE_REPEATED_SHORTCUT.get().booleanValue() && this.getShortcut().isEvent(e))) {
            return;
        }
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
            return;
        }
        this.snapHelper.unFixOrTurnOff();
        this.computeHelperLine();
        this.redrawIfRequired(e);
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            event.getOldSelection().stream().forEach(x -> DrawAction.updatePreservedFlag(x, false));
            event.getSelection().stream().forEach(x -> DrawAction.updatePreservedFlag(x, true));
            if (MainApplication.getMap() != null) {
                this.computeHelperLine();
                this.addHighlighting(event);
            }
        });
    }

    private void tryAgain(MouseEvent e) {
        this.getLayerManager().getEditDataSet().clearSelection();
        this.mouseReleased(e);
    }

    private void finishDrawing() {
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        MainApplication.getMap().selectSelectTool(true);
        this.snapHelper.noSnapNow();
        this.computeHelperLine();
        this.removeHighlighting(null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.rightClickPressPos = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            Point curMousePos = e.getPoint();
            if (curMousePos.equals(this.rightClickPressPos)) {
                this.tryToSetBaseSegmentForAngleSnap();
            }
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        MapView mapView = MainApplication.getMap().mapView;
        if (!mapView.isActiveLayerDrawable()) {
            return;
        }
        mapView.requestFocus();
        if (e.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        DataSet ds = this.getLayerManager().getEditDataSet();
        ArrayList selection = new ArrayList(ds.getSelected());
        boolean newNode = false;
        Node n = mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        if (this.ctrl) {
            Iterator it = ds.getSelectedWays().iterator();
            if (it.hasNext()) {
                if (!((Way)it.next()).containsNode(n)) {
                    n = null;
                }
            } else {
                n = null;
            }
        }
        if (n != null && !this.snapHelper.isActive()) {
            if (selection.isEmpty() || this.wayIsFinished) {
                DrawAction.setSelection(ds, n);
                Way continueFrom = DrawAction.getWayForNode(n);
                if (continueFrom != null) {
                    DrawAction.addSelection(ds, continueFrom);
                }
                this.wayIsFinished = false;
                return;
            }
        } else {
            EastNorth newEN;
            if (n != null) {
                EastNorth foundPoint = n.getEastNorth();
                newEN = this.snapHelper.getSnapPoint(foundPoint);
                double tolerance = mapView.getDist100Pixel() * this.toleranceMultiplier;
                if (foundPoint.distance(newEN) > tolerance) {
                    n = new Node(newEN);
                    newNode = true;
                }
            } else {
                EastNorth mouseEN = mapView.getEastNorth(e.getX(), e.getY());
                newEN = this.snapHelper.isSnapOn() ? this.snapHelper.getSnapPoint(mouseEN) : mouseEN;
                n = new Node(newEN);
                newNode = true;
            }
            this.snapHelper.unsetFixedMode();
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(ds.getSelected());
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        ArrayList<Way> replacedWays = new ArrayList<Way>();
        if (newNode) {
            if (n.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            cmds.add(new AddCommand(ds, n));
            if (!this.ctrl) {
                List<WaySegment> wss = mapView.getNearestWaySegments(mapView.getPoint(n), OsmPrimitive::isSelectable);
                if (this.snapHelper.isActive()) {
                    this.tryToMoveNodeOnIntersection(wss, n);
                }
                this.insertNodeIntoAllNearbySegments(wss, n, newSelection, cmds, replacedWays, reuseWays);
            }
        }
        boolean extendedWay = false;
        boolean wayIsFinishedTemp = this.wayIsFinished;
        this.wayIsFinished = false;
        if (!selection.isEmpty() && !this.shift) {
            Node selectedNode = null;
            Way selectedWay = null;
            for (OsmPrimitive p : selection) {
                if (p instanceof Node) {
                    if (selectedNode != null) {
                        this.tryAgain(e);
                        return;
                    }
                    selectedNode = (Node)p;
                    continue;
                }
                if (!(p instanceof Way)) continue;
                if (selectedWay != null) {
                    this.tryAgain(e);
                    return;
                }
                selectedWay = (Way)p;
            }
            Node n0 = this.findNodeToContinueFrom(selectedNode, selectedWay);
            if (n0 == null) {
                this.tryAgain(e);
                return;
            }
            if (!wayIsFinishedTemp) {
                Way wayToSelect;
                Way way;
                if (this.isSelfContainedWay(selectedWay, n0, n)) {
                    return;
                }
                if (n0 == n) {
                    this.finishDrawing();
                    return;
                }
                Way way2 = this.alt ? null : (way = selectedWay != null ? selectedWay : DrawAction.getWayForNode(n0));
                if (way != null) {
                    int nodeCount = 0;
                    for (Node p : way.getNodes()) {
                        if (!p.equals(n0)) continue;
                        ++nodeCount;
                    }
                    if (nodeCount > 1) {
                        way = null;
                    }
                }
                if (way == null) {
                    way = new Way();
                    way.addNode(n0);
                    cmds.add(new AddCommand(ds, way));
                    wayToSelect = way;
                } else {
                    int i = replacedWays.indexOf(way);
                    if (i != -1) {
                        wayToSelect = way = (Way)reuseWays.get(i);
                    } else {
                        wayToSelect = way;
                        Way wnew = new Way(way);
                        cmds.add(new ChangeCommand(way, wnew));
                        way = wnew;
                    }
                }
                if (way.containsNode(n)) {
                    this.wayIsFinished = true;
                    selection.clear();
                }
                if (way.getNode(way.getNodesCount() - 1) == n0) {
                    way.addNode(n);
                } else {
                    way.addNode(0, n);
                }
                extendedWay = true;
                newSelection.clear();
                newSelection.add(wayToSelect);
            }
        }
        if (!extendedWay && !newNode) {
            return;
        }
        String title = DrawAction.getTitle(newNode, n, newSelection, reuseWays, extendedWay);
        SequenceCommand c = new SequenceCommand(title, cmds);
        MainApplication.undoRedo.add(c);
        if (!this.wayIsFinished) {
            this.lastUsedNode = n;
        }
        DrawAction.setSelection(ds, newSelection);
        if (VIEWPORT_FOLLOWING.get().booleanValue()) {
            mapView.smoothScrollTo(n.getEastNorth());
        }
        this.computeHelperLine();
        this.removeHighlighting(e);
    }

    private static String getTitle(boolean newNode, Node n, Collection<OsmPrimitive> newSelection, List<Way> reuseWays, boolean extendedWay) {
        String title;
        if (!extendedWay) {
            if (reuseWays.isEmpty()) {
                title = I18n.tr("Add node", new Object[0]);
            } else {
                title = I18n.tr("Add node into way", new Object[0]);
                for (Way w : reuseWays) {
                    newSelection.remove(w);
                }
            }
            newSelection.clear();
            newSelection.add(n);
        } else {
            title = !newNode ? I18n.tr("Connect existing way to node", new Object[0]) : (reuseWays.isEmpty() ? I18n.tr("Add a new node to an existing way", new Object[0]) : I18n.tr("Add node into way and connect", new Object[0]));
        }
        return title;
    }

    private void insertNodeIntoAllNearbySegments(List<WaySegment> wss, Node n, Collection<OsmPrimitive> newSelection, Collection<Command> cmds, List<Way> replacedWays, List<Way> reuseWays) {
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            is.add(ws.lowerIndex);
        }
        HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            Way w = (Way)insertPoint.getKey();
            List is = (List)insertPoint.getValue();
            Way wnew = new Way(w);
            DrawAction.pruneSuccsAndReverse(is);
            Iterator iterator = is.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                segSet.add(Pair.sort(new Pair<Node, Node>(w.getNode(i), w.getNode(i + 1))));
                wnew.addNode(i + 1, n);
            }
            if (this.alt) {
                newSelection.add((OsmPrimitive)insertPoint.getKey());
            }
            cmds.add(new ChangeCommand((OsmPrimitive)insertPoint.getKey(), wnew));
            replacedWays.add((Way)insertPoint.getKey());
            reuseWays.add(wnew);
        }
        DrawAction.adjustNode(segSet, n);
    }

    private boolean isSelfContainedWay(Way selectedWay, Node currentNode, Node targetNode) {
        int posn0;
        if (selectedWay != null && ((posn0 = selectedWay.getNodes().indexOf(currentNode)) != -1 && posn0 >= 1 && targetNode.equals(selectedWay.getNode(posn0 - 1)) || posn0 < selectedWay.getNodesCount() - 1 && targetNode.equals(selectedWay.getNode(posn0 + 1)))) {
            DrawAction.setSelection(this.getLayerManager().getEditDataSet(), targetNode);
            this.lastUsedNode = targetNode;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node selectedNode, Way selectedWay) {
        if (selectedNode == null && selectedWay == null) {
            return null;
        }
        if (selectedNode == null) {
            if (selectedWay.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (selectedWay == null) {
            return selectedNode;
        }
        if (selectedWay.isFirstLastNode(selectedNode)) {
            return selectedNode;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        if (this.snapHelper.isSnapOn() && this.ctrl) {
            this.tryToSetBaseSegmentForAngleSnap();
        }
        this.computeHelperLine();
        this.addHighlighting(e);
    }

    private void tryToSetBaseSegmentForAngleSnap() {
        WaySegment seg;
        if (this.mousePos != null && (seg = MainApplication.getMap().mapView.getNearestWaySegment(this.mousePos, OsmPrimitive::isSelectable)) != null) {
            this.snapHelper.setBaseSegment(seg);
        }
    }

    private void computeHelperLine() {
        EastNorth en;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection<Object> selection = ds != null ? ds.getSelected() : Collections.emptyList();
        MapView mv = MainApplication.getMap().mapView;
        Node currentMouseNode = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        if (!this.ctrl && this.mousePos != null) {
            currentMouseNode = mv.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        }
        if (!this.ctrl && currentMouseNode == null) {
            List<WaySegment> wss = mv.getNearestWaySegments(this.mousePos, OsmPrimitive::isSelectable);
            for (WaySegment ws : wss) {
                this.mouseOnExistingWays.add(ws.way);
            }
        }
        if (currentMouseNode != null) {
            if (selection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = currentMouseNode.getEastNorth();
            this.mouseOnExistingNode = currentMouseNode;
        } else {
            this.currentMouseEastNorth = mv.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        this.determineCurrentBaseNodeAndPreviousNode(selection);
        if (this.previousNode == null) {
            this.snapHelper.noSnapNow();
        }
        if (this.getCurrentBaseNode() == null || this.getCurrentBaseNode() == currentMouseNode) {
            return;
        }
        DrawAction.showStatusInfo(-1.0, -1.0, -1.0, this.snapHelper.isSnapOn());
        double curHdg = Utils.toDegrees(this.getCurrentBaseNode().getEastNorth().heading(this.currentMouseEastNorth));
        double baseHdg = -1.0;
        if (this.previousNode != null && (en = this.previousNode.getEastNorth()) != null) {
            baseHdg = Utils.toDegrees(en.heading(this.getCurrentBaseNode().getEastNorth()));
        }
        this.snapHelper.checkAngleSnapping(this.currentMouseEastNorth, baseHdg, curHdg);
    }

    static void showStatusInfo(double angle, double hdg, double distance, boolean activeFlag) {
        MapFrame map = MainApplication.getMap();
        map.statusLine.setAngle(angle);
        map.statusLine.activateAnglePanel(activeFlag);
        map.statusLine.setHeading(hdg);
        map.statusLine.setDist(distance);
    }

    private void determineCurrentBaseNodeAndPreviousNode(Collection<OsmPrimitive> selection) {
        Node selectedNode = null;
        AbstractPrimitive selectedWay = null;
        for (OsmPrimitive p : selection) {
            if (p instanceof Node) {
                if (selectedNode != null) {
                    return;
                }
                selectedNode = (Node)p;
                continue;
            }
            if (!(p instanceof Way)) continue;
            if (selectedWay != null) {
                return;
            }
            selectedWay = (Way)p;
        }
        this.currentBaseNode = null;
        this.previousNode = null;
        if (selectedWay == null && selectedNode != null) {
            for (OsmPrimitive p : selectedNode.getReferrers()) {
                if (!p.isUsable() || !(p instanceof Way) || !((Way)p).isFirstLastNode(selectedNode)) continue;
                if (selectedWay != null) {
                    selectedWay = null;
                    break;
                }
                selectedWay = (Way)p;
            }
        }
        if (selectedNode == null) {
            if (selectedWay == null) {
                return;
            }
            this.continueWayFromNode((Way)selectedWay, this.lastUsedNode);
        } else if (selectedWay == null) {
            this.currentBaseNode = selectedNode;
        } else if (!selectedWay.isDeleted()) {
            this.continueWayFromNode((Way)selectedWay, selectedNode);
        }
    }

    private void continueWayFromNode(Way way, Node node) {
        int n = way.getNodesCount();
        if (node == way.firstNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(1);
            }
        } else if (node == way.lastNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(n - 2);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer == null) {
            return;
        }
        this.mousePos = e.getPoint();
        this.snapHelper.noSnapNow();
        boolean repaintIssued = this.removeHighlighting(e);
        if (!repaintIssued) {
            editLayer.invalidate();
        }
    }

    public static Way getWayForNode(Node n) {
        Way way = null;
        for (Way w : Utils.filteredCollection(n.getReferrers(), Way.class)) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            Node firstNode = w.getNode(0);
            Node lastNode = w.getNode(w.getNodesCount() - 1);
            if (firstNode != n && lastNode != n || firstNode == lastNode) continue;
            if (way != null) {
                return null;
            }
            way = w;
        }
        return way;
    }

    public Node getCurrentBaseNode() {
        if (!(this.currentBaseNode == null || this.currentBaseNode.getDataSet() != null && this.currentBaseNode.isUsable())) {
            this.currentBaseNode = null;
        }
        return this.currentBaseNode;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                DrawAction.adjustNodeTwoSegments(segs, n);
                break;
            }
            default: {
                DrawAction.adjustNodeDefault(segs, n);
            }
        }
    }

    private static void adjustNodeTwoSegments(Collection<Pair<Node, Node>> segs, Node n) {
        Iterator<Pair<Node, Node>> i = segs.iterator();
        Pair<Node, Node> seg = i.next();
        EastNorth pA = ((Node)seg.a).getEastNorth();
        EastNorth pB = ((Node)seg.b).getEastNorth();
        seg = i.next();
        EastNorth pC = ((Node)seg.a).getEastNorth();
        EastNorth pD = ((Node)seg.b).getEastNorth();
        double u = DrawAction.det(pB.east() - pA.east(), pB.north() - pA.north(), pC.east() - pD.east(), pC.north() - pD.north());
        if (u == 0.0) {
            return;
        }
        double q = DrawAction.det(pB.north() - pC.north(), pB.east() - pC.east(), pD.north() - pC.north(), pD.east() - pC.east()) / u;
        EastNorth intersection = new EastNorth(pB.east() + q * (pA.east() - pB.east()), pB.north() + q * (pA.north() - pB.north()));
        MapFrame map = MainApplication.getMap();
        if (map.mapView.getPoint2D(n).distance(map.mapView.getPoint2D(intersection)) < SNAP_TO_INTERSECTION_THRESHOLD.get()) {
            n.setEastNorth(intersection);
            return;
        }
        DrawAction.adjustNodeDefault(segs, n);
    }

    private static void adjustNodeDefault(Collection<Pair<Node, Node>> segs, Node n) {
        EastNorth p = n.getEastNorth();
        Pair<Node, Node> seg = segs.iterator().next();
        EastNorth pA = ((Node)seg.a).getEastNorth();
        EastNorth pB = ((Node)seg.b).getEastNorth();
        double a = p.distanceSq(pB);
        double b = p.distanceSq(pA);
        double c = pA.distanceSq(pB);
        double q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(pB.east() + q * (pA.east() - pB.east()), pB.north() + q * (pA.north() - pB.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private void tryToMoveNodeOnIntersection(List<WaySegment> wss, Node n) {
        EastNorth xPoint;
        if (wss.isEmpty()) {
            return;
        }
        WaySegment ws = wss.get(0);
        EastNorth p1 = ws.getFirstNode().getEastNorth();
        EastNorth p2 = ws.getSecondNode().getEastNorth();
        if (this.snapHelper.dir2 != null && this.getCurrentBaseNode() != null && (xPoint = Geometry.getSegmentSegmentIntersection(p1, p2, this.snapHelper.dir2, this.getCurrentBaseNode().getEastNorth())) != null) {
            n.setEastNorth(xPoint);
        }
    }

    private void addHighlighting(Object event) {
        this.newHighlights = new HashSet<OsmPrimitive>();
        MapView mapView = MainApplication.getMap().mapView;
        if (this.ctrl) {
            mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired(event);
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (this.mouseOnExistingNode == null && this.mousePos != null && ds != null && ds.selectionEmpty()) {
            this.mouseOnExistingNode = mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        }
        if (this.mouseOnExistingNode != null) {
            mapView.setNewCursor(this.cursorJoinNode, (Object)this);
            this.newHighlights.add(this.mouseOnExistingNode);
            this.redrawIfRequired(event);
            return;
        }
        if (this.mouseOnExistingWays.isEmpty()) {
            mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired(event);
            return;
        }
        mapView.setNewCursor(this.cursorJoinWay, (Object)this);
        this.newHighlights.addAll(this.mouseOnExistingWays);
        this.redrawIfRequired(event);
    }

    private boolean removeHighlighting(Object event) {
        this.newHighlights = new HashSet<OsmPrimitive>();
        return this.redrawIfRequired(event);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        MapView mapView = MainApplication.getMap().mapView;
        if (mapView == null || this.mousePos == null || this.currentMouseEastNorth == null || this.getCurrentBaseNode() == null || !mapView.getState().getForView(this.mousePos.getX(), this.mousePos.getY()).isInView()) {
            return;
        }
        Graphics2D g2 = g;
        this.snapHelper.drawIfNeeded(g2, mv.getState());
        if (!DRAW_HELPER_LINE.get().booleanValue() || this.wayIsFinished || this.shift) {
            return;
        }
        if (!this.snapHelper.isActive()) {
            g2.setColor(RUBBER_LINE_COLOR.get());
            g2.setStroke(RUBBER_LINE_STROKE.get());
            this.paintConstructionGeometry(mv, g2);
        } else if (DRAW_CONSTRUCTION_GEOMETRY.get().booleanValue()) {
            this.paintConstructionGeometry(mv, g2);
        }
    }

    private void paintConstructionGeometry(MapView mv, Graphics2D g2) {
        MapPath2D b = new MapPath2D();
        MapViewState.MapViewPoint p1 = mv.getState().getPointFor(this.getCurrentBaseNode());
        MapViewState.MapViewPoint p2 = mv.getState().getPointFor(this.currentMouseEastNorth);
        b.moveTo(p1);
        b.lineTo(p2);
        if (this.alt) {
            START_WAY_INDICATOR.paintArrowAt(b, p1, p2);
        }
        g2.draw(b);
        g2.setStroke(BASIC_STROKE);
    }

    @Override
    public String getModeHelpText() {
        OsmPrimitive x;
        StringBuilder rv = this.ctrl || this.oldHighlights.isEmpty() ? new StringBuilder(I18n.tr("Create new node.", new Object[0])) : ((x = this.oldHighlights.iterator().next()) instanceof Node ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size())));
        if (!this.wayIsFinished && this.getCurrentBaseNode() != null) {
            if (this.alt) {
                rv.append(' ').append(I18n.tr("Start new way from last node.", new Object[0]));
            } else {
                rv.append(' ').append(I18n.tr("Continue way from last node.", new Object[0]));
            }
            if (this.snapHelper.isSnapOn()) {
                rv.append(' ').append(I18n.tr("Angle snapping active.", new Object[0]));
            }
        }
        Node n = this.mouseOnExistingNode;
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (n != null && ds != null && ds.getSelectedNodes().contains(n)) {
            rv = this.wayIsFinished ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.tr("Finish drawing.", new Object[0]));
        }
        if (!(ds == null || ds.getSelectedWays().isEmpty() || this.wayIsFinished || this.alt)) {
            Way w = (Way)ds.getSelectedWays().iterator().next();
            for (Node m : w.getNodes()) {
                if (!m.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(w)) continue;
                rv.append(' ').append(I18n.tr("Finish drawing.", new Object[0]));
                break;
            }
        }
        return rv.toString();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        Way continueFrom;
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return Collections.emptyList();
        }
        if (this.getCurrentBaseNode() != null && !ds.selectionEmpty() && (continueFrom = DrawAction.getWayForNode(this.getCurrentBaseNode())) != null) {
            return Collections.singleton(continueFrom);
        }
        return ds.getSelected();
    }

    @Override
    @Deprecated
    public Collection<? extends OsmPrimitive> getPreservedPrimitives() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        return ds != null ? ds.allPreservedPrimitives() : Collections.emptySet();
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.snapChangeAction.destroy();
    }

    private class SnapChangeAction
    extends JosmAction {
        SnapChangeAction() {
            super(I18n.tr("Angle snapping", new Object[0]), "anglesnap", I18n.tr("Switch angle snapping mode while drawing", new Object[0]), null, false);
            this.putValue("help", HelpUtil.ht("/Action/Draw/AngleSnap"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DrawAction.this.snapHelper != null) {
                DrawAction.this.snapHelper.toggleSnapping();
            }
        }

        @Override
        protected void updateEnabledState() {
            MapFrame map = MainApplication.getMap();
            this.setEnabled(map != null && map.mapMode instanceof DrawAction);
        }
    }

    public class BackSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MainApplication.undoRedo.undo();
            Command lastCmd = MainApplication.undoRedo.getLastCommand();
            if (lastCmd == null) {
                return;
            }
            Node n = null;
            for (OsmPrimitive osmPrimitive : lastCmd.getParticipatingPrimitives()) {
                if (!(osmPrimitive instanceof Node)) continue;
                if (n == null) {
                    n = (Node)osmPrimitive;
                    DrawAction.this.wayIsFinished = false;
                    continue;
                }
                n = null;
                break;
            }
            if (n != null) {
                DrawAction.addSelection(DrawAction.this.getLayerManager().getEditDataSet(), n);
            }
        }
    }
}

