/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TemplatedWMSTileSource
extends AbstractWMSTileSource
implements TemplatedTileSource {
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Set<String> serverProjections;
    private static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
    private static final Pattern PATTERN_PROJ = Pattern.compile("\\{proj\\}");
    private static final Pattern PATTERN_WKID = Pattern.compile("\\{wkid\\}");
    private static final Pattern PATTERN_BBOX = Pattern.compile("\\{bbox\\}");
    private static final Pattern PATTERN_W = Pattern.compile("\\{w\\}");
    private static final Pattern PATTERN_S = Pattern.compile("\\{s\\}");
    private static final Pattern PATTERN_E = Pattern.compile("\\{e\\}");
    private static final Pattern PATTERN_N = Pattern.compile("\\{n\\}");
    private static final Pattern PATTERN_WIDTH = Pattern.compile("\\{width\\}");
    private static final Pattern PATTERN_HEIGHT = Pattern.compile("\\{height\\}");
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{([^}]+)\\}");
    private static final NumberFormat LATLON_FORMAT = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_PROJ, PATTERN_WKID, PATTERN_BBOX, PATTERN_W, PATTERN_S, PATTERN_E, PATTERN_N, PATTERN_WIDTH, PATTERN_HEIGHT};

    public TemplatedWMSTileSource(ImageryInfo info, Projection tileProjection) {
        super(info, tileProjection);
        this.serverProjections = new TreeSet<String>(info.getServerProjections());
        this.headers.putAll(info.getCustomHttpHeaders());
        this.handleTemplate();
        this.initProjection();
    }

    @Override
    public int getDefaultTileSize() {
        return WMSLayer.PROP_IMAGE_SIZE.get();
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String myProjCode = this.getServerCRS();
        EastNorth nw = this.getTileEastNorth(tilex, tiley, zoom);
        EastNorth se = this.getTileEastNorth(tilex + 1, tiley + 1, zoom);
        double w = nw.getX();
        double n = nw.getY();
        double s = se.getY();
        double e = se.getX();
        if ("EPSG:4326".equals(myProjCode) && !this.serverProjections.contains(myProjCode) && this.serverProjections.contains("CRS:84")) {
            myProjCode = "CRS:84";
        }
        boolean switchLatLon = false;
        if (this.baseUrl.toLowerCase(Locale.US).contains("crs=epsg:4326")) {
            switchLatLon = true;
        } else if (this.baseUrl.toLowerCase(Locale.US).contains("crs=")) {
            switchLatLon = Main.getProjection().switchXY();
        }
        String bbox = this.getBbox(zoom, tilex, tiley, switchLatLon);
        StringBuffer url = new StringBuffer(this.baseUrl.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            String replacement;
            switch (matcher.group(1)) {
                case "proj": {
                    replacement = myProjCode;
                    break;
                }
                case "wkid": {
                    replacement = myProjCode.startsWith("EPSG:") ? myProjCode.substring(5) : myProjCode;
                    break;
                }
                case "bbox": {
                    replacement = bbox;
                    break;
                }
                case "w": {
                    replacement = LATLON_FORMAT.format(w);
                    break;
                }
                case "s": {
                    replacement = LATLON_FORMAT.format(s);
                    break;
                }
                case "e": {
                    replacement = LATLON_FORMAT.format(e);
                    break;
                }
                case "n": {
                    replacement = LATLON_FORMAT.format(n);
                    break;
                }
                case "width": 
                case "height": {
                    replacement = String.valueOf(this.getTileSize());
                    break;
                }
                default: {
                    replacement = '{' + matcher.group(1) + '}';
                }
            }
            matcher.appendReplacement(url, replacement);
        }
        matcher.appendTail(url);
        return url.toString().replace(" ", "%20");
    }

    @Override
    public String getTileId(int zoom, int tilex, int tiley) {
        return this.getTileUrl(zoom, tilex, tiley);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static void checkUrl(String url) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        Matcher m = PATTERN_PARAM.matcher(url);
        while (m.find()) {
            boolean isSupportedPattern = false;
            for (Pattern pattern : ALL_PATTERNS) {
                if (!pattern.matcher(m.group()).matches()) continue;
                isSupportedPattern = true;
                break;
            }
            if (isSupportedPattern) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", m.group(), url));
        }
    }

    private void handleTemplate() {
        StringBuffer output = new StringBuffer();
        Matcher matcher = PATTERN_HEADER.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        this.baseUrl = output.toString();
    }
}

