/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DiffResultProcessor {
    private final Map<PrimitiveId, DiffResultEntry> diffResults = new HashMap<PrimitiveId, DiffResultEntry>();
    private final Set<OsmPrimitive> processed;
    private final Collection<? extends OsmPrimitive> primitives;

    public DiffResultProcessor(Collection<? extends OsmPrimitive> primitives) {
        this.primitives = Optional.ofNullable(primitives).orElseGet(Collections::emptyList);
        this.processed = new HashSet<OsmPrimitive>();
    }

    public void parse(String diffUploadResponse, ProgressMonitor progressMonitor) throws XmlParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(diffUploadResponse, "diffUploadResponse");
        try {
            progressMonitor.beginTask(I18n.tr("Parsing response from server...", new Object[0]));
            InputSource inputSource = new InputSource(new StringReader(diffUploadResponse));
            XmlUtils.parseSafeSAX(inputSource, new Parser());
        }
        catch (XmlParsingException e) {
            throw e;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlParsingException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OsmPrimitive> postProcess(Changeset cs, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        DataSet ds = null;
        if (!this.primitives.isEmpty()) {
            ds = this.primitives.iterator().next().getDataSet();
        }
        boolean readOnly = false;
        if (ds != null) {
            readOnly = ds.isLocked();
            if (readOnly) {
                ds.unlock();
            }
            ds.beginUpdate();
        }
        try {
            monitor.beginTask("Postprocessing uploaded data ...");
            monitor.setTicksCount(this.primitives.size());
            monitor.setTicks(0);
            for (OsmPrimitive osmPrimitive : this.primitives) {
                monitor.worked(1);
                DiffResultEntry entry = this.diffResults.get(osmPrimitive.getPrimitiveId());
                if (entry == null) continue;
                this.processed.add(osmPrimitive);
                if (!osmPrimitive.isDeleted()) {
                    osmPrimitive.setOsmId(entry.newId, entry.newVersion);
                    osmPrimitive.setVisible(true);
                } else {
                    osmPrimitive.setVisible(false);
                }
                if (cs == null || cs.isNew()) continue;
                osmPrimitive.setChangesetId(cs.getId());
                osmPrimitive.setUser(cs.getUser());
                osmPrimitive.setTimestamp(Utils.firstNonNull(cs.getClosedAt(), new Date()));
            }
            Set<OsmPrimitive> set = this.processed;
            return set;
        }
        finally {
            if (ds != null) {
                ds.endUpdate();
                if (readOnly) {
                    ds.lock();
                }
            }
            monitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws XmlParsingException {
            throw new XmlParsingException(msg).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                switch (qName) {
                    case "diffResult": {
                        break;
                    }
                    case "node": 
                    case "way": 
                    case "relation": {
                        SimplePrimitiveId id = new SimplePrimitiveId(Long.parseLong(atts.getValue("old_id")), OsmPrimitiveType.fromApiTypeName(qName));
                        DiffResultEntry entry = new DiffResultEntry();
                        if (atts.getValue("new_id") != null) {
                            entry.newId = Long.parseLong(atts.getValue("new_id"));
                        }
                        if (atts.getValue("new_version") != null) {
                            entry.newVersion = Integer.parseInt(atts.getValue("new_version"));
                        }
                        DiffResultProcessor.this.diffResults.put(id, entry);
                        break;
                    }
                    default: {
                        this.throwException(I18n.tr("Unexpected XML element with name ''{0}''", qName));
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new XmlParsingException(e).rememberLocation(this.locator);
            }
        }
    }

    private static class DiffResultEntry {
        private long newId;
        private int newVersion;

        private DiffResultEntry() {
        }
    }
}

