/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader
implements GpxConstants {
    private String version;
    private GpxData gpxData;
    private final InputSource inputSource;

    public GpxReader(InputStream source) throws IOException {
        UTFInputStreamReader utf8stream = UTFInputStreamReader.create(source);
        InvalidXmlCharacterFilter filtered = new InvalidXmlCharacterFilter(utf8stream);
        this.inputSource = new InputSource(filtered);
    }

    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            XmlUtils.parseSafeSAX(this.inputSource, parser);
            return true;
        }
        catch (SAXException e) {
            if (tryToFinish) {
                parser.tryToFinish();
                if (parser.data.isEmpty()) {
                    throw e;
                }
                String message = e.getMessage();
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    message = message + ' ' + I18n.tr("(at line {0}, column {1})", spe.getLineNumber(), spe.getColumnNumber());
                }
                Logging.warn(message);
                return false;
            }
            throw e;
        }
        catch (ParserConfigurationException e) {
            Logging.error(e);
            throw new SAXException(e);
        }
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    private class Parser
    extends DefaultHandler {
        private GpxData data;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.INIT;
        private GpxLink currentLink;
        private Extensions currentExtensions;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuilder accumulator = new StringBuilder();
        private boolean nokiaSportsTrackerBug;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.states = new Stack();
            this.data = new GpxData();
        }

        private double parseCoord(Attributes atts, String key) {
            String val = atts.getValue(key);
            if (val != null) {
                return this.parseCoord(val);
            }
            return this.parseCoord(atts.getValue(key.replaceFirst("l", "L")));
        }

        private double parseCoord(String s) {
            if (s != null) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException ex) {
                    Logging.trace(ex);
                }
            }
            return Double.NaN;
        }

        private LatLon parseLatLon(Attributes atts) {
            return new LatLon(this.parseCoord(atts, "lat"), this.parseCoord(atts, "lon"));
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.elements.push(localName);
            block0 : switch (this.currentState) {
                case INIT: {
                    this.states.push(this.currentState);
                    this.currentState = State.GPX;
                    this.data.creator = atts.getValue("creator");
                    GpxReader.this.version = atts.getValue("version");
                    if (GpxReader.this.version != null && GpxReader.this.version.startsWith("1.0")) {
                        GpxReader.this.version = "1.0";
                        break;
                    }
                    if ("1.1".equals(GpxReader.this.version)) break;
                    GpxReader.this.version = "1.1";
                    break;
                }
                case GPX: {
                    switch (localName) {
                        case "metadata": {
                            this.states.push(this.currentState);
                            this.currentState = State.METADATA;
                            break;
                        }
                        case "wpt": {
                            this.states.push(this.currentState);
                            this.currentState = State.WPT;
                            this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                            break;
                        }
                        case "rte": {
                            this.states.push(this.currentState);
                            this.currentState = State.RTE;
                            this.currentRoute = new GpxRoute();
                            break;
                        }
                        case "trk": {
                            this.states.push(this.currentState);
                            this.currentState = State.TRK;
                            this.currentTrack = new ArrayList<Collection<WayPoint>>();
                            this.currentTrackAttr = new HashMap<String, Object>();
                            break;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break;
                        }
                        case "gpx": {
                            if (atts.getValue("creator") == null || !atts.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                            this.nokiaSportsTrackerBug = true;
                            break;
                        }
                    }
                    break;
                }
                case METADATA: {
                    switch (localName) {
                        case "author": {
                            this.states.push(this.currentState);
                            this.currentState = State.AUTHOR;
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                        case "copyright": {
                            this.states.push(this.currentState);
                            this.currentState = State.COPYRIGHT;
                            this.data.put("meta.copyright.author", atts.getValue("author"));
                            break block0;
                        }
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(atts.getValue("href"));
                            break block0;
                        }
                        case "bounds": {
                            this.data.put("meta.bounds", new Bounds(this.parseCoord(atts, "minlat"), this.parseCoord(atts, "minlon"), this.parseCoord(atts, "maxlat"), this.parseCoord(atts, "maxlon")));
                            break block0;
                        }
                    }
                    break;
                }
                case AUTHOR: {
                    switch (localName) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(atts.getValue("href"));
                            break block0;
                        }
                        case "email": {
                            this.data.put("meta.author.email", atts.getValue("id") + '@' + atts.getValue("domain"));
                            break block0;
                        }
                    }
                    break;
                }
                case TRK: {
                    switch (localName) {
                        case "trkseg": {
                            this.states.push(this.currentState);
                            this.currentState = State.TRKSEG;
                            this.currentTrackSeg = new ArrayList<WayPoint>();
                            break block0;
                        }
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(atts.getValue("href"));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
                case TRKSEG: {
                    if (!"trkpt".equals(localName)) break;
                    this.states.push(this.currentState);
                    this.currentState = State.WPT;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                    break;
                }
                case WPT: {
                    switch (localName) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(atts.getValue("href"));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
                case RTE: {
                    switch (localName) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(atts.getValue("href"));
                            break block0;
                        }
                        case "rtept": {
                            this.states.push(this.currentState);
                            this.currentState = State.WPT;
                            this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < ch.length; ++i) {
                    if (ch[i] != '\u0001') continue;
                    ch[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(ch, start, length);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case RTE: {
                    return this.currentRoute.attr;
                }
                case METADATA: {
                    return this.data.attr;
                }
                case WPT: {
                    return this.currentWayPoint.attr;
                }
                case TRK: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            this.elements.pop();
            block1 : switch (this.currentState) {
                case GPX: 
                case METADATA: {
                    switch (localName) {
                        case "name": {
                            this.data.put("meta.name", this.accumulator.toString());
                            break;
                        }
                        case "desc": {
                            this.data.put("meta.desc", this.accumulator.toString());
                            break;
                        }
                        case "time": {
                            this.data.put("meta.time", this.accumulator.toString());
                            break;
                        }
                        case "keywords": {
                            this.data.put("meta.keywords", this.accumulator.toString());
                            break;
                        }
                        case "author": {
                            if (!"1.0".equals(GpxReader.this.version)) break;
                            this.data.put("meta.author.name", this.accumulator.toString());
                            break;
                        }
                        case "email": {
                            if (!"1.0".equals(GpxReader.this.version)) break;
                            this.data.put("meta.author.email", this.accumulator.toString());
                            break;
                        }
                        case "url": 
                        case "urlname": {
                            this.data.put(localName, this.accumulator.toString());
                            break;
                        }
                        case "metadata": 
                        case "gpx": {
                            if ((this.currentState != State.METADATA || !"metadata".equals(localName)) && (this.currentState != State.GPX || !"gpx".equals(localName))) break;
                            this.convertUrlToLink(this.data.attr);
                            if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                                this.data.put("meta.extensions", this.currentExtensions);
                            }
                            this.currentState = this.states.pop();
                            break;
                        }
                        case "bounds": {
                            break;
                        }
                    }
                    break;
                }
                case AUTHOR: {
                    switch (localName) {
                        case "author": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "name": {
                            this.data.put("meta.author.name", this.accumulator.toString());
                            break block1;
                        }
                        case "email": {
                            break block1;
                        }
                        case "link": {
                            this.data.put("meta.author.link", this.currentLink);
                            break block1;
                        }
                    }
                    break;
                }
                case COPYRIGHT: {
                    switch (localName) {
                        case "copyright": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "year": {
                            this.data.put("meta.copyright.year", this.accumulator.toString());
                            break block1;
                        }
                        case "license": {
                            this.data.put("meta.copyright.license", this.accumulator.toString());
                            break block1;
                        }
                    }
                    break;
                }
                case LINK: {
                    switch (localName) {
                        case "text": {
                            this.currentLink.text = this.accumulator.toString();
                            break;
                        }
                        case "type": {
                            this.currentLink.type = this.accumulator.toString();
                            break;
                        }
                        case "link": {
                            if (this.currentLink.uri == null && this.accumulator != null && !this.accumulator.toString().isEmpty()) {
                                this.currentLink = new GpxLink(this.accumulator.toString());
                            }
                            this.currentState = this.states.pop();
                            break;
                        }
                    }
                    if (this.currentState == State.AUTHOR) {
                        this.data.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.LINK) break;
                    Map<String, Object> attr = this.getAttr();
                    if (attr != null && !attr.containsKey("meta.links")) {
                        attr.put("meta.links", new LinkedList());
                    }
                    if (attr == null) break;
                    ((Collection)attr.get("meta.links")).add(this.currentLink);
                    break;
                }
                case WPT: {
                    switch (localName) {
                        case "ele": 
                        case "magvar": 
                        case "name": 
                        case "src": 
                        case "geoidheight": 
                        case "type": 
                        case "sym": 
                        case "url": 
                        case "urlname": {
                            this.currentWayPoint.put(localName, this.accumulator.toString());
                            break block1;
                        }
                        case "hdop": 
                        case "vdop": 
                        case "pdop": {
                            try {
                                this.currentWayPoint.put(localName, Float.valueOf(this.accumulator.toString()));
                            }
                            catch (NumberFormatException e) {
                                this.currentWayPoint.put(localName, Float.valueOf(0.0f));
                            }
                            break block1;
                        }
                        case "time": 
                        case "cmt": 
                        case "desc": {
                            this.currentWayPoint.put(localName, this.accumulator.toString());
                            this.currentWayPoint.setTime();
                            break block1;
                        }
                        case "rtept": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            this.currentRoute.routePoints.add(this.currentWayPoint);
                            break block1;
                        }
                        case "trkpt": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            this.currentTrackSeg.add(this.currentWayPoint);
                            break block1;
                        }
                        case "wpt": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                                this.currentWayPoint.put("meta.extensions", this.currentExtensions);
                            }
                            this.data.waypoints.add(this.currentWayPoint);
                            break block1;
                        }
                    }
                    break;
                }
                case TRKSEG: {
                    if (!"trkseg".equals(localName)) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case TRK: {
                    switch (localName) {
                        case "trk": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentTrackAttr);
                            this.data.addTrack(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                            break block1;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": 
                        case "number": 
                        case "url": 
                        case "urlname": {
                            this.currentTrackAttr.put(localName, this.accumulator.toString());
                            break block1;
                        }
                    }
                    break;
                }
                case EXT: {
                    if ("extensions".equals(localName)) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!GpxConstants.JOSM_EXTENSIONS_NAMESPACE_URI.equals(namespaceURI)) break;
                    this.currentExtensions.put(localName, this.accumulator.toString());
                    break;
                }
                default: {
                    switch (localName) {
                        case "wpt": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "rte": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentRoute.attr);
                            this.data.addRoute(this.currentRoute);
                            break block1;
                        }
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
            }
            Extensions metaExt = (Extensions)this.data.get("meta.extensions");
            if (metaExt != null && "true".equals(metaExt.get("from-server"))) {
                this.data.fromServer = true;
            }
            GpxReader.this.gpxData = this.data;
        }

        private void convertUrlToLink(Map<String, Object> attr) {
            String url = (String)attr.get("url");
            String urlname = (String)attr.get("urlname");
            if (url != null) {
                if (!attr.containsKey("meta.links")) {
                    attr.put("meta.links", new LinkedList());
                }
                GpxLink link = new GpxLink(url);
                link.text = urlname;
                Collection links = (Collection)attr.get("meta.links");
                links.add(link);
            }
        }

        void tryToFinish() throws SAXException {
            ArrayList<String> remainingElements = new ArrayList<String>(this.elements);
            for (int i = remainingElements.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)remainingElements.get(i), (String)remainingElements.get(i));
            }
            this.endDocument();
        }
    }

    private static enum State {
        INIT,
        GPX,
        METADATA,
        WPT,
        RTE,
        TRK,
        EXT,
        AUTHOR,
        LINK,
        TRKSEG,
        COPYRIGHT;

    }
}

