/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PropertySet;
import writer2latex.util.Calc;
import writer2latex.util.Misc;

public class StyleWithProperties
extends OfficeStyle {
    private static final int OLDPROPS = 0;
    private static final int TEXT = 1;
    private static final int PAR = 2;
    private static final int SECTION = 3;
    private static final int TABLE = 4;
    private static final int COLUMN = 5;
    private static final int ROW = 6;
    private static final int CELL = 7;
    private static final int GRAPHIC = 8;
    private static final int PAGE = 9;
    private static final int COUNT = 10;
    private PropertySet[] properties = new PropertySet[10];
    private boolean bIsOldProps = false;
    private PropertySet backgroundImageProperties = new PropertySet();
    private int nColCount = 0;
    private boolean bHasFootnoteSep = false;
    private PropertySet footnoteSep = new PropertySet();

    public StyleWithProperties() {
        for (int i = 0; i < 10; ++i) {
            this.properties[i] = new PropertySet();
        }
    }

    @Override
    public void loadStyleFromDOM(Node node) {
        super.loadStyleFromDOM(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if ("style:properties".equals(sName)) {
                this.bIsOldProps = true;
                this.loadPropertiesFromDOM(0, child);
                continue;
            }
            if ("style:text-properties".equals(sName)) {
                this.loadPropertiesFromDOM(1, child);
                continue;
            }
            if ("style:paragraph-properties".equals(sName)) {
                this.loadPropertiesFromDOM(2, child);
                continue;
            }
            if ("style:section-properties".equals(sName)) {
                this.loadPropertiesFromDOM(3, child);
                continue;
            }
            if ("style:table-properties".equals(sName)) {
                this.loadPropertiesFromDOM(4, child);
                continue;
            }
            if ("style:table-column-properties".equals(sName)) {
                this.loadPropertiesFromDOM(5, child);
                continue;
            }
            if ("style:table-row-properties".equals(sName)) {
                this.loadPropertiesFromDOM(6, child);
                continue;
            }
            if ("style:table-cell-properties".equals(sName)) {
                this.loadPropertiesFromDOM(7, child);
                continue;
            }
            if ("style:graphic-properties".equals(sName)) {
                this.loadPropertiesFromDOM(8, child);
                continue;
            }
            if ("style:page-layout-properties".equals(sName)) {
                this.loadPropertiesFromDOM(9, child);
                continue;
            }
            if (!"style:drawing-page-properties".equals(sName)) continue;
            this.loadPropertiesFromDOM(9, child);
        }
    }

    private void loadPropertiesFromDOM(int nIndex, Node node) {
        this.properties[nIndex].loadFromDOM(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if ("style:background-image".equals(sName)) {
                this.backgroundImageProperties.loadFromDOM(child);
                continue;
            }
            if ("style:columns".equals(sName)) {
                this.nColCount = Misc.getPosInteger(Misc.getAttribute(child, "fo:column-count"), 1);
                continue;
            }
            if (!"style:footnote-sep".equals(sName)) continue;
            this.bHasFootnoteSep = true;
            this.footnoteSep.loadFromDOM(child);
        }
    }

    protected String getProperty(int nIndex, String sName, boolean bInherit) {
        StyleWithProperties parentStyle;
        int nRealIndex;
        int n = nRealIndex = this.bIsOldProps ? 0 : nIndex;
        if (this.properties[nRealIndex].containsProperty(sName)) {
            String sValue = this.properties[nRealIndex].getProperty(sName);
            return Calc.truncateLength(sValue);
        }
        if (bInherit && this.getParentName() != null && (parentStyle = (StyleWithProperties)this.family.getStyle(this.getParentName())) != null) {
            return parentStyle.getProperty(nIndex, sName, bInherit);
        }
        return null;
    }

    public String getTextProperty(String sName, boolean bInherit) {
        return this.getProperty(1, sName, bInherit);
    }

    public String getParProperty(String sName, boolean bInherit) {
        return this.getProperty(2, sName, bInherit);
    }

    public String getSectionProperty(String sName, boolean bInherit) {
        return this.getProperty(3, sName, bInherit);
    }

    public String getTableProperty(String sName, boolean bInherit) {
        return this.getProperty(4, sName, bInherit);
    }

    public String getColumnProperty(String sName, boolean bInherit) {
        return this.getProperty(5, sName, bInherit);
    }

    public String getRowProperty(String sName, boolean bInherit) {
        return this.getProperty(6, sName, bInherit);
    }

    public String getCellProperty(String sName, boolean bInherit) {
        return this.getProperty(7, sName, bInherit);
    }

    public String getGraphicProperty(String sName, boolean bInherit) {
        return this.getProperty(8, sName, bInherit);
    }

    public String getProperty(String sProperty, boolean bInherit) {
        for (int i = 0; i < 10; ++i) {
            String sValue = this.getProperty(i, sProperty, bInherit);
            if (sValue == null) continue;
            return sValue;
        }
        return null;
    }

    public String getProperty(String sProperty) {
        return this.getProperty(sProperty, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getAbsoluteProperty(int nIndex, String sProperty) {
        StyleWithProperties style;
        String sValue;
        int nRealIndex;
        int n = nRealIndex = this.bIsOldProps ? 0 : nIndex;
        if (this.properties[nRealIndex].containsProperty(sProperty)) {
            String sValue2 = this.properties[nRealIndex].getProperty(sProperty);
            if (!sValue2.endsWith("%")) return Calc.truncateLength(sValue2);
            StyleWithProperties parentStyle = (StyleWithProperties)this.family.getStyle(this.getParentName());
            if (parentStyle != null) {
                String sParentValue = parentStyle.getAbsoluteProperty(nIndex, sProperty);
                if (sParentValue == null) return null;
                return Calc.multiply(sValue2, sParentValue);
            }
            if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null) return null;
            StyleWithProperties style2 = (StyleWithProperties)this.getFamily().getDefaultStyle();
            String sDefaultValue = style2.getProperty(nIndex, sProperty, false);
            if (sValue2 == null) return null;
            return Calc.multiply(sValue2, sDefaultValue);
        }
        if (this.getParentName() != null) {
            StyleWithProperties parentStyle = (StyleWithProperties)this.family.getStyle(this.getParentName());
            if (parentStyle == null) return null;
            return parentStyle.getAbsoluteProperty(nIndex, sProperty);
        }
        if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null || (sValue = (style = (StyleWithProperties)this.getFamily().getDefaultStyle()).getProperty(nIndex, sProperty, false)) == null) return null;
        return sValue;
    }

    public String getAbsoluteTextProperty(String sName) {
        return this.getAbsoluteProperty(1, sName);
    }

    public String getAbsoluteParProperty(String sName) {
        return this.getAbsoluteProperty(2, sName);
    }

    public String getAbsoluteSectionProperty(String sName) {
        return this.getAbsoluteProperty(3, sName);
    }

    public String getAbsoluteTableProperty(String sName) {
        return this.getAbsoluteProperty(4, sName);
    }

    public String getAbsoluteColumnProperty(String sName) {
        return this.getAbsoluteProperty(5, sName);
    }

    public String getAbsoluteRowProperty(String sName) {
        return this.getAbsoluteProperty(6, sName);
    }

    public String getAbsoluteCellProperty(String sName) {
        return this.getAbsoluteProperty(7, sName);
    }

    public String getAbsoluteGraphicProperty(String sName) {
        return this.getAbsoluteProperty(8, sName);
    }

    public String getAbsoluteProperty(String sProperty) {
        for (int i = 0; i < 10; ++i) {
            String sValue = this.getAbsoluteProperty(i, sProperty);
            if (sValue == null) continue;
            return sValue;
        }
        return null;
    }

    public String getAbsoluteLength(String sProperty) {
        String s = this.getAbsoluteProperty(sProperty);
        if (s == null) {
            return "0cm";
        }
        return s;
    }

    public String getBackgroundImageProperty(String sName) {
        return this.backgroundImageProperties.getProperty(sName);
    }

    public int getColCount() {
        return this.nColCount;
    }

    public boolean hasFootnoteSep() {
        return this.bHasFootnoteSep;
    }

    public String getFootnoteProperty(String sPropName) {
        return this.footnoteSep.getProperty(sPropName);
    }
}

