"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const profilingCPUFallback_1 = require("../profiling/profilingCPUFallback");
const profilingHeapFallback_1 = require("../profiling/profilingHeapFallback");
const configuration_1 = require("../configuration");
class ProfilingFeature {
    init(forceFallback) {
        // allow to force the fallback via environment
        if (process.env.PM2_PROFILING_FORCE_FALLBACK)
            forceFallback = true;
        const isInspectorOk = require('semver').satisfies(process.version, '>= 8.0.0') && !forceFallback;
        let ProfilingCPU;
        let ProfilingHeap;
        if (isInspectorOk) {
            ProfilingCPU = require('../profiling/profilingCPU').default;
            ProfilingHeap = require('../profiling/profilingHeap').default;
            configuration_1.default.configureModule({
                heapdump: true
            });
        }
        this.profilings = {
            cpuProfiling: isInspectorOk ? new ProfilingCPU() : new profilingCPUFallback_1.default(),
            heapProfiling: isInspectorOk ? new ProfilingHeap() : new profilingHeapFallback_1.default()
        };
        return this.profilings;
    }
    destroy() {
        for (let profilingName in this.profilings) {
            if (typeof this.profilings[profilingName].destroy === 'function') {
                this.profilings[profilingName].destroy();
            }
        }
    }
}
exports.default = ProfilingFeature;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvZmlsaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2ZlYXR1cmVzL3Byb2ZpbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBLDRFQUFvRTtBQUNwRSw4RUFBc0U7QUFDdEUsb0RBQTRDO0FBRTVDO0lBSUUsSUFBSSxDQUFFLGFBQXVCO1FBQzNCLDhDQUE4QztRQUM5QyxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsNEJBQTRCO1lBQUUsYUFBYSxHQUFHLElBQUksQ0FBQTtRQUVsRSxNQUFNLGFBQWEsR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUE7UUFDaEcsSUFBSSxZQUFZLENBQUE7UUFDaEIsSUFBSSxhQUFhLENBQUE7UUFFakIsSUFBSSxhQUFhLEVBQUU7WUFDakIsWUFBWSxHQUFHLE9BQU8sQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLE9BQU8sQ0FBQTtZQUMzRCxhQUFhLEdBQUcsT0FBTyxDQUFDLDRCQUE0QixDQUFDLENBQUMsT0FBTyxDQUFBO1lBRTdELHVCQUFhLENBQUMsZUFBZSxDQUFDO2dCQUM1QixRQUFRLEVBQUcsSUFBSTthQUNoQixDQUFDLENBQUE7U0FDSDtRQUVELElBQUksQ0FBQyxVQUFVLEdBQUc7WUFDaEIsWUFBWSxFQUFFLGFBQWEsQ0FBQyxDQUFDLENBQUMsSUFBSSxZQUFZLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSw4QkFBb0IsRUFBRTtZQUM3RSxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUMsQ0FBQyxJQUFJLGFBQWEsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLCtCQUFxQixFQUFFO1NBQ2pGLENBQUE7UUFFRCxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUE7SUFDeEIsQ0FBQztJQUVELE9BQU87UUFDTCxLQUFLLElBQUksYUFBYSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDekMsSUFBSSxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsT0FBTyxLQUFLLFVBQVUsRUFBRTtnQkFDaEUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQTthQUN6QztTQUNGO0lBQ0gsQ0FBQztDQUNGO0FBcENELG1DQW9DQyJ9