/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Vector;

class Util {
    private static final byte[] b64 = Util.str2byte("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
    private static String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static final byte[] empty = Util.str2byte("");

    Util() {
    }

    private static byte val(byte by) {
        if (by == 61) {
            return 0;
        }
        for (int i = 0; i < b64.length; ++i) {
            if (by != b64[i]) continue;
            return (byte)i;
        }
        return 0;
    }

    static byte[] fromBase64(byte[] byArray, int n, int n2) throws JSchException {
        try {
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            for (int i = n; i < n + n2; i += 4) {
                byArray2[n3] = (byte)(Util.val(byArray[i]) << 2 | (Util.val(byArray[i + 1]) & 0x30) >>> 4);
                if (byArray[i + 2] == 61) {
                    ++n3;
                    break;
                }
                byArray2[n3 + 1] = (byte)((Util.val(byArray[i + 1]) & 0xF) << 4 | (Util.val(byArray[i + 2]) & 0x3C) >>> 2);
                if (byArray[i + 3] == 61) {
                    n3 += 2;
                    break;
                }
                byArray2[n3 + 2] = (byte)((Util.val(byArray[i + 2]) & 3) << 6 | Util.val(byArray[i + 3]) & 0x3F);
                n3 += 3;
            }
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JSchException("fromBase64: invalid base64 data", arrayIndexOutOfBoundsException);
        }
    }

    static byte[] toBase64(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray2 = new byte[n2 * 2];
        int n5 = n2 / 3 * 3 + n;
        int n6 = 0;
        for (n4 = n; n4 < n5; n4 += 3) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 | byArray[n4 + 1] >>> 4 & 0xF;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4 + 1] & 0xF) << 2 | byArray[n4 + 2] >>> 6 & 3;
            byArray2[n6++] = b64[n3];
            n3 = byArray[n4 + 2] & 0x3F;
            byArray2[n6++] = b64[n3];
        }
        if ((n5 = n + n2 - n5) == 1) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 & 0x3F;
            byArray2[n6++] = b64[n3];
            byArray2[n6++] = 61;
            byArray2[n6++] = 61;
        } else if (n5 == 2) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 | byArray[n4 + 1] >>> 4 & 0xF;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4 + 1] & 0xF) << 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            byArray2[n6++] = 61;
        }
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray2, 0, byArray3, 0, n6);
        return byArray3;
    }

    static String[] split(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        byte[] byArray = Util.str2byte(string);
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            vector.addElement(Util.byte2str(byArray, n2, n - n2));
            n2 = n + 1;
        }
        vector.addElement(Util.byte2str(byArray, n2, byArray.length - n2));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static boolean glob(byte[] byArray, byte[] byArray2) {
        return Util.glob0(byArray, 0, byArray2, 0);
    }

    private static boolean glob0(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray2.length > 0 && byArray2[0] == 46) {
            if (byArray.length > 0 && byArray[0] == 46) {
                if (byArray.length == 2 && byArray[1] == 42) {
                    return true;
                }
                return Util.glob(byArray, n + 1, byArray2, n2 + 1);
            }
            return false;
        }
        return Util.glob(byArray, n, byArray2, n2);
    }

    private static boolean glob(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray.length;
        if (n3 == 0) {
            return false;
        }
        int n4 = byArray2.length;
        int n5 = n;
        int n6 = n2;
        while (n5 < n3 && n6 < n4) {
            if (byArray[n5] == 92) {
                if (n5 + 1 == n3) {
                    return false;
                }
                if (byArray[++n5] != byArray2[n6]) {
                    return false;
                }
                n5 += Util.skipUTF8Char(byArray[n5]);
                n6 += Util.skipUTF8Char(byArray2[n6]);
                continue;
            }
            if (byArray[n5] == 42) {
                while (n5 < n3 && byArray[n5] == 42) {
                    ++n5;
                }
                if (n3 == n5) {
                    return true;
                }
                byte by = byArray[n5];
                if (by == 63) {
                    while (n6 < n4) {
                        if (Util.glob(byArray, n5, byArray2, n6)) {
                            return true;
                        }
                        n6 += Util.skipUTF8Char(byArray2[n6]);
                    }
                    return false;
                }
                if (by == 92) {
                    if (n5 + 1 == n3) {
                        return false;
                    }
                    by = byArray[++n5];
                    while (n6 < n4) {
                        if (by == byArray2[n6] && Util.glob(byArray, n5 + Util.skipUTF8Char(by), byArray2, n6 + Util.skipUTF8Char(byArray2[n6]))) {
                            return true;
                        }
                        n6 += Util.skipUTF8Char(byArray2[n6]);
                    }
                    return false;
                }
                while (n6 < n4) {
                    if (by == byArray2[n6] && Util.glob(byArray, n5, byArray2, n6)) {
                        return true;
                    }
                    n6 += Util.skipUTF8Char(byArray2[n6]);
                }
                return false;
            }
            if (byArray[n5] == 63) {
                ++n5;
                n6 += Util.skipUTF8Char(byArray2[n6]);
                continue;
            }
            if (byArray[n5] != byArray2[n6]) {
                return false;
            }
            n5 += Util.skipUTF8Char(byArray[n5]);
            if ((n6 += Util.skipUTF8Char(byArray2[n6])) < n4) continue;
            if (n5 >= n3) {
                return true;
            }
            if (byArray[n5] != 42) continue;
        }
        if (n5 == n3 && n6 == n4) {
            return true;
        }
        if (n6 >= n4 && byArray[n5] == 42) {
            boolean bl = true;
            while (n5 < n3) {
                if (byArray[n5++] == 42) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    static String quote(String string) {
        int n;
        byte[] byArray = Util.str2byte(string);
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n = byArray[i];
            if (n != 92 && n != 63 && n != 42) continue;
            ++n2;
        }
        if (n2 == 0) {
            return string;
        }
        byte[] byArray2 = new byte[byArray.length + n2];
        int n3 = 0;
        for (n = 0; n < byArray.length; ++n) {
            byte by = byArray[n];
            if (by == 92 || by == 63 || by == 42) {
                byArray2[n3++] = 92;
            }
            byArray2[n3++] = by;
        }
        return Util.byte2str(byArray2);
    }

    static String unquote(String string) {
        byte[] byArray;
        byte[] byArray2 = Util.str2byte(string);
        if (byArray2.length == (byArray = Util.unquote(byArray2)).length) {
            return string;
        }
        return Util.byte2str(byArray);
    }

    static byte[] unquote(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 92) {
                if (n2 + 1 == n) break;
                System.arraycopy(byArray, n2 + 1, byArray, n2, byArray.length - (n2 + 1));
                --n;
                ++n2;
                continue;
            }
            ++n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    static String getFingerPrint(HASH hASH, byte[] byArray) {
        try {
            hASH.init();
            hASH.update(byArray, 0, byArray.length);
            byte[] byArray2 = hASH.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                int n = byArray2[i] & 0xFF;
                stringBuffer.append(chars[n >>> 4 & 0xF]);
                stringBuffer.append(chars[n & 0xF]);
                if (i + 1 >= byArray2.length) continue;
                stringBuffer.append(":");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "???";
        }
    }

    static boolean array_equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static Socket createSocket(String string, int n, int n2) throws JSchException {
        Socket socket = null;
        if (n2 == 0) {
            try {
                socket = new Socket(string, n);
                return socket;
            }
            catch (Exception exception) {
                String string2 = exception.toString();
                if (exception instanceof Throwable) {
                    throw new JSchException(string2, exception);
                }
                throw new JSchException(string2);
            }
        }
        final String string3 = string;
        final int n3 = n;
        final Socket[] socketArray = new Socket[1];
        final Exception[] exceptionArray = new Exception[1];
        String string4 = "";
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                socketArray[0] = null;
                try {
                    socketArray[0] = new Socket(string3, n3);
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                    if (socketArray[0] != null && socketArray[0].isConnected()) {
                        try {
                            socketArray[0].close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    socketArray[0] = null;
                }
            }
        });
        thread.setName("Opening Socket " + string);
        thread.start();
        try {
            thread.join(n2);
            string4 = "timeout: ";
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (socketArray[0] == null || !socketArray[0].isConnected()) {
            string4 = string4 + "socket is not established";
            if (exceptionArray[0] != null) {
                string4 = exceptionArray[0].toString();
            }
            thread.interrupt();
            thread = null;
            throw new JSchException(string4, exceptionArray[0]);
        }
        socket = socketArray[0];
        return socket;
    }

    static byte[] str2byte(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    static byte[] str2byte(String string) {
        return Util.str2byte(string, "UTF-8");
    }

    static String byte2str(byte[] byArray, String string) {
        return Util.byte2str(byArray, 0, byArray.length, string);
    }

    static String byte2str(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    static String byte2str(byte[] byArray) {
        return Util.byte2str(byArray, 0, byArray.length, "UTF-8");
    }

    static String byte2str(byte[] byArray, int n, int n2) {
        return Util.byte2str(byArray, n, n2, "UTF-8");
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            stringBuffer.append("0x" + (string.length() == 1 ? "0" : "") + string);
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    static void bzero(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    static String diffString(String string, String[] stringArray) {
        String[] stringArray2 = Util.split(string, ",");
        String string2 = null;
        block0: for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray2[i].equals(stringArray[j])) continue block0;
            }
            string2 = string2 == null ? stringArray2[i] : string2 + "," + stringArray2[i];
        }
        return string2;
    }

    static String checkTilde(String string) {
        try {
            if (string.startsWith("~")) {
                string = string.replace("~", System.getProperty("user.home"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    private static int skipUTF8Char(byte by) {
        if ((byte)(by & 0x80) == 0) {
            return 1;
        }
        if ((byte)(by & 0xE0) == -64) {
            return 2;
        }
        if ((byte)(by & 0xF0) == -32) {
            return 3;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] fromFile(String string) throws IOException {
        string = Util.checkTilde(string);
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            int n;
            byte[] byArray = new byte[(int)file.length()];
            int n2 = 0;
            while ((n = fileInputStream.read(byArray, n2, byArray.length - n2)) > 0) {
                n2 += n;
            }
            fileInputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

