#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.6.2
id: scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul
key: scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul
license: BSD-3-Clause
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
author: Bas van Dijk
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    "Data.Scientific" provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    >>> read "1e1000000000" :: Scientific
    1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
abi: 67146f6b2fe2f883da537f78817eb0dd
exposed: True
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific
hidden-modules: GHC.Integer.Compat Utils
import-dirs: /usr/lib/ghc-8.4.3/site-local/scientific-0.3.6.2
library-dirs: /usr/lib/ghc-8.4.3/site-local/scientific-0.3.6.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/scientific-0.3.6.2
hs-libraries: HSscientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul
depends:
    base-4.11.1.0 integer-logarithms-1.0.2.1-JUhgLgztEu58YkLteYDxF7
    deepseq-1.4.3.0 text-1.2.3.0
    hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg
    primitive-0.6.4.0-39Pwmm1zkQX6bM7xFUT3Jc containers-0.5.11.0
    binary-0.8.5.1 bytestring-0.10.8.2 integer-gmp-1.0.2.0
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             integer-logarithms-1.0.2.1-JUhgLgztEu58YkLteYDxF7=eeedf4354519c4e3e699ab99dd64713f
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg=0f14342a1ffe8710d31657335cf81134
             primitive-0.6.4.0-39Pwmm1zkQX6bM7xFUT3Jc=0a8d9e3ca28de3a4ac62e5f0044fa23c
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             integer-gmp-1.0.2.0=9ea484dc1eeb054803bb4cf8d65c934d
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

