/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Vector4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelClip
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_PLANE_READ = 14;
    public static final int ALLOW_PLANE_WRITE = 15;
    public static final int ALLOW_ENABLE_READ = 16;
    public static final int ALLOW_ENABLE_WRITE = 17;
    public static final int ALLOW_SCOPE_READ = 18;
    public static final int ALLOW_SCOPE_WRITE = 19;
    private static final int[] readCapabilities = new int[]{18, 16, 12, 14};

    public ModelClip() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ModelClip(Vector4d[] vector4dArray) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ModelClipRetained)this.retained).initPlanes(vector4dArray);
    }

    public ModelClip(Vector4d[] vector4dArray, boolean[] blArray) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ModelClipRetained)this.retained).initPlanes(vector4dArray);
        ((ModelClipRetained)this.retained).initEnables(blArray);
    }

    public void setInfluencingBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip0"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setInfluencingBounds(bounds);
        } else {
            ((ModelClipRetained)this.retained).initInfluencingBounds(bounds);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip1"));
        }
        return ((ModelClipRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip13"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setInfluencingBoundingLeaf(boundingLeaf);
        } else {
            ((ModelClipRetained)this.retained).initInfluencingBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip14"));
        }
        return ((ModelClipRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip7"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setScope(group, n);
        } else {
            ((ModelClipRetained)this.retained).initScope(group, n);
        }
    }

    public Group getScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip8"));
        }
        return ((ModelClipRetained)this.retained).getScope(n);
    }

    public void insertScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip9"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).insertScope(group, n);
        } else {
            ((ModelClipRetained)this.retained).initInsertScope(group, n);
        }
    }

    public void removeScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeScope(n);
        } else {
            ((ModelClipRetained)this.retained).initRemoveScope(n);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip11"));
        }
        return ((ModelClipRetained)this.retained).getAllScopes();
    }

    public void addScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip12"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).addScope(group);
        } else {
            ((ModelClipRetained)this.retained).initAddScope(group);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip11"));
        }
        return ((ModelClipRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip8"));
        }
        return ((ModelClipRetained)this.retained).indexOfScope(group);
    }

    public void removeScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeScope(group);
        } else {
            ((ModelClipRetained)this.retained).initRemoveScope(group);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeAllScopes();
        } else {
            ((ModelClipRetained)this.retained).initRemoveAllScopes();
        }
    }

    public void setPlanes(Vector4d[] vector4dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip2"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setPlanes(vector4dArray);
        } else {
            ((ModelClipRetained)this.retained).initPlanes(vector4dArray);
        }
    }

    public void getPlanes(Vector4d[] vector4dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip3"));
        }
        ((ModelClipRetained)this.retained).getPlanes(vector4dArray);
    }

    public void setPlane(int n, Vector4d vector4d) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip2"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setPlane(n, vector4d);
        } else {
            ((ModelClipRetained)this.retained).initPlane(n, vector4d);
        }
    }

    public void getPlane(int n, Vector4d vector4d) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip3"));
        }
        ((ModelClipRetained)this.retained).getPlane(n, vector4d);
    }

    public void setEnables(boolean[] blArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip4"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setEnables(blArray);
        } else {
            ((ModelClipRetained)this.retained).initEnables(blArray);
        }
    }

    public void getEnables(boolean[] blArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip5"));
        }
        ((ModelClipRetained)this.retained).getEnables(blArray);
    }

    public void setEnable(int n, boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip4"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setEnable(n, bl);
        } else {
            ((ModelClipRetained)this.retained).initEnable(n, bl);
        }
    }

    public boolean getEnable(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip5"));
        }
        return ((ModelClipRetained)this.retained).getEnable(n);
    }

    @Override
    void createRetained() {
        this.retained = new ModelClipRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean bl) {
        ModelClip modelClip = new ModelClip();
        modelClip.duplicateNode(this, bl);
        return modelClip;
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)this.retained;
        BoundingLeaf boundingLeaf = modelClipRetained.getInfluencingBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            modelClipRetained.initInfluencingBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
        int n = modelClipRetained.numScopes();
        for (int i = 0; i < n; ++i) {
            modelClipRetained.initScope((Group)nodeReferenceTable.getNewObjectReference(modelClipRetained.getScope(i)), i);
        }
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ModelClipRetained modelClipRetained = (ModelClipRetained)node.retained;
        ModelClipRetained modelClipRetained2 = (ModelClipRetained)this.retained;
        Vector4d vector4d = new Vector4d();
        for (int i = 5; i >= 0; --i) {
            modelClipRetained.getPlane(i, vector4d);
            modelClipRetained2.initPlane(i, vector4d);
            modelClipRetained2.initEnable(i, modelClipRetained.getEnable(i));
        }
        modelClipRetained2.initInfluencingBounds(modelClipRetained.getInfluencingBounds());
        Enumeration<Group> enumeration = modelClipRetained.getAllScopes();
        while (enumeration.hasMoreElements()) {
            modelClipRetained2.initAddScope(enumeration.nextElement());
        }
        modelClipRetained2.initInfluencingBoundingLeaf(modelClipRetained.getInfluencingBoundingLeaf());
    }
}

