/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.TCPConnectionInfo;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.StreamSocket;
import com.zeroc.IceInternal.Transceiver;
import java.net.Socket;
import java.nio.channels.SelectableChannel;

final class TcpTransceiver
implements Transceiver {
    private final ProtocolInstance _instance;
    private final StreamSocket _stream;

    @Override
    public SelectableChannel fd() {
        assert (this._stream != null);
        return this._stream.fd();
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer) {
        return this._stream.connect(readBuffer, writeBuffer);
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return initiator ? 1 : 0;
    }

    @Override
    public void close() {
        this._stream.close();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buf) {
        return this._stream.write(buf);
    }

    @Override
    public int read(Buffer buf) {
        return this._stream.read(buf);
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._stream.toString();
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public ConnectionInfo getInfo() {
        TCPConnectionInfo info = new TCPConnectionInfo();
        if (this._stream.fd() != null) {
            Socket socket = this._stream.fd().socket();
            info.localAddress = socket.getLocalAddress().getHostAddress();
            info.localPort = socket.getLocalPort();
            if (socket.getInetAddress() != null) {
                info.remoteAddress = socket.getInetAddress().getHostAddress();
                info.remotePort = socket.getPort();
            }
            if (!socket.isClosed()) {
                info.rcvSize = Network.getRecvBufferSize(this._stream.fd());
                info.sndSize = Network.getSendBufferSize(this._stream.fd());
            }
        }
        return info;
    }

    @Override
    public void checkSendSize(Buffer buf) {
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this._stream.setBufferSize(rcvSize, sndSize);
    }

    TcpTransceiver(ProtocolInstance instance, StreamSocket stream) {
        this._instance = instance;
        this._stream = stream;
    }
}

