# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.

#.rst:
# CPackDMG
# --------
#
# DragNDrop CPack generator (Mac OS X).
#
# Variables specific to CPack DragNDrop generator
# ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
# The following variables are specific to the DragNDrop installers built
# on Mac OS X:
#
# .. variable:: CPACK_DMG_VOLUME_NAME
#
#  The volume name of the generated disk image. Defaults to
#  CPACK_PACKAGE_FILE_NAME.
#
# .. variable:: CPACK_DMG_FORMAT
#
#  The disk image format. Common values are UDRO (UDIF read-only), UDZO (UDIF
#  zlib-compressed) or UDBZ (UDIF bzip2-compressed). Refer to hdiutil(1) for
#  more information on other available formats. Defaults to UDZO.
#
# .. variable:: CPACK_DMG_DS_STORE
#
#  Path to a custom DS_Store file. This .DS_Store file e.g. can be used to
#  specify the Finder window position/geometry and layout (such as hidden
#  toolbars, placement of the icons etc.). This file has to be generated by
#  the Finder (either manually or through AppleScript) using a normal folder
#  from which the .DS_Store file can then be extracted.
#
# .. variable:: CPACK_DMG_DS_STORE_SETUP_SCRIPT
#
#  Path to a custom AppleScript file.  This AppleScript is used to generate
#  a .DS_Store file which specifies the Finder window position/geometry and
#  layout (such as hidden toolbars, placement of the icons etc.).
#  By specifying a custom AppleScript there is no need to use
#  CPACK_DMG_DS_STORE, as the .DS_Store that is generated by the AppleScript
#  will be packaged.
#
# .. variable:: CPACK_DMG_BACKGROUND_IMAGE
#
#  Path to an image file to be used as the background.  This file will be
#  copied to .background/background.<ext>, where ext is the original image file
#  extension.  The background image is installed into the image before
#  CPACK_DMG_DS_STORE_SETUP_SCRIPT is executed or CPACK_DMG_DS_STORE is
#  installed.  By default no background image is set.
#
# .. variable:: CPACK_DMG_DISABLE_APPLICATIONS_SYMLINK
#
#  Default behaviour is to include a symlink to ``/Applications`` in the DMG.
#  Set this option to ``ON`` to avoid adding the symlink.
#
# .. variable:: CPACK_DMG_SLA_DIR
#
#   Directory where license and menu files for different languages are stored.
#   Setting this causes CPack to look for a ``<language>.menu.txt`` and
#   ``<language>.license.txt`` file for every language defined in
#   ``CPACK_DMG_SLA_LANGUAGES``. If both this variable and
#   ``CPACK_RESOURCE_FILE_LICENSE`` are set, CPack will only look for the menu
#   files and use the same license file for all languages.
#
# .. variable:: CPACK_DMG_SLA_LANGUAGES
#
#   Languages for which a license agreement is provided when mounting the
#   generated DMG. A menu file consists of 9 lines of text. The first line is
#   is the name of the language itself, uppercase, in English (e.g. German).
#   The other lines are translations of the following strings:
#
#   - Agree
#   - Disagree
#   - Print
#   - Save...
#   - You agree to the terms of the License Agreement when you click the
#     "Agree" button.
#   - Software License Agreement
#   - This text cannot be saved. The disk may be full or locked, or the file
#     may be locked.
#   - Unable to print. Make sure you have selected a printer.
#
#   For every language in this list, CPack will try to find files
#   ``<language>.menu.txt`` and ``<language>.license.txt`` in the directory
#   specified by the :variable:`CPACK_DMG_SLA_DIR` variable.
#
# .. variable:: CPACK_COMMAND_HDIUTIL
#
#  Path to the hdiutil(1) command used to operate on disk image files on Mac
#  OS X. This variable can be used to override the automatically detected
#  command (or specify its location if the auto-detection fails to find it.)
#
# .. variable:: CPACK_COMMAND_SETFILE
#
#  Path to the SetFile(1) command used to set extended attributes on files and
#  directories on Mac OS X. This variable can be used to override the
#  automatically detected command (or specify its location if the
#  auto-detection fails to find it.)
#
# .. variable:: CPACK_COMMAND_REZ
#
#  Path to the Rez(1) command used to compile resources on Mac OS X. This
#  variable can be used to override the automatically detected command (or
#  specify its location if the auto-detection fails to find it.)
