/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectRealmCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.aether.graph.DependencyFilter;

@Component(role=ProjectRealmCache.class)
public class DefaultProjectRealmCache
implements ProjectRealmCache,
Disposable {
    protected final Map<ProjectRealmCache.Key, ProjectRealmCache.CacheRecord> cache = new ConcurrentHashMap<ProjectRealmCache.Key, ProjectRealmCache.CacheRecord>();

    @Override
    public ProjectRealmCache.Key createKey(List<? extends ClassRealm> extensionRealms) {
        return new CacheKey(extensionRealms);
    }

    @Override
    public ProjectRealmCache.CacheRecord get(ProjectRealmCache.Key key2) {
        return this.cache.get(key2);
    }

    @Override
    public ProjectRealmCache.CacheRecord put(ProjectRealmCache.Key key2, ClassRealm projectRealm, DependencyFilter extensionArtifactFilter) {
        Validate.notNull(projectRealm, "projectRealm cannot be null", new Object[0]);
        if (this.cache.containsKey(key2)) {
            throw new IllegalStateException("Duplicate project realm for extensions " + key2);
        }
        ProjectRealmCache.CacheRecord record = new ProjectRealmCache.CacheRecord(projectRealm, extensionArtifactFilter);
        this.cache.put(key2, record);
        return record;
    }

    @Override
    public void flush() {
        for (ProjectRealmCache.CacheRecord record : this.cache.values()) {
            ClassRealm realm = record.realm;
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {}
        }
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project2, ProjectRealmCache.Key key2, ProjectRealmCache.CacheRecord record) {
    }

    @Override
    public void dispose() {
        this.flush();
    }

    protected static class CacheKey
    implements ProjectRealmCache.Key {
        private final List<? extends ClassRealm> extensionRealms;
        private final int hashCode;

        public CacheKey(List<? extends ClassRealm> extensionRealms) {
            this.extensionRealms = extensionRealms != null ? extensionRealms : Collections.emptyList();
            this.hashCode = this.extensionRealms.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.extensionRealms.equals(other.extensionRealms);
        }

        public String toString() {
            return this.extensionRealms.toString();
        }
    }
}

