// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `LocalException.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_LocalException_h__
#define __Ice_LocalException_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/Version.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class ICE_CLASS(ICE_API) InitializationException : public ::Ice::LocalExceptionHelper<InitializationException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InitializationException();

    InitializationException(const InitializationException&) = default;

    InitializationException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<InitializationException, ::Ice::LocalException>(file_, line_)
    {
    }

    InitializationException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<InitializationException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICE_API) PluginInitializationException : public ::Ice::LocalExceptionHelper<PluginInitializationException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~PluginInitializationException();

    PluginInitializationException(const PluginInitializationException&) = default;

    PluginInitializationException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<PluginInitializationException, ::Ice::LocalException>(file_, line_)
    {
    }

    PluginInitializationException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<PluginInitializationException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICE_API) CollocationOptimizationException : public ::Ice::LocalExceptionHelper<CollocationOptimizationException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CollocationOptimizationException();

    CollocationOptimizationException(const CollocationOptimizationException&) = default;

    CollocationOptimizationException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CollocationOptimizationException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) AlreadyRegisteredException : public ::Ice::LocalExceptionHelper<AlreadyRegisteredException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~AlreadyRegisteredException();

    AlreadyRegisteredException(const AlreadyRegisteredException&) = default;

    AlreadyRegisteredException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<AlreadyRegisteredException, ::Ice::LocalException>(file_, line_)
    {
    }

    AlreadyRegisteredException(const char* file_, int line_, const ::std::string& iceP_kindOfObject, const ::std::string& iceP_id) : ::Ice::LocalExceptionHelper<AlreadyRegisteredException, ::Ice::LocalException>(file_, line_),
        kindOfObject(::std::move(iceP_kindOfObject)),
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(kindOfObject, id);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string kindOfObject;
    ::std::string id;
};

class ICE_CLASS(ICE_API) NotRegisteredException : public ::Ice::LocalExceptionHelper<NotRegisteredException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~NotRegisteredException();

    NotRegisteredException(const NotRegisteredException&) = default;

    NotRegisteredException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<NotRegisteredException, ::Ice::LocalException>(file_, line_)
    {
    }

    NotRegisteredException(const char* file_, int line_, const ::std::string& iceP_kindOfObject, const ::std::string& iceP_id) : ::Ice::LocalExceptionHelper<NotRegisteredException, ::Ice::LocalException>(file_, line_),
        kindOfObject(::std::move(iceP_kindOfObject)),
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(kindOfObject, id);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string kindOfObject;
    ::std::string id;
};

class ICE_CLASS(ICE_API) TwowayOnlyException : public ::Ice::LocalExceptionHelper<TwowayOnlyException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~TwowayOnlyException();

    TwowayOnlyException(const TwowayOnlyException&) = default;

    TwowayOnlyException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<TwowayOnlyException, ::Ice::LocalException>(file_, line_)
    {
    }

    TwowayOnlyException(const char* file_, int line_, const ::std::string& iceP_operation) : ::Ice::LocalExceptionHelper<TwowayOnlyException, ::Ice::LocalException>(file_, line_),
        operation(::std::move(iceP_operation))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(operation);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string operation;
};

class ICE_CLASS(ICE_API) CloneNotImplementedException : public ::Ice::LocalExceptionHelper<CloneNotImplementedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CloneNotImplementedException();

    CloneNotImplementedException(const CloneNotImplementedException&) = default;

    CloneNotImplementedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CloneNotImplementedException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) UnknownException : public ::Ice::LocalExceptionHelper<UnknownException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownException();

    UnknownException(const UnknownException&) = default;

    UnknownException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownException, ::Ice::LocalException>(file_, line_)
    {
    }

    UnknownException(const char* file_, int line_, const ::std::string& iceP_unknown) : ::Ice::LocalExceptionHelper<UnknownException, ::Ice::LocalException>(file_, line_),
        unknown(::std::move(iceP_unknown))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(unknown);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string unknown;
};

class ICE_CLASS(ICE_API) UnknownLocalException : public ::Ice::LocalExceptionHelper<UnknownLocalException, ::Ice::UnknownException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownLocalException();

    UnknownLocalException(const UnknownLocalException&) = default;

    UnknownLocalException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownLocalException, ::Ice::UnknownException>(file_, line_)
    {
    }

    UnknownLocalException(const char* file_, int line_, const ::std::string& iceP_unknown) :
        ::Ice::LocalExceptionHelper<UnknownLocalException, ::Ice::UnknownException>(file_, line_, ::std::move(iceP_unknown))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(unknown);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) UnknownUserException : public ::Ice::LocalExceptionHelper<UnknownUserException, ::Ice::UnknownException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownUserException();

    UnknownUserException(const UnknownUserException&) = default;

    UnknownUserException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownUserException, ::Ice::UnknownException>(file_, line_)
    {
    }

    UnknownUserException(const char* file_, int line_, const ::std::string& iceP_unknown) :
        ::Ice::LocalExceptionHelper<UnknownUserException, ::Ice::UnknownException>(file_, line_, ::std::move(iceP_unknown))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(unknown);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) VersionMismatchException : public ::Ice::LocalExceptionHelper<VersionMismatchException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~VersionMismatchException();

    VersionMismatchException(const VersionMismatchException&) = default;

    VersionMismatchException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<VersionMismatchException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) CommunicatorDestroyedException : public ::Ice::LocalExceptionHelper<CommunicatorDestroyedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CommunicatorDestroyedException();

    CommunicatorDestroyedException(const CommunicatorDestroyedException&) = default;

    CommunicatorDestroyedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CommunicatorDestroyedException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ObjectAdapterDeactivatedException : public ::Ice::LocalExceptionHelper<ObjectAdapterDeactivatedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectAdapterDeactivatedException();

    ObjectAdapterDeactivatedException(const ObjectAdapterDeactivatedException&) = default;

    ObjectAdapterDeactivatedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ObjectAdapterDeactivatedException, ::Ice::LocalException>(file_, line_)
    {
    }

    ObjectAdapterDeactivatedException(const char* file_, int line_, const ::std::string& iceP_name) : ::Ice::LocalExceptionHelper<ObjectAdapterDeactivatedException, ::Ice::LocalException>(file_, line_),
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string name;
};

class ICE_CLASS(ICE_API) ObjectAdapterIdInUseException : public ::Ice::LocalExceptionHelper<ObjectAdapterIdInUseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectAdapterIdInUseException();

    ObjectAdapterIdInUseException(const ObjectAdapterIdInUseException&) = default;

    ObjectAdapterIdInUseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ObjectAdapterIdInUseException, ::Ice::LocalException>(file_, line_)
    {
    }

    ObjectAdapterIdInUseException(const char* file_, int line_, const ::std::string& iceP_id) : ::Ice::LocalExceptionHelper<ObjectAdapterIdInUseException, ::Ice::LocalException>(file_, line_),
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string id;
};

class ICE_CLASS(ICE_API) NoEndpointException : public ::Ice::LocalExceptionHelper<NoEndpointException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~NoEndpointException();

    NoEndpointException(const NoEndpointException&) = default;

    NoEndpointException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<NoEndpointException, ::Ice::LocalException>(file_, line_)
    {
    }

    NoEndpointException(const char* file_, int line_, const ::std::string& iceP_proxy) : ::Ice::LocalExceptionHelper<NoEndpointException, ::Ice::LocalException>(file_, line_),
        proxy(::std::move(iceP_proxy))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(proxy);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string proxy;
};

class ICE_CLASS(ICE_API) EndpointParseException : public ::Ice::LocalExceptionHelper<EndpointParseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~EndpointParseException();

    EndpointParseException(const EndpointParseException&) = default;

    EndpointParseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<EndpointParseException, ::Ice::LocalException>(file_, line_)
    {
    }

    EndpointParseException(const char* file_, int line_, const ::std::string& iceP_str) : ::Ice::LocalExceptionHelper<EndpointParseException, ::Ice::LocalException>(file_, line_),
        str(::std::move(iceP_str))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(str);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string str;
};

class ICE_CLASS(ICE_API) EndpointSelectionTypeParseException : public ::Ice::LocalExceptionHelper<EndpointSelectionTypeParseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~EndpointSelectionTypeParseException();

    EndpointSelectionTypeParseException(const EndpointSelectionTypeParseException&) = default;

    EndpointSelectionTypeParseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<EndpointSelectionTypeParseException, ::Ice::LocalException>(file_, line_)
    {
    }

    EndpointSelectionTypeParseException(const char* file_, int line_, const ::std::string& iceP_str) : ::Ice::LocalExceptionHelper<EndpointSelectionTypeParseException, ::Ice::LocalException>(file_, line_),
        str(::std::move(iceP_str))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(str);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string str;
};

class ICE_CLASS(ICE_API) VersionParseException : public ::Ice::LocalExceptionHelper<VersionParseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~VersionParseException();

    VersionParseException(const VersionParseException&) = default;

    VersionParseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<VersionParseException, ::Ice::LocalException>(file_, line_)
    {
    }

    VersionParseException(const char* file_, int line_, const ::std::string& iceP_str) : ::Ice::LocalExceptionHelper<VersionParseException, ::Ice::LocalException>(file_, line_),
        str(::std::move(iceP_str))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(str);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string str;
};

class ICE_CLASS(ICE_API) IdentityParseException : public ::Ice::LocalExceptionHelper<IdentityParseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~IdentityParseException();

    IdentityParseException(const IdentityParseException&) = default;

    IdentityParseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<IdentityParseException, ::Ice::LocalException>(file_, line_)
    {
    }

    IdentityParseException(const char* file_, int line_, const ::std::string& iceP_str) : ::Ice::LocalExceptionHelper<IdentityParseException, ::Ice::LocalException>(file_, line_),
        str(::std::move(iceP_str))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(str);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string str;
};

class ICE_CLASS(ICE_API) ProxyParseException : public ::Ice::LocalExceptionHelper<ProxyParseException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ProxyParseException();

    ProxyParseException(const ProxyParseException&) = default;

    ProxyParseException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ProxyParseException, ::Ice::LocalException>(file_, line_)
    {
    }

    ProxyParseException(const char* file_, int line_, const ::std::string& iceP_str) : ::Ice::LocalExceptionHelper<ProxyParseException, ::Ice::LocalException>(file_, line_),
        str(::std::move(iceP_str))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(str);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string str;
};

class ICE_CLASS(ICE_API) IllegalIdentityException : public ::Ice::LocalExceptionHelper<IllegalIdentityException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~IllegalIdentityException();

    IllegalIdentityException(const IllegalIdentityException&) = default;

    IllegalIdentityException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<IllegalIdentityException, ::Ice::LocalException>(file_, line_)
    {
    }

    IllegalIdentityException(const char* file_, int line_, const ::Ice::Identity& iceP_id) : ::Ice::LocalExceptionHelper<IllegalIdentityException, ::Ice::LocalException>(file_, line_),
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::Ice::Identity id;
};

class ICE_CLASS(ICE_API) IllegalServantException : public ::Ice::LocalExceptionHelper<IllegalServantException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~IllegalServantException();

    IllegalServantException(const IllegalServantException&) = default;

    IllegalServantException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<IllegalServantException, ::Ice::LocalException>(file_, line_)
    {
    }

    IllegalServantException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<IllegalServantException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICE_API) RequestFailedException : public ::Ice::LocalExceptionHelper<RequestFailedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~RequestFailedException();

    RequestFailedException(const RequestFailedException&) = default;

    RequestFailedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<RequestFailedException, ::Ice::LocalException>(file_, line_)
    {
    }

    RequestFailedException(const char* file_, int line_, const ::Ice::Identity& iceP_id, const ::std::string& iceP_facet, const ::std::string& iceP_operation) : ::Ice::LocalExceptionHelper<RequestFailedException, ::Ice::LocalException>(file_, line_),
        id(::std::move(iceP_id)),
        facet(::std::move(iceP_facet)),
        operation(::std::move(iceP_operation))
    {
    }

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, facet, operation);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::Ice::Identity id;
    ::std::string facet;
    ::std::string operation;
};

class ICE_CLASS(ICE_API) ObjectNotExistException : public ::Ice::LocalExceptionHelper<ObjectNotExistException, ::Ice::RequestFailedException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectNotExistException();

    ObjectNotExistException(const ObjectNotExistException&) = default;

    ObjectNotExistException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ObjectNotExistException, ::Ice::RequestFailedException>(file_, line_)
    {
    }

    ObjectNotExistException(const char* file_, int line_, const ::Ice::Identity& iceP_id, const ::std::string& iceP_facet, const ::std::string& iceP_operation) :
        ::Ice::LocalExceptionHelper<ObjectNotExistException, ::Ice::RequestFailedException>(file_, line_, ::std::move(iceP_id), ::std::move(iceP_facet), ::std::move(iceP_operation))
    {
    }

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, facet, operation);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) FacetNotExistException : public ::Ice::LocalExceptionHelper<FacetNotExistException, ::Ice::RequestFailedException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~FacetNotExistException();

    FacetNotExistException(const FacetNotExistException&) = default;

    FacetNotExistException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<FacetNotExistException, ::Ice::RequestFailedException>(file_, line_)
    {
    }

    FacetNotExistException(const char* file_, int line_, const ::Ice::Identity& iceP_id, const ::std::string& iceP_facet, const ::std::string& iceP_operation) :
        ::Ice::LocalExceptionHelper<FacetNotExistException, ::Ice::RequestFailedException>(file_, line_, ::std::move(iceP_id), ::std::move(iceP_facet), ::std::move(iceP_operation))
    {
    }

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, facet, operation);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) OperationNotExistException : public ::Ice::LocalExceptionHelper<OperationNotExistException, ::Ice::RequestFailedException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~OperationNotExistException();

    OperationNotExistException(const OperationNotExistException&) = default;

    OperationNotExistException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<OperationNotExistException, ::Ice::RequestFailedException>(file_, line_)
    {
    }

    OperationNotExistException(const char* file_, int line_, const ::Ice::Identity& iceP_id, const ::std::string& iceP_facet, const ::std::string& iceP_operation) :
        ::Ice::LocalExceptionHelper<OperationNotExistException, ::Ice::RequestFailedException>(file_, line_, ::std::move(iceP_id), ::std::move(iceP_facet), ::std::move(iceP_operation))
    {
    }

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, facet, operation);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) SyscallException : public ::Ice::LocalExceptionHelper<SyscallException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~SyscallException();

    SyscallException(const SyscallException&) = default;

    SyscallException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<SyscallException, ::Ice::LocalException>(file_, line_)
    {
    }

    SyscallException(const char* file_, int line_, int iceP_error) : ::Ice::LocalExceptionHelper<SyscallException, ::Ice::LocalException>(file_, line_),
        error(iceP_error)
    {
    }

    std::tuple<const int&> ice_tuple() const
    {
        return std::tie(error);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    int error = 0;
};

class ICE_CLASS(ICE_API) SocketException : public ::Ice::LocalExceptionHelper<SocketException, ::Ice::SyscallException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~SocketException();

    SocketException(const SocketException&) = default;

    SocketException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<SocketException, ::Ice::SyscallException>(file_, line_)
    {
    }

    SocketException(const char* file_, int line_, int iceP_error) :
        ::Ice::LocalExceptionHelper<SocketException, ::Ice::SyscallException>(file_, line_, iceP_error)
    {
    }

    std::tuple<const int&> ice_tuple() const
    {
        return std::tie(error);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) CFNetworkException : public ::Ice::LocalExceptionHelper<CFNetworkException, ::Ice::SocketException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CFNetworkException();

    CFNetworkException(const CFNetworkException&) = default;

    CFNetworkException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CFNetworkException, ::Ice::SocketException>(file_, line_)
    {
    }

    CFNetworkException(const char* file_, int line_, int iceP_error, const ::std::string& iceP_domain) :
        ::Ice::LocalExceptionHelper<CFNetworkException, ::Ice::SocketException>(file_, line_, iceP_error),
        domain(::std::move(iceP_domain))
    {
    }

    std::tuple<const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(error, domain);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string domain;
};

class ICE_CLASS(ICE_API) FileException : public ::Ice::LocalExceptionHelper<FileException, ::Ice::SyscallException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~FileException();

    FileException(const FileException&) = default;

    FileException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<FileException, ::Ice::SyscallException>(file_, line_)
    {
    }

    FileException(const char* file_, int line_, int iceP_error, const ::std::string& iceP_path) :
        ::Ice::LocalExceptionHelper<FileException, ::Ice::SyscallException>(file_, line_, iceP_error),
        path(::std::move(iceP_path))
    {
    }

    std::tuple<const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(error, path);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string path;
};

class ICE_CLASS(ICE_API) ConnectFailedException : public ::Ice::LocalExceptionHelper<ConnectFailedException, ::Ice::SocketException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectFailedException();

    ConnectFailedException(const ConnectFailedException&) = default;

    ConnectFailedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectFailedException, ::Ice::SocketException>(file_, line_)
    {
    }

    ConnectFailedException(const char* file_, int line_, int iceP_error) :
        ::Ice::LocalExceptionHelper<ConnectFailedException, ::Ice::SocketException>(file_, line_, iceP_error)
    {
    }

    std::tuple<const int&> ice_tuple() const
    {
        return std::tie(error);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectionRefusedException : public ::Ice::LocalExceptionHelper<ConnectionRefusedException, ::Ice::ConnectFailedException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionRefusedException();

    ConnectionRefusedException(const ConnectionRefusedException&) = default;

    ConnectionRefusedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectionRefusedException, ::Ice::ConnectFailedException>(file_, line_)
    {
    }

    ConnectionRefusedException(const char* file_, int line_, int iceP_error) :
        ::Ice::LocalExceptionHelper<ConnectionRefusedException, ::Ice::ConnectFailedException>(file_, line_, iceP_error)
    {
    }

    std::tuple<const int&> ice_tuple() const
    {
        return std::tie(error);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectionLostException : public ::Ice::LocalExceptionHelper<ConnectionLostException, ::Ice::SocketException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionLostException();

    ConnectionLostException(const ConnectionLostException&) = default;

    ConnectionLostException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectionLostException, ::Ice::SocketException>(file_, line_)
    {
    }

    ConnectionLostException(const char* file_, int line_, int iceP_error) :
        ::Ice::LocalExceptionHelper<ConnectionLostException, ::Ice::SocketException>(file_, line_, iceP_error)
    {
    }

    std::tuple<const int&> ice_tuple() const
    {
        return std::tie(error);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) DNSException : public ::Ice::LocalExceptionHelper<DNSException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~DNSException();

    DNSException(const DNSException&) = default;

    DNSException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<DNSException, ::Ice::LocalException>(file_, line_)
    {
    }

    DNSException(const char* file_, int line_, int iceP_error, const ::std::string& iceP_host) : ::Ice::LocalExceptionHelper<DNSException, ::Ice::LocalException>(file_, line_),
        error(iceP_error),
        host(::std::move(iceP_host))
    {
    }

    std::tuple<const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(error, host);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    int error = 0;
    ::std::string host;
};

class ICE_CLASS(ICE_API) OperationInterruptedException : public ::Ice::LocalExceptionHelper<OperationInterruptedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~OperationInterruptedException();

    OperationInterruptedException(const OperationInterruptedException&) = default;

    OperationInterruptedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<OperationInterruptedException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) TimeoutException : public ::Ice::LocalExceptionHelper<TimeoutException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~TimeoutException();

    TimeoutException(const TimeoutException&) = default;

    TimeoutException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<TimeoutException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectTimeoutException : public ::Ice::LocalExceptionHelper<ConnectTimeoutException, ::Ice::TimeoutException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectTimeoutException();

    ConnectTimeoutException(const ConnectTimeoutException&) = default;

    ConnectTimeoutException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectTimeoutException, ::Ice::TimeoutException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) CloseTimeoutException : public ::Ice::LocalExceptionHelper<CloseTimeoutException, ::Ice::TimeoutException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CloseTimeoutException();

    CloseTimeoutException(const CloseTimeoutException&) = default;

    CloseTimeoutException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CloseTimeoutException, ::Ice::TimeoutException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectionTimeoutException : public ::Ice::LocalExceptionHelper<ConnectionTimeoutException, ::Ice::TimeoutException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionTimeoutException();

    ConnectionTimeoutException(const ConnectionTimeoutException&) = default;

    ConnectionTimeoutException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectionTimeoutException, ::Ice::TimeoutException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) InvocationTimeoutException : public ::Ice::LocalExceptionHelper<InvocationTimeoutException, ::Ice::TimeoutException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvocationTimeoutException();

    InvocationTimeoutException(const InvocationTimeoutException&) = default;

    InvocationTimeoutException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<InvocationTimeoutException, ::Ice::TimeoutException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) InvocationCanceledException : public ::Ice::LocalExceptionHelper<InvocationCanceledException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvocationCanceledException();

    InvocationCanceledException(const InvocationCanceledException&) = default;

    InvocationCanceledException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<InvocationCanceledException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ProtocolException : public ::Ice::LocalExceptionHelper<ProtocolException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ProtocolException();

    ProtocolException(const ProtocolException&) = default;

    ProtocolException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ProtocolException, ::Ice::LocalException>(file_, line_)
    {
    }

    ProtocolException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<ProtocolException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICE_API) BadMagicException : public ::Ice::LocalExceptionHelper<BadMagicException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~BadMagicException();

    BadMagicException(const BadMagicException&) = default;

    BadMagicException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<BadMagicException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    BadMagicException(const char* file_, int line_, const ::std::string& iceP_reason, const ::Ice::ByteSeq& iceP_badMagic) :
        ::Ice::LocalExceptionHelper<BadMagicException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason)),
        badMagic(::std::move(iceP_badMagic))
    {
    }

    std::tuple<const ::std::string&, const ::Ice::ByteSeq&> ice_tuple() const
    {
        return std::tie(reason, badMagic);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::Ice::ByteSeq badMagic;
};

class ICE_CLASS(ICE_API) UnsupportedProtocolException : public ::Ice::LocalExceptionHelper<UnsupportedProtocolException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnsupportedProtocolException();

    UnsupportedProtocolException(const UnsupportedProtocolException&) = default;

    UnsupportedProtocolException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnsupportedProtocolException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    UnsupportedProtocolException(const char* file_, int line_, const ::std::string& iceP_reason, const ::Ice::ProtocolVersion& iceP_bad, const ::Ice::ProtocolVersion& iceP_supported) :
        ::Ice::LocalExceptionHelper<UnsupportedProtocolException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason)),
        bad(::std::move(iceP_bad)),
        supported(::std::move(iceP_supported))
    {
    }

    std::tuple<const ::std::string&, const ::Ice::ProtocolVersion&, const ::Ice::ProtocolVersion&> ice_tuple() const
    {
        return std::tie(reason, bad, supported);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::Ice::ProtocolVersion bad;
    ::Ice::ProtocolVersion supported;
};

class ICE_CLASS(ICE_API) UnsupportedEncodingException : public ::Ice::LocalExceptionHelper<UnsupportedEncodingException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnsupportedEncodingException();

    UnsupportedEncodingException(const UnsupportedEncodingException&) = default;

    UnsupportedEncodingException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnsupportedEncodingException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    UnsupportedEncodingException(const char* file_, int line_, const ::std::string& iceP_reason, const ::Ice::EncodingVersion& iceP_bad, const ::Ice::EncodingVersion& iceP_supported) :
        ::Ice::LocalExceptionHelper<UnsupportedEncodingException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason)),
        bad(::std::move(iceP_bad)),
        supported(::std::move(iceP_supported))
    {
    }

    std::tuple<const ::std::string&, const ::Ice::EncodingVersion&, const ::Ice::EncodingVersion&> ice_tuple() const
    {
        return std::tie(reason, bad, supported);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::Ice::EncodingVersion bad;
    ::Ice::EncodingVersion supported;
};

class ICE_CLASS(ICE_API) UnknownMessageException : public ::Ice::LocalExceptionHelper<UnknownMessageException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownMessageException();

    UnknownMessageException(const UnknownMessageException&) = default;

    UnknownMessageException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownMessageException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    UnknownMessageException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<UnknownMessageException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectionNotValidatedException : public ::Ice::LocalExceptionHelper<ConnectionNotValidatedException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionNotValidatedException();

    ConnectionNotValidatedException(const ConnectionNotValidatedException&) = default;

    ConnectionNotValidatedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectionNotValidatedException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    ConnectionNotValidatedException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<ConnectionNotValidatedException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) UnknownRequestIdException : public ::Ice::LocalExceptionHelper<UnknownRequestIdException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownRequestIdException();

    UnknownRequestIdException(const UnknownRequestIdException&) = default;

    UnknownRequestIdException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownRequestIdException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    UnknownRequestIdException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<UnknownRequestIdException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) UnknownReplyStatusException : public ::Ice::LocalExceptionHelper<UnknownReplyStatusException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownReplyStatusException();

    UnknownReplyStatusException(const UnknownReplyStatusException&) = default;

    UnknownReplyStatusException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnknownReplyStatusException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    UnknownReplyStatusException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<UnknownReplyStatusException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) CloseConnectionException : public ::Ice::LocalExceptionHelper<CloseConnectionException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CloseConnectionException();

    CloseConnectionException(const CloseConnectionException&) = default;

    CloseConnectionException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CloseConnectionException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    CloseConnectionException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<CloseConnectionException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ConnectionManuallyClosedException : public ::Ice::LocalExceptionHelper<ConnectionManuallyClosedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionManuallyClosedException();

    ConnectionManuallyClosedException(const ConnectionManuallyClosedException&) = default;

    ConnectionManuallyClosedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ConnectionManuallyClosedException, ::Ice::LocalException>(file_, line_)
    {
    }

    ConnectionManuallyClosedException(const char* file_, int line_, bool iceP_graceful) : ::Ice::LocalExceptionHelper<ConnectionManuallyClosedException, ::Ice::LocalException>(file_, line_),
        graceful(iceP_graceful)
    {
    }

    std::tuple<const bool&> ice_tuple() const
    {
        return std::tie(graceful);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    bool graceful;
};

class ICE_CLASS(ICE_API) IllegalMessageSizeException : public ::Ice::LocalExceptionHelper<IllegalMessageSizeException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~IllegalMessageSizeException();

    IllegalMessageSizeException(const IllegalMessageSizeException&) = default;

    IllegalMessageSizeException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<IllegalMessageSizeException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    IllegalMessageSizeException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<IllegalMessageSizeException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) CompressionException : public ::Ice::LocalExceptionHelper<CompressionException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CompressionException();

    CompressionException(const CompressionException&) = default;

    CompressionException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<CompressionException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    CompressionException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<CompressionException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) DatagramLimitException : public ::Ice::LocalExceptionHelper<DatagramLimitException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~DatagramLimitException();

    DatagramLimitException(const DatagramLimitException&) = default;

    DatagramLimitException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<DatagramLimitException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    DatagramLimitException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<DatagramLimitException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) MarshalException : public ::Ice::LocalExceptionHelper<MarshalException, ::Ice::ProtocolException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~MarshalException();

    MarshalException(const MarshalException&) = default;

    MarshalException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<MarshalException, ::Ice::ProtocolException>(file_, line_)
    {
    }

    MarshalException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<MarshalException, ::Ice::ProtocolException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ProxyUnmarshalException : public ::Ice::LocalExceptionHelper<ProxyUnmarshalException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ProxyUnmarshalException();

    ProxyUnmarshalException(const ProxyUnmarshalException&) = default;

    ProxyUnmarshalException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ProxyUnmarshalException, ::Ice::MarshalException>(file_, line_)
    {
    }

    ProxyUnmarshalException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<ProxyUnmarshalException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) UnmarshalOutOfBoundsException : public ::Ice::LocalExceptionHelper<UnmarshalOutOfBoundsException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnmarshalOutOfBoundsException();

    UnmarshalOutOfBoundsException(const UnmarshalOutOfBoundsException&) = default;

    UnmarshalOutOfBoundsException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnmarshalOutOfBoundsException, ::Ice::MarshalException>(file_, line_)
    {
    }

    UnmarshalOutOfBoundsException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<UnmarshalOutOfBoundsException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) NoValueFactoryException : public ::Ice::LocalExceptionHelper<NoValueFactoryException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~NoValueFactoryException();

    NoValueFactoryException(const NoValueFactoryException&) = default;

    NoValueFactoryException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<NoValueFactoryException, ::Ice::MarshalException>(file_, line_)
    {
    }

    NoValueFactoryException(const char* file_, int line_, const ::std::string& iceP_reason, const ::std::string& iceP_type) :
        ::Ice::LocalExceptionHelper<NoValueFactoryException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason)),
        type(::std::move(iceP_type))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(reason, type);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string type;
};

class ICE_CLASS(ICE_API) UnexpectedObjectException : public ::Ice::LocalExceptionHelper<UnexpectedObjectException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnexpectedObjectException();

    UnexpectedObjectException(const UnexpectedObjectException&) = default;

    UnexpectedObjectException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<UnexpectedObjectException, ::Ice::MarshalException>(file_, line_)
    {
    }

    UnexpectedObjectException(const char* file_, int line_, const ::std::string& iceP_reason, const ::std::string& iceP_type, const ::std::string& iceP_expectedType) :
        ::Ice::LocalExceptionHelper<UnexpectedObjectException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason)),
        type(::std::move(iceP_type)),
        expectedType(::std::move(iceP_expectedType))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(reason, type, expectedType);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string type;
    ::std::string expectedType;
};

class ICE_CLASS(ICE_API) MemoryLimitException : public ::Ice::LocalExceptionHelper<MemoryLimitException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~MemoryLimitException();

    MemoryLimitException(const MemoryLimitException&) = default;

    MemoryLimitException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<MemoryLimitException, ::Ice::MarshalException>(file_, line_)
    {
    }

    MemoryLimitException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<MemoryLimitException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) StringConversionException : public ::Ice::LocalExceptionHelper<StringConversionException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~StringConversionException();

    StringConversionException(const StringConversionException&) = default;

    StringConversionException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<StringConversionException, ::Ice::MarshalException>(file_, line_)
    {
    }

    StringConversionException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<StringConversionException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) EncapsulationException : public ::Ice::LocalExceptionHelper<EncapsulationException, ::Ice::MarshalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~EncapsulationException();

    EncapsulationException(const EncapsulationException&) = default;

    EncapsulationException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<EncapsulationException, ::Ice::MarshalException>(file_, line_)
    {
    }

    EncapsulationException(const char* file_, int line_, const ::std::string& iceP_reason) :
        ::Ice::LocalExceptionHelper<EncapsulationException, ::Ice::MarshalException>(file_, line_, ::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) FeatureNotSupportedException : public ::Ice::LocalExceptionHelper<FeatureNotSupportedException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~FeatureNotSupportedException();

    FeatureNotSupportedException(const FeatureNotSupportedException&) = default;

    FeatureNotSupportedException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<FeatureNotSupportedException, ::Ice::LocalException>(file_, line_)
    {
    }

    FeatureNotSupportedException(const char* file_, int line_, const ::std::string& iceP_unsupportedFeature) : ::Ice::LocalExceptionHelper<FeatureNotSupportedException, ::Ice::LocalException>(file_, line_),
        unsupportedFeature(::std::move(iceP_unsupportedFeature))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(unsupportedFeature);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string unsupportedFeature;
};

class ICE_CLASS(ICE_API) SecurityException : public ::Ice::LocalExceptionHelper<SecurityException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~SecurityException();

    SecurityException(const SecurityException&) = default;

    SecurityException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<SecurityException, ::Ice::LocalException>(file_, line_)
    {
    }

    SecurityException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<SecurityException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICE_API) FixedProxyException : public ::Ice::LocalExceptionHelper<FixedProxyException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~FixedProxyException();

    FixedProxyException(const FixedProxyException&) = default;

    FixedProxyException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<FixedProxyException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

class ICE_CLASS(ICE_API) ResponseSentException : public ::Ice::LocalExceptionHelper<ResponseSentException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ResponseSentException();

    ResponseSentException(const ResponseSentException&) = default;

    ResponseSentException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<ResponseSentException, ::Ice::LocalException>(file_, line_)
    {
    }

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICE_API) virtual void ice_print(::std::ostream&) const override;
};

}

namespace Ice
{

}

#else // C++98 mapping

namespace Ice
{

class ICE_API InitializationException : public ::Ice::LocalException
{
public:

    InitializationException(const char*, int);
    InitializationException(const char*, int, const ::std::string&);
    virtual ~InitializationException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual InitializationException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICE_API PluginInitializationException : public ::Ice::LocalException
{
public:

    PluginInitializationException(const char*, int);
    PluginInitializationException(const char*, int, const ::std::string&);
    virtual ~PluginInitializationException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual PluginInitializationException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICE_API CollocationOptimizationException : public ::Ice::LocalException
{
public:

    CollocationOptimizationException(const char*, int);
    virtual ~CollocationOptimizationException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CollocationOptimizationException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API AlreadyRegisteredException : public ::Ice::LocalException
{
public:

    AlreadyRegisteredException(const char*, int);
    AlreadyRegisteredException(const char*, int, const ::std::string&, const ::std::string&);
    virtual ~AlreadyRegisteredException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual AlreadyRegisteredException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string kindOfObject;
    ::std::string id;
};

class ICE_API NotRegisteredException : public ::Ice::LocalException
{
public:

    NotRegisteredException(const char*, int);
    NotRegisteredException(const char*, int, const ::std::string&, const ::std::string&);
    virtual ~NotRegisteredException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual NotRegisteredException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string kindOfObject;
    ::std::string id;
};

class ICE_API TwowayOnlyException : public ::Ice::LocalException
{
public:

    TwowayOnlyException(const char*, int);
    TwowayOnlyException(const char*, int, const ::std::string&);
    virtual ~TwowayOnlyException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual TwowayOnlyException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string operation;
};

class ICE_API CloneNotImplementedException : public ::Ice::LocalException
{
public:

    CloneNotImplementedException(const char*, int);
    virtual ~CloneNotImplementedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CloneNotImplementedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API UnknownException : public ::Ice::LocalException
{
public:

    UnknownException(const char*, int);
    UnknownException(const char*, int, const ::std::string&);
    virtual ~UnknownException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string unknown;
};

class ICE_API UnknownLocalException : public ::Ice::UnknownException
{
public:

    UnknownLocalException(const char*, int);
    UnknownLocalException(const char*, int, const ::std::string&);
    virtual ~UnknownLocalException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownLocalException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API UnknownUserException : public ::Ice::UnknownException
{
public:

    UnknownUserException(const char*, int);
    UnknownUserException(const char*, int, const ::std::string&);
    virtual ~UnknownUserException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownUserException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API VersionMismatchException : public ::Ice::LocalException
{
public:

    VersionMismatchException(const char*, int);
    virtual ~VersionMismatchException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual VersionMismatchException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API CommunicatorDestroyedException : public ::Ice::LocalException
{
public:

    CommunicatorDestroyedException(const char*, int);
    virtual ~CommunicatorDestroyedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CommunicatorDestroyedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ObjectAdapterDeactivatedException : public ::Ice::LocalException
{
public:

    ObjectAdapterDeactivatedException(const char*, int);
    ObjectAdapterDeactivatedException(const char*, int, const ::std::string&);
    virtual ~ObjectAdapterDeactivatedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ObjectAdapterDeactivatedException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;
};

class ICE_API ObjectAdapterIdInUseException : public ::Ice::LocalException
{
public:

    ObjectAdapterIdInUseException(const char*, int);
    ObjectAdapterIdInUseException(const char*, int, const ::std::string&);
    virtual ~ObjectAdapterIdInUseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ObjectAdapterIdInUseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string id;
};

class ICE_API NoEndpointException : public ::Ice::LocalException
{
public:

    NoEndpointException(const char*, int);
    NoEndpointException(const char*, int, const ::std::string&);
    virtual ~NoEndpointException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual NoEndpointException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string proxy;
};

class ICE_API EndpointParseException : public ::Ice::LocalException
{
public:

    EndpointParseException(const char*, int);
    EndpointParseException(const char*, int, const ::std::string&);
    virtual ~EndpointParseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual EndpointParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string str;
};

class ICE_API EndpointSelectionTypeParseException : public ::Ice::LocalException
{
public:

    EndpointSelectionTypeParseException(const char*, int);
    EndpointSelectionTypeParseException(const char*, int, const ::std::string&);
    virtual ~EndpointSelectionTypeParseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual EndpointSelectionTypeParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string str;
};

class ICE_API VersionParseException : public ::Ice::LocalException
{
public:

    VersionParseException(const char*, int);
    VersionParseException(const char*, int, const ::std::string&);
    virtual ~VersionParseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual VersionParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string str;
};

class ICE_API IdentityParseException : public ::Ice::LocalException
{
public:

    IdentityParseException(const char*, int);
    IdentityParseException(const char*, int, const ::std::string&);
    virtual ~IdentityParseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual IdentityParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string str;
};

class ICE_API ProxyParseException : public ::Ice::LocalException
{
public:

    ProxyParseException(const char*, int);
    ProxyParseException(const char*, int, const ::std::string&);
    virtual ~ProxyParseException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ProxyParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string str;
};

class ICE_API IllegalIdentityException : public ::Ice::LocalException
{
public:

    IllegalIdentityException(const char*, int);
    IllegalIdentityException(const char*, int, const ::Ice::Identity&);
    virtual ~IllegalIdentityException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual IllegalIdentityException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Identity id;
};

class ICE_API IllegalServantException : public ::Ice::LocalException
{
public:

    IllegalServantException(const char*, int);
    IllegalServantException(const char*, int, const ::std::string&);
    virtual ~IllegalServantException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual IllegalServantException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICE_API RequestFailedException : public ::Ice::LocalException
{
public:

    RequestFailedException(const char*, int);
    RequestFailedException(const char*, int, const ::Ice::Identity&, const ::std::string&, const ::std::string&);
    virtual ~RequestFailedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual RequestFailedException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Identity id;
    ::std::string facet;
    ::std::string operation;
};

class ICE_API ObjectNotExistException : public ::Ice::RequestFailedException
{
public:

    ObjectNotExistException(const char*, int);
    ObjectNotExistException(const char*, int, const ::Ice::Identity&, const ::std::string&, const ::std::string&);
    virtual ~ObjectNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ObjectNotExistException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API FacetNotExistException : public ::Ice::RequestFailedException
{
public:

    FacetNotExistException(const char*, int);
    FacetNotExistException(const char*, int, const ::Ice::Identity&, const ::std::string&, const ::std::string&);
    virtual ~FacetNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual FacetNotExistException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API OperationNotExistException : public ::Ice::RequestFailedException
{
public:

    OperationNotExistException(const char*, int);
    OperationNotExistException(const char*, int, const ::Ice::Identity&, const ::std::string&, const ::std::string&);
    virtual ~OperationNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual OperationNotExistException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API SyscallException : public ::Ice::LocalException
{
public:

    SyscallException(const char*, int);
    SyscallException(const char*, int, ::Ice::Int);
    virtual ~SyscallException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual SyscallException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Int error;
};

class ICE_API SocketException : public ::Ice::SyscallException
{
public:

    SocketException(const char*, int);
    SocketException(const char*, int, ::Ice::Int);
    virtual ~SocketException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual SocketException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API CFNetworkException : public ::Ice::SocketException
{
public:

    CFNetworkException(const char*, int);
    CFNetworkException(const char*, int, ::Ice::Int, const ::std::string&);
    virtual ~CFNetworkException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CFNetworkException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string domain;
};

class ICE_API FileException : public ::Ice::SyscallException
{
public:

    FileException(const char*, int);
    FileException(const char*, int, ::Ice::Int, const ::std::string&);
    virtual ~FileException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual FileException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string path;
};

class ICE_API ConnectFailedException : public ::Ice::SocketException
{
public:

    ConnectFailedException(const char*, int);
    ConnectFailedException(const char*, int, ::Ice::Int);
    virtual ~ConnectFailedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectFailedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectionRefusedException : public ::Ice::ConnectFailedException
{
public:

    ConnectionRefusedException(const char*, int);
    ConnectionRefusedException(const char*, int, ::Ice::Int);
    virtual ~ConnectionRefusedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectionRefusedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectionLostException : public ::Ice::SocketException
{
public:

    ConnectionLostException(const char*, int);
    ConnectionLostException(const char*, int, ::Ice::Int);
    virtual ~ConnectionLostException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectionLostException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API DNSException : public ::Ice::LocalException
{
public:

    DNSException(const char*, int);
    DNSException(const char*, int, ::Ice::Int, const ::std::string&);
    virtual ~DNSException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual DNSException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Int error;
    ::std::string host;
};

class ICE_API OperationInterruptedException : public ::Ice::LocalException
{
public:

    OperationInterruptedException(const char*, int);
    virtual ~OperationInterruptedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual OperationInterruptedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API TimeoutException : public ::Ice::LocalException
{
public:

    TimeoutException(const char*, int);
    virtual ~TimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual TimeoutException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectTimeoutException : public ::Ice::TimeoutException
{
public:

    ConnectTimeoutException(const char*, int);
    virtual ~ConnectTimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectTimeoutException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API CloseTimeoutException : public ::Ice::TimeoutException
{
public:

    CloseTimeoutException(const char*, int);
    virtual ~CloseTimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CloseTimeoutException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectionTimeoutException : public ::Ice::TimeoutException
{
public:

    ConnectionTimeoutException(const char*, int);
    virtual ~ConnectionTimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectionTimeoutException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API InvocationTimeoutException : public ::Ice::TimeoutException
{
public:

    InvocationTimeoutException(const char*, int);
    virtual ~InvocationTimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual InvocationTimeoutException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API InvocationCanceledException : public ::Ice::LocalException
{
public:

    InvocationCanceledException(const char*, int);
    virtual ~InvocationCanceledException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual InvocationCanceledException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ProtocolException : public ::Ice::LocalException
{
public:

    ProtocolException(const char*, int);
    ProtocolException(const char*, int, const ::std::string&);
    virtual ~ProtocolException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ProtocolException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICE_API BadMagicException : public ::Ice::ProtocolException
{
public:

    BadMagicException(const char*, int);
    BadMagicException(const char*, int, const ::std::string&, const ::Ice::ByteSeq&);
    virtual ~BadMagicException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual BadMagicException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::ByteSeq badMagic;
};

class ICE_API UnsupportedProtocolException : public ::Ice::ProtocolException
{
public:

    UnsupportedProtocolException(const char*, int);
    UnsupportedProtocolException(const char*, int, const ::std::string&, const ::Ice::ProtocolVersion&, const ::Ice::ProtocolVersion&);
    virtual ~UnsupportedProtocolException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnsupportedProtocolException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::ProtocolVersion bad;
    ::Ice::ProtocolVersion supported;
};

class ICE_API UnsupportedEncodingException : public ::Ice::ProtocolException
{
public:

    UnsupportedEncodingException(const char*, int);
    UnsupportedEncodingException(const char*, int, const ::std::string&, const ::Ice::EncodingVersion&, const ::Ice::EncodingVersion&);
    virtual ~UnsupportedEncodingException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnsupportedEncodingException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::EncodingVersion bad;
    ::Ice::EncodingVersion supported;
};

class ICE_API UnknownMessageException : public ::Ice::ProtocolException
{
public:

    UnknownMessageException(const char*, int);
    UnknownMessageException(const char*, int, const ::std::string&);
    virtual ~UnknownMessageException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownMessageException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectionNotValidatedException : public ::Ice::ProtocolException
{
public:

    ConnectionNotValidatedException(const char*, int);
    ConnectionNotValidatedException(const char*, int, const ::std::string&);
    virtual ~ConnectionNotValidatedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectionNotValidatedException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API UnknownRequestIdException : public ::Ice::ProtocolException
{
public:

    UnknownRequestIdException(const char*, int);
    UnknownRequestIdException(const char*, int, const ::std::string&);
    virtual ~UnknownRequestIdException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownRequestIdException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API UnknownReplyStatusException : public ::Ice::ProtocolException
{
public:

    UnknownReplyStatusException(const char*, int);
    UnknownReplyStatusException(const char*, int, const ::std::string&);
    virtual ~UnknownReplyStatusException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnknownReplyStatusException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API CloseConnectionException : public ::Ice::ProtocolException
{
public:

    CloseConnectionException(const char*, int);
    CloseConnectionException(const char*, int, const ::std::string&);
    virtual ~CloseConnectionException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CloseConnectionException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ConnectionManuallyClosedException : public ::Ice::LocalException
{
public:

    ConnectionManuallyClosedException(const char*, int);
    ConnectionManuallyClosedException(const char*, int, bool);
    virtual ~ConnectionManuallyClosedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ConnectionManuallyClosedException* ice_clone() const;
    virtual void ice_throw() const;

    bool graceful;
};

class ICE_API IllegalMessageSizeException : public ::Ice::ProtocolException
{
public:

    IllegalMessageSizeException(const char*, int);
    IllegalMessageSizeException(const char*, int, const ::std::string&);
    virtual ~IllegalMessageSizeException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual IllegalMessageSizeException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API CompressionException : public ::Ice::ProtocolException
{
public:

    CompressionException(const char*, int);
    CompressionException(const char*, int, const ::std::string&);
    virtual ~CompressionException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual CompressionException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API DatagramLimitException : public ::Ice::ProtocolException
{
public:

    DatagramLimitException(const char*, int);
    DatagramLimitException(const char*, int, const ::std::string&);
    virtual ~DatagramLimitException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual DatagramLimitException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API MarshalException : public ::Ice::ProtocolException
{
public:

    MarshalException(const char*, int);
    MarshalException(const char*, int, const ::std::string&);
    virtual ~MarshalException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual MarshalException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ProxyUnmarshalException : public ::Ice::MarshalException
{
public:

    ProxyUnmarshalException(const char*, int);
    ProxyUnmarshalException(const char*, int, const ::std::string&);
    virtual ~ProxyUnmarshalException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ProxyUnmarshalException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API UnmarshalOutOfBoundsException : public ::Ice::MarshalException
{
public:

    UnmarshalOutOfBoundsException(const char*, int);
    UnmarshalOutOfBoundsException(const char*, int, const ::std::string&);
    virtual ~UnmarshalOutOfBoundsException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnmarshalOutOfBoundsException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API NoValueFactoryException : public ::Ice::MarshalException
{
public:

    NoValueFactoryException(const char*, int);
    NoValueFactoryException(const char*, int, const ::std::string&, const ::std::string&);
    virtual ~NoValueFactoryException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual NoValueFactoryException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string type;
};

class ICE_API UnexpectedObjectException : public ::Ice::MarshalException
{
public:

    UnexpectedObjectException(const char*, int);
    UnexpectedObjectException(const char*, int, const ::std::string&, const ::std::string&, const ::std::string&);
    virtual ~UnexpectedObjectException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual UnexpectedObjectException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string type;
    ::std::string expectedType;
};

class ICE_API MemoryLimitException : public ::Ice::MarshalException
{
public:

    MemoryLimitException(const char*, int);
    MemoryLimitException(const char*, int, const ::std::string&);
    virtual ~MemoryLimitException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual MemoryLimitException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API StringConversionException : public ::Ice::MarshalException
{
public:

    StringConversionException(const char*, int);
    StringConversionException(const char*, int, const ::std::string&);
    virtual ~StringConversionException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual StringConversionException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API EncapsulationException : public ::Ice::MarshalException
{
public:

    EncapsulationException(const char*, int);
    EncapsulationException(const char*, int, const ::std::string&);
    virtual ~EncapsulationException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual EncapsulationException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API FeatureNotSupportedException : public ::Ice::LocalException
{
public:

    FeatureNotSupportedException(const char*, int);
    FeatureNotSupportedException(const char*, int, const ::std::string&);
    virtual ~FeatureNotSupportedException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual FeatureNotSupportedException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string unsupportedFeature;
};

class ICE_API SecurityException : public ::Ice::LocalException
{
public:

    SecurityException(const char*, int);
    SecurityException(const char*, int, const ::std::string&);
    virtual ~SecurityException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual SecurityException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICE_API FixedProxyException : public ::Ice::LocalException
{
public:

    FixedProxyException(const char*, int);
    virtual ~FixedProxyException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual FixedProxyException* ice_clone() const;
    virtual void ice_throw() const;
};

class ICE_API ResponseSentException : public ::Ice::LocalException
{
public:

    ResponseSentException(const char*, int);
    virtual ~ResponseSentException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual ResponseSentException* ice_clone() const;
    virtual void ice_throw() const;
};

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
