/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fil extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "Bengali";
        final String metaValue_bo = "Tibetan";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_hy = "Armenian";
        final String metaValue_ja = "Japanese";
        final String metaValue_ka = "Georgian";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_la = "Latin";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "key.colStrength", "Lakas ng Pag-uuri-uri" },
            { "luo", "Luo" },
            { "Zsym", "Mga Simbolo" },
            { "fil", "Filipino" },
            { "luy", "Luyia" },
            { "es_ES", "European Spanish" },
            { "teo", "Teso" },
            { "ab", "Abkhazian" },
            { "AC", "Acsencion island" },
            { "tet", "Tetum" },
            { "key.colCaseFirst", "Uppercase/Lowercase na Pagsusunud-sunod" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua and Barbuda" },
            { "type.ca.ethiopic", "Kalendaryo ng Ethiopia" },
            { "AI", "Anguilla" },
            { "key.tz", "Time Zone" },
            { "ak", "Akan" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "Amharic" },
            { "Arab", "Arabic" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "ar", "Arabe" },
            { "AS", "American Samoa" },
            { "as", "Assamese" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "sdh", "Katimugang Kurdish" },
            { "en_US", "Ingles (US)" },
            { "AX", "\u00c5land Islands" },
            { "key.colNormalization", "Normalized na Pag-uuri-uri" },
            { "ay", "Aymara" },
            { "AZ", "Azerbaijan" },
            { "az", "Azerbaijani" },
            { "BA", "Bosnia and Herzegovina" },
            { "ba", "Bashkir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "type.co.unihan", "Pagkakasunud-sunod ng Pag-uuri ng Radical-Stroke" },
            { "BE", "Belgium" },
            { "be", "Belarusian" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "Bulgarian" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bosnian" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "Mymr", "Myanmar" },
            { "type.nu.laoo", "Mga Lao na Digit" },
            { "BY", "Belarus" },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalendaryong Persian" },
            { "type.nu.hebr", "Mga Hebrew Numeral" },
            { "CA", "Canada" },
            { "ca", "Catalan" },
            { "CC", "Cocos (Keeling) Islands" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Congo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "Corsican" },
            { "CP", "Clipperton Island" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Czech" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "cv", "Chuvash" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "cy", "Welsh" },
            { "CZ", "Czech Republic" },
            { "type.nu.ethi", "Mga Ethiopic Numeral" },
            { "da", "Danish" },
            { "pt_PT", "European Portuguese" },
            { "DE", "Germany" },
            { "de", "German" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Mga Devanagari Digit" },
            { "DJ", "Djibouti" },
            { "type.colNumeric.no", "Pag-uri-uriin ang Mga Digit nang Indibidwal" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenian Lowercase Numerals" },
            { "DO", "Dominican Republic" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Mongolian Digits" },
            { "key.variableTop", "Pag-uri-uriin Bilang Mga Simbolo" },
            { "dv", "Divehi" },
            { "es_419", "Latin American na Espanyol" },
            { "DZ", "Algeria" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendaryong Chinese" },
            { "EA", "Ceuta and Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Greek na Mga Numeral" },
            { "EE", "Estonia" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Normal na Estilo ng Putol ng Linya" },
            { "EG", "Egypt" },
            { "EH", "Kanlurang Sahara" },
            { "ro_MD", "Moldavian" },
            { "type.colNormalization.yes", "Pag-uri-uriin ang Unicode nang Normalized" },
            { "el", metaValue_el },
            { "en", "Ingles" },
            { "eo", "Esperanto" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "type.co.big5han", "Pagkakasunod-sunod ng Pag-uuri ng Tradisyunal na Chinese - Big5" },
            { "ES", "Spain" },
            { "es", "Espanyol" },
            { "ET", "Ethiopia" },
            { "et", "Estonian" },
            { "EU", "European Union" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "type.ca.gregorian", "Gregorian na Kalendaryo" },
            { "shi", "Tachelhit" },
            { "type.nu.gujr", "Mga Gujarati Digit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "fa", "Persian" },
            { "Hans", "Pinasimple" },
            { "type.nu.latn", "Mga Kanluraning Digit" },
            { "Hant", "Tradisyonal" },
            { "FI", "Finland" },
            { "fi", "Finnish" },
            { "FJ", "Fiji" },
            { "fj", "Fijian" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "key.va", "Lokal na Variant" },
            { "bgn", "Kanlurang Balochi" },
            { "yue", "Cantonese" },
            { "FO", "Faroe Islands" },
            { "fo", "Faroese" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "fr", "French" },
            { "fy", "Kanlurang Frisian" },
            { "type.ca.indian", "Pambansang Kalendaryong Indian" },
            { "GA", "Gabon" },
            { "ga", "Irish" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "gd", "Scots Gaelic" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "key.colCaseLevel", "Case Sensitive na Pag-uuri-uri" },
            { "GL", "Greenland" },
            { "gl", "Galician" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "und", "Hindi Kilalang Wika" },
            { "GR", "Greece" },
            { "type.ca.ethiopic-amete-alem", "Kalendaryong Ethiopic Amete Alem" },
            { "GS", "South Georgia and the South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "Manx" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Central Kurdish" },
            { "zxx", "Walang nilalaman na ukol sa wika" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "de_AT", "Austrian German" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard Island and McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "hr", "Croatian" },
            { "agq", "Aghem" },
            { "gsw", "Swiss German" },
            { "HT", "Haiti" },
            { "ht", "Haitian" },
            { "HU", "Hungary" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "ia", "Interlingua" },
            { "IC", "Canary Island" },
            { "ID", "Indonesia" },
            { "id", "Indonesian" },
            { "type.nu.tibt", "Mga Tibetan na Digit" },
            { "IE", "Ireland" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "is", "Icelandic" },
            { "IT", "Italy" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "type.nu.thai", "Mga Thai na Digit" },
            { "type.nu.beng", "Mga Bengali Digit" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendaryong Islamic" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "sma", "Katimugang Sami" },
            { "jv", "Javanese" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Mga Kannada na Digit" },
            { "smj", "Lule Sami" },
            { "de_CH", "Swiss High German" },
            { "smn", "Inari Sami" },
            { "type.co.phonetic", "Phonetic na Ayos ng Pag-uuri-uri" },
            { "ka", metaValue_ka },
            { "type.ca.buddhist", "Kalendaryo ng Buddhist" },
            { "sms", "Skolt Sami" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "kg", "Kongo" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Saint Kitts and Nevis" },
            { "fr_CA", "Canadian French" },
            { "type.colStrength.identical", "Pag-uri-uriin Lahat" },
            { "ko", metaValue_ko },
            { "KP", "Hilagang Korea" },
            { "KR", "Timog Korea" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "fr_CH", "Swiss French" },
            { "KW", "Kuwait" },
            { "kw", "Cornish" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Islands" },
            { "ky", "Kirghiz" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Cyrillic" },
            { "type.colStrength.primary", "Mga Base na Titik Lang ang Pag-uri-uriin" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "lb", "Luxembourgish" },
            { "LC", "Saint Lucia" },
            { "type.nu.mlym", "Mga Malayalam na Digit" },
            { "lg", "Ganda" },
            { "nds", "Low German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "type.colCaseLevel.no", "Pag-uri-uriin ang Hindi Case Sensitive" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Sistemang Imperial na Pagsukat" },
            { "type.colStrength.tertiary", "Pag-uri-uriin ang Mga Accent/Case/Lapad" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "lt", "Lithuanian" },
            { "LU", "Luxembourg" },
            { "lu", "Luba-Katanga" },
            { "LV", "Latvia" },
            { "lv", "Latvian" },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "mg", "Malagasy" },
            { "Thai", metaValue_th },
            { "MH", "Marshall Islands" },
            { "type.co.ducet", "Default na Pagkakasunud-sunod ng Ayos ng Unicode" },
            { "mi", "Maori" },
            { "type.nu.vaii", "Mga Vai na Digit" },
            { "MK", "Macedonia" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_mn },
            { "MN", "Mongolia" },
            { "MO", "Macau SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "mr", "Marathi" },
            { "MS", "Montserrat" },
            { "ms", "Malay" },
            { "type.colAlternate.non-ignorable", "Pag-uri-uriin ang Mga Simbolo" },
            { "MT", "Malta" },
            { "mt", "Maltese" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kalendaryong Japanese" },
            { "MY", "Malaysia" },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozambique" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibia" },
            { "type.co.search", "Pangkalahatang Paghahanap" },
            { "nb", "Norwegian Bokmal" },
            { "type.ca.hebrew", "Hebrew na Kalendaryo" },
            { "type.co.dictionary", "Pagkakasunud-sunod ng Pag-uuri ng Diksyunaryo" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "nd", "Hilagang Ndebele" },
            { "NE", "Niger" },
            { "ne", "Nepali" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "NO", "Norway" },
            { "no", "Norwegian" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "New Zealand" },
            { "kab", "Kabyle" },
            { "type.colCaseFirst.lower", "Lowercase Muna ang Pag-uri-uriin" },
            { "oc", "Occitan" },
            { "kam", "Kamba" },
            { "type.colAlternate.shifted", "Pag-uri-uriin ang Mga Ignoring Symbol" },
            { "mer", "Meru" },
            { "type.nu.armn", "Mga Armenian Numeral" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetic" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "type.ca.islamic-civil", "Kalendaryong Islamic-Civil" },
            { "en_GB", "Ingles ng British" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Pilipinas" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "pl", "Polish" },
            { "PM", "Saint Pierre and Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "type.ca.dangi", "Dangi na Kalendaryo" },
            { "type.colBackwards.yes", "Pag-uri-uriin ang Mga Accent nang Baliktad" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "ps", "Pashto" },
            { "PT", "Portugal" },
            { "pt", "Portuges" },
            { "key.co", "Pagkakasunud-sunod ng Ayos" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Greek Lowercase Numerals" },
            { "PY", "Paraguay" },
            { "pt_BR", "Portuges ng Brasil" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "QA", "Qatar" },
            { "key.ca", "Kalendaryo" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24 na Oras na Sistema (0\u201323)" },
            { "type.hc.h24", "24 na Oras na Sistema (1\u201324)" },
            { "type.nu.mymr", "Mga Myanmar na Digit" },
            { "QO", "Outlying Oceania" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "001", "Mundo" },
            { "Ethi", "Ethiopic" },
            { "002", "Africa" },
            { "003", "Hilagang Amerika" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "Pag-uri-uriin nang Walang Pag-normalize" },
            { "type.hc.h12", "12 Oras na Sistema (1\u201312)" },
            { "005", "Timog Amerika" },
            { "type.hc.h11", "12 Oras na Sistema (0\u201311)" },
            { "009", "Oceania" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Pera" },
            { "RO", "Romania" },
            { "ro", "Romanian" },
            { "RS", "Serbia" },
            { "type.nu.orya", "Mga Oriya na Digit" },
            { "type.nu.hanidec", "Mga Chinese Decimal na Numeral" },
            { "RU", "Russia" },
            { "ru", "Russian" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "en_AU", "Ingles ng Australya" },
            { "key.colAlternate", "Pag-uuri-uri ng Mga Ignore Symbol" },
            { "SA", "Saudi Arabia" },
            { "sa", "Sanskrit" },
            { "SB", "Solomon Islands" },
            { "twq", "Tasawaq" },
            { "011", "Kanlurang Africa" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "013", "Gitnang Amerika" },
            { "SE", "Sweden" },
            { "se", "Hilagang Sami" },
            { "014", "Silangang Africa" },
            { "015", "Hilagang Africa" },
            { "SG", "Singapore" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "sh", "Serbo-Croatian" },
            { "type.lb.strict", "Mahigpit na Estilo ng Putol ng Linya" },
            { "si", metaValue_si },
            { "017", "Gitnang Africa" },
            { "SI", "Slovenia" },
            { "018", "Katimugang Africa" },
            { "SJ", "Svalbard and Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovakia" },
            { "sk", "Slovak" },
            { "SL", "Sierra Leone" },
            { "sl", "Slovenian" },
            { "SM", "San Marino" },
            { "sm", "Samoan" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somalia" },
            { "so", "Somali" },
            { "arn", "Mapuche" },
            { "type.nu.arab", "Arabic-Indic na Mga Digit" },
            { "sq", "Albanian" },
            { "type.nu.taml", "Tamil na Mga Numeral" },
            { "SR", "Suriname" },
            { "sr", "Serbian" },
            { "SS", "Timog Sudan" },
            { "ss", "Swati" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "st", "Southern Sotho" },
            { "su", "Sundanese" },
            { "SV", "El Salvador" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "type.nu.hantfin", "Traditional Chinese na Mga Numeral para sa Pananalapi" },
            { "SZ", "Swaziland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan de Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistema ng Pagsukat sa US" },
            { "021", "Northern America" },
            { "142", "Asya" },
            { "TC", "Turks and Caicos Islands" },
            { "143", "Gitnang Asya" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Kanlurang Asya" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "TH", "Thailand" },
            { "ti", "Tigrinya" },
            { "type.colNumeric.yes", "Pag-uri-uriin ang Mga Digit nang Numerical" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Ingles sa Canada" },
            { "029", "Carribbean" },
            { "TK", "Tokelau" },
            { "tk", "Turkmen" },
            { "TL", "Timor-Leste" },
            { "type.co.searchjl", "Maghanap Ayon sa Unang Katinig ng Hangul" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "Tswana" },
            { "TO", "Tonga" },
            { "to", "Tongan" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Mga Japanese Numeral" },
            { "TR", "Turkey" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "swb", "Comorian" },
            { "TT", "Trinidad and Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ty", "Tahitian" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Hindi Kilalang Script" },
            { "150", "Europe" },
            { "UA", "Ukraine" },
            { "key.colHiraganaQuaternary", "Pag-uuri-uri ng Kana" },
            { "030", "Silangang Asya" },
            { "151", "Silangang Europe" },
            { "154", "Hilagang Europe" },
            { "sw_CD", "Swahili (Congo)" },
            { "034", "Katimugang Asya" },
            { "155", "Kanlurang Europe" },
            { "035", "Timog-Silangang Asya" },
            { "UG", "Uganda" },
            { "ug", "Uyghur" },
            { "type.co.pinyin", "Pagkakasunud-sunod ng Pag-uuri ng Pinyin" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Karaniwan" },
            { "type.colHiraganaQuaternary.yes", "Pag-uri-uriin ang Kana nang Naiiba" },
            { "039", "Katimugang Europe" },
            { "uk", "Ukranian" },
            { "Sinh", metaValue_si },
            { "type.colCaseFirst.no", "Pag-uri-uriin ang Ayos ng Normal na Case" },
            { "UM", "U.S. Outlying Islands" },
            { "type.colStrength.quaternary", "Pag-uri-uriin ang Mga Accent/Case/Lapad/Kana" },
            { "type.ca.coptic", "Coptic Calendar" },
            { "ur", "Urdu" },
            { "US", "Estados Unidos" },
            { "haw", "Hawaiian" },
            { "type.co.gb2312han", "Pagkakasunud-sunod ng Pag-uuri ng Pinasimpleng Chinese - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "uz", "Uzbek" },
            { "tzm", "Tamazight ng Gitnang Atlas" },
            { "type.co.stroke", "Pagkakasunud-sunod ng Pag-uuri ng Stroke" },
            { "VA", "Vatican City" },
            { "nds_NL", "Low Saxon" },
            { "VC", "Saint Vincent and the Grenadines" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "type.ca.roc", "Kalendaryong Minguo" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "vi", "Vietnamese" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Siklo ng Oras (12 laban sa 24)" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "Pag-uri-uriin ang Mga Accent nang Normal" },
            { "key.x", "Pribadong Paggamit" },
            { "quc", "K\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "Rwa" },
            { "gag", "Gagauz" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis and Futuna" },
            { "Grek", metaValue_el },
            { "type.co.traditional", "Tradisyunal na Pagkakasunud-sunod ng Pag-uuri" },
            { "057", "Rehiyon ng Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Mga Pampinansyang Numeral" },
            { "wo", "Wolof" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Modernong Karaniwang Arabe" },
            { "WS", "Samoa" },
            { "key.colNumeric", "Numeric na Pag-uuri-uri" },
            { "Mong", metaValue_mn },
            { "Latn", metaValue_la },
            { "061", "Polynesia" },
            { "type.nu.hans", "Simplified Chinese na Mga Numeral" },
            { "type.nu.hant", "Traditional Chinese na Mga Numeral" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "Roman Lowercase Numerals" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Hindi Nakasulat" },
            { "wbp", "Warlpiri" },
            { "moh", "Mohawk" },
            { "YE", "Yemen" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "Karaniwang Pagkakasunud-sunod ng Ayos" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Mga Tradisyunal na Numeral" },
            { "es_MX", "Espanyol ng Mehiko" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "South Africa" },
            { "type.lb.loose", "Loose na Estilo ng Putol ng Linya" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Chinese" },
            { "type.nu.geor", "Georgian na Mga Numeral" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Bopomofo" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "key.lb", "Estilo ng Putol ng Linya" },
            { "zu", "Zulu" },
            { "ZW", "Zimbabwe" },
            { "type.co.phonebook", "Pagkakasunud-sunod ng Pag-uuri ng Phonebook" },
            { "Geor", metaValue_ka },
            { "ZZ", "Hindi Kilalang Rehiyon" },
            { "type.colCaseLevel.yes", "Pag-uri-uriin ang Case Sensitive" },
            { "type.ms.metric", "Metrikong Sistema" },
            { "type.ca.iso8601", "ISO-8601 na Kalendaryo" },
            { "nso", "Northern Sotho" },
            { "type.nu.telu", "Mga Telugu na Digit" },
            { "type.nu.jpanfin", "Mga Japanese Numeral sa Pananalapi" },
            { "loz", "Lozi" },
            { "type.co.reformed", "Pagkakasunud-sunod ng Pag-uuri ng Na-reform" },
            { "key.colBackwards", "Pag-uuri-uri ng Baliktad na Accent" },
            { "type.colHiraganaQuaternary.no", "Pag-uri-uriin ang Kana nang Hiwalay" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "zh_Hans", "Simplified Chinese" },
            { "koi", "Komi-Permyak" },
            { "type.nu.hansfin", "Simplified Chinese na Mga Numeral para sa Pananalapi" },
            { "type.colStrength.secondary", "Pag-uri-uriin ang Mga Accent" },
            { "kok", "Konkani" },
            { "type.nu.arabext", "Extendend Arabic-Indic na Mga Digit" },
            { "nus", "Nuer" },
            { "type.nu.fullwide", "Mga Full-Width Digit" },
            { "dav", "Taita" },
            { "lrc", "Hilagang Luri" },
            { "type.nu.khmr", "Mga Khmer na Digit" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Mga Gurmukhi Digit" },
            { "Khmr", metaValue_km },
            { "key.ms", "Sistema ng Pagsukat" },
            { "type.nu.roman", "Mga Roman Numeral" },
            { "type.nu.tamldec", "Mga Tamil na Digit" },
            { "saq", "Samburu" },
            { "efi", "Efik" },
            { "key.nu", "Mga Numero" },
            { "type.nu.native", "Mga Native na Digit" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "ksb", "Shambala" },
            { "type.colCaseFirst.upper", "Uppercase Muna ang Pag-uri-uriin" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
