/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_el extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MSK",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MSD",
               "\u038f\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1\u03c2",
               "JST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1\u03c2",
               "JDT",
               "\u038f\u03c1\u03b1 \u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1\u03c2",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "PKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "PKST",
               "\u038f\u03c1\u03b1 \u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03b1\u03ca\u03c0\u03ad\u03b9",
               "CST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03b1\u03ca\u03c0\u03ad\u03b9",
               "CDT",
               "\u038f\u03c1\u03b1 \u03a4\u03b1\u03ca\u03c0\u03ad\u03b9",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HOVT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HOVST",
               "\u038f\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MAGT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MAGST",
               "\u038f\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CEST",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SAKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SAKST",
               "\u038f\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "PYT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "PYST",
               "\u038f\u03c1\u03b1 \u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1\u03c2",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "EST",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "EDT",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHDT",
               "\u038f\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "NZST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "NZDT",
               "\u038f\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u038f\u03c1\u03b1 \u0399\u03bd\u03b4\u03b9\u03ba\u03bf\u03cd \u03a9\u03ba\u03b5\u03b1\u03bd\u03bf\u03cd",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YAKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YAKST",
               "\u038f\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c5",
               "MUT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c5",
               "MUST",
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c5",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03bf\u03cd \u03a4\u03b9\u03bc\u03cc\u03c1",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03b1",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03bf\u03c3\u03c1\u03ac\u03b7\u03c2",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039c\u03ac\u03c1\u03c3\u03b1\u03bb",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EEST",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NDT",
               "\u038f\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba",
               "HKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba",
               "HKST",
               "\u038f\u03c1\u03b1 \u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ART",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ARST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "ADT",
               "\u038f\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u038f\u03c1\u03b1 \u03a0\u03bf\u03bd\u03ac\u03c0\u03b5",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u038f\u03c1\u03b1 \u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1\u03c2",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03b9\u03bd\u03c4 \u03a0\u03b9\u03b5\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd",
               "PMST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03b9\u03bd\u03c4 \u03a0\u03b9\u03b5\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd",
               "PMDT",
               "\u038f\u03c1\u03b1 \u03a3\u03b1\u03b9\u03bd\u03c4 \u03a0\u03b9\u03b5\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u038f\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03ba\u03af\u03bd\u03b1\u03c2",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b9\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YEKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b9\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YEKST",
               "\u038f\u03c1\u03b1 \u0391\u03b9\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03c9\u03bd",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03ca\u03c4\u03ae\u03c2",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c3\u03c1\u03b1\u03ae\u03bb",
               "IST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c3\u03c1\u03b1\u03ae\u03bb",
               "IDT",
               "\u038f\u03c1\u03b1 \u0399\u03c3\u03c1\u03b1\u03ae\u03bb",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u038f\u03c1\u03b1: \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03cc\u03bb\u03b9\u03c2 \u03ba\u03b1\u03b9 \u03a6\u03bf\u03c5\u03c4\u03bf\u03cd\u03bd\u03b1",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u038f\u03c1\u03b1 \u03a3\u03af\u03bf\u03b2\u03b1",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039b\u03ac\u03b9\u03bd",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "UZT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "UZST",
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OMST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OMSST",
               "\u038f\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u038f\u03c1\u03b1 \u03a3\u03b5\u03cb\u03c7\u03b5\u03bb\u03bb\u03ce\u03bd",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "UYT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "UYST",
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b5\u03c0\u03ac\u03bb",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "ULAT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "ULAST",
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CST",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CDT",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03bf\u03c5\u03ba",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b9\u03bf\u03cd\u03b5",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u0393\u03bf\u03c5\u03ad\u03b9\u03ba",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u03a6\u03ce\u03ba\u03bb\u03b1\u03bd\u03c4",
               "FKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u03a6\u03ce\u03ba\u03bb\u03b1\u03bd\u03c4",
               "FKST",
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u03a6\u03ce\u03ba\u03bb\u03b1\u03bd\u03c4",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5",
               "VUT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5",
               "VUST",
               "\u038f\u03c1\u03b1 \u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NOVT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NOVST",
               "\u038f\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u038f\u03c1\u03b1 \u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7\u03c2",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b6\u03bf\u03c1\u03ce\u03bd",
               "AZOT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b6\u03bf\u03c1\u03ce\u03bd",
               "AZOST",
               "\u038f\u03c1\u03b1 \u0391\u03b6\u03bf\u03c1\u03ce\u03bd",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c0\u03af\u03b1",
               "WSST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c0\u03af\u03b1",
               "WSDT",
               "\u038f\u03c1\u03b1 \u0391\u03c0\u03af\u03b1",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u038f\u03c1\u03b1 \u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b1\u03bf\u03cd\u03c1\u03bf\u03c5",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KRAT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KRAST",
               "\u038f\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03c5\u03b3\u03ad\u03bd\u03bd\u03c9\u03bd",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AMT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AMST",
               "\u038f\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03af\u03c4\u03b6\u03b9",
               "FJT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03af\u03c4\u03b6\u03b9",
               "FJST",
               "\u038f\u03c1\u03b1 \u03a6\u03af\u03c4\u03b6\u03b9",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u038f\u03c1\u03b1 \u03a1\u03b5\u03ca\u03bd\u03b9\u03cc\u03bd",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039a\u03cc\u03ba\u03bf\u03c2",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03ac\u03b8\u03b1\u03bc",
               "CHAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03ac\u03b8\u03b1\u03bc",
               "CHADT",
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03ac\u03b8\u03b1\u03bc",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u038f\u03c1\u03b1 \u0392\u03cc\u03c3\u03c4\u03bf\u03ba",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ART",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ARST",
               "\u038f\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u038f\u03c1\u03b1 \u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b5\u03c1",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b5\u03c4\u03c1\u03bf\u03c0\u03b1\u03b2\u03bb\u03cc\u03b2\u03c3\u03ba-\u039a\u03b1\u03bc\u03c4\u03c3\u03ac\u03c4\u03c3\u03ba\u03b9",
               "PETT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b5\u03c4\u03c1\u03bf\u03c0\u03b1\u03b2\u03bb\u03cc\u03b2\u03c3\u03ba-\u039a\u03b1\u03bc\u03c4\u03c3\u03ac\u03c4\u03c3\u03ba\u03b9",
               "PETST",
               "\u038f\u03c1\u03b1 \u039a\u03b1\u03bc\u03c4\u03c3\u03ac\u03c4\u03ba\u03b1",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u038f\u03c1\u03b1 \u03a4\u03bf\u03c5\u03b2\u03b1\u03bb\u03bf\u03cd",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u038f\u03c1\u03b1 \u0393\u03ba\u03b1\u03bb\u03ac\u03c0\u03b1\u03b3\u03ba\u03bf\u03c2",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u039c\u03b1\u03ba\u03bf\u03c5\u03ac\u03c1\u03b9",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u038f\u03c1\u03b1 \u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1\u03c2",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HADT",
               "\u038f\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "PST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "PDT",
               "\u038f\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u03a6\u03af\u03bd\u03b9\u03be",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd",
               "TMT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd",
               "TMST",
               "\u038f\u03c1\u03b1 \u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WEST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5",
               "CVT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5",
               "CVST",
               "\u038f\u03c1\u03b1 \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039d\u03cc\u03c1\u03c6\u03bf\u03bb\u03ba",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u038f\u03c1\u03b1 \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1\u03c2",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u038f\u03c1\u03b1 \u03a0\u03af\u03c4\u03ba\u03b5\u03c1\u03bd",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u038f\u03c1\u03b1 \u03a1\u03bf\u03b8\u03ad\u03c1\u03b1",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03bc\u03cc\u03b1",
               "SST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03bc\u03cc\u03b1",
               "SDT",
               "\u038f\u03c1\u03b1 \u03a3\u03b1\u03bc\u03cc\u03b1",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u038f\u03c1\u03b1 \u03a0\u03b1\u03bb\u03ac\u03bf\u03c5",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u03c0\u03b5\u03c1\u03b1\u03b9\u03c4\u03ad\u03c1\u03c9 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd",
               "AZT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd",
               "AZST",
               "\u038f\u03c1\u03b1 \u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03cc\u03c3\u03bf\u03bd",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "MST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "MDT",
               "\u038f\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03c4\u03ad\u03b9\u03b2\u03b9\u03c2",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03cd\u03b2\u03b1\u03c2",
               "CST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03cd\u03b2\u03b1\u03c2",
               "CDT",
               "\u038f\u03c1\u03b1 \u039a\u03bf\u03cd\u03b2\u03b1\u03c2",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAT",
            };
        final String[] GMT = new String[] {
               "\u039c\u03ad\u03c3\u03b7 \u03ce\u03c1\u03b1 \u0393\u03ba\u03c1\u03af\u03bd\u03bf\u03c5\u03b9\u03c4\u03c2",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03b9\u03bd\u03ce\u03bd",
               "PHT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03b9\u03bd\u03ce\u03bd",
               "PHST",
               "\u038f\u03c1\u03b1 \u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03b9\u03bd\u03ce\u03bd",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u038f\u03c1\u03b1 \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03bf\u03cd \u039d\u03cc\u03c4\u03bf\u03c5 \u03ba\u03b1\u03b9 \u0391\u03bd\u03c4\u03b1\u03c1\u03ba\u03c4\u03b9\u03ba\u03ae\u03c2",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1\u03c2",
               "NCT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1\u03c2",
               "NCST",
               "\u038f\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1\u03c2",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9 \u039d\u03c4\u03b1\u03c1\u03bf\u03c5\u03c3\u03b1\u03bb\u03ac\u03bc",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ac\u03bd",
               "IRST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ac\u03bd",
               "IRDT",
               "\u038f\u03c1\u03b1 \u0399\u03c1\u03ac\u03bd",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u03a0\u03ac\u03c3\u03c7\u03b1",
               "EAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u03a0\u03ac\u03c3\u03c7\u03b1",
               "EASST",
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03bf\u03cd \u03a0\u03ac\u03c3\u03c7\u03b1",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bf\u03c1\u03b5\u03b9\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "PST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bf\u03c1\u03b5\u03b9\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "PDT",
               "\u038f\u03c1\u03b1 \u0392\u03bf\u03c1\u03b5\u03b9\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03c4\u03b9\u03bc\u03cc\u03bd\u03c4 \u039d\u03c4\u03b5\u03c1\u03b2\u03af\u03bb",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u038f\u03c1\u03b1 \u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03cc\u03bd\u03b3\u03ba\u03b1",
               "TOT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03cc\u03bd\u03b3\u03ba\u03b1",
               "TOST",
               "\u038f\u03c1\u03b1 \u03a4\u03cc\u03bd\u03b3\u03ba\u03b1",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2",
               "BDT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2",
               "BDST",
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b5\u03c1\u03bf\u03cd",
               "PET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a0\u03b5\u03c1\u03bf\u03cd",
               "PEST",
               "\u038f\u03c1\u03b1 \u03a0\u03b5\u03c1\u03bf\u03cd",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "WGT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "WGST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u038f\u03c1\u03b1 \u0395\u03ba\u03bf\u03c5\u03b1\u03b4\u03cc\u03c1",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "EGT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "EGST",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03cc\u03bb\u03c0\u03bf\u03c5",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u038f\u03c1\u03b1: \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1\u03c2",
               "KST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1\u03c2",
               "KDT",
               "\u038f\u03c1\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1\u03c2",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWDT",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03b9\u03c1\u03b3\u03b9\u03c3\u03c4\u03ac\u03bd",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u038f\u03c1\u03b1: \u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEDT",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u038f\u03c1\u03b1 \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae\u03c2 \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1\u03c2",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1\u03c2",
               "COT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1\u03c2",
               "COST",
               "\u038f\u03c1\u03b1 \u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1\u03c2",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b9\u03bb\u03ae\u03c2",
               "CLT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b9\u03bb\u03ae\u03c2",
               "CLST",
               "\u038f\u03c1\u03b1 \u03a7\u03b9\u03bb\u03ae\u03c2",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u0393\u03ba\u03af\u03bb\u03bc\u03c0\u03b5\u03c1\u03c4",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "MST",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "MDT",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03c1\u03ba\u03ad\u03c3\u03b1\u03c2",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "AST",
               "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "ADT",
               "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKDT",
               "\u038f\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VLAT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VLAST",
               "\u038f\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03b1\u03bc\u03cc\u03c1\u03bf",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IRKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IRKST",
               "\u038f\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2",
               "GET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2",
               "GEST",
               "\u038f\u03c1\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u038f\u03c1\u03b1 \u03a4\u03bf\u03ba\u03b5\u03bb\u03ac\u03bf\u03c5",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u038f\u03c1\u03b1 \u03a0\u03b1\u03c0\u03bf\u03c5\u03ac \u039d\u03ad\u03b1 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNST",
               "\u038f\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CHOT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CHOST",
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BRT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BRST",
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BRT",
            };
        final String[] China = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03af\u03bd\u03b1\u03c2",
               "CST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03af\u03bd\u03b1\u03c2",
               "CDT",
               "\u038f\u03c1\u03b1 \u039a\u03af\u03bd\u03b1\u03c2",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1\u03c2",
               "AMT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1\u03c2",
               "AMST",
               "\u038f\u03c1\u03b1 \u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1\u03c2",
               "AMT",
            };
        final String[] Samara = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03ac\u03bc\u03b1\u03c1\u03b1\u03c2",
               "SAMT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03bc\u03ac\u03c1\u03b1\u03c2",
               "SAMST",
               "\u038f\u03c1\u03b1 \u03a3\u03ac\u03bc\u03b1\u03c1\u03b1\u03c2",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u038f\u03c1\u03b1 \u0399\u03bd\u03b4\u03af\u03b1\u03c2",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039a\u03bf\u03c5\u03ba",
               "CKT",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039a\u03bf\u03c5\u03ba",
               "CKHST",
               "\u038f\u03c1\u03b1 \u039d\u03b7\u03c3\u03b9\u03ce\u03bd \u039a\u03bf\u03c5\u03ba",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u039c\u03ad\u03c3\u03b7 \u03ce\u03c1\u03b1 \u0393\u03ba\u03c1\u03af\u03bd\u03bf\u03c5\u03b9\u03c4\u03c2",
                    "GMT",
                    "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03af\u03b1\u03c2",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u039c\u03ad\u03c3\u03b7 \u03ce\u03c1\u03b1 \u0393\u03ba\u03c1\u03af\u03bd\u03bf\u03c5\u03b9\u03c4\u03c2",
                    "GMT",
                    "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
