/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.peer.SystemTrayPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.HeadlessToolkit;
import sun.awt.SunToolkit;
import sun.security.util.SecurityConstants;

public class SystemTray {
    private static SystemTray systemTray;
    private int currentIconID = 0;
    private transient SystemTrayPeer peer;
    private static final TrayIcon[] EMPTY_TRAY_ARRAY;

    private SystemTray() {
        this.addNotify();
    }

    public static SystemTray getSystemTray() {
        SystemTray.checkSystemTrayAllowed();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        SystemTray.initializeSystemTrayIfNeeded();
        if (!SystemTray.isSupported()) {
            throw new UnsupportedOperationException("The system tray is not supported on the current platform.");
        }
        return systemTray;
    }

    public static boolean isSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            SystemTray.initializeSystemTrayIfNeeded();
            return ((SunToolkit)toolkit).isTraySupported();
        }
        if (toolkit instanceof HeadlessToolkit) {
            return ((HeadlessToolkit)toolkit).isTraySupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TrayIcon trayIcon) throws AWTException {
        if (trayIcon == null) {
            throw new NullPointerException("adding null TrayIcon");
        }
        TrayIcon[] oldArray = null;
        TrayIcon[] newArray = null;
        Vector<TrayIcon> icons = null;
        SystemTray systemTray = this;
        synchronized (systemTray) {
            oldArray = SystemTray.systemTray.getTrayIcons();
            icons = (Vector<TrayIcon>)AppContext.getAppContext().get(TrayIcon.class);
            if (icons == null) {
                icons = new Vector<TrayIcon>(3);
                AppContext.getAppContext().put(TrayIcon.class, icons);
            } else if (icons.contains(trayIcon)) {
                throw new IllegalArgumentException("adding TrayIcon that is already added");
            }
            icons.add(trayIcon);
            newArray = SystemTray.systemTray.getTrayIcons();
            trayIcon.setID(++this.currentIconID);
        }
        try {
            trayIcon.addNotify();
        }
        catch (AWTException e) {
            icons.remove(trayIcon);
            throw e;
        }
        this.firePropertyChange("trayIcons", oldArray, newArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TrayIcon trayIcon) {
        if (trayIcon == null) {
            return;
        }
        TrayIcon[] oldArray = null;
        TrayIcon[] newArray = null;
        SystemTray systemTray = this;
        synchronized (systemTray) {
            oldArray = SystemTray.systemTray.getTrayIcons();
            Vector icons = (Vector)AppContext.getAppContext().get(TrayIcon.class);
            if (icons == null || !icons.remove(trayIcon)) {
                return;
            }
            trayIcon.removeNotify();
            newArray = SystemTray.systemTray.getTrayIcons();
        }
        this.firePropertyChange("trayIcons", oldArray, newArray);
    }

    public TrayIcon[] getTrayIcons() {
        Vector icons = (Vector)AppContext.getAppContext().get(TrayIcon.class);
        if (icons != null) {
            return icons.toArray(new TrayIcon[icons.size()]);
        }
        return EMPTY_TRAY_ARRAY;
    }

    public Dimension getTrayIconSize() {
        return this.peer.getTrayIconSize();
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.getCurrentChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.getCurrentChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.getCurrentChangeSupport().getPropertyChangeListeners(propertyName);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.getCurrentChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    private synchronized PropertyChangeSupport getCurrentChangeSupport() {
        PropertyChangeSupport changeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(SystemTray.class);
        if (changeSupport == null) {
            changeSupport = new PropertyChangeSupport(this);
            AppContext.getAppContext().put(SystemTray.class, changeSupport);
        }
        return changeSupport;
    }

    synchronized void addNotify() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                this.peer = ((SunToolkit)Toolkit.getDefaultToolkit()).createSystemTray(this);
            } else if (toolkit instanceof HeadlessToolkit) {
                this.peer = ((HeadlessToolkit)Toolkit.getDefaultToolkit()).createSystemTray(this);
            }
        }
    }

    static void checkSystemTrayAllowed() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.AWT.ACCESS_SYSTEM_TRAY_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSystemTrayIfNeeded() {
        Class<SystemTray> clazz = SystemTray.class;
        synchronized (SystemTray.class) {
            if (systemTray == null) {
                systemTray = new SystemTray();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        EMPTY_TRAY_ARRAY = new TrayIcon[0];
        AWTAccessor.setSystemTrayAccessor(new AWTAccessor.SystemTrayAccessor(){

            @Override
            public void firePropertyChange(SystemTray tray, String propertyName, Object oldValue, Object newValue) {
                tray.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }
}

