/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import sun.rmi.server.ActivatableRef;
import sun.rmi.server.ActivatableServerRef;
import sun.rmi.transport.ObjectTable;

public abstract class Activatable
extends RemoteServer {
    private ActivationID id;
    private static final long serialVersionUID = -3120617863591563455L;

    protected Activatable(String location, MarshalledObject<?> data, boolean restart, int port) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject((Remote)this, location, data, restart, port);
    }

    protected Activatable(String location, MarshalledObject<?> data, boolean restart, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject(this, location, data, restart, port, csf, ssf);
    }

    protected Activatable(ActivationID id, int port) throws RemoteException {
        this.id = id;
        Activatable.exportObject(this, id, port);
    }

    protected Activatable(ActivationID id, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.id = id;
        Activatable.exportObject((Remote)this, id, port, csf, ssf);
    }

    protected ActivationID getID() {
        return this.id;
    }

    public static Remote register(ActivationDesc desc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID id = ActivationGroup.getSystem().registerObject(desc);
        return ActivatableRef.getStub(desc, id);
    }

    public static boolean inactive(ActivationID id) throws UnknownObjectException, ActivationException, RemoteException {
        return ActivationGroup.currentGroup().inactiveObject(id);
    }

    public static void unregister(ActivationID id) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.getSystem().unregisterObject(id);
    }

    public static ActivationID exportObject(Remote obj, String location, MarshalledObject<?> data, boolean restart, int port) throws ActivationException, RemoteException {
        return Activatable.exportObject(obj, location, data, restart, port, null, null);
    }

    public static ActivationID exportObject(Remote obj, String location, MarshalledObject<?> data, boolean restart, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws ActivationException, RemoteException {
        ActivationDesc desc = new ActivationDesc(obj.getClass().getName(), location, data, restart);
        ActivationSystem system = ActivationGroup.getSystem();
        ActivationID id = system.registerObject(desc);
        try {
            Activatable.exportObject(obj, id, port, csf, ssf);
        }
        catch (RemoteException e) {
            try {
                system.unregisterObject(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        ActivationGroup.currentGroup().activeObject(id, obj);
        return id;
    }

    public static Remote exportObject(Remote obj, ActivationID id, int port) throws RemoteException {
        return Activatable.exportObject(obj, new ActivatableServerRef(id, port));
    }

    public static Remote exportObject(Remote obj, ActivationID id, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return Activatable.exportObject(obj, new ActivatableServerRef(id, port, csf, ssf));
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return ObjectTable.unexportObject(obj, force);
    }

    private static Remote exportObject(Remote obj, ActivatableServerRef sref) throws RemoteException {
        if (obj instanceof Activatable) {
            ((Activatable)obj).ref = sref;
        }
        return sref.exportObject(obj, null, false);
    }
}

