/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Depth;
import sun.awt.X11.Native;
import sun.awt.X11.Visual;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Screen
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 80;
    }

    @Override
    public int getDataSize() {
        return Screen.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public Screen(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public Screen() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Screen.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(index * 16)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_display(int index) {
        log.finest("");
        return Native.getLong(this.pData + 4L) + (long)(index * Native.getLongSize());
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_display(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_root(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_width(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_height(int v) {
        log.finest("");
        Native.putInt(this.pData + 16L, v);
    }

    public int get_mwidth() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_mwidth(int v) {
        log.finest("");
        Native.putInt(this.pData + 20L, v);
    }

    public int get_mheight() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_mheight(int v) {
        log.finest("");
        Native.putInt(this.pData + 24L, v);
    }

    public int get_ndepths() {
        log.finest("");
        return Native.getInt(this.pData + 28L);
    }

    public void set_ndepths(int v) {
        log.finest("");
        Native.putInt(this.pData + 28L, v);
    }

    public Depth get_depths(int index) {
        log.finest("");
        return Native.getLong(this.pData + 32L) != 0L ? new Depth(Native.getLong(this.pData + 32L) + (long)(index * 12)) : null;
    }

    public long get_depths() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_depths(long v) {
        log.finest("");
        Native.putLong(this.pData + 32L, v);
    }

    public int get_root_depth() {
        log.finest("");
        return Native.getInt(this.pData + 36L);
    }

    public void set_root_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 36L, v);
    }

    public Visual get_root_visual(int index) {
        log.finest("");
        return Native.getLong(this.pData + 40L) != 0L ? new Visual(Native.getLong(this.pData + 40L) + (long)(index * 32)) : null;
    }

    public long get_root_visual() {
        log.finest("");
        return Native.getLong(this.pData + 40L);
    }

    public void set_root_visual(long v) {
        log.finest("");
        Native.putLong(this.pData + 40L, v);
    }

    public long get_default_gc() {
        log.finest("");
        return Native.getLong(this.pData + 44L);
    }

    public void set_default_gc(long v) {
        log.finest("");
        Native.putLong(this.pData + 44L, v);
    }

    public long get_cmap() {
        log.finest("");
        return Native.getLong(this.pData + 48L);
    }

    public void set_cmap(long v) {
        log.finest("");
        Native.putLong(this.pData + 48L, v);
    }

    public long get_white_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 52L);
    }

    public void set_white_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 52L, v);
    }

    public long get_black_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 56L);
    }

    public void set_black_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 56L, v);
    }

    public int get_max_maps() {
        log.finest("");
        return Native.getInt(this.pData + 60L);
    }

    public void set_max_maps(int v) {
        log.finest("");
        Native.putInt(this.pData + 60L, v);
    }

    public int get_min_maps() {
        log.finest("");
        return Native.getInt(this.pData + 64L);
    }

    public void set_min_maps(int v) {
        log.finest("");
        Native.putInt(this.pData + 64L, v);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + 68L);
    }

    public void set_backing_store(int v) {
        log.finest("");
        Native.putInt(this.pData + 68L, v);
    }

    public boolean get_save_unders() {
        log.finest("");
        return Native.getBool(this.pData + 72L);
    }

    public void set_save_unders(boolean v) {
        log.finest("");
        Native.putBool(this.pData + 72L, v);
    }

    public long get_root_input_mask() {
        log.finest("");
        return Native.getLong(this.pData + 76L);
    }

    public void set_root_input_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 76L, v);
    }

    @Override
    String getName() {
        return "Screen";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(800);
        ret.append("ext_data = ").append(this.get_ext_data()).append(", ");
        ret.append("display = ").append(this.get_display()).append(", ");
        ret.append("root = ").append(this.get_root()).append(", ");
        ret.append("width = ").append(this.get_width()).append(", ");
        ret.append("height = ").append(this.get_height()).append(", ");
        ret.append("mwidth = ").append(this.get_mwidth()).append(", ");
        ret.append("mheight = ").append(this.get_mheight()).append(", ");
        ret.append("ndepths = ").append(this.get_ndepths()).append(", ");
        ret.append("depths = ").append(this.get_depths()).append(", ");
        ret.append("root_depth = ").append(this.get_root_depth()).append(", ");
        ret.append("root_visual = ").append(this.get_root_visual()).append(", ");
        ret.append("default_gc = ").append(this.get_default_gc()).append(", ");
        ret.append("cmap = ").append(this.get_cmap()).append(", ");
        ret.append("white_pixel = ").append(this.get_white_pixel()).append(", ");
        ret.append("black_pixel = ").append(this.get_black_pixel()).append(", ");
        ret.append("max_maps = ").append(this.get_max_maps()).append(", ");
        ret.append("min_maps = ").append(this.get_min_maps()).append(", ");
        ret.append("backing_store = ").append(this.get_backing_store()).append(", ");
        ret.append("save_unders = ").append(this.get_save_unders()).append(", ");
        ret.append("root_input_mask = ").append(this.get_root_input_mask()).append(", ");
        return ret.toString();
    }
}

