/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.io.IOUtils;
import grails.util.BuildSettings;
import grails.util.CollectionUtils;
import grails.util.Holder;
import grails.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.io.support.UrlResource;

public final class Environment
extends Enum<Environment> {
    public static final /* enum */ Environment DEVELOPMENT;
    public static final /* enum */ Environment PRODUCTION;
    public static final /* enum */ Environment TEST;
    public static final /* enum */ Environment APPLICATION;
    public static final /* enum */ Environment CUSTOM;
    public static String KEY;
    public static final String ENV_KEY = "GRAILS_ENV";
    public static String ENV_GRAILS_HOME;
    public static String RELOAD_ENABLED;
    public static String RUN_ACTIVE;
    public static String FULL_STACKTRACE;
    public static final String RELOAD_LOCATION = "grails.reload.location";
    public static final String INTERACTIVE_MODE_ENABLED = "grails.interactive.mode.enabled";
    public static final String DEFAULT = "grails.env.default";
    public static final String INITIALIZING = "grails.env.initializing";
    public static final String STANDALONE = "grails.env.standalone";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static Map<String, String> envNameMappings;
    private static Holder<Environment> cachedCurrentEnvironment;
    private static final boolean DEVELOPMENT_MODE;
    private static boolean initializingState;
    private static final String GRAILS_IMPLEMENTATION_TITLE = "Grails";
    private static final String GRAILS_VERSION;
    private static final boolean STANDALONE_DEPLOYED;
    private static final boolean WAR_DEPLOYED;
    public static Throwable currentReloadError;
    public static MultipleCompilationErrorsException currentCompilationError;
    private String name;
    private String reloadLocation;
    private static Boolean reloadingAgentEnabled;
    private static final /* synthetic */ Environment[] $VALUES;

    public static Environment[] values() {
        return (Environment[])$VALUES.clone();
    }

    public static Environment valueOf(String name) {
        return Enum.valueOf(Environment.class, name);
    }

    private Environment() {
        this.initialize();
    }

    public static String getGrailsVersion() {
        return GRAILS_VERSION;
    }

    public static void setCurrentReloadError(Throwable currentReloadError) {
        Environment.currentReloadError = currentReloadError;
    }

    public static MultipleCompilationErrorsException getCurrentCompilationError() {
        return currentCompilationError;
    }

    public static Throwable getCurrentReloadError() {
        return currentReloadError;
    }

    public static boolean isReloadInProgress() {
        return Boolean.getBoolean("grails.reloading.in.progress");
    }

    private void initialize() {
        this.name = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static Environment getCurrent() {
        Environment env;
        String envName = Environment.getEnvironment();
        if (!Environment.isBlank(envName) && (env = Environment.getEnvironment(envName)) != null) {
            return env;
        }
        Environment current = cachedCurrentEnvironment.get();
        if (current != null) {
            return current;
        }
        return Environment.cacheCurrentEnvironment();
    }

    private static Environment resolveCurrentEnvironment() {
        Environment env;
        String envName = Environment.getEnvironment();
        if (Environment.isBlank(envName)) {
            Metadata metadata = Metadata.getCurrent();
            if (metadata != null) {
                envName = metadata.getEnvironment();
            }
            if (Environment.isBlank(envName)) {
                return DEVELOPMENT;
            }
        }
        if ((env = Environment.getEnvironment(envName)) == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    private static Environment cacheCurrentEnvironment() {
        Environment env = Environment.resolveCurrentEnvironment();
        cachedCurrentEnvironment.set(env);
        return env;
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static void reset() {
        cachedCurrentEnvironment.set(null);
        Metadata.reset();
    }

    public static boolean isDevelopmentMode() {
        return DEVELOPMENT_MODE;
    }

    public static boolean isDevelopmentEnvironmentAvailable() {
        return BuildSettings.GRAILS_APP_DIR_PRESENT && !Environment.isStandaloneDeployed() && !Environment.isWarDeployed();
    }

    public static boolean isDevelopmentRun() {
        Environment env = Environment.getCurrent();
        return Environment.isDevelopmentEnvironmentAvailable() && Boolean.getBoolean(RUN_ACTIVE) && env == DEVELOPMENT;
    }

    public static boolean isWarDeployed() {
        if (!Environment.isStandalone()) {
            return WAR_DEPLOYED;
        }
        return false;
    }

    private static boolean isWebPath(String path) {
        return path.contains("/WEB-INF/classes") || path.contains("_wl_cls_gen.jar!/");
    }

    public static boolean isStandalone() {
        return Boolean.getBoolean(STANDALONE);
    }

    public static boolean isStandaloneDeployed() {
        return Environment.isStandalone() && STANDALONE_DEPLOYED;
    }

    public static boolean isFork() {
        return Boolean.getBoolean("grails.fork.active");
    }

    public static boolean isWithinShell() {
        return DefaultGroovyMethods.getRootLoader((ClassLoader)Environment.class.getClassLoader()) != null;
    }

    public static boolean isSystemSet() {
        return Environment.getEnvironment() != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        try {
            return Environment.valueOf(shortName.toUpperCase());
        }
        catch (IllegalArgumentException ise) {
            return null;
        }
    }

    public static Closure<?> getEnvironmentSpecificBlock(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure<?> getEnvironmentSpecificBlock(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.getCallable();
    }

    public static Object executeForCurrentEnvironment(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.execute();
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure<?> closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReloadEnabled() {
        boolean reloadOverride = Boolean.getBoolean(RELOAD_ENABLED);
        this.getReloadLocation();
        boolean reloadLocationSpecified = this.hasLocation(this.reloadLocation);
        return this == DEVELOPMENT && reloadLocationSpecified || reloadOverride && reloadLocationSpecified;
    }

    public static boolean isInteractiveMode() {
        return Boolean.getBoolean(INTERACTIVE_MODE_ENABLED);
    }

    public static boolean isInitializing() {
        return initializingState;
    }

    public static void setInitializing(boolean initializing) {
        initializingState = initializing;
        System.setProperty(INITIALIZING, String.valueOf(initializing));
    }

    public static boolean isReloadingAgentEnabled() {
        if (reloadingAgentEnabled != null) {
            return reloadingAgentEnabled;
        }
        try {
            Class.forName("org.springsource.loaded.TypeRegistry");
            reloadingAgentEnabled = Environment.getCurrent().isReloadEnabled();
        }
        catch (ClassNotFoundException e) {
            reloadingAgentEnabled = false;
        }
        return reloadingAgentEnabled;
    }

    public String getReloadLocation() {
        if (this.reloadLocation != null) {
            return this.reloadLocation;
        }
        String location = this.getReloadLocationInternal();
        if (this.hasLocation(location)) {
            this.reloadLocation = location;
            return location;
        }
        return ".";
    }

    private boolean hasLocation(String location) {
        return location != null && location.length() > 0;
    }

    public boolean hasReloadLocation() {
        this.getReloadLocation();
        return this.hasLocation(this.reloadLocation);
    }

    private String getReloadLocationInternal() {
        String location = System.getProperty(RELOAD_LOCATION);
        if (!this.hasLocation(location)) {
            location = System.getProperty("base.dir");
        }
        if (!this.hasLocation(location)) {
            File current = new File(".", "grails-app");
            if (current.exists()) {
                location = current.getParentFile().getAbsolutePath();
            } else {
                current = new File(".", "settings.gradle");
                if (current.exists()) {
                    location = IOUtils.findApplicationDirectory();
                }
            }
        }
        return location;
    }

    private static String getEnvironment() {
        String envName = System.getProperty(KEY);
        return Environment.isBlank(envName) ? System.getenv(ENV_KEY) : envName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String path;
        String version;
        DEVELOPMENT = new Environment();
        PRODUCTION = new Environment();
        TEST = new Environment();
        APPLICATION = new Environment();
        CUSTOM = new Environment();
        $VALUES = new Environment[]{DEVELOPMENT, PRODUCTION, TEST, APPLICATION, CUSTOM};
        KEY = "grails.env";
        ENV_GRAILS_HOME = "GRAILS_HOME";
        RELOAD_ENABLED = "grails.reload.enabled";
        RUN_ACTIVE = "grails.run.active";
        FULL_STACKTRACE = "grails.full.stacktrace";
        envNameMappings = CollectionUtils.newMap(DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName(), PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName(), TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
        cachedCurrentEnvironment = new Holder("Environment");
        DEVELOPMENT_MODE = Environment.getCurrent() == DEVELOPMENT && BuildSettings.GRAILS_APP_DIR_PRESENT;
        initializingState = false;
        Package p = Environment.class.getPackage();
        String string = version = p != null ? p.getImplementationVersion() : null;
        if (version == null || Environment.isBlank(version)) {
            try {
                UrlResource r;
                URL manifestURL = IOUtils.findResourceRelativeToClass(Environment.class, "/META-INF/MANIFEST.MF");
                Manifest grailsManifest = null;
                if (manifestURL != null && (r = new UrlResource(manifestURL)).exists()) {
                    InputStream inputStream = null;
                    Manifest mf = null;
                    try {
                        inputStream = r.getInputStream();
                        mf = new Manifest(inputStream);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    String implTitle = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    if (!Environment.isBlank(implTitle) && implTitle.equals(GRAILS_IMPLEMENTATION_TITLE)) {
                        grailsManifest = mf;
                    }
                }
                if (grailsManifest != null) {
                    version = grailsManifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (Environment.isBlank(version)) {
                    version = "Unknown";
                }
            }
            catch (Exception e) {
                version = "Unknown";
            }
        }
        GRAILS_VERSION = version;
        URL url = Environment.class.getResource("");
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equals("jar")) {
                String fullPath = url.toString();
                if (fullPath.contains(".war!")) {
                    STANDALONE_DEPLOYED = true;
                } else {
                    int i = fullPath.indexOf(".jar!");
                    if (i > -1) {
                        fullPath = fullPath.substring(i + ".jar!".length());
                        STANDALONE_DEPLOYED = fullPath.contains(".jar!");
                    } else {
                        STANDALONE_DEPLOYED = false;
                    }
                }
            } else {
                STANDALONE_DEPLOYED = false;
            }
        } else {
            STANDALONE_DEPLOYED = false;
        }
        URL loadedLocation = Environment.class.getClassLoader().getResource("application.yml");
        if (loadedLocation != null) {
            path = loadedLocation.getPath();
            WAR_DEPLOYED = Environment.isWebPath(path);
        } else {
            loadedLocation = Thread.currentThread().getContextClassLoader().getResource("application.yml");
            if (loadedLocation != null) {
                path = loadedLocation.getPath();
                WAR_DEPLOYED = Environment.isWebPath(path);
            } else {
                WAR_DEPLOYED = false;
            }
        }
        currentReloadError = null;
        currentCompilationError = null;
        reloadingAgentEnabled = null;
    }

    private static class EnvironmentBlockEvaluator
    extends GroovyObjectSupport {
        private Environment current;
        private Closure<?> callable;

        public Closure<?> getCallable() {
            return this.callable;
        }

        Object execute() {
            return this.callable == null ? null : this.callable.call();
        }

        private EnvironmentBlockEvaluator(Environment e) {
            this.current = e;
        }

        public void environments(Closure<?> c) {
            if (c != null) {
                c.setDelegate((Object)this);
                c.call();
            }
        }

        public void production(Closure<?> c) {
            if (this.current == PRODUCTION) {
                this.callable = c;
            }
        }

        public void development(Closure<?> c) {
            if (this.current == DEVELOPMENT) {
                this.callable = c;
            }
        }

        public void test(Closure<?> c) {
            if (this.current == TEST) {
                this.callable = c;
            }
        }

        public Object methodMissing(String name, Object args) {
            Object[] argsArray = (Object[])args;
            if (args != null && argsArray.length > 0 && argsArray[0] instanceof Closure) {
                if (this.current == CUSTOM && this.current.getName().equals(name)) {
                    this.callable = (Closure)argsArray[0];
                }
                return null;
            }
            throw new MissingMethodException(name, Environment.class, argsArray);
        }
    }
}

