/* Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.grails.databinding.converters

import grails.databinding.converters.ValueConverter
import groovy.transform.CompileStatic

/**
 * 
 * A ValueConverter for converting String to Currency.
 * 
 * @see ValueConverter
 * @since 2.3.10
 *
 */
@CompileStatic
class CurrencyValueConverter implements ValueConverter {

    @Override
    public boolean canConvert(Object value) {
        value instanceof String
    }

    @Override
    public Object convert(Object value) {
        Currency.getInstance(value as String)
    }

    @Override
    public Class<?> getTargetType() {
        Currency
    }

}
