/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.VBuilder;
import a_vcard.android.syncml.pim.vcard.CustomBufferedReader;
import a_vcard.android.syncml.pim.vcard.VCardException;
import a_vcard.android.syncml.pim.vcard.VCardNestedException;
import a_vcard.android.syncml.pim.vcard.VCardSourceDetector;
import a_vcard.android.syncml.pim.vcard.VCardVersionException;
import a_vcard.android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class VCardParser_V21 {
    private static final String LOG_TAG = "VCardParser_V21";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final HashSet<String> sKnownTypeSet = new HashSet<String>(Arrays.asList("DOM", "INTL", "POSTAL", "PARCEL", "HOME", "WORK", "PREF", "VOICE", "FAX", "MSG", "CELL", "PAGER", "BBS", "MODEM", "CAR", "ISDN", "VIDEO", "AOL", "APPLELINK", "ATTMAIL", "CIS", "EWORLD", "INTERNET", "IBMMAIL", "MCIMAIL", "POWERSHARE", "PRODIGY", "TLX", "X400", "GIF", "CGM", "WMF", "BMP", "MET", "PMB", "DIB", "PICT", "TIFF", "PDF", "PS", "JPEG", "QTIME", "MPEG", "MPEG2", "AVI", "WAVE", "AIFF", "PCM", "X509", "PGP"));
    private static final HashSet<String> sKnownValueSet = new HashSet<String>(Arrays.asList("INLINE", "URL", "CONTENT-ID", "CID"));
    private static final HashSet<String> sAvailablePropertyNameV21 = new HashSet<String>(Arrays.asList("BEGIN", "LOGO", "PHOTO", "LABEL", "FN", "TITLE", "SOUND", "VERSION", "TEL", "EMAIL", "TZ", "GEO", "NOTE", "URL", "BDAY", "ROLE", "REV", "UID", "KEY", "MAILER"));
    private static final HashSet<String> sAvailableEncodingV21 = new HashSet<String>(Arrays.asList("7BIT", "8BIT", "QUOTED-PRINTABLE", "BASE64", "B"));
    private String mPreviousLine;
    protected VBuilder mBuilder = null;
    protected String mEncoding = null;
    protected final String sDefaultEncoding = "8BIT";
    protected BufferedReader mReader;
    private boolean mCanceled;
    private int mNestCount;
    protected HashSet<String> mWarningValueMap = new HashSet();
    private long mTimeTotal;
    private long mTimeStartRecord;
    private long mTimeEndRecord;
    private long mTimeStartProperty;
    private long mTimeEndProperty;
    private long mTimeParseItems;
    private long mTimeParseItem1;
    private long mTimeParseItem2;
    private long mTimeParseItem3;
    private long mTimeHandlePropertyValue1;
    private long mTimeHandlePropertyValue2;
    private long mTimeHandlePropertyValue3;
    private static final int STATE_GROUP_OR_PROPNAME = 0;
    private static final int STATE_PARAMS = 1;
    private static final int STATE_PARAMS_IN_DQUOTE = 2;

    public VCardParser_V21() {
    }

    public VCardParser_V21(VCardSourceDetector detector) {
        if (detector != null && detector.getType() == 3) {
            this.mNestCount = 1;
        }
    }

    protected void parseVCardFile() throws IOException, VCardException {
        boolean firstReading = true;
        while (!this.mCanceled && this.parseOneVCard(firstReading)) {
            firstReading = false;
        }
        if (this.mNestCount > 0) {
            boolean useCache = true;
            for (int i = 0; i < this.mNestCount; ++i) {
                this.readEndVCard(useCache, true);
                useCache = false;
            }
        }
    }

    protected String getVersion() {
        return "2.1";
    }

    protected boolean isValidPropertyName(String propertyName) {
        if (!(sAvailablePropertyNameV21.contains(propertyName.toUpperCase()) || propertyName.startsWith("X-") || this.mWarningValueMap.contains(propertyName))) {
            this.mWarningValueMap.add(propertyName);
            Log.w(LOG_TAG, "Property name unsupported by vCard 2.1: " + propertyName);
        }
        return true;
    }

    protected boolean isValidEncoding(String encoding) {
        return sAvailableEncodingV21.contains(encoding.toUpperCase());
    }

    protected String getLine() throws IOException {
        return this.mReader.readLine();
    }

    protected String getNonEmptyLine() throws IOException, VCardException {
        String line;
        do {
            if ((line = this.getLine()) != null) continue;
            throw new VCardException("Reached end of buffer.");
        } while (line.trim().length() <= 0);
        return line;
    }

    private boolean parseOneVCard(boolean firstReading) throws IOException, VCardException {
        boolean allowGarbage = false;
        if (firstReading && this.mNestCount > 0) {
            for (int i = 0; i < this.mNestCount; ++i) {
                if (!this.readBeginVCard(allowGarbage)) {
                    return false;
                }
                allowGarbage = true;
            }
        }
        if (!this.readBeginVCard(allowGarbage)) {
            return false;
        }
        if (this.mBuilder != null) {
            long start = System.currentTimeMillis();
            this.mBuilder.startRecord("VCARD");
            this.mTimeStartRecord += System.currentTimeMillis() - start;
        }
        long start = System.currentTimeMillis();
        this.parseItems();
        this.mTimeParseItems += System.currentTimeMillis() - start;
        this.readEndVCard(true, false);
        if (this.mBuilder != null) {
            start = System.currentTimeMillis();
            this.mBuilder.endRecord();
            this.mTimeEndRecord += System.currentTimeMillis() - start;
        }
        return true;
    }

    protected boolean readBeginVCard(boolean allowGarbage) throws IOException, VCardException {
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                return false;
            }
            if (line.trim().length() <= 0) continue;
            String[] strArray = line.split(":", 2);
            int length = strArray.length;
            if (length == 2 && strArray[0].trim().equalsIgnoreCase("BEGIN") && strArray[1].trim().equalsIgnoreCase("VCARD")) {
                return true;
            }
            if (!allowGarbage) {
                if (this.mNestCount > 0) {
                    this.mPreviousLine = line;
                    return false;
                }
                throw new VCardException("Expected String \"BEGIN:VCARD\" did not come (Instead, \"" + line + "\" came)");
            }
            if (!allowGarbage) break;
        }
        throw new VCardException("Reached where must not be reached.");
    }

    protected void readEndVCard(boolean useCache, boolean allowGarbage) throws IOException, VCardException {
        do {
            String line;
            if (useCache) {
                line = this.mPreviousLine;
            } else {
                do {
                    if ((line = this.getLine()) != null) continue;
                    throw new VCardException("Expected END:VCARD was not found.");
                } while (line.trim().length() <= 0);
            }
            String[] strArray = line.split(":", 2);
            if (strArray.length == 2 && strArray[0].trim().equalsIgnoreCase("END") && strArray[1].trim().equalsIgnoreCase("VCARD")) {
                return;
            }
            if (!allowGarbage) {
                throw new VCardException("END:VCARD != \"" + this.mPreviousLine + "\"");
            }
            useCache = false;
        } while (allowGarbage);
    }

    protected void parseItems() throws IOException, VCardException {
        long start;
        boolean ended = false;
        if (this.mBuilder != null) {
            start = System.currentTimeMillis();
            this.mBuilder.startProperty();
            this.mTimeStartProperty += System.currentTimeMillis() - start;
        }
        ended = this.parseItem();
        if (this.mBuilder != null && !ended) {
            start = System.currentTimeMillis();
            this.mBuilder.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - start;
        }
        while (!ended) {
            if (this.mBuilder != null) {
                start = System.currentTimeMillis();
                this.mBuilder.startProperty();
                this.mTimeStartProperty += System.currentTimeMillis() - start;
            }
            ended = this.parseItem();
            if (this.mBuilder == null || ended) continue;
            start = System.currentTimeMillis();
            this.mBuilder.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - start;
        }
    }

    protected boolean parseItem() throws IOException, VCardException {
        this.mEncoding = "8BIT";
        String line = this.getNonEmptyLine();
        long start = System.currentTimeMillis();
        String[] propertyNameAndValue = this.separateLineAndHandleGroup(line);
        if (propertyNameAndValue == null) {
            return true;
        }
        if (propertyNameAndValue.length != 2) {
            throw new VCardException("Invalid line \"" + line + "\"");
        }
        String propertyName = propertyNameAndValue[0].toUpperCase();
        String propertyValue = propertyNameAndValue[1];
        this.mTimeParseItem1 += System.currentTimeMillis() - start;
        if (propertyName.equals("ADR") || propertyName.equals("ORG") || propertyName.equals("N")) {
            start = System.currentTimeMillis();
            this.handleMultiplePropertyValue(propertyName, propertyValue);
            this.mTimeParseItem3 += System.currentTimeMillis() - start;
            return false;
        }
        if (propertyName.equals("AGENT")) {
            this.handleAgent(propertyValue);
            return false;
        }
        if (this.isValidPropertyName(propertyName)) {
            if (propertyName.equals("BEGIN")) {
                if (propertyValue.equals("VCARD")) {
                    throw new VCardNestedException("This vCard has nested vCard data in it.");
                }
                throw new VCardException("Unknown BEGIN type: " + propertyValue);
            }
            if (propertyName.equals("VERSION") && !propertyValue.equals(this.getVersion())) {
                throw new VCardVersionException("Incompatible version: " + propertyValue + " != " + this.getVersion());
            }
            start = System.currentTimeMillis();
            this.handlePropertyValue(propertyName, propertyValue);
            this.mTimeParseItem2 += System.currentTimeMillis() - start;
            return false;
        }
        throw new VCardException("Unknown property name: \"" + propertyName + "\"");
    }

    protected String[] separateLineAndHandleGroup(String line) throws VCardException {
        int length = line.length();
        int state = 0;
        int nameIndex = 0;
        String[] propertyNameAndValue = new String[2];
        block5: for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            switch (state) {
                case 0: {
                    String propertyName;
                    if (ch == ':') {
                        propertyName = line.substring(nameIndex, i);
                        if (propertyName.equalsIgnoreCase("END")) {
                            this.mPreviousLine = line;
                            return null;
                        }
                        if (this.mBuilder != null) {
                            this.mBuilder.propertyName(propertyName);
                        }
                        propertyNameAndValue[0] = propertyName;
                        propertyNameAndValue[1] = i < length - 1 ? line.substring(i + 1) : "";
                        return propertyNameAndValue;
                    }
                    if (ch == '.') {
                        String groupName = line.substring(nameIndex, i);
                        if (this.mBuilder != null) {
                            this.mBuilder.propertyGroup(groupName);
                        }
                        nameIndex = i + 1;
                        continue block5;
                    }
                    if (ch != ';') continue block5;
                    propertyName = line.substring(nameIndex, i);
                    if (propertyName.equalsIgnoreCase("END")) {
                        this.mPreviousLine = line;
                        return null;
                    }
                    if (this.mBuilder != null) {
                        this.mBuilder.propertyName(propertyName);
                    }
                    propertyNameAndValue[0] = propertyName;
                    nameIndex = i + 1;
                    state = 1;
                    continue block5;
                }
                case 1: {
                    if (ch == '\"') {
                        state = 2;
                        continue block5;
                    }
                    if (ch == ';') {
                        this.handleParams(line.substring(nameIndex, i));
                        nameIndex = i + 1;
                        continue block5;
                    }
                    if (ch != ':') continue block5;
                    this.handleParams(line.substring(nameIndex, i));
                    propertyNameAndValue[1] = i < length - 1 ? line.substring(i + 1) : "";
                    return propertyNameAndValue;
                }
                case 2: {
                    if (ch != '\"') continue block5;
                    state = 1;
                }
            }
        }
        throw new VCardException("Invalid line: \"" + line + "\"");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleParams(String params) throws VCardException {
        String[] strArray = params.split("=", 2);
        if (strArray.length == 2) {
            String paramName = strArray[0].trim();
            String paramValue = strArray[1].trim();
            if (paramName.equals("TYPE")) {
                this.handleType(paramValue);
                return;
            } else if (paramName.equals("VALUE")) {
                this.handleValue(paramValue);
                return;
            } else if (paramName.equals("ENCODING")) {
                this.handleEncoding(paramValue);
                return;
            } else if (paramName.equals("CHARSET")) {
                this.handleCharset(paramValue);
                return;
            } else if (paramName.equals("LANGUAGE")) {
                this.handleLanguage(paramValue);
                return;
            } else {
                if (!paramName.startsWith("X-")) throw new VCardException("Unknown type \"" + paramName + "\"");
                this.handleAnyParam(paramName, paramValue);
            }
            return;
        } else {
            this.handleType(strArray[0]);
        }
    }

    protected void handleType(String ptypeval) {
        String upperTypeValue = ptypeval;
        if (!(sKnownTypeSet.contains(upperTypeValue) || upperTypeValue.startsWith("X-") || this.mWarningValueMap.contains(ptypeval))) {
            this.mWarningValueMap.add(ptypeval);
            Log.w(LOG_TAG, "Type unsupported by vCard 2.1: " + ptypeval);
        }
        if (this.mBuilder != null) {
            this.mBuilder.propertyParamType("TYPE");
            this.mBuilder.propertyParamValue(upperTypeValue);
        }
    }

    protected void handleValue(String pvalueval) throws VCardException {
        if (sKnownValueSet.contains(pvalueval.toUpperCase()) || pvalueval.startsWith("X-")) {
            if (this.mBuilder != null) {
                this.mBuilder.propertyParamType("VALUE");
                this.mBuilder.propertyParamValue(pvalueval);
            }
        } else {
            throw new VCardException("Unknown value \"" + pvalueval + "\"");
        }
    }

    protected void handleEncoding(String pencodingval) throws VCardException {
        if (this.isValidEncoding(pencodingval) || pencodingval.startsWith("X-")) {
            if (this.mBuilder != null) {
                this.mBuilder.propertyParamType("ENCODING");
                this.mBuilder.propertyParamValue(pencodingval);
            }
        } else {
            throw new VCardException("Unknown encoding \"" + pencodingval + "\"");
        }
        this.mEncoding = pencodingval;
    }

    protected void handleCharset(String charsetval) {
        if (this.mBuilder != null) {
            this.mBuilder.propertyParamType("CHARSET");
            this.mBuilder.propertyParamValue(charsetval);
        }
    }

    protected void handleLanguage(String langval) throws VCardException {
        int i;
        String[] strArray = langval.split("-");
        if (strArray.length != 2) {
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        String tmp = strArray[0];
        int length = tmp.length();
        for (i = 0; i < length; ++i) {
            if (this.isLetter(tmp.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        tmp = strArray[1];
        length = tmp.length();
        for (i = 0; i < length; ++i) {
            if (this.isLetter(tmp.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        if (this.mBuilder != null) {
            this.mBuilder.propertyParamType("LANGUAGE");
            this.mBuilder.propertyParamValue(langval);
        }
    }

    protected void handleAnyParam(String paramName, String paramValue) {
        if (this.mBuilder != null) {
            this.mBuilder.propertyParamType(paramName);
            this.mBuilder.propertyParamValue(paramValue);
        }
    }

    protected void handlePropertyValue(String propertyName, String propertyValue) throws IOException, VCardException {
        if (this.mEncoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
            long start = System.currentTimeMillis();
            String result = this.getQuotedPrintable(propertyValue);
            if (this.mBuilder != null) {
                ArrayList<String> v = new ArrayList<String>();
                v.add(result);
                this.mBuilder.propertyValues(v);
            }
            this.mTimeHandlePropertyValue2 += System.currentTimeMillis() - start;
        } else if (this.mEncoding.equalsIgnoreCase("BASE64") || this.mEncoding.equalsIgnoreCase("B")) {
            long start;
            block10: {
                start = System.currentTimeMillis();
                try {
                    String result = this.getBase64(propertyValue);
                    if (this.mBuilder != null) {
                        ArrayList<String> v = new ArrayList<String>();
                        v.add(result);
                        this.mBuilder.propertyValues(v);
                    }
                }
                catch (OutOfMemoryError error) {
                    Log.e(LOG_TAG, "OutOfMemoryError happened during parsing BASE64 data!");
                    if (this.mBuilder == null) break block10;
                    this.mBuilder.propertyValues(null);
                }
            }
            this.mTimeHandlePropertyValue3 += System.currentTimeMillis() - start;
        } else {
            if (!(this.mEncoding == null || this.mEncoding.equalsIgnoreCase("7BIT") || this.mEncoding.equalsIgnoreCase("8BIT") || this.mEncoding.toUpperCase().startsWith("X-"))) {
                Log.w(LOG_TAG, "The encoding unsupported by vCard spec: \"" + this.mEncoding + "\".");
            }
            long start = System.currentTimeMillis();
            if (this.mBuilder != null) {
                ArrayList<String> v = new ArrayList<String>();
                v.add(this.maybeUnescapeText(propertyValue));
                this.mBuilder.propertyValues(v);
            }
            this.mTimeHandlePropertyValue1 += System.currentTimeMillis() - start;
        }
    }

    protected String getQuotedPrintable(String firstString) throws IOException, VCardException {
        if (firstString.trim().endsWith("=")) {
            String line;
            int pos = firstString.length() - 1;
            while (firstString.charAt(pos) != '=') {
            }
            StringBuilder builder = new StringBuilder();
            builder.append(firstString.substring(0, pos + 1));
            builder.append("\r\n");
            while (true) {
                if ((line = this.getLine()) == null) {
                    throw new VCardException("File ended during parsing quoted-printable String");
                }
                if (!line.trim().endsWith("=")) break;
                pos = line.length() - 1;
                while (line.charAt(pos) != '=') {
                }
                builder.append(line.substring(0, pos + 1));
                builder.append("\r\n");
            }
            builder.append(line);
            return builder.toString();
        }
        return firstString;
    }

    protected String getBase64(String firstString) throws IOException, VCardException {
        StringBuilder builder = new StringBuilder();
        builder.append(firstString);
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (line.length() == 0) break;
            builder.append(line);
        }
        return builder.toString();
    }

    protected void handleMultiplePropertyValue(String propertyName, String propertyValue) throws IOException, VCardException {
        if (this.mEncoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
            propertyValue = this.getQuotedPrintable(propertyValue);
        }
        if (this.mBuilder != null) {
            StringBuilder builder = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            int length = propertyValue.length();
            for (int i = 0; i < length; ++i) {
                char ch = propertyValue.charAt(i);
                if (ch == '\\' && i < length - 1) {
                    char nextCh = propertyValue.charAt(i + 1);
                    String unescapedString = this.maybeUnescape(nextCh);
                    if (unescapedString != null) {
                        builder.append(unescapedString);
                        ++i;
                        continue;
                    }
                    builder.append(ch);
                    continue;
                }
                if (ch == ';') {
                    list.add(builder.toString());
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(ch);
            }
            list.add(builder.toString());
            this.mBuilder.propertyValues(list);
        }
    }

    protected void handleAgent(String propertyValue) throws VCardException {
        throw new VCardException("AGENT Property is not supported.");
    }

    protected String maybeUnescapeText(String text) {
        return text;
    }

    protected String maybeUnescape(char ch) {
        if (ch == '\\' || ch == ';' || ch == ':' || ch == ',') {
            return String.valueOf(ch);
        }
        return null;
    }

    public boolean parse(InputStream is, String charset, VBuilder builder) throws IOException, VCardException {
        this.mReader = new CustomBufferedReader(new InputStreamReader(is, charset));
        this.mBuilder = builder;
        long start = System.currentTimeMillis();
        if (this.mBuilder != null) {
            this.mBuilder.start();
        }
        this.parseVCardFile();
        if (this.mBuilder != null) {
            this.mBuilder.end();
        }
        this.mTimeTotal += System.currentTimeMillis() - start;
        return true;
    }

    public boolean parse(InputStream is, VBuilder builder) throws IOException, VCardException {
        return this.parse(is, DEFAULT_CHARSET, builder);
    }

    public void cancel() {
        this.mCanceled = true;
    }

    public void parse(InputStream is, String charset, VBuilder builder, boolean canceled) throws IOException, VCardException {
        this.mCanceled = canceled;
        this.parse(is, charset, builder);
    }

    public void showDebugInfo() {
        Log.d(LOG_TAG, "total parsing time:  " + this.mTimeTotal + " ms");
        if (this.mReader instanceof CustomBufferedReader) {
            Log.d(LOG_TAG, "total readLine time: " + ((CustomBufferedReader)this.mReader).getTotalmillisecond() + " ms");
        }
        Log.d(LOG_TAG, "mTimeStartRecord: " + this.mTimeStartRecord + " ms");
        Log.d(LOG_TAG, "mTimeEndRecord: " + this.mTimeEndRecord + " ms");
        Log.d(LOG_TAG, "mTimeParseItem1: " + this.mTimeParseItem1 + " ms");
        Log.d(LOG_TAG, "mTimeParseItem2: " + this.mTimeParseItem2 + " ms");
        Log.d(LOG_TAG, "mTimeParseItem3: " + this.mTimeParseItem3 + " ms");
        Log.d(LOG_TAG, "mTimeHandlePropertyValue1: " + this.mTimeHandlePropertyValue1 + " ms");
        Log.d(LOG_TAG, "mTimeHandlePropertyValue2: " + this.mTimeHandlePropertyValue2 + " ms");
        Log.d(LOG_TAG, "mTimeHandlePropertyValue3: " + this.mTimeHandlePropertyValue3 + " ms");
    }

    private boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }
}

