// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Connection.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Connection_h__
#define __Ice_Connection_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/OutgoingAsync.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ObjectAdapterF.h>
#include <Ice/Identity.h>
#include <Ice/Endpoint.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class ConnectionInfo;
class Connection;
class IPConnectionInfo;
class TCPConnectionInfo;
class UDPConnectionInfo;
class WSConnectionInfo;

}

namespace Ice
{

enum class CompressBatch : unsigned char
{
    Yes,
    No,
    BasedOnProxy
};

enum class ACMClose : unsigned char
{
    CloseOff,
    CloseOnIdle,
    CloseOnInvocation,
    CloseOnInvocationAndIdle,
    CloseOnIdleForceful
};

enum class ACMHeartbeat : unsigned char
{
    HeartbeatOff,
    HeartbeatOnDispatch,
    HeartbeatOnIdle,
    HeartbeatAlways
};

struct ACM
{
    int timeout;
    ::Ice::ACMClose close;
    ::Ice::ACMHeartbeat heartbeat;

    std::tuple<const int&, const ::Ice::ACMClose&, const ::Ice::ACMHeartbeat&> ice_tuple() const
    {
        return std::tie(timeout, close, heartbeat);
    }
};

enum class ConnectionClose : unsigned char
{
    Forcefully,
    Gracefully,
    GracefullyWithWait
};

using HeaderDict = ::std::map<::std::string, ::std::string>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

class ICE_CLASS(ICE_API) ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionInfo();

    ConnectionInfo() = default;

    ConnectionInfo(const ConnectionInfo&) = default;
    ConnectionInfo(ConnectionInfo&&) = default;
    ConnectionInfo& operator=(const ConnectionInfo&) = default;
    ConnectionInfo& operator=(ConnectionInfo&&) = default;

    ConnectionInfo(const ::std::shared_ptr<::Ice::ConnectionInfo>& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId) :
        underlying(::std::move(iceP_underlying)),
        incoming(iceP_incoming),
        adapterName(::std::move(iceP_adapterName)),
        connectionId(::std::move(iceP_connectionId))
    {
    }

    ::std::shared_ptr<::Ice::ConnectionInfo> underlying;
    bool incoming;
    ::std::string adapterName;
    ::std::string connectionId;
};

using CloseCallback = ::std::function<void(const ::std::shared_ptr<::Ice::Connection>&)>;

using HeartbeatCallback = ::std::function<void(const ::std::shared_ptr<::Ice::Connection>&)>;

class ICE_CLASS(ICE_API) Connection
{
public:

    ICE_MEMBER(ICE_API) virtual ~Connection();

    virtual void close(::Ice::ConnectionClose) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> createProxy(const ::Ice::Identity&) const = 0;

    virtual void setAdapter(const ::std::shared_ptr<::Ice::ObjectAdapter>&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectAdapter> getAdapter() const = 0;

    virtual ::std::shared_ptr<::Ice::Endpoint> getEndpoint() const = 0;

    virtual void flushBatchRequests(::Ice::CompressBatch compress)
    {
        flushBatchRequestsAsync(compress).get();
    }

    virtual ::std::function<void()>
    flushBatchRequestsAsync(::Ice::CompressBatch compress,
                            ::std::function<void(::std::exception_ptr)> exception,
                            ::std::function<void(bool)> sent = nullptr) = 0;

    template<template<typename> class P = ::std::promise>
    auto flushBatchRequestsAsync(::Ice::CompressBatch compress)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        using Promise = P<void>;
        auto promise = ::std::make_shared<Promise>();
        flushBatchRequestsAsync(compress,
                                [promise](::std::exception_ptr ex)
                                {
                                    promise->set_exception(::std::move(ex));
                                },
                                [promise](bool)
                                {
                                    promise->set_value();
                                });
        return promise->get_future();
    }

    virtual void setCloseCallback(::Ice::CloseCallback) = 0;

    virtual void setHeartbeatCallback(::Ice::HeartbeatCallback) = 0;

    virtual void heartbeat()
    {
        heartbeatAsync().get();
    }

    virtual ::std::function<void()>
    heartbeatAsync(::std::function<void(::std::exception_ptr)> exception,
                   ::std::function<void(bool)> sent = nullptr) = 0;

    template<template<typename> class P = ::std::promise>
    auto heartbeatAsync()
        -> decltype(::std::declval<P<void>>().get_future())
    {
        using Promise = P<void>;
        auto promise = ::std::make_shared<Promise>();
        heartbeatAsync([promise](::std::exception_ptr ex)
                       {
                           promise->set_exception(::std::move(ex));
                       },
                       [promise](bool)
                       {
                           promise->set_value();
                       });
        return promise->get_future();
    }

    virtual void setACM(const Ice::optional<int>&, const Ice::optional<::Ice::ACMClose>&, const Ice::optional<::Ice::ACMHeartbeat>&) = 0;

    virtual ::Ice::ACM getACM() = 0;

    virtual ::std::string type() const = 0;

    virtual int timeout() const = 0;

    virtual ::std::string toString() const = 0;

    virtual ::std::shared_ptr<::Ice::ConnectionInfo> getInfo() const = 0;

    virtual void setBufferSize(int, int) = 0;

    virtual void throwException() const = 0;
};

class ICE_CLASS(ICE_API) IPConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~IPConnectionInfo();

    IPConnectionInfo() :
        localAddress(""),
        localPort(-1),
        remoteAddress(""),
        remotePort(-1)
    {
    }

    IPConnectionInfo(const IPConnectionInfo&) = default;
    IPConnectionInfo(IPConnectionInfo&&) = default;
    IPConnectionInfo& operator=(const IPConnectionInfo&) = default;
    IPConnectionInfo& operator=(IPConnectionInfo&&) = default;

    IPConnectionInfo(const ::std::shared_ptr<::Ice::ConnectionInfo>& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, int iceP_localPort, const ::std::string& iceP_remoteAddress, int iceP_remotePort) :
        ::Ice::ConnectionInfo(::std::move(iceP_underlying), iceP_incoming, ::std::move(iceP_adapterName), ::std::move(iceP_connectionId)),
        localAddress(::std::move(iceP_localAddress)),
        localPort(iceP_localPort),
        remoteAddress(::std::move(iceP_remoteAddress)),
        remotePort(iceP_remotePort)
    {
    }

    ::std::string localAddress;
    int localPort = -1;
    ::std::string remoteAddress;
    int remotePort = -1;
};

class ICE_CLASS(ICE_API) TCPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~TCPConnectionInfo();

    TCPConnectionInfo() :
        rcvSize(0),
        sndSize(0)
    {
    }

    TCPConnectionInfo(const TCPConnectionInfo&) = default;
    TCPConnectionInfo(TCPConnectionInfo&&) = default;
    TCPConnectionInfo& operator=(const TCPConnectionInfo&) = default;
    TCPConnectionInfo& operator=(TCPConnectionInfo&&) = default;

    TCPConnectionInfo(const ::std::shared_ptr<::Ice::ConnectionInfo>& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, int iceP_localPort, const ::std::string& iceP_remoteAddress, int iceP_remotePort, int iceP_rcvSize, int iceP_sndSize) :
        ::Ice::IPConnectionInfo(::std::move(iceP_underlying), iceP_incoming, ::std::move(iceP_adapterName), ::std::move(iceP_connectionId), ::std::move(iceP_localAddress), iceP_localPort, ::std::move(iceP_remoteAddress), iceP_remotePort),
        rcvSize(iceP_rcvSize),
        sndSize(iceP_sndSize)
    {
    }

    int rcvSize = 0;
    int sndSize = 0;
};

class ICE_CLASS(ICE_API) UDPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~UDPConnectionInfo();

    UDPConnectionInfo() :
        mcastPort(-1),
        rcvSize(0),
        sndSize(0)
    {
    }

    UDPConnectionInfo(const UDPConnectionInfo&) = default;
    UDPConnectionInfo(UDPConnectionInfo&&) = default;
    UDPConnectionInfo& operator=(const UDPConnectionInfo&) = default;
    UDPConnectionInfo& operator=(UDPConnectionInfo&&) = default;

    UDPConnectionInfo(const ::std::shared_ptr<::Ice::ConnectionInfo>& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, int iceP_localPort, const ::std::string& iceP_remoteAddress, int iceP_remotePort, const ::std::string& iceP_mcastAddress, int iceP_mcastPort, int iceP_rcvSize, int iceP_sndSize) :
        ::Ice::IPConnectionInfo(::std::move(iceP_underlying), iceP_incoming, ::std::move(iceP_adapterName), ::std::move(iceP_connectionId), ::std::move(iceP_localAddress), iceP_localPort, ::std::move(iceP_remoteAddress), iceP_remotePort),
        mcastAddress(::std::move(iceP_mcastAddress)),
        mcastPort(iceP_mcastPort),
        rcvSize(iceP_rcvSize),
        sndSize(iceP_sndSize)
    {
    }

    ::std::string mcastAddress;
    int mcastPort = -1;
    int rcvSize = 0;
    int sndSize = 0;
};

class ICE_CLASS(ICE_API) WSConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~WSConnectionInfo();

    WSConnectionInfo() = default;

    WSConnectionInfo(const WSConnectionInfo&) = default;
    WSConnectionInfo(WSConnectionInfo&&) = default;
    WSConnectionInfo& operator=(const WSConnectionInfo&) = default;
    WSConnectionInfo& operator=(WSConnectionInfo&&) = default;

    WSConnectionInfo(const ::std::shared_ptr<::Ice::ConnectionInfo>& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::Ice::HeaderDict& iceP_headers) :
        ::Ice::ConnectionInfo(::std::move(iceP_underlying), iceP_incoming, ::std::move(iceP_adapterName), ::std::move(iceP_connectionId)),
        headers(::std::move(iceP_headers))
    {
    }

    ::Ice::HeaderDict headers;
};

}

namespace Ice
{

}

namespace Ice
{

using ConnectionInfoPtr = ::std::shared_ptr<ConnectionInfo>;

using ConnectionPtr = ::std::shared_ptr<Connection>;

using IPConnectionInfoPtr = ::std::shared_ptr<IPConnectionInfo>;

using TCPConnectionInfoPtr = ::std::shared_ptr<TCPConnectionInfo>;

using UDPConnectionInfoPtr = ::std::shared_ptr<UDPConnectionInfo>;

using WSConnectionInfoPtr = ::std::shared_ptr<WSConnectionInfo>;

}

#else // C++98 mapping

namespace Ice
{

class ConnectionInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::ConnectionInfo*);
typedef ::IceInternal::Handle< ::Ice::ConnectionInfo> ConnectionInfoPtr;

class Connection;
ICE_API ::Ice::LocalObject* upCast(::Ice::Connection*);
typedef ::IceInternal::Handle< ::Ice::Connection> ConnectionPtr;

class CloseCallback;
ICE_API ::Ice::LocalObject* upCast(::Ice::CloseCallback*);
typedef ::IceInternal::Handle< ::Ice::CloseCallback> CloseCallbackPtr;

class HeartbeatCallback;
ICE_API ::Ice::LocalObject* upCast(::Ice::HeartbeatCallback*);
typedef ::IceInternal::Handle< ::Ice::HeartbeatCallback> HeartbeatCallbackPtr;

class IPConnectionInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::IPConnectionInfo*);
typedef ::IceInternal::Handle< ::Ice::IPConnectionInfo> IPConnectionInfoPtr;

class TCPConnectionInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::TCPConnectionInfo*);
typedef ::IceInternal::Handle< ::Ice::TCPConnectionInfo> TCPConnectionInfoPtr;

class UDPConnectionInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::UDPConnectionInfo*);
typedef ::IceInternal::Handle< ::Ice::UDPConnectionInfo> UDPConnectionInfoPtr;

class WSConnectionInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::WSConnectionInfo*);
typedef ::IceInternal::Handle< ::Ice::WSConnectionInfo> WSConnectionInfoPtr;

}

namespace Ice
{

enum CompressBatch
{
    CompressBatchYes,
    CompressBatchNo,
    CompressBatchBasedOnProxy
};

enum ACMClose
{
    CloseOff,
    CloseOnIdle,
    CloseOnInvocation,
    CloseOnInvocationAndIdle,
    CloseOnIdleForceful
};

enum ACMHeartbeat
{
    HeartbeatOff,
    HeartbeatOnDispatch,
    HeartbeatOnIdle,
    HeartbeatAlways
};

struct ACM
{
    ::Ice::Int timeout;
    ::Ice::ACMClose close;
    ::Ice::ACMHeartbeat heartbeat;

    bool operator==(const ACM& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(timeout != rhs_.timeout)
        {
            return false;
        }
        if(close != rhs_.close)
        {
            return false;
        }
        if(heartbeat != rhs_.heartbeat)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ACM& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(timeout < rhs_.timeout)
        {
            return true;
        }
        else if(rhs_.timeout < timeout)
        {
            return false;
        }
        if(close < rhs_.close)
        {
            return true;
        }
        else if(rhs_.close < close)
        {
            return false;
        }
        if(heartbeat < rhs_.heartbeat)
        {
            return true;
        }
        else if(rhs_.heartbeat < heartbeat)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ACM& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ACM& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ACM& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ACM& rhs_) const
    {
        return !operator<(rhs_);
    }
};

enum ConnectionClose
{
    ConnectionCloseForcefully,
    ConnectionCloseGracefully,
    ConnectionCloseGracefullyWithWait
};

typedef ::std::map< ::std::string, ::std::string> HeaderDict;

}

namespace Ice
{

class Callback_Connection_flushBatchRequests_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Connection_flushBatchRequests_Base> Callback_Connection_flushBatchRequestsPtr;

class Callback_Connection_heartbeat_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Connection_heartbeat_Base> Callback_Connection_heartbeatPtr;

}

namespace Ice
{

class ICE_API ConnectionInfo : public virtual ::Ice::LocalObject
{
public:

    typedef ConnectionInfoPtr PointerType;

    virtual ~ConnectionInfo();

    ConnectionInfo()
    {
    }

    ConnectionInfo(const ::Ice::ConnectionInfoPtr& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId) :
        underlying(iceP_underlying),
        incoming(iceP_incoming),
        adapterName(iceP_adapterName),
        connectionId(iceP_connectionId)
    {
    }

    ::Ice::ConnectionInfoPtr underlying;
    bool incoming;
    ::std::string adapterName;
    ::std::string connectionId;
};

inline bool operator==(const ConnectionInfo& lhs, const ConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ConnectionInfo& lhs, const ConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API CloseCallback : public virtual ::Ice::LocalObject
{
public:

    typedef CloseCallbackPtr PointerType;

    virtual ~CloseCallback();

    virtual void closed(const ::Ice::ConnectionPtr&) = 0;
};

inline bool operator==(const CloseCallback& lhs, const CloseCallback& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const CloseCallback& lhs, const CloseCallback& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API HeartbeatCallback : public virtual ::Ice::LocalObject
{
public:

    typedef HeartbeatCallbackPtr PointerType;

    virtual ~HeartbeatCallback();

    virtual void heartbeat(const ::Ice::ConnectionPtr&) = 0;
};

inline bool operator==(const HeartbeatCallback& lhs, const HeartbeatCallback& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const HeartbeatCallback& lhs, const HeartbeatCallback& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API Connection : public virtual ::Ice::LocalObject
{
public:

    typedef ConnectionPtr PointerType;

    virtual ~Connection();

    virtual void close(::Ice::ConnectionClose) = 0;

    virtual ::Ice::ObjectPrx createProxy(const ::Ice::Identity&) const = 0;

    virtual void setAdapter(const ::Ice::ObjectAdapterPtr&) = 0;

    virtual ::Ice::ObjectAdapterPtr getAdapter() const = 0;

    virtual ::Ice::EndpointPtr getEndpoint() const = 0;

    virtual void flushBatchRequests(::Ice::CompressBatch) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress, const ::Ice::Callback_Connection_flushBatchRequestsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual void end_flushBatchRequests(const ::Ice::AsyncResultPtr&) = 0;

    virtual void setCloseCallback(const ::Ice::CloseCallbackPtr&) = 0;

    virtual void setHeartbeatCallback(const ::Ice::HeartbeatCallbackPtr&) = 0;

    virtual void heartbeat() = 0;

    virtual ::Ice::AsyncResultPtr begin_heartbeat() = 0;

    virtual ::Ice::AsyncResultPtr begin_heartbeat(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual ::Ice::AsyncResultPtr begin_heartbeat(const ::Ice::Callback_Connection_heartbeatPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual void end_heartbeat(const ::Ice::AsyncResultPtr&) = 0;

    virtual void setACM(const IceUtil::Optional< ::Ice::Int>&, const IceUtil::Optional< ::Ice::ACMClose>&, const IceUtil::Optional< ::Ice::ACMHeartbeat>&) = 0;

    virtual ::Ice::ACM getACM() = 0;

    virtual ::std::string type() const = 0;

    virtual ::Ice::Int timeout() const = 0;

    virtual ::std::string toString() const = 0;

    virtual ::Ice::ConnectionInfoPtr getInfo() const = 0;

    virtual void setBufferSize(::Ice::Int, ::Ice::Int) = 0;

    virtual void throwException() const = 0;
};

inline bool operator==(const Connection& lhs, const Connection& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Connection& lhs, const Connection& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API IPConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    typedef IPConnectionInfoPtr PointerType;

    virtual ~IPConnectionInfo();

    IPConnectionInfo() :
        localAddress(""),
        localPort(-1),
        remoteAddress(""),
        remotePort(-1)
    {
    }

    IPConnectionInfo(const ::Ice::ConnectionInfoPtr& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, ::Ice::Int iceP_localPort, const ::std::string& iceP_remoteAddress, ::Ice::Int iceP_remotePort) :
        ::Ice::ConnectionInfo(iceP_underlying, iceP_incoming, iceP_adapterName, iceP_connectionId),
        localAddress(iceP_localAddress),
        localPort(iceP_localPort),
        remoteAddress(iceP_remoteAddress),
        remotePort(iceP_remotePort)
    {
    }

    ::std::string localAddress;
    ::Ice::Int localPort;
    ::std::string remoteAddress;
    ::Ice::Int remotePort;
};

inline bool operator==(const IPConnectionInfo& lhs, const IPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const IPConnectionInfo& lhs, const IPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API TCPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    typedef TCPConnectionInfoPtr PointerType;

    virtual ~TCPConnectionInfo();

    TCPConnectionInfo() :
        rcvSize(0),
        sndSize(0)
    {
    }

    TCPConnectionInfo(const ::Ice::ConnectionInfoPtr& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, ::Ice::Int iceP_localPort, const ::std::string& iceP_remoteAddress, ::Ice::Int iceP_remotePort, ::Ice::Int iceP_rcvSize, ::Ice::Int iceP_sndSize) :
        ::Ice::IPConnectionInfo(iceP_underlying, iceP_incoming, iceP_adapterName, iceP_connectionId, iceP_localAddress, iceP_localPort, iceP_remoteAddress, iceP_remotePort),
        rcvSize(iceP_rcvSize),
        sndSize(iceP_sndSize)
    {
    }

    ::Ice::Int rcvSize;
    ::Ice::Int sndSize;
};

inline bool operator==(const TCPConnectionInfo& lhs, const TCPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const TCPConnectionInfo& lhs, const TCPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API UDPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    typedef UDPConnectionInfoPtr PointerType;

    virtual ~UDPConnectionInfo();

    UDPConnectionInfo() :
        mcastPort(-1),
        rcvSize(0),
        sndSize(0)
    {
    }

    UDPConnectionInfo(const ::Ice::ConnectionInfoPtr& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::std::string& iceP_localAddress, ::Ice::Int iceP_localPort, const ::std::string& iceP_remoteAddress, ::Ice::Int iceP_remotePort, const ::std::string& iceP_mcastAddress, ::Ice::Int iceP_mcastPort, ::Ice::Int iceP_rcvSize, ::Ice::Int iceP_sndSize) :
        ::Ice::IPConnectionInfo(iceP_underlying, iceP_incoming, iceP_adapterName, iceP_connectionId, iceP_localAddress, iceP_localPort, iceP_remoteAddress, iceP_remotePort),
        mcastAddress(iceP_mcastAddress),
        mcastPort(iceP_mcastPort),
        rcvSize(iceP_rcvSize),
        sndSize(iceP_sndSize)
    {
    }

    ::std::string mcastAddress;
    ::Ice::Int mcastPort;
    ::Ice::Int rcvSize;
    ::Ice::Int sndSize;
};

inline bool operator==(const UDPConnectionInfo& lhs, const UDPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const UDPConnectionInfo& lhs, const UDPConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API WSConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    typedef WSConnectionInfoPtr PointerType;

    virtual ~WSConnectionInfo();

    WSConnectionInfo()
    {
    }

    WSConnectionInfo(const ::Ice::ConnectionInfoPtr& iceP_underlying, bool iceP_incoming, const ::std::string& iceP_adapterName, const ::std::string& iceP_connectionId, const ::Ice::HeaderDict& iceP_headers) :
        ::Ice::ConnectionInfo(iceP_underlying, iceP_incoming, iceP_adapterName, iceP_connectionId),
        headers(iceP_headers)
    {
    }

    ::Ice::HeaderDict headers;
};

inline bool operator==(const WSConnectionInfo& lhs, const WSConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const WSConnectionInfo& lhs, const WSConnectionInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
