/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Units {
    private static final I18n i18n = I18nFactory.getI18n(Units.class);
    private static final String[] DISTANCE_DISPLAY_NAMES = new String[]{i18n.tr("Kilometers"), i18n.tr("Miles")};
    private static final String[] DISTANCE_ABBREVIATIONS = new String[]{i18n.tr("km"), i18n.tr("mi")};
    private static final String[] ALTITUDE_DISPLAY_NAMES = new String[]{i18n.tr("Meters"), i18n.tr("Feet")};
    private static final String[] ALTITUDE_ABBREVIATIONS = new String[]{i18n.tr("m"), i18n.tr("ft")};
    private static final double MILE = 1.609344;
    private static final double FOOT = 0.3048;

    private Units() {
    }

    private static double toKilometres(double distance, DISTANCE unit) {
        switch (unit) {
            case KILOMETRES: {
                return distance;
            }
            case MILES: {
                return distance * 1.609344;
            }
        }
        return distance;
    }

    private static double fromKilometres(double kilometres, DISTANCE unit) {
        switch (unit) {
            case KILOMETRES: {
                return kilometres;
            }
            case MILES: {
                return kilometres / 1.609344;
            }
        }
        return kilometres;
    }

    private static double toMetres(double altitude, ALTITUDE unit) {
        switch (unit) {
            case METRES: {
                return altitude;
            }
            case FEET: {
                return altitude * 0.3048;
            }
        }
        return altitude;
    }

    private static double fromMetres(double metres, ALTITUDE unit) {
        switch (unit) {
            case METRES: {
                return metres;
            }
            case FEET: {
                return metres / 0.3048;
            }
        }
        return metres;
    }

    public static double convert(double distance, DISTANCE from, DISTANCE to) {
        double kilometres = Units.toKilometres(distance, from);
        return Units.fromKilometres(kilometres, to);
    }

    public static double convert(double altitude, ALTITUDE from, ALTITUDE to) {
        double metres = Units.toMetres(altitude, from);
        return Units.fromMetres(metres, to);
    }

    public static String getDisplayName(DISTANCE unit) {
        return DISTANCE_DISPLAY_NAMES[unit.ordinal()];
    }

    public static String getDisplayName(ALTITUDE unit) {
        return ALTITUDE_DISPLAY_NAMES[unit.ordinal()];
    }

    public static String[] getDistanceUnitNames() {
        return DISTANCE_DISPLAY_NAMES;
    }

    public static String[] getAltitudeUnitNames() {
        return ALTITUDE_DISPLAY_NAMES;
    }

    public static String getAbbreviation(DISTANCE unit) {
        return DISTANCE_ABBREVIATIONS[unit.ordinal()];
    }

    public static String getAbbreviation(ALTITUDE unit) {
        return ALTITUDE_ABBREVIATIONS[unit.ordinal()];
    }

    public static enum ALTITUDE {
        METRES,
        FEET;

    }

    public static enum DISTANCE {
        KILOMETRES,
        MILES;

    }
}

