/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.gephi.graph.api.Graph;
import org.gephi.layout.plugin.openord.Control;
import org.gephi.layout.plugin.openord.DensityGrid;
import org.gephi.layout.plugin.openord.Node;
import org.gephi.layout.plugin.openord.OpenOrdLayout;
import org.gephi.layout.plugin.openord.OpenOrdLayoutData;
import org.gephi.layout.plugin.openord.Worker;
import org.openide.util.Exceptions;

public class Combine
implements Runnable {
    private final OpenOrdLayout layout;
    private final Object lock = new Object();
    private final Control control;

    public Combine(OpenOrdLayout layout) {
        this.layout = layout;
        this.control = layout.getControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        float totEnergy;
        int i;
        Worker[] workers = this.layout.getWorkers();
        Node[] positions = null;
        for (Worker worker : workers) {
            if (positions == null) {
                positions = worker.getPositions();
                continue;
            }
            Node[] workerPositions = worker.getPositions();
            for (i = worker.getId(); i < positions.length; i += workers.length) {
                positions[i] = workerPositions[i];
            }
        }
        if (!this.control.isRealFixed()) {
            for (Worker object : positions) {
                ((Node)((Object)object)).fixed = false;
            }
        }
        for (Worker worker : workers) {
            DensityGrid densityGrid = worker.getDensityGrid();
            boolean fineDensity = worker.isFineDensity();
            boolean firstAdd = worker.isFirstAdd();
            boolean fineFirstAdd = worker.isFineFirstAdd();
            Node[] wNodes = worker.getPositions();
            for (Worker z : workers) {
                if (worker == z) continue;
                Node[] zNodes = worker.getPositions();
                for (int i2 = z.getId(); i2 < wNodes.length; i2 += workers.length) {
                    densityGrid.substract(wNodes[i2], firstAdd, fineFirstAdd, fineDensity);
                    densityGrid.add(zNodes[i2], fineDensity);
                }
            }
        }
        if (workers.length > 1) {
            for (Worker worker : workers) {
                Node[] positionsCopy = new Node[positions.length];
                for (i = 0; i < positions.length; ++i) {
                    positionsCopy[i] = positions[i].clone();
                }
                worker.setPositions(positionsCopy);
            }
        }
        boolean done = !this.control.udpateStage(totEnergy = this.getTotEnergy());
        for (Worker w : this.layout.getWorkers()) {
            this.control.initWorker(w);
        }
        Graph graph = this.layout.getGraph();
        for (org.gephi.graph.api.Node n : graph.getNodes()) {
            if (n.getLayoutData() == null || !(n.getLayoutData() instanceof OpenOrdLayoutData)) continue;
            OpenOrdLayoutData layoutData = (OpenOrdLayoutData)n.getLayoutData();
            Node node = positions[layoutData.nodeId];
            n.setX(node.x * 10.0f);
            n.setY(node.y * 10.0f);
        }
        if (!this.layout.canAlgo() || done) {
            for (Worker w : this.layout.getWorkers()) {
                w.setDone(true);
            }
            this.layout.setRunning(false);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    private void printPositions(Node[] nodes) {
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        for (Node node : nodes) {
            String xStr = formatter.format(node.x);
            String string = formatter.format(node.y);
        }
    }

    public float getTotEnergy() {
        float totEnergy = 0.0f;
        for (Worker w : this.layout.getWorkers()) {
            totEnergy += w.getTotEnergy();
        }
        return totEnergy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIteration() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

