/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureUsage {
    private final String message;
    private final List<StackTraceElement> stack;
    private final Class<?> calledFrom;

    public FeatureUsage(String message, Class<?> calledFrom) {
        this.message = message;
        this.calledFrom = calledFrom;
        this.stack = Collections.emptyList();
    }

    FeatureUsage(FeatureUsage usage, List<StackTraceElement> stack) {
        if (stack == null) {
            throw new NullPointerException("stack");
        }
        this.message = usage.message;
        this.calledFrom = usage.calledFrom;
        this.stack = Collections.unmodifiableList(new ArrayList<StackTraceElement>(stack));
    }

    public String getMessage() {
        return this.message;
    }

    public List<StackTraceElement> getStack() {
        return this.stack;
    }

    public FeatureUsage withStackTrace() {
        int caller;
        if (!this.stack.isEmpty()) {
            return this;
        }
        StackTraceElement[] originalStack = new Exception().getStackTrace();
        String calledFromName = this.calledFrom.getName();
        boolean calledFromFound = false;
        for (caller = 0; caller < originalStack.length; ++caller) {
            StackTraceElement current = originalStack[caller];
            if (!calledFromFound) {
                if (!current.getClassName().startsWith(calledFromName)) continue;
                calledFromFound = true;
                continue;
            }
            if (!current.getClassName().startsWith(calledFromName)) break;
        }
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (caller = FeatureUsage.skipSystemStackElements(originalStack, caller); caller < originalStack.length; ++caller) {
            result.add(originalStack[caller]);
        }
        return new FeatureUsage(this, result);
    }

    private static int skipSystemStackElements(StackTraceElement[] stackTrace, int caller) {
        String currentClassName;
        while (caller < stackTrace.length && ((currentClassName = stackTrace[caller].getClassName()).startsWith("org.codehaus.groovy.") || currentClassName.startsWith("org.gradle.internal.metaobject.") || currentClassName.startsWith("groovy.") || currentClassName.startsWith("java.") || currentClassName.startsWith("jdk.internal."))) {
            ++caller;
        }
        return caller;
    }
}

