/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import javax.annotation.Nullable;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPhasedActionResultListener
implements PhasedActionResultListener {
    @Nullable
    private final IntermediateResultHandler<?> projectsLoadedHandler;
    @Nullable
    private final IntermediateResultHandler<?> buildFinishedHandler;

    public DefaultPhasedActionResultListener(@Nullable IntermediateResultHandler<?> projectsLoadedHandler, @Nullable IntermediateResultHandler<?> buildFinishedHandler) {
        this.projectsLoadedHandler = projectsLoadedHandler;
        this.buildFinishedHandler = buildFinishedHandler;
    }

    @Override
    public void onResult(PhasedActionResult<?> result) {
        Object model = result.getResult();
        PhasedActionResult.Phase type = result.getPhase();
        if (type == PhasedActionResult.Phase.PROJECTS_LOADED) {
            this.onComplete(model, this.projectsLoadedHandler);
        } else if (type == PhasedActionResult.Phase.BUILD_FINISHED) {
            this.onComplete(model, this.buildFinishedHandler);
        }
    }

    private <T> void onComplete(Object result, @Nullable IntermediateResultHandler<T> handler) {
        if (handler != null) {
            handler.onComplete(result);
        }
    }
}

