/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractBuildController;
import org.gradle.tooling.internal.consumer.connection.BuildControllerAdapter;
import org.gradle.tooling.internal.consumer.connection.BuildControllerWithoutParameterSupport;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterController;
import org.gradle.tooling.internal.consumer.connection.InternalBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.converters.ConsumerTargetTypeProvider;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.gradle.BuildInvocations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalBuildActionAdapter<T>
implements InternalBuildAction<T>,
InternalBuildActionVersion2<T> {
    private final BuildAction<T> action;
    private final File rootDir;
    private final VersionDetails versionDetails;

    public InternalBuildActionAdapter(BuildAction<T> action, File rootDir, VersionDetails versionDetails) {
        this.action = action;
        this.rootDir = rootDir;
        this.versionDetails = versionDetails;
    }

    @Override
    public T execute(final InternalBuildController buildController) {
        ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter(new ConsumerTargetTypeProvider());
        AbstractBuildController buildControllerAdapter = new BuildControllerAdapter(protocolToModelAdapter, new InternalBuildControllerAdapter(){

            @Override
            public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier, Object parameter) {
                return buildController.getModel(target, modelIdentifier);
            }
        }, new ModelMapping(), this.rootDir);
        buildControllerAdapter = new BuildControllerWithoutParameterSupport(this.versionDetails, buildControllerAdapter);
        if (!this.versionDetails.maySupportModel(BuildInvocations.class)) {
            buildControllerAdapter = new BuildInvocationsAdapterController(protocolToModelAdapter, buildControllerAdapter);
        }
        return this.action.execute(buildControllerAdapter);
    }

    @Override
    public T execute(final InternalBuildControllerVersion2 buildController) {
        ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter(new ConsumerTargetTypeProvider());
        BuildControllerAdapter buildControllerAdapter = new BuildControllerAdapter(protocolToModelAdapter, new InternalBuildControllerAdapter(){

            @Override
            public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier, Object parameter) {
                return buildController.getModel(target, modelIdentifier, parameter);
            }
        }, new ModelMapping(), this.rootDir);
        return this.action.execute(buildControllerAdapter);
    }
}

