/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.tree;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return false;
        }
    };
    public static final TokenSet ANY = new TokenSet(Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return true;
        }
    };
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
    }

    private boolean get(int index2) {
        int wordIndex = (index2 >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index2) != 0L;
    }

    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i);
    }

    @NotNull
    public IElementType[] getTypes() {
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list2 = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type2;
                    if (!this.get(i) || (type2 = IElementType.find(i)) == null) continue;
                    list2.add(type2);
                }
                types = list2.toArray(new IElementType[list2.size()]);
            }
            this.myTypes = types;
        }
        if (types == null) {
            TokenSet.$$$reportNull$$$0(0);
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types == null) {
            TokenSet.$$$reportNull$$$0(1);
        }
        if (types.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(2);
            }
            return tokenSet;
        }
        if (types.length == 1 && types[0] == TokenType.WHITE_SPACE) {
            TokenSet tokenSet = WHITE_SPACE;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(3);
            }
            return tokenSet;
        }
        TokenSet tokenSet = TokenSet.doCreate(types);
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types) {
        if (types == null) {
            TokenSet.$$$reportNull$$$0(5);
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type2 : types) {
            if (type2 == null) continue;
            short index2 = type2.getIndex();
            assert (index2 >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type2);
            if (min > index2) {
                min = index2;
            }
            if (max >= index2) continue;
            max = index2;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max);
        for (IElementType type3 : types) {
            int wordIndex;
            if (type3 == null) continue;
            short index3 = type3.getIndex();
            int n = wordIndex = (index3 >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index3;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(6);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            TokenSet.$$$reportNull$$$0(7);
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(8);
            }
            return tokenSet;
        }
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max >= sets[i].myMax) continue;
            max = sets[i].myMax;
        }
        TokenSet newSet = new TokenSet(shift, max);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(9);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(10);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(11);
        }
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(12);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(13);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(14);
        }
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(15);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/tree/TokenSet";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/tree/TokenSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "orSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "andSet";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "orSet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "andSet";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "andNot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

