/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectInternal dependencyProject;
    private final boolean buildProjectDependencies;
    private final ProjectAccessListener projectAccessListener;

    public DefaultProjectDependency(ProjectInternal dependencyProject, ProjectAccessListener projectAccessListener, boolean buildProjectDependencies) {
        this(dependencyProject, null, projectAccessListener, buildProjectDependencies);
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, String configuration, ProjectAccessListener projectAccessListener, boolean buildProjectDependencies) {
        super(configuration);
        this.dependencyProject = dependencyProject;
        this.projectAccessListener = projectAccessListener;
        this.buildProjectDependencies = buildProjectDependencies;
    }

    public Project getDependencyProject() {
        return this.dependencyProject;
    }

    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    public String getName() {
        return this.dependencyProject.getName();
    }

    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    @Override
    public Configuration findProjectConfiguration() {
        String declaredConfiguration;
        ConfigurationContainer dependencyConfigurations = this.getDependencyProject().getConfigurations();
        Configuration selectedConfiguration = dependencyConfigurations.getByName((String)GUtil.elvis((Object)(declaredConfiguration = this.getTargetConfiguration()), (Object)"default"));
        if (!selectedConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(this.dependencyProject.getDisplayName(), selectedConfiguration.getName());
        }
        return selectedConfiguration;
    }

    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.dependencyProject, this.getTargetConfiguration(), this.projectAccessListener, this.buildProjectDependencies);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    public Set<File> resolve() {
        return this.resolve(true);
    }

    public Set<File> resolve(boolean transitive) {
        CachingDependencyResolveContext context = new CachingDependencyResolveContext(transitive, Collections.<String, String>emptyMap());
        context.add(this);
        return context.resolve().getFiles();
    }

    @Override
    public void beforeResolved() {
        this.projectAccessListener.beforeResolvingProjectDependency(this.dependencyProject);
    }

    @Override
    public void resolve(DependencyResolveContext context) {
        boolean transitive;
        boolean bl = transitive = this.isTransitive() && context.isTransitive();
        if (transitive) {
            Configuration projectConfiguration = this.findProjectConfiguration();
            for (Dependency dependency : projectConfiguration.getAllDependencies()) {
                context.add(dependency);
            }
            for (DependencyConstraint dependencyConstraint : projectConfiguration.getAllDependencyConstraints()) {
                context.add(dependencyConstraint);
            }
        }
    }

    public TaskDependencyInternal getBuildDependencies() {
        return new TaskDependencyImpl();
    }

    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ProjectDependency that = (ProjectDependency)dependency;
        if (!this.isCommonContentEquals((ModuleDependency)that)) {
            return false;
        }
        return this.dependencyProject.equals(that.getDependencyProject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)o;
        if (!this.getDependencyProject().equals(that.getDependencyProject())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(that.getTargetConfiguration()) : that.getTargetConfiguration() != null) {
            return false;
        }
        return this.buildProjectDependencies == that.buildProjectDependencies;
    }

    @Override
    public int hashCode() {
        return this.getDependencyProject().hashCode() ^ (this.getTargetConfiguration() != null ? this.getTargetConfiguration().hashCode() : 31) ^ (this.buildProjectDependencies ? 1 : 0);
    }

    public String toString() {
        return "DefaultProjectDependency{dependencyProject='" + this.dependencyProject + '\'' + ", configuration='" + (this.getTargetConfiguration() == null ? "default" : this.getTargetConfiguration()) + '\'' + '}';
    }

    private class TaskDependencyImpl
    extends AbstractTaskDependency {
        private TaskDependencyImpl() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            if (!DefaultProjectDependency.this.buildProjectDependencies) {
                return;
            }
            DefaultProjectDependency.this.projectAccessListener.beforeResolvingProjectDependency(DefaultProjectDependency.this.dependencyProject);
            Configuration configuration = DefaultProjectDependency.this.findProjectConfiguration();
            context.add(configuration);
            context.add(configuration.getAllArtifacts());
        }
    }
}

