/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;

class SummaryTaskStateChanges
implements TaskStateChanges {
    private final List<TaskStateChanges> sources;

    public SummaryTaskStateChanges(TaskStateChanges ... sources) {
        this.sources = Arrays.asList(sources);
    }

    public boolean accept(TaskStateChangeVisitor visitor) {
        ChangeDetectingVisitor changeDetectingVisitor = new ChangeDetectingVisitor(visitor);
        for (TaskStateChanges source : this.sources) {
            if (!source.accept(changeDetectingVisitor)) {
                return false;
            }
            if (!changeDetectingVisitor.isChangesDetected()) continue;
            return true;
        }
        return true;
    }

    private static class ChangeDetectingVisitor
    implements TaskStateChangeVisitor {
        private final TaskStateChangeVisitor delegate;
        private boolean changesDetected;

        public ChangeDetectingVisitor(TaskStateChangeVisitor delegate) {
            this.delegate = delegate;
        }

        public boolean visitChange(TaskStateChange change) {
            this.changesDetected = true;
            return this.delegate.visitChange(change);
        }

        public boolean isChangesDetected() {
            return this.changesDetected;
        }
    }
}

