/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.EOFException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntSetSerializer
implements Serializer<IntSet> {
    public static final IntSetSerializer INSTANCE = new IntSetSerializer();

    private IntSetSerializer() {
    }

    @Override
    public IntSet read(Decoder decoder) throws EOFException, Exception {
        int size = decoder.readInt();
        IntOpenHashSet result = new IntOpenHashSet(size);
        for (int i = 0; i < size; ++i) {
            result.add(decoder.readInt());
        }
        return result;
    }

    @Override
    public void write(Encoder encoder, IntSet value) throws Exception {
        encoder.writeInt(value.size());
        IntIterator iterator = value.iterator();
        while (iterator.hasNext()) {
            encoder.writeInt(iterator.nextInt());
        }
    }
}

