/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class ProgressionIteratorBasicValue
extends StrictBasicValue {
    private static final ImmutableMap<String, Type> VALUES_TYPENAME_TO_TYPE;
    private static final ImmutableMap<PrimitiveType, ProgressionIteratorBasicValue> ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE;
    private final Type valuesPrimitiveType;
    private final String valuesPrimitiveTypeName;

    @NotNull
    private static Type getValuesType(@NotNull String valuesTypeName) {
        Type type2 = VALUES_TYPENAME_TO_TYPE.get(valuesTypeName);
        assert (type2 != null) : "Unexpected type " + valuesTypeName;
        return type2;
    }

    private ProgressionIteratorBasicValue(@NotNull String valuesPrimitiveTypeName) {
        super(IteratorNext.Companion.getPrimitiveIteratorType(Name.identifier(valuesPrimitiveTypeName)));
        this.valuesPrimitiveType = ProgressionIteratorBasicValue.getValuesType(valuesPrimitiveTypeName);
        this.valuesPrimitiveTypeName = valuesPrimitiveTypeName;
    }

    @Nullable
    public static ProgressionIteratorBasicValue byProgressionClassType(@NotNull Type progressionClassType) {
        FqName classFqName = new FqName(progressionClassType.getClassName());
        PrimitiveType elementType = RangeCodegenUtilKt.getPrimitiveRangeOrProgressionElementType(classFqName);
        return ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE.get((Object)elementType);
    }

    @NotNull
    public Type getValuesPrimitiveType() {
        return this.valuesPrimitiveType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgressionIteratorBasicValue value = (ProgressionIteratorBasicValue)o;
        return this.valuesPrimitiveType.equals(value.valuesPrimitiveType);
    }

    @NotNull
    public String getNextMethodName() {
        return "next" + this.valuesPrimitiveTypeName;
    }

    @NotNull
    public String getNextMethodDesc() {
        return "()" + this.getValuesPrimitiveType().getDescriptor();
    }

    static {
        ImmutableMap.Builder<Object, Object> builder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtilKt.getSupportedRangeTypes()) {
            builder.put(primitiveType.getTypeName().asString(), Type.getType(JvmPrimitiveType.get(primitiveType).getDesc()));
        }
        VALUES_TYPENAME_TO_TYPE = builder.build();
        builder = ImmutableMap.builder();
        for (PrimitiveType elementType : RangeCodegenUtilKt.getSupportedRangeTypes()) {
            builder.put((Object)elementType, new ProgressionIteratorBasicValue(elementType.getTypeName().asString()));
        }
        ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE = builder.build();
    }
}

