/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class ReferenceAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JsExpression reference;

    @NotNull
    static ReferenceAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression2);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression2.getText();
        return new ReferenceAccessTranslator(referenceDescriptor, context);
    }

    private ReferenceAccessTranslator(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        super(context);
        this.reference = ReferenceTranslator.translateAsValueReference(descriptor2, this.context());
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.reference;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        return JsAstUtils.assignment(this.reference, toSetTo);
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        return this;
    }
}

