/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import sbt.BuildPaths$;
import sbt.BuildRef;
import sbt.Def$;
import sbt.Keys$;
import sbt.ProjectDefinition;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.ResolvedReference;
import sbt.Scope;
import sbt.Scope$;
import sbt.ScopeAxis;
import sbt.Select;
import sbt.State;
import sbt.State$;
import sbt.This$;
import sbt.Zero$;
import sbt.internal.LoadedBuildUnit;
import sbt.internal.LogManager$;
import sbt.internal.util.AttributeEntry;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeMap;
import sbt.internal.util.Init;
import sbt.internal.util.Settings;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.std.Streams;
import sbt.std.Streams$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.sys.package$;
import sjsonnew.IsoString;
import sjsonnew.IsoString$;
import sjsonnew.SupportConverter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;

public final class BuildStreams$ {
    public static BuildStreams$ MODULE$;

    static {
        new BuildStreams$();
    }

    public final String GlobalPath() {
        return "$global";
    }

    public final String BuildUnitPath() {
        return "$build";
    }

    public final String StreamsDirectory() {
        return "streams";
    }

    public Function1<State, Streams<Init.ScopedKey<?>>> mkStreams(Map<URI, LoadedBuildUnit> units, URI root, Settings<Scope> data) {
        return (Function1 & Serializable & scala.Serializable)s2 -> {
            IsoString isoString = IsoString$.MODULE$.iso((Function1 & Serializable & scala.Serializable)x -> CompactPrinter$.MODULE$.apply(x), (Function1 & Serializable & scala.Serializable)s -> (JValue)Parser$.MODULE$.parseUnsafe(s));
            return (Streams)State$.MODULE$.stateOps(s2).get(Keys$.MODULE$.stateStreams()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Streams$.MODULE$.apply((Function1 & Serializable & scala.Serializable)scoped -> MODULE$.path(units, root, data, (Init.ScopedKey<?>)scoped), (Function1 & Serializable & scala.Serializable)scoped -> Def$.MODULE$.displayFull(scoped), LogManager$.MODULE$.construct(data, (State)s2), (SupportConverter)Converter$.MODULE$, isoString));
        };
    }

    public File path(Map<URI, LoadedBuildUnit> units, URI root, Settings<Scope> data, Init.ScopedKey<?> scoped) {
        return this.resolvePath(this.projectPath(units, root, scoped, data), this.nonProjectPath(scoped));
    }

    public File resolvePath(File base, Seq<String> components) {
        File file = base;
        return (File)components.$div$colon((Object)file, (Function2 & Serializable & scala.Serializable)(b, p) -> new File((File)b, (String)p));
    }

    public <T> String pathComponent(ScopeAxis<T> axis, Init.ScopedKey<?> scoped, String label, Function1<T, String> show) {
        String string;
        ScopeAxis<T> scopeAxis = axis;
        if (Zero$.MODULE$.equals(scopeAxis)) {
            string = "$global";
        } else {
            if (This$.MODULE$.equals(scopeAxis)) {
                throw package$.MODULE$.error("Unresolved This reference for " + label + " in " + Def$.MODULE$.displayFull(scoped));
            }
            if (scopeAxis instanceof Select) {
                Select select = (Select)scopeAxis;
                Object t = select.s();
                string = (String)show.apply(t);
            } else {
                throw new MatchError(scopeAxis);
            }
        }
        return string;
    }

    public <T> Seq<String> nonProjectPath(Init.ScopedKey<T> scoped) {
        Scope scope = (Scope)scoped.scope();
        String string = this.pathComponent(scope.config(), scoped, "config", (Function1 & Serializable & scala.Serializable)x$14 -> x$14.name());
        String string2 = this.pathComponent(scope.task(), scoped, "task", (Function1 & Serializable & scala.Serializable)x$15 -> x$15.label());
        String string3 = this.pathComponent(scope.extra(), scoped, "extra", (Function1 & Serializable & scala.Serializable)a -> MODULE$.showAMap((AttributeMap)a));
        String string4 = scoped.key().label();
        return Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
    }

    public String showAMap(AttributeMap a) {
        return ((TraversableOnce)((TraversableLike)a.entries().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$20 -> x$20.key().label(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            AttributeEntry attributeEntry = x0$3;
            if (attributeEntry == null) {
                throw new MatchError((Object)attributeEntry);
            }
            AttributeKey key = attributeEntry.key();
            Object value = attributeEntry.value();
            String string = key.label() + "=" + value.toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File projectPath(Map<URI, LoadedBuildUnit> units, URI root, Init.ScopedKey<?> scoped, Settings<Scope> data) {
        Reference pr;
        boolean bl = false;
        Select select = null;
        ScopeAxis scopeAxis = ((Scope)scoped.scope()).project();
        if (Zero$.MODULE$.equals(scopeAxis)) {
            return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.refTarget(Scope$.MODULE$.GlobalScope(), ((LoadedBuildUnit)units.apply((Object)root)).localBase(), data)), "$global");
        }
        if (scopeAxis instanceof Select) {
            bl = true;
            select = (Select)scopeAxis;
            Reference br = (Reference)select.s();
            if (br instanceof BuildRef) {
                BuildRef buildRef = (BuildRef)br;
                URI uri = buildRef.build();
                return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.refTarget((ResolvedReference)buildRef, ((LoadedBuildUnit)units.apply((Object)uri)).localBase(), data)), "$build");
            }
        }
        if (bl && (pr = (Reference)select.s()) instanceof ProjectRef) {
            ProjectRef projectRef = (ProjectRef)pr;
            URI uri = projectRef.build();
            String id = projectRef.project();
            return this.refTarget((ResolvedReference)projectRef, ((ProjectDefinition)((LoadedBuildUnit)units.apply((Object)uri)).defined().apply((Object)id)).base(), data);
        }
        if (bl) {
            Reference pr2 = (Reference)select.s();
            throw package$.MODULE$.error("Unresolved project reference (" + pr2 + ") in " + Def$.MODULE$.displayFull(scoped));
        }
        if (!This$.MODULE$.equals(scopeAxis)) throw new MatchError((Object)scopeAxis);
        throw package$.MODULE$.error("Unresolved project reference (This) in " + Def$.MODULE$.displayFull(scoped));
    }

    public File refTarget(ResolvedReference ref, File fallbackBase, Settings<Scope> data) {
        return this.refTarget(Scope$.MODULE$.GlobalScope().copy((ScopeAxis)new Select((Object)ref), Scope$.MODULE$.GlobalScope().copy$default$2(), Scope$.MODULE$.GlobalScope().copy$default$3(), Scope$.MODULE$.GlobalScope().copy$default$4()), fallbackBase, data);
    }

    public File refTarget(Scope scope, File fallbackBase, Settings<Scope> data) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile((File)Keys$.MODULE$.target().in(scope).get(data).getOrElse((Function0 & Serializable & scala.Serializable)() -> syntax$.MODULE$.fileToRichFile(BuildPaths$.MODULE$.outputDirectory(fallbackBase)))), "streams");
    }

    private BuildStreams$() {
        MODULE$ = this;
    }
}

