/*
 * Decompiled with CFR 0.152.
 */
package scalacache.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalacache.serialization.Codec;
import scalacache.serialization.CompressingCodec$;
import scalacache.serialization.CompressingCodec$Headers$;

@ScalaSignature(bytes="\u0006\u000153q!\u0001\u0002\u0011\u0002\u0007\u0005qAA\nH5&\u0004\b/\u001b8h\u0005&t\u0017M]=D_\u0012,7M\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u000bg\u000e\fG.Y2bG\",7\u0001A\u000b\u0003\u0011U\u00192\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0019\u0001#E\n\u000e\u0003\tI!A\u0005\u0002\u0003\u000b\r{G-Z2\u0011\u0005Q)B\u0002\u0001\u0003\u0006-\u0001\u0011\ra\u0006\u0002\u0002\u0003F\u0011\u0001d\u0007\t\u0003\u0015eI!AG\u0006\u0003\u000f9{G\u000f[5oOB\u0011!\u0002H\u0005\u0003;-\u00111!\u00118z\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019!\u0013N\\5uIQ\t\u0011\u0005\u0005\u0002\u000bE%\u00111e\u0003\u0002\u0005+:LG\u000fC\u0003&\u0001\u0011Ea%A\u0007tSj,G\u000b\u001b:fg\"|G\u000eZ\u000b\u0002OA\u0011!\u0002K\u0005\u0003S-\u00111!\u00138u\u0011\u0019Y\u0003\u0001%C\u0001Y\u00051QM\\2pI\u0016$\"!L\u001a\u0011\u0007)q\u0003'\u0003\u00020\u0017\t)\u0011I\u001d:bsB\u0011!\"M\u0005\u0003e-\u0011AAQ=uK\")AG\u000ba\u0001'\u0005)a/\u00197vK\"1a\u0007\u0001I\u0005\u0002]\na\u0001Z3d_\u0012,GCA\n9\u0011\u0015IT\u00071\u0001.\u0003\u0011!\u0017\r^1\t\u000bm\u0002A\u0011\u0002\u001f\u0002\u0011\r|W\u000e\u001d:fgN$\"!L\u001f\t\u000beR\u0004\u0019A\u0017\t\u000b}\u0002A\u0011\u0002!\u0002\u0015\u0011,7m\\7qe\u0016\u001c8\u000f\u0006\u0002.\u0003\")\u0011H\u0010a\u0001[!Y1\t\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002#G\u00031\u0019X\u000f]3sI\u0015t7m\u001c3f)\tiS\tC\u00035\u0005\u0002\u00071#\u0003\u0002,#!Y\u0001\n\u0001I\u0001\u0004\u0003\u0005I\u0011B%M\u00031\u0019X\u000f]3sI\u0011,7m\u001c3f)\t\u0019\"\nC\u0003L\u000f\u0002\u0007Q&A\u0003csR,7/\u0003\u00027#\u0001")
public interface GZippingBinaryCodec<A>
extends Codec<A> {
    public /* synthetic */ byte[] scalacache$serialization$GZippingBinaryCodec$$super$encode(Object var1);

    public /* synthetic */ Object scalacache$serialization$GZippingBinaryCodec$$super$decode(byte[] var1);

    public static /* synthetic */ int sizeThreshold$(GZippingBinaryCodec $this) {
        return $this.sizeThreshold();
    }

    default public int sizeThreshold() {
        return CompressingCodec$.MODULE$.DefaultSizeThreshold();
    }

    public static /* synthetic */ byte[] encode$(GZippingBinaryCodec $this, Object value) {
        return $this.encode(value);
    }

    @Override
    default public byte[] encode(A value) {
        byte[] byArray;
        byte[] serialised = this.scalacache$serialization$GZippingBinaryCodec$$super$encode(value);
        if (serialised.length > this.sizeThreshold()) {
            byte by = CompressingCodec$Headers$.MODULE$.Gzipped();
            byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.compress(serialised))).$plus$colon((Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.Byte());
        } else {
            byte by = CompressingCodec$Headers$.MODULE$.Uncompressed();
            byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(serialised)).$plus$colon((Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.Byte());
        }
        return byArray;
    }

    public static /* synthetic */ Object decode$(GZippingBinaryCodec $this, byte[] data) {
        return $this.decode(data);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public A decode(byte[] data) {
        Object object;
        Option firstByte = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).headOption();
        boolean bl = false;
        Some some = null;
        Option option = firstByte;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            byte by = BoxesRunTime.unboxToByte((Object)some.value());
            if (CompressingCodec$Headers$.MODULE$.Uncompressed() == by) {
                object = this.scalacache$serialization$GZippingBinaryCodec$$super$decode((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).tail());
                return (A)object;
            }
        }
        if (bl) {
            byte by = BoxesRunTime.unboxToByte((Object)some.value());
            if (CompressingCodec$Headers$.MODULE$.Gzipped() == by) {
                object = this.scalacache$serialization$GZippingBinaryCodec$$super$decode(this.decompress((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).tail()));
                return (A)object;
            }
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected either ", " or ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)CompressingCodec$Headers$.MODULE$.Uncompressed()), BoxesRunTime.boxToByte((byte)CompressingCodec$Headers$.MODULE$.Gzipped()), option})));
    }

    private byte[] compress(byte[] data) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteOutputStream);
        try {
            gzipOutputStream.write(data);
        }
        finally {
            gzipOutputStream.close();
            byteOutputStream.close();
        }
        return byteOutputStream.toByteArray();
    }

    private byte[] decompress(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        GZIPInputStream gis = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int r = gis.read(buf);
            while (r > 0) {
                bos.write(buf, 0, r);
                r = gis.read(buf);
            }
        }
        finally {
            gis.close();
            bis.close();
            bos.close();
        }
        return bos.toByteArray();
    }

    public static void $init$(GZippingBinaryCodec $this) {
    }
}

