/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class CounterMode
extends FeedbackCipher {
    private final byte[] counter = new byte[this.blockSize];
    private final byte[] encryptedCounter = new byte[this.blockSize];
    private int used;
    private byte[] counterSave = null;
    private byte[] encryptedCounterSave = null;
    private int usedSave = 0;

    CounterMode(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
    }

    @Override
    String getFeedback() {
        return "CTR";
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.counter, 0, this.blockSize);
        this.used = this.blockSize;
    }

    @Override
    void save() {
        if (this.counterSave == null) {
            this.counterSave = new byte[this.blockSize];
            this.encryptedCounterSave = new byte[this.blockSize];
        }
        System.arraycopy(this.counter, 0, this.counterSave, 0, this.blockSize);
        System.arraycopy(this.encryptedCounter, 0, this.encryptedCounterSave, 0, this.blockSize);
        this.usedSave = this.used;
    }

    @Override
    void restore() {
        System.arraycopy(this.counterSave, 0, this.counter, 0, this.blockSize);
        System.arraycopy(this.encryptedCounterSave, 0, this.encryptedCounter, 0, this.blockSize);
        this.used = this.usedSave;
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(false, string, byArray);
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.crypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.crypt(byArray, n, n2, byArray2, n3);
    }

    private static void increment(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    private int crypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        int n4 = n2;
        while (n2-- > 0) {
            if (this.used >= this.blockSize) {
                this.embeddedCipher.encryptBlock(this.counter, 0, this.encryptedCounter, 0);
                CounterMode.increment(this.counter);
                this.used = 0;
            }
            byArray2[n3++] = (byte)(byArray[n++] ^ this.encryptedCounter[this.used++]);
        }
        return n4;
    }
}

