/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.GroupParser;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.ModeParser;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.TCRefParser;
import org.netbeans.core.windows.persistence.WindowManagerConfig;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WindowManagerParser {
    public static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Window Manager Properties 1.0//EN";
    public static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Window Manager Properties 1.1//EN";
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Window Manager Properties 2.0//EN";
    public static final String INSTANCE_DTD_ID_2_1 = "-//NetBeans//DTD Window Manager Properties 2.1//EN";
    private static final boolean DEBUG = Debug.isLoggable(WindowManagerParser.class);
    private String wmName;
    private PersistenceManager pm;
    private InternalConfig internalConfig;
    private Map<String, ModeParser> modeParserMap = new HashMap<String, ModeParser>(19);
    private Map<String, GroupParser> groupParserMap = new HashMap<String, GroupParser>(19);
    private Set<String> tcRefNameLocalSet = new HashSet<String>(101);
    private static final Object SAVING_LOCK = new Object();
    private static final String[] floatStrings = new String[]{"0", "0.0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "1.0"};
    private static final float[] floatVals = new float[]{0.0f, 0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.0f};

    public WindowManagerParser(PersistenceManager persistenceManager, String string) {
        this.pm = persistenceManager;
        this.wmName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WindowManagerConfig load() throws IOException {
        Object object = SAVING_LOCK;
        synchronized (object) {
            WindowManagerConfig windowManagerConfig = new WindowManagerConfig();
            this.readProperties(windowManagerConfig);
            this.readModes(windowManagerConfig);
            this.readGroups(windowManagerConfig);
            return windowManagerConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(WindowManagerConfig windowManagerConfig) throws IOException {
        Object object = SAVING_LOCK;
        synchronized (object) {
            this.writeProperties(windowManagerConfig);
            this.writeModes(windowManagerConfig);
            this.writeGroups(windowManagerConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMode(String string) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            ModeParser modeParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "removeMode mo:" + string);
            }
            if ((modeParser = this.modeParserMap.get(string)) != null) {
                modeParser.setInModuleFolder(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModeConfig addMode(String string) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            ModeParser modeParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "addMode ENTER mo:" + string);
            }
            if ((modeParser = this.modeParserMap.get(string)) == null) {
                modeParser = new ModeParser(string, this.tcRefNameLocalSet);
                this.modeParserMap.put(string, modeParser);
            }
            FileObject fileObject = null;
            try {
                fileObject = this.pm.getModesModuleFolder();
            }
            catch (IOException iOException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addMode] Cannot get modes folder", iOException);
                return null;
            }
            modeParser.setModuleParentFolder(fileObject);
            modeParser.setInModuleFolder(true);
            ModeConfig modeConfig = null;
            try {
                modeConfig = modeParser.load();
            }
            catch (IOException iOException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addMode] Warning: Cannot load mode " + string, iOException);
            }
            return modeConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroup(String string) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.removeGroup group:" + string);
            }
            this.groupParserMap.remove(string);
            this.deleteLocalGroup(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupConfig addGroup(String string) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            GroupParser groupParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.addGroup ENTER group:" + string);
            }
            if ((groupParser = this.groupParserMap.get(string)) != null) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addGroup] Warning: GroupParser " + string + " exists but it should not.");
                this.groupParserMap.remove(string);
            }
            groupParser = new GroupParser(string);
            FileObject fileObject = null;
            try {
                fileObject = this.pm.getGroupsModuleFolder();
            }
            catch (IOException iOException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addGroup] Cannot get groups folder", iOException);
                return null;
            }
            groupParser.setModuleParentFolder(fileObject);
            groupParser.setInModuleFolder(true);
            this.groupParserMap.put(string, groupParser);
            GroupConfig groupConfig = null;
            try {
                groupConfig = groupParser.load();
            }
            catch (IOException iOException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addGroup] Warning: Cannot load group " + string, iOException);
            }
            return groupConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTCRef(String string) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            ModeParser modeParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "removeTCRef ENTER tcRef:" + string);
            }
            if ((modeParser = this.findModeParser(string)) == null) {
                if (DEBUG) {
                    Debug.log(WindowManagerParser.class, "removeTCRef LEAVE 1 tcRef:" + string);
                }
                return false;
            }
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "removeTCRef REMOVING tcRef:" + string + " FROM mo:" + modeParser.getName());
            }
            modeParser.removeTCRef(string);
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "removeTCRef LEAVE 2 tcRef:" + string);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCRefConfig addTCRef(String string, String string2, List<String> list) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            ModeParser modeParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.addTCRef ENTER mo:" + string + " tcRef:" + string2);
            }
            if ((modeParser = this.modeParserMap.get(string)) == null) {
                if (DEBUG) {
                    Debug.log(WindowManagerParser.class, "WMParser.addTCRef LEAVE 1 mo:" + string + " tcRef:" + string2);
                }
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addTCRef] Warning: Cannot add tcRef " + string2 + ". ModeParser " + string + " not found.");
                return null;
            }
            TCRefConfig tCRefConfig = modeParser.addTCRef(string2, list);
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.addTCRef LEAVE 2 mo:" + string + " tcRef:" + string2);
            }
            return tCRefConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTCGroup(String string, String string2) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            GroupParser groupParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.removeTCGroup ENTER group:" + string + " tcGroup:" + string2);
            }
            if ((groupParser = this.groupParserMap.get(string)) == null) {
                if (DEBUG) {
                    Debug.log(WindowManagerParser.class, "WMParser.removeTCGroup LEAVE 1 group:" + string + " tcGroup:" + string2);
                }
                return false;
            }
            groupParser.removeTCGroup(string2);
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.removeTCGroup LEAVE 2 group:" + string + " tcGroup:" + string2);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCGroupConfig addTCGroup(String string, String string2) {
        Object object = SAVING_LOCK;
        synchronized (object) {
            GroupParser groupParser;
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.addTCGroup ENTER group:" + string + " tcGroup:" + string2);
            }
            if ((groupParser = this.groupParserMap.get(string)) == null) {
                if (DEBUG) {
                    Debug.log(WindowManagerParser.class, "WMParser.addTCGroup LEAVE 1 group:" + string + " tcGroup:" + string2);
                }
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addTCGroup] Warning: Cannot add tcGroup " + string2 + ". GroupParser " + string + " not found.");
                return null;
            }
            TCGroupConfig tCGroupConfig = groupParser.addTCGroup(string2);
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMParser.addTCGroup LEAVE 2 group:" + string + " tcGroup:" + string2);
            }
            return tCGroupConfig;
        }
    }

    public void addTCRefImport(String string, String string2, InternalConfig internalConfig) {
        ModeParser modeParser;
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "addTCRefImport ENTER mo:" + string + " tcRef:" + string2);
        }
        if ((modeParser = this.modeParserMap.get(string)) == null) {
            if (DEBUG) {
                Debug.log(WindowManagerParser.class, "addTCRefImport LEAVE 1 mo:" + string + " tcRef:" + string2);
            }
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.addTCRef] Warning: Cannot add tcRef " + string2 + ". ModeParser " + string + " not found.");
            return;
        }
        modeParser.addTCRefImport(string2, internalConfig);
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "addTCRefImport LEAVE 2 mo:" + string + " tcRef:" + string2);
        }
    }

    ModeParser findModeParser(String string) {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "findModeParser ENTER tcRef:" + string);
        }
        Iterator<String> iterator = this.modeParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            ModeParser modeParser = this.modeParserMap.get(iterator.next());
            TCRefParser tCRefParser = modeParser.findTCRefParser(string);
            if (tCRefParser == null) continue;
            return modeParser;
        }
        return null;
    }

    private void readProperties(WindowManagerConfig windowManagerConfig) throws IOException {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readProperties ENTER");
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        this.internalConfig = new InternalConfig();
        propertyHandler.readData(windowManagerConfig, this.internalConfig);
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readProperties LEAVE");
        }
    }

    private void readModes(WindowManagerConfig windowManagerConfig) throws IOException {
        Object object;
        FileObject fileObject;
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readModes ENTER");
        }
        FileObject fileObject2 = this.modeParserMap.keySet().iterator();
        while (fileObject2.hasNext()) {
            fileObject = this.modeParserMap.get(fileObject2.next());
            fileObject.setInModuleFolder(false);
            fileObject.setInLocalFolder(false);
        }
        fileObject2 = this.pm.getRootModuleFolder().getFileObject("Modes");
        if (fileObject2 != null) {
            fileObject = fileObject2.getChildren();
            for (int i = 0; i < ((FileObject)fileObject).length; ++i) {
                if (fileObject[i].isFolder() || !"wsmode".equals(fileObject[i].getExt())) continue;
                ModeParser modeParser = this.modeParserMap.get(fileObject[i].getName());
                if (modeParser == null) {
                    modeParser = new ModeParser(fileObject[i].getName(), this.tcRefNameLocalSet);
                    this.modeParserMap.put(fileObject[i].getName(), modeParser);
                }
                modeParser.setInModuleFolder(true);
                modeParser.setModuleParentFolder(fileObject2);
            }
        }
        fileObject = this.pm.getRootLocalFolder().getFileObject("Modes");
        this.tcRefNameLocalSet.clear();
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].isFolder() && "wsmode".equals(fileObjectArray[i].getExt())) {
                    if (this.modeParserMap.containsKey(fileObjectArray[i].getName())) {
                        object = this.modeParserMap.get(fileObjectArray[i].getName());
                    } else {
                        object = new ModeParser(fileObjectArray[i].getName(), this.tcRefNameLocalSet);
                        this.modeParserMap.put(fileObjectArray[i].getName(), (ModeParser)object);
                    }
                    ((ModeParser)object).setInLocalFolder(true);
                    ((ModeParser)object).setLocalParentFolder(fileObject);
                }
                if (!fileObjectArray[i].isFolder()) continue;
                object = fileObjectArray[i].getChildren();
                for (int j = 0; j < ((FileObject[])object).length; ++j) {
                    if (object[j].isFolder() || !"wstcref".equals(object[j].getExt())) continue;
                    this.tcRefNameLocalSet.add(object[j].getName());
                }
            }
        }
        ArrayList<ModeConfig> arrayList = new ArrayList<ModeConfig>(this.modeParserMap.size());
        ArrayList<ModeParser> arrayList2 = new ArrayList<ModeParser>(this.modeParserMap.size());
        object = this.modeParserMap.keySet().iterator();
        while (object.hasNext()) {
            ModeConfig modeConfig;
            ModeParser modeParser = this.modeParserMap.get(object.next());
            try {
                modeConfig = modeParser.load();
            }
            catch (IOException iOException) {
                Logger.getLogger(WindowManagerParser.class.getName()).log(Level.INFO, null, iOException);
                continue;
            }
            boolean bl = this.acceptMode(modeParser, modeConfig);
            if (bl) {
                arrayList.add(modeConfig);
                continue;
            }
            arrayList2.add(modeParser);
            this.deleteLocalMode(modeParser.getName());
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            ModeParser modeParser = (ModeParser)arrayList2.get(i);
            this.modeParserMap.remove(modeParser.getName());
        }
        this.mergeModes(arrayList);
        windowManagerConfig.modes = arrayList.toArray(new ModeConfig[arrayList.size()]);
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readModes LEAVE");
        }
    }

    private void mergeModes(List<ModeConfig> list) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>(20);
        for (ModeConfig object2 : list) {
            if (object2.otherNames == null) continue;
            hashSet.addAll(object2.otherNames);
            object = this.modeParserMap.get(object2.name);
            if (null == object) continue;
            for (String string : object2.otherNames) {
                this.modeParserMap.put(string, (ModeParser)object);
            }
        }
        for (String string : hashSet) {
            object = null;
            for (ModeConfig modeConfig : list) {
                if (!string.equals(modeConfig.name)) continue;
                list.remove(modeConfig);
                object = modeConfig;
                break;
            }
            if (null != object && ((ModeConfig)object).tcRefConfigs.length > 0) {
                for (ModeConfig modeConfig : list) {
                    if (null == modeConfig.otherNames || !modeConfig.otherNames.contains(((ModeConfig)object).name)) continue;
                    ArrayList<TCRefConfig> arrayList = new ArrayList<TCRefConfig>(Arrays.asList(modeConfig.tcRefConfigs));
                    for (TCRefConfig tCRefConfig : ((ModeConfig)object).tcRefConfigs) {
                        if (arrayList.contains(tCRefConfig)) continue;
                        arrayList.add(tCRefConfig);
                    }
                    modeConfig.tcRefConfigs = arrayList.toArray(new TCRefConfig[arrayList.size()]);
                    break;
                }
            }
            Iterator<ModeConfig> iterator = this.modeParserMap.remove(string);
        }
    }

    private boolean acceptMode(ModeParser modeParser, ModeConfig modeConfig) {
        InternalConfig internalConfig = modeParser.getInternalConfig();
        if (internalConfig.moduleCodeNameBase != null) {
            ModuleInfo moduleInfo = PersistenceManager.findModule(internalConfig.moduleCodeNameBase, internalConfig.moduleCodeNameRelease, internalConfig.moduleSpecificationVersion);
            if (moduleInfo == null) {
                PersistenceManager.LOG.info("Cannot find module '" + internalConfig.moduleCodeNameBase + " " + internalConfig.moduleCodeNameRelease + " " + internalConfig.moduleSpecificationVersion + "' for wsmode with name '" + modeConfig.name + "'");
            }
            return moduleInfo != null && moduleInfo.isEnabled();
        }
        return true;
    }

    private void readGroups(WindowManagerConfig windowManagerConfig) throws IOException {
        GroupParser groupParser;
        Object object;
        FileObject fileObject;
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readGroups ENTER");
        }
        FileObject fileObject2 = this.groupParserMap.keySet().iterator();
        while (fileObject2.hasNext()) {
            fileObject = this.groupParserMap.get(fileObject2.next());
            fileObject.setInModuleFolder(false);
            fileObject.setInLocalFolder(false);
        }
        fileObject2 = this.pm.getRootModuleFolder().getFileObject("Groups");
        if (fileObject2 != null) {
            fileObject = fileObject2.getChildren();
            for (int i = 0; i < ((FileObject)fileObject).length; ++i) {
                GroupParser groupParser2;
                if (fileObject[i].isFolder() || !"wsgrp".equals(fileObject[i].getExt())) continue;
                if (this.groupParserMap.containsKey(fileObject[i].getName())) {
                    groupParser2 = this.groupParserMap.get(fileObject[i].getName());
                } else {
                    groupParser2 = new GroupParser(fileObject[i].getName());
                    this.groupParserMap.put(fileObject[i].getName(), groupParser2);
                }
                groupParser2.setInModuleFolder(true);
                groupParser2.setModuleParentFolder(fileObject2);
            }
        }
        if ((fileObject = this.pm.getRootLocalFolder().getFileObject("Groups")) != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObjectArray[i].isFolder() || !"wsgrp".equals(fileObjectArray[i].getExt())) continue;
                if (this.groupParserMap.containsKey(fileObjectArray[i].getName())) {
                    object = this.groupParserMap.get(fileObjectArray[i].getName());
                } else {
                    object = new GroupParser(fileObjectArray[i].getName());
                    this.groupParserMap.put(fileObjectArray[i].getName(), (GroupParser)object);
                }
                ((GroupParser)object).setInLocalFolder(true);
                ((GroupParser)object).setLocalParentFolder(fileObject);
            }
        }
        ArrayList<GroupConfig> arrayList = new ArrayList<GroupConfig>(this.groupParserMap.size());
        ArrayList<GroupParser> arrayList2 = new ArrayList<GroupParser>(this.groupParserMap.size());
        object = this.groupParserMap.keySet().iterator();
        while (object.hasNext()) {
            GroupConfig groupConfig;
            groupParser = this.groupParserMap.get(object.next());
            try {
                groupConfig = groupParser.load();
            }
            catch (IOException iOException) {
                Logger.getLogger(WindowManagerParser.class.getName()).log(Level.INFO, null, iOException);
                continue;
            }
            boolean bl = this.acceptGroup(groupParser, groupConfig);
            if (bl) {
                arrayList.add(groupConfig);
                continue;
            }
            arrayList2.add(groupParser);
            this.deleteLocalGroup(groupParser.getName());
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            groupParser = (GroupParser)arrayList2.get(i);
            this.groupParserMap.remove(groupParser.getName());
        }
        windowManagerConfig.groups = arrayList.toArray(new GroupConfig[arrayList.size()]);
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "readGroups LEAVE");
        }
    }

    private boolean acceptGroup(GroupParser groupParser, GroupConfig groupConfig) {
        InternalConfig internalConfig = groupParser.getInternalConfig();
        if (internalConfig.moduleCodeNameBase != null) {
            ModuleInfo moduleInfo = PersistenceManager.findModule(internalConfig.moduleCodeNameBase, internalConfig.moduleCodeNameRelease, internalConfig.moduleSpecificationVersion);
            if (moduleInfo == null) {
                PersistenceManager.LOG.log(Level.FINE, "Cannot find module '" + internalConfig.moduleCodeNameBase + " " + internalConfig.moduleCodeNameRelease + " " + internalConfig.moduleSpecificationVersion + "' for group with name '" + groupConfig.name + "'");
            }
            return moduleInfo != null && moduleInfo.isEnabled();
        }
        return true;
    }

    private void writeProperties(WindowManagerConfig windowManagerConfig) throws IOException {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeProperties ENTER");
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        propertyHandler.writeData(windowManagerConfig);
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeProperties LEAVE");
        }
    }

    private void writeModes(WindowManagerConfig windowManagerConfig) throws IOException {
        int n;
        ModeParser modeParser;
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeModes ENTER");
        }
        HashMap<String, ModeConfig> hashMap = new HashMap<String, ModeConfig>();
        for (int i = 0; i < windowManagerConfig.modes.length; ++i) {
            hashMap.put(windowManagerConfig.modes[i].name, windowManagerConfig.modes[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (String object2 : this.modeParserMap.keySet()) {
            modeParser = this.modeParserMap.get(object2);
            if (hashMap.containsKey(modeParser.getName())) continue;
            arrayList.add(modeParser.getName());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.modeParserMap.remove(arrayList.get(n));
            this.deleteLocalMode((String)arrayList.get(n));
        }
        for (n = 0; n < windowManagerConfig.modes.length; ++n) {
            if (this.modeParserMap.containsKey(windowManagerConfig.modes[n].name)) continue;
            ModeParser modeParser2 = new ModeParser(windowManagerConfig.modes[n].name, this.tcRefNameLocalSet);
            this.modeParserMap.put(windowManagerConfig.modes[n].name, modeParser2);
        }
        FileObject fileObject = this.pm.getRootLocalFolder().getFileObject("Modes");
        if (fileObject == null && this.modeParserMap.size() > 0) {
            fileObject = this.pm.getModesLocalFolder();
        }
        Iterator<String> iterator = this.modeParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            modeParser = this.modeParserMap.get(iterator.next());
            modeParser.setLocalParentFolder(fileObject);
            modeParser.setInLocalFolder(true);
            modeParser.save((ModeConfig)hashMap.get(modeParser.getName()));
        }
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeModes LEAVE");
        }
    }

    private void writeGroups(WindowManagerConfig windowManagerConfig) throws IOException {
        int n;
        GroupParser groupParser;
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeGroups ENTER");
        }
        HashMap<String, GroupConfig> hashMap = new HashMap<String, GroupConfig>();
        for (int i = 0; i < windowManagerConfig.groups.length; ++i) {
            hashMap.put(windowManagerConfig.groups[i].name, windowManagerConfig.groups[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (String object2 : this.groupParserMap.keySet()) {
            groupParser = this.groupParserMap.get(object2);
            if (hashMap.containsKey(groupParser.getName())) continue;
            arrayList.add(groupParser.getName());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.groupParserMap.remove(arrayList.get(n));
            this.deleteLocalGroup((String)arrayList.get(n));
        }
        for (n = 0; n < windowManagerConfig.groups.length; ++n) {
            if (this.groupParserMap.containsKey(windowManagerConfig.groups[n].name)) continue;
            GroupParser groupParser2 = new GroupParser(windowManagerConfig.groups[n].name);
            this.groupParserMap.put(windowManagerConfig.groups[n].name, groupParser2);
        }
        FileObject fileObject = this.pm.getRootLocalFolder().getFileObject("Groups");
        if (fileObject == null && this.groupParserMap.size() > 0) {
            fileObject = this.pm.getGroupsLocalFolder();
        }
        Iterator<String> iterator = this.groupParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            groupParser = this.groupParserMap.get(iterator.next());
            groupParser.setLocalParentFolder(fileObject);
            groupParser.setInLocalFolder(true);
            groupParser.save((GroupConfig)hashMap.get(groupParser.getName()));
        }
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "writeGroups LEAVE");
        }
    }

    private void deleteLocalMode(String string) {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "deleteLocalMode mo:" + string);
        }
        FileObject fileObject = null;
        try {
            fileObject = this.pm.getRootLocalFolder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.deleteLocalMode] Cannot get root local folder", iOException);
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Modes");
        if (fileObject2 == null) {
            return;
        }
        FileObject fileObject3 = fileObject2.getFileObject(string);
        if (fileObject3 != null) {
            PersistenceManager.deleteOneFO(fileObject3);
        }
        if ((fileObject3 = fileObject2.getFileObject(string, "wsmode")) != null) {
            PersistenceManager.deleteOneFO(fileObject3);
        }
    }

    private void deleteLocalGroup(String string) {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, "deleteLocalGroup groupName:" + string);
        }
        FileObject fileObject = null;
        try {
            fileObject = this.pm.getRootLocalFolder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.deleteLocalGroup] Cannot get root local folder", iOException);
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Groups");
        if (fileObject2 == null) {
            return;
        }
        FileObject fileObject3 = fileObject2.getFileObject(string);
        if (fileObject3 != null) {
            PersistenceManager.deleteOneFO(fileObject3);
        }
        if ((fileObject3 = fileObject2.getFileObject(string, "wsgrp")) != null) {
            PersistenceManager.deleteOneFO(fileObject3);
        }
    }

    String getName() {
        return this.wmName;
    }

    void log(String string) {
        if (DEBUG) {
            Debug.log(WindowManagerParser.class, string);
        }
    }

    private static final float floatParse(String string) throws NumberFormatException {
        int n = Arrays.binarySearch(floatStrings, string);
        if (n >= 0) {
            return floatVals[n];
        }
        return Float.parseFloat(string);
    }

    public static ModeConfig loadModeConfigFrom(FileObject fileObject) throws IOException {
        String string = fileObject.getName();
        ModeParser modeParser = new ModeParser(string, new HashSet(1));
        modeParser.setInLocalFolder(true);
        modeParser.setLocalParentFolder(fileObject.getParent());
        return modeParser.load();
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private WindowManagerConfig winMgrConfig = null;
        private InternalConfig internalConfig = null;
        private List<SplitConstraint> itemList = new ArrayList<SplitConstraint>(10);
        private List<String> tcIdList = new ArrayList<String>(10);
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() throws IOException {
            FileObject fileObject = WindowManagerParser.this.pm.getRootLocalFolder();
            FileObject fileObject2 = fileObject.getFileObject(WindowManagerParser.this.getName(), "wswmgr");
            if (fileObject2 != null) {
                return fileObject2;
            }
            fileObject = WindowManagerParser.this.pm.getRootModuleFolder();
            fileObject2 = fileObject.getFileObject(WindowManagerParser.this.getName(), "wswmgr");
            return fileObject2;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = WindowManagerParser.this.pm.getRootLocalFolder();
            FileObject fileObject2 = fileObject.getFileObject(WindowManagerParser.this.getName(), "wswmgr");
            if (fileObject2 != null) {
                return fileObject2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(WindowManagerParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wswmgr");
            fileObject2 = FileUtil.createData((FileObject)fileObject, (String)stringBuffer.toString());
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readData(WindowManagerConfig windowManagerConfig, InternalConfig internalConfig) throws IOException {
            this.winMgrConfig = windowManagerConfig;
            this.internalConfig = internalConfig;
            this.itemList.clear();
            this.tcIdList.clear();
            FileObject fileObject = this.getConfigFOInput();
            if (fileObject == null) {
                throw new FileNotFoundException("[WinSys] Missing Window Manager configuration file");
            }
            InputStream inputStream = null;
            try {
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
            }
            catch (SAXException sAXException) {
                String string = NbBundle.getMessage(WindowManagerParser.class, (String)"EXC_WindowManagerParse", (Object)fileObject);
                throw (IOException)new IOException(string).initCause(sAXException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(WindowManagerParser.class.getName()).log(Level.INFO, null, iOException);
                }
            }
            this.winMgrConfig.editorAreaConstraints = this.itemList.toArray(new SplitConstraint[this.itemList.size()]);
            this.winMgrConfig.tcIdViewList = this.tcIdList.toArray(new String[this.tcIdList.size()]);
            windowManagerConfig = this.winMgrConfig;
            internalConfig = this.internalConfig;
            this.winMgrConfig = null;
            this.internalConfig = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("windowmanager".equals(string3)) {
                this.handleWindowManager(attributes);
            } else if (this.internalConfig.specVersion != null && this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) >= 0) {
                if ("main-window".equals(string3)) {
                    this.handleMainWindow(attributes);
                } else if ("joined-properties".equals(string3)) {
                    this.handleJoinedProperties(attributes);
                } else if ("separated-properties".equals(string3)) {
                    this.handleSeparatedProperties(attributes);
                } else if ("editor-area".equals(string3)) {
                    this.handleEditorArea(attributes);
                } else if ("constraints".equals(string3)) {
                    this.handleConstraints(attributes);
                } else if ("path".equals(string3)) {
                    this.handlePath(attributes);
                } else if ("bounds".equals(string3)) {
                    this.handleEditorAreaBounds(attributes);
                } else if ("relative-bounds".equals(string3)) {
                    this.handleEditorAreaRelativeBounds(attributes);
                } else if ("screen".equals(string3)) {
                    this.handleScreen(attributes);
                } else if ("active-mode".equals(string3)) {
                    this.handleActiveMode(attributes);
                } else if ("maximized-mode".equals(string3)) {
                    this.handleMaximizedMode(attributes);
                } else if ("toolbar".equals(string3)) {
                    this.handleToolbar(attributes);
                } else if ("tc-id".equals(string3)) {
                    this.handleTcId(attributes);
                } else if ("tcref-item".equals(string3)) {
                    this.handleTCRefItem(attributes);
                }
            } else if (DEBUG) {
                Debug.log(WindowManagerParser.class, "WMP.startElement PARSING OLD");
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleWindowManager(Attributes attributes) {
            String string = attributes.getValue("version");
            if (string != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string);
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleWindowManager] Missing attribute \"version\" of element \"windowmanager\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
        }

        private void handleMainWindow(Attributes attributes) {
        }

        private void handleJoinedProperties(Attributes attributes) {
            String string;
            try {
                string = attributes.getValue("x");
                this.winMgrConfig.xJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"x\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.xJoined = -1;
            }
            try {
                string = attributes.getValue("y");
                this.winMgrConfig.yJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"y\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.yJoined = -1;
            }
            try {
                string = attributes.getValue("width");
                this.winMgrConfig.widthJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"width\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.widthJoined = -1;
            }
            try {
                string = attributes.getValue("height");
                this.winMgrConfig.heightJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"height\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.heightJoined = -1;
            }
            try {
                string = attributes.getValue("relative-x");
                this.winMgrConfig.relativeXJoined = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"relative-x\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.relativeXJoined = -1.0f;
            }
            try {
                string = attributes.getValue("relative-y");
                this.winMgrConfig.relativeYJoined = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"relative-y\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.relativeYJoined = -1.0f;
            }
            try {
                string = attributes.getValue("relative-width");
                this.winMgrConfig.relativeWidthJoined = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"relative-width\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.relativeWidthJoined = -1.0f;
            }
            try {
                string = attributes.getValue("relative-height");
                this.winMgrConfig.relativeHeightJoined = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"relative-height\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.relativeHeightJoined = -1.0f;
            }
            string = attributes.getValue("centered-horizontally");
            if (string != null) {
                if ("true".equals(string)) {
                    this.winMgrConfig.centeredHorizontallyJoined = true;
                } else if ("false".equals(string)) {
                    this.winMgrConfig.centeredHorizontallyJoined = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Invalid value of attribute \"centered-horizontally\" of element \"joined-properties\".");
                    this.winMgrConfig.centeredHorizontallyJoined = false;
                }
            } else {
                this.winMgrConfig.centeredHorizontallyJoined = false;
            }
            string = attributes.getValue("centered-vertically");
            if (string != null) {
                if ("true".equals(string)) {
                    this.winMgrConfig.centeredVerticallyJoined = true;
                } else if ("false".equals(string)) {
                    this.winMgrConfig.centeredVerticallyJoined = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Invalid value of attribute \"centered-vertically\" of element \"joined-properties\".");
                    this.winMgrConfig.centeredVerticallyJoined = false;
                }
            } else {
                this.winMgrConfig.centeredVerticallyJoined = false;
            }
            try {
                string = attributes.getValue("maximize-if-width-below");
                this.winMgrConfig.maximizeIfWidthBelowJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"maximize-if-width-below\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.maximizeIfWidthBelowJoined = -1;
            }
            try {
                string = attributes.getValue("maximize-if-height-below");
                this.winMgrConfig.maximizeIfHeightBelowJoined = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"maximize-if-height-below\" of element \"joined-properties\".", numberFormatException);
                this.winMgrConfig.maximizeIfHeightBelowJoined = -1;
            }
            String string2 = attributes.getValue("frame-state");
            if (string2 != null) {
                try {
                    this.winMgrConfig.mainWindowFrameStateJoined = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleJoinedProperties] Warning: Cannot read attribute \"frame-state\" of element \"joined-properties\".", numberFormatException);
                    this.winMgrConfig.mainWindowFrameStateJoined = 0;
                }
            } else {
                this.winMgrConfig.mainWindowFrameStateJoined = 0;
            }
        }

        private void handleSeparatedProperties(Attributes attributes) {
            String string;
            try {
                string = attributes.getValue("x");
                this.winMgrConfig.xSeparated = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"x\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.xSeparated = -1;
            }
            try {
                string = attributes.getValue("y");
                this.winMgrConfig.ySeparated = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"y\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.ySeparated = -1;
            }
            try {
                string = attributes.getValue("width");
                this.winMgrConfig.widthSeparated = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"width\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.widthSeparated = -1;
            }
            try {
                string = attributes.getValue("height");
                this.winMgrConfig.heightSeparated = string != null ? Integer.parseInt(string) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"height\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.heightSeparated = -1;
            }
            try {
                string = attributes.getValue("relative-x");
                this.winMgrConfig.relativeXSeparated = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"relative-x\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.relativeXSeparated = -1.0f;
            }
            try {
                string = attributes.getValue("relative-y");
                this.winMgrConfig.relativeYSeparated = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"relative-y\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.relativeYSeparated = -1.0f;
            }
            try {
                string = attributes.getValue("relative-width");
                this.winMgrConfig.relativeWidthSeparated = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"relative-width\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.relativeWidthSeparated = -1.0f;
            }
            try {
                string = attributes.getValue("relative-height");
                this.winMgrConfig.relativeHeightSeparated = string != null ? WindowManagerParser.floatParse(string) : -1.0f;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"relative-height\" of element \"separated-properties\".", numberFormatException);
                this.winMgrConfig.relativeHeightSeparated = -1.0f;
            }
            string = attributes.getValue("centered-horizontally");
            if (string != null) {
                if ("true".equals(string)) {
                    this.winMgrConfig.centeredHorizontallySeparated = true;
                } else if ("false".equals(string)) {
                    this.winMgrConfig.centeredHorizontallySeparated = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Invalid value of attribute \"centered-horizontally\" of element \"separated-properties\".");
                    this.winMgrConfig.centeredHorizontallySeparated = false;
                }
            } else {
                this.winMgrConfig.centeredHorizontallySeparated = false;
            }
            string = attributes.getValue("centered-vertically");
            if (string != null) {
                if ("true".equals(string)) {
                    this.winMgrConfig.centeredVerticallySeparated = true;
                } else if ("false".equals(string)) {
                    this.winMgrConfig.centeredVerticallySeparated = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Invalid value of attribute \"centered-vertically\" of element \"separated-properties\".");
                    this.winMgrConfig.centeredVerticallySeparated = false;
                }
            } else {
                this.winMgrConfig.centeredVerticallySeparated = false;
            }
            String string2 = attributes.getValue("frame-state");
            if (string2 != null) {
                try {
                    this.winMgrConfig.mainWindowFrameStateSeparated = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleSeparatedProperties] Warning: Cannot read attribute \"frame-state\" of element \"separated-properties\".", numberFormatException);
                    this.winMgrConfig.mainWindowFrameStateSeparated = 0;
                }
            } else {
                this.winMgrConfig.mainWindowFrameStateSeparated = 0;
            }
        }

        private void handleEditorArea(Attributes attributes) {
            String string = attributes.getValue("state");
            if (string != null) {
                if ("joined".equals(string)) {
                    this.winMgrConfig.editorAreaState = 0;
                } else if ("separated".equals(string)) {
                    this.winMgrConfig.editorAreaState = 1;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorArea] Warning: Invalid value of attribute \"state\" of element \"editor-area\".");
                    this.winMgrConfig.editorAreaState = 0;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorArea] Warning: Missing value of attribute \"state\" of element \"editor-area\".");
                this.winMgrConfig.editorAreaState = 0;
            }
            String string2 = attributes.getValue("frame-state");
            if (string2 != null) {
                try {
                    this.winMgrConfig.editorAreaFrameState = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorArea] Warning: Cannot read attribute \"frame-state\" of element \"editor-area\".", numberFormatException);
                    this.winMgrConfig.editorAreaFrameState = 0;
                }
            } else {
                this.winMgrConfig.editorAreaFrameState = 0;
            }
        }

        private void handleConstraints(Attributes attributes) {
        }

        private void handlePath(Attributes attributes) {
            double d;
            int n;
            int n2;
            String string = attributes.getValue("orientation");
            if ("horizontal".equals(string)) {
                n2 = 1;
            } else if ("vertical".equals(string)) {
                n2 = 0;
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handlePath] Invalid or missing value of attribute \"orientation\".");
                n2 = 0;
            }
            try {
                string = attributes.getValue("number");
                if (string != null) {
                    n = Integer.parseInt(string);
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handlePath] Missing value of attribute \"number\".");
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handlePath] Cannot read element \"path\", attribute \"number\"", numberFormatException);
                n = 0;
            }
            try {
                string = attributes.getValue("weight");
                d = string != null ? Double.parseDouble(string) : 0.5;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handlePath] Warning: Cannot read element \"path\", attribute \"weight\".", numberFormatException);
                d = 0.5;
            }
            SplitConstraint splitConstraint = new SplitConstraint(n2, n, d);
            this.itemList.add(splitConstraint);
        }

        private void handleScreen(Attributes attributes) {
            try {
                this.winMgrConfig.screenSize = null;
                String string = attributes.getValue("width");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleScreen] Warning: Missing attribute \"width\" of element \"screen\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleScreen] Warning: Missing attribute \"height\" of element \"screen\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                this.winMgrConfig.screenSize = new Dimension(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleScreen] Warning: Cannot read element \"screen\".", numberFormatException);
            }
        }

        private void handleEditorAreaBounds(Attributes attributes) {
            try {
                this.winMgrConfig.editorAreaBounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaBounds] Warning: Missing attribute \"x\" of element \"bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaBounds] Warning: Missing attribute \"y\" of element \"bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaBounds] Warning: Missing attribute \"width\" of element \"bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaBounds] Warning: Missing attribute \"height\" of element \"bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.winMgrConfig.editorAreaBounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaBounds] Warning: Cannot read element \"bounds\".", numberFormatException);
            }
        }

        private void handleEditorAreaRelativeBounds(Attributes attributes) {
            try {
                this.winMgrConfig.editorAreaRelativeBounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaRelativeBounds] Warning: Missing attribute \"x\" of element \"relative-bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaRelativeBounds] Warning: Missing attribute \"y\" of element \"relative-bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaRelativeBounds] Warning: Missing attribute \"width\" of element \"relative-bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaRelativeBounds] Warning: Missing attribute \"height\" of element \"relative-bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.winMgrConfig.editorAreaRelativeBounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleEditorAreaRelativeBounds] Warning: Cannot read element \"relative-bounds\".", numberFormatException);
            }
        }

        private void handleActiveMode(Attributes attributes) {
            String string = attributes.getValue("name");
            this.winMgrConfig.activeModeName = string != null ? string : "";
        }

        private void handleMaximizedMode(Attributes attributes) {
            String string = attributes.getValue("editor");
            this.winMgrConfig.editorMaximizedModeName = string != null ? string : "";
            string = attributes.getValue("view");
            this.winMgrConfig.viewMaximizedModeName = string != null ? string : "";
        }

        private void handleToolbar(Attributes attributes) {
            String string = attributes.getValue("configuration");
            this.winMgrConfig.toolbarConfiguration = string != null ? string : "";
            String string2 = attributes.getValue("preferred-icon-size");
            if (string2 != null) {
                try {
                    this.winMgrConfig.preferredToolbarIconSize = Integer.parseInt(string2);
                    if (this.winMgrConfig.preferredToolbarIconSize != 16 && this.winMgrConfig.preferredToolbarIconSize != 24) {
                        PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleToolbar] Warning: Invalid value of attribute \"preferred-icon-size\" of element \"toolbar\": " + this.winMgrConfig.preferredToolbarIconSize + ". Fixed to default value 24.");
                        this.winMgrConfig.preferredToolbarIconSize = 24;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleToolbar] Warning: Cannot read attribute \"preferred-icon-size\" of element \"toolbar\". Fixed to default value 24.", numberFormatException);
                    this.winMgrConfig.preferredToolbarIconSize = 24;
                }
            } else {
                this.winMgrConfig.preferredToolbarIconSize = 24;
            }
        }

        private void handleTcId(Attributes attributes) {
            String string = attributes.getValue("id");
            if (string != null) {
                if (!"".equals(string)) {
                    this.tcIdList.add(string);
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTcId] Warning: Empty required attribute \"id\" of element \"tc-id\".");
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTcId] Warning: Missing required attribute \"id\" of element \"tc-id\".");
            }
        }

        private void handleTCRefItem(Attributes attributes) {
            String string = attributes.getValue("workspace");
            String string2 = attributes.getValue("mode");
            String string3 = attributes.getValue("id");
            if (string != null) {
                if ("".equals(string)) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Empty required attribute \"workspace\" of element \"tcref-item\".");
                    return;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Missing required attribute \"workspace\" of element \"tcref-item\".");
                return;
            }
            if (string2 != null) {
                if ("".equals(string2)) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Empty required attribute \"mode\" of element \"tcref-item\".");
                    return;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Missing required attribute \"mode\" of element \"tcref-item\".");
                return;
            }
            if (string3 != null) {
                if ("".equals(string3)) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Empty required attribute \"id\" of element \"tcref-item\".");
                    return;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.WindowManagerParser.handleTCRefItem] Warning: Missing required attribute \"id\" of element \"tcref-item\".");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(WindowManagerConfig windowManagerConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(windowManagerConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WindowManagerParser.class.getName()).log(Level.INFO, null, iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private StringBuffer fillBuffer(WindowManagerConfig windowManagerConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            Object var3_3 = null;
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n").append("<windowmanager version=\"2.1\">\n");
            this.appendMainWindow(windowManagerConfig, stringBuffer);
            this.appendEditorArea(windowManagerConfig, stringBuffer);
            this.appendScreen(windowManagerConfig, stringBuffer);
            this.appendActiveMode(windowManagerConfig, stringBuffer);
            this.appendMaximizedMode(windowManagerConfig, stringBuffer);
            this.appendToolbar(windowManagerConfig, stringBuffer);
            this.appendRecentViewList(windowManagerConfig, stringBuffer);
            stringBuffer.append("</windowmanager>\n");
            return stringBuffer;
        }

        private void appendMainWindow(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <main-window>\n  <joined-properties\n").append("   x=\"").append(windowManagerConfig.xJoined).append("\"\n").append("   y=\"").append(windowManagerConfig.yJoined).append("\"\n").append("   width=\"").append(windowManagerConfig.widthJoined).append("\"\n").append("   height=\"").append(windowManagerConfig.heightJoined).append("\"\n").append("   relative-x=\"").append(windowManagerConfig.relativeXJoined).append("\"\n").append("   relative-y=\"").append(windowManagerConfig.relativeYJoined).append("\"\n").append("   relative-width=\"").append(windowManagerConfig.relativeWidthJoined).append("\"\n").append("   relative-height=\"").append(windowManagerConfig.relativeHeightJoined).append("\"\n").append("   centered-horizontally=\"").append(windowManagerConfig.centeredHorizontallyJoined).append("\"\n").append("   centered-vertically=\"").append(windowManagerConfig.centeredVerticallyJoined).append("\"\n").append("   maximize-if-width-below=\"").append(windowManagerConfig.maximizeIfWidthBelowJoined).append("\"\n").append("   maximize-if-height-below=\"").append(windowManagerConfig.maximizeIfHeightBelowJoined).append("\"\n").append("   frame-state=\"").append(windowManagerConfig.mainWindowFrameStateJoined).append("\"\n/>\n").append("  <separated-properties\n").append("   x=\"").append(windowManagerConfig.xSeparated).append("\"\n").append("   y=\"").append(windowManagerConfig.ySeparated).append("\"\n").append("   width=\"").append(windowManagerConfig.widthSeparated).append("\"\n").append("   height=\"").append(windowManagerConfig.heightSeparated).append("\"\n").append("   relative-x=\"").append(windowManagerConfig.relativeXSeparated).append("\"\n").append("   relative-y=\"").append(windowManagerConfig.relativeYSeparated).append("\"\n").append("   relative-width=\"").append(windowManagerConfig.relativeWidthSeparated).append("\"\n").append("   relative-height=\"").append(windowManagerConfig.relativeHeightSeparated).append("\"\n").append("   centered-horizontally=\"").append(windowManagerConfig.centeredHorizontallySeparated).append("\"\n").append("   centered-vertically=\"").append(windowManagerConfig.centeredVerticallySeparated).append("\"\n").append("   frame-state=\"").append(windowManagerConfig.mainWindowFrameStateSeparated).append("\"\n").append("/>\n  </main-window>\n");
        }

        private void appendEditorArea(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <editor-area state=\"");
            if (windowManagerConfig.editorAreaState == 0) {
                stringBuffer.append("joined");
            } else {
                stringBuffer.append("separated");
            }
            stringBuffer.append("\" frame-state=\"").append(windowManagerConfig.editorAreaFrameState).append("\">\n");
            stringBuffer.append("  <constraints>\n");
            for (int i = 0; i < windowManagerConfig.editorAreaConstraints.length; ++i) {
                SplitConstraint splitConstraint = windowManagerConfig.editorAreaConstraints[i];
                stringBuffer.append("  <path orientation=\"");
                if (splitConstraint.orientation == 1) {
                    stringBuffer.append("horizontal");
                } else {
                    stringBuffer.append("vertical");
                }
                stringBuffer.append("\" number=\"").append(splitConstraint.index).append("\" weight=\"").append(splitConstraint.splitWeight).append("\" />\n");
            }
            stringBuffer.append("  </constraints>\n");
            if (windowManagerConfig.editorAreaBounds != null) {
                stringBuffer.append("  <bounds x=\"").append(windowManagerConfig.editorAreaBounds.x).append("\" y=\"").append(windowManagerConfig.editorAreaBounds.y).append("\" width=\"").append(windowManagerConfig.editorAreaBounds.width).append("\" height=\"");
                stringBuffer.append(windowManagerConfig.editorAreaBounds.height).append("\" />\n");
            } else if (windowManagerConfig.editorAreaRelativeBounds != null) {
                stringBuffer.append("  <relative-bounds x=\"").append(windowManagerConfig.editorAreaRelativeBounds.x).append("\" y=\"").append(windowManagerConfig.editorAreaRelativeBounds.y).append("\" width=\"").append(windowManagerConfig.editorAreaRelativeBounds.width).append("\" height=\"").append(windowManagerConfig.editorAreaRelativeBounds.height).append("\"/>\n");
            }
            stringBuffer.append("    </editor-area>\n");
        }

        private void appendScreen(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <screen width=\"").append(windowManagerConfig.screenSize.width).append("\" height=\"").append(windowManagerConfig.screenSize.height).append("\"/>\n");
        }

        private void appendActiveMode(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            if (windowManagerConfig.activeModeName != null && !"".equals(windowManagerConfig.activeModeName)) {
                stringBuffer.append("    <active-mode name=\"").append(windowManagerConfig.activeModeName).append("\"/>\n");
            }
        }

        private void appendMaximizedMode(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            if (windowManagerConfig.editorMaximizedModeName != null && !"".equals(windowManagerConfig.editorMaximizedModeName) || windowManagerConfig.viewMaximizedModeName != null && !"".equals(windowManagerConfig.viewMaximizedModeName)) {
                stringBuffer.append("    <maximized-mode");
                if (windowManagerConfig.editorMaximizedModeName != null && !"".equals(windowManagerConfig.editorMaximizedModeName)) {
                    stringBuffer.append(" editor=\"").append(windowManagerConfig.editorMaximizedModeName).append("\"");
                }
                if (windowManagerConfig.viewMaximizedModeName != null && !"".equals(windowManagerConfig.viewMaximizedModeName)) {
                    stringBuffer.append(" view=\"").append(windowManagerConfig.viewMaximizedModeName).append("\"");
                }
                stringBuffer.append("/>\n");
            }
        }

        private void appendToolbar(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <toolbar");
            if (windowManagerConfig.toolbarConfiguration != null && !"".equals(windowManagerConfig.toolbarConfiguration)) {
                stringBuffer.append(" configuration=\"").append(windowManagerConfig.toolbarConfiguration).append("\"");
            }
            stringBuffer.append(" preferred-icon-size=\"").append(windowManagerConfig.preferredToolbarIconSize).append("\"/>\n");
        }

        private void appendRecentViewList(WindowManagerConfig windowManagerConfig, StringBuffer stringBuffer) {
            if (windowManagerConfig.tcIdViewList.length == 0) {
                return;
            }
            stringBuffer.append("    <tc-list>\n");
            for (int i = 0; i < windowManagerConfig.tcIdViewList.length; ++i) {
                stringBuffer.append("  <tc-id id=\"").append(windowManagerConfig.tcIdViewList[i]).append("\"/>\n");
            }
            stringBuffer.append("    </tc-list>\n");
        }
    }
}

